/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

class HashKey {
    char[] value;
    int count = 0;

    HashKey() {
        this(16);
    }

    HashKey(int n2) {
        this.value = new char[n2];
    }

    HashKey(HashKey hashKey) {
        this.set(hashKey);
    }

    HashKey(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    void set(HashKey hashKey) {
        if (this.count < hashKey.count) {
            this.value = new char[hashKey.count];
        }
        for (int i2 = 0; i2 < hashKey.count; ++i2) {
            this.value[i2] = hashKey.value[i2];
        }
        this.count = hashKey.count;
    }

    void reset() {
        this.count = 0;
    }

    void ensureCapacity(int n2) {
        int n3 = this.value.length;
        if (n2 > n3) {
            int n4 = (n3 + 1) * 2;
            if (n2 > n4) {
                n4 = n2;
            }
            char[] cArray = new char[n4];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    HashKey append(String string) {
        int n2 = 0;
        if (string == null) {
            return this;
        }
        n2 = string.length();
        this.ensureCapacity(this.count + n2);
        string.getChars(0, n2, this.value, this.count);
        this.count += n2;
        return this;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this.value;
        int n4 = this.count;
        if (n4 < 16) {
            for (int i2 = n4; i2 > 0; --i2) {
                n2 = n2 * 37 + cArray[n3++];
            }
        } else {
            int n5 = n4 / 8;
            int n6 = n4;
            while (n6 > 0) {
                n2 = n2 * 39 + cArray[n3];
                n6 -= n5;
                n3 += n5;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof HashKey) {
            HashKey hashKey = (HashKey)object;
            int n2 = this.count;
            if (n2 == hashKey.count) {
                char[] cArray = this.value;
                char[] cArray2 = hashKey.value;
                int n3 = 0;
                int n4 = 0;
                while (n2-- != 0) {
                    if (cArray[n3++] == cArray2[n4++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private int equals(HashKey hashKey) {
        for (int i2 = 0; i2 < this.count && i2 < hashKey.count; ++i2) {
            if (this.value[i2] < hashKey.value[i2]) {
                return -1;
            }
            if (this.value[i2] <= hashKey.value[i2]) continue;
            return 1;
        }
        if (this.count == hashKey.count) {
            return 0;
        }
        if (this.count < hashKey.count) {
            return -1;
        }
        return 1;
    }

    int equals(HashKey[] hashKeyArray, int n2, int n3) {
        int n4 = n2 + (n3 - n2) / 2;
        if (hashKeyArray[n4] != null) {
            int n5 = this.equals(hashKeyArray[n4]);
            if (n5 < 0 && n2 != n4) {
                return this.equals(hashKeyArray, n2, n4);
            }
            if (n5 > 0 && n2 != n4) {
                return this.equals(hashKeyArray, n4, n3);
            }
            if (n5 == 0) {
                return n4;
            }
            return -1;
        }
        return -2;
    }

    boolean equals(HashKey[] hashKeyArray, int[] nArray, int n2, int n3) {
        int n4 = n2 + (n3 - n2) / 2;
        if (hashKeyArray[n4] != null) {
            int n5 = this.equals(hashKeyArray[n4]);
            if (n2 != n4) {
                if (n5 < 0) {
                    return this.equals(hashKeyArray, nArray, n2, n4);
                }
                if (n5 > 0) {
                    return this.equals(hashKeyArray, nArray, n4, n3);
                }
            } else {
                if (n5 < 0) {
                    nArray[0] = n4;
                    return false;
                }
                if (n5 > 0) {
                    nArray[0] = n4 + 1;
                    return false;
                }
            }
            nArray[0] = n4;
            return true;
        }
        nArray[0] = n4;
        return false;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    String getLastNodeId() {
        int n2;
        for (n2 = this.count - 1; n2 > 0 && this.value[n2] != '+'; --n2) {
        }
        if (n2 > 0) {
            this.value[n2++] = '\u0000';
            int n3 = this.count - n2;
            char[] cArray = new char[n3];
            int n4 = 0;
            while (n4 < n3) {
                cArray[n4] = this.value[n2];
                this.value[n2] = '\u0000';
                ++n4;
                ++n2;
            }
            this.count -= n3 + 1;
            return new String(cArray);
        }
        return new String(this.value, 0, this.count);
    }
}

