/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

class IndexedTriangleFanArrayRetained
extends IndexedGeometryStripArrayRetained {
    IndexedTriangleFanArrayRetained() {
        this.geoType = 13;
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        Point3d[] point3dArray = new Point3d[3];
        double[] dArray = new double[1];
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        int n5 = 0;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        int[] nArray = new int[3];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        nArray[i2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i2]);
                    }
                    int n6 = this.stripIndexCounts[n4++];
                    for (int i3 = 2; i3 < n6; ++i3) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectRay(point3dArray, pickRay, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i4 = 0; i4 < 2; ++i4) {
                        nArray[i4] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i4]);
                    }
                    int n7 = this.stripIndexCounts[n4++];
                    for (int i5 = 2; i5 < n7; ++i5) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectSegment(point3dArray, pickSegment.start, pickSegment.end, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i6 = 0; i6 < 2; ++i6) {
                        nArray[i6] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i6]);
                    }
                    int n8 = this.stripIndexCounts[n4++];
                    for (int i7 = 2; i7 < n8; ++i7) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i8 = 0; i8 < 2; ++i8) {
                        nArray[i8] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i8]);
                    }
                    int n9 = this.stripIndexCounts[n4++];
                    for (int i9 = 2; i9 < n9; ++i9) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i10 = 0; i10 < 2; ++i10) {
                        nArray[i10] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i10]);
                    }
                    int n10 = this.stripIndexCounts[n4++];
                    for (int i11 = 2; i11 < n10; ++i11) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i12 = 0; i12 < 2; ++i12) {
                        nArray[i12] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i12]);
                    }
                    int n11 = this.stripIndexCounts[n4++];
                    for (int i13 = 2; i13 < n11; ++i13) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectCylinder(point3dArray, pickCylinder, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    for (int i14 = 0; i14 < 2; ++i14) {
                        nArray[i14] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[i14]);
                    }
                    int n12 = this.stripIndexCounts[n4++];
                    for (int i15 = 2; i15 < n12; ++i15) {
                        nArray[2] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[2]);
                        if (this.intersectCone(point3dArray, pickCone, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[1].set(point3dArray[2]);
                        nArray[1] = nArray[2];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d2 < Double.MAX_VALUE) {
            point3d.x = d3;
            point3d.y = d4;
            point3d.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[3];
        double[] dArray = new double[1];
        int n2 = 0;
        int n3 = 0;
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        point3dArray2[2] = new Point3d();
        switch (point3dArray.length) {
            case 3: {
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                    int n4 = this.stripIndexCounts[n2++];
                    for (int i2 = 2; i2 < n4; ++i2) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[2]);
                        if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2])) {
                            return true;
                        }
                        point3dArray2[1].set(point3dArray2[2]);
                    }
                }
                break;
            }
            case 4: {
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                    int n5 = this.stripIndexCounts[n2++];
                    for (int i3 = 2; i3 < n5; ++i3) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[2]);
                        if (this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2]) || this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3])) {
                            return true;
                        }
                        point3dArray2[1].set(point3dArray2[2]);
                    }
                }
                break;
            }
            case 2: {
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                    int n6 = this.stripIndexCounts[n2++];
                    for (int i4 = 2; i4 < n6; ++i4) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[2]);
                        if (this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray, null)) {
                            return true;
                        }
                        point3dArray2[1].set(point3dArray2[2]);
                    }
                }
                break;
            }
            case 1: {
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                    int n7 = this.stripIndexCounts[n2++];
                    for (int i5 = 2; i5 < n7; ++i5) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[2]);
                        if (this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0])) {
                            return true;
                        }
                        point3dArray2[1].set(point3dArray2[2]);
                    }
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        int n2 = 0;
        int n3 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        while (n2 < this.stripIndexCounts.length) {
            this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
            this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
            transform3D.transform(point3dArray[0]);
            transform3D.transform(point3dArray[1]);
            int n4 = this.stripIndexCounts[n2++];
            for (int i2 = 2; i2 < n4; ++i2) {
                this.getVertexData(this.indexCoord[n3++], point3dArray[2]);
                transform3D.transform(point3dArray[2]);
                if (geometryRetained.intersect(point3dArray)) {
                    return true;
                }
                point3dArray[1].set(point3dArray[2]);
            }
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        int n2 = 0;
        int n3 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                    int n4 = this.stripIndexCounts[n2++];
                    for (int i2 = 2; i2 < n4; ++i2) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[2]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, null, null)) {
                            return true;
                        }
                        point3dArray[1].set(point3dArray[2]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                    int n5 = this.stripIndexCounts[n2++];
                    for (int i3 = 2; i3 < n5; ++i3) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[2]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) {
                            return true;
                        }
                        point3dArray[1].set(point3dArray[2]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                    int n6 = this.stripIndexCounts[n2++];
                    for (int i4 = 2; i4 < n6; ++i4) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[2]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) {
                            return true;
                        }
                        point3dArray[1].set(point3dArray[2]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    int getClassType() {
        return 3;
    }
}

