/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.DoubleBufferWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.media.j3d.J3dI18N;

public class J3DBuffer {
    static final int TYPE_NULL = 0;
    static final int TYPE_UNKNOWN = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_CHAR = 3;
    static final int TYPE_SHORT = 4;
    static final int TYPE_INT = 5;
    static final int TYPE_LONG = 6;
    static final int TYPE_FLOAT = 7;
    static final int TYPE_DOUBLE = 8;
    static boolean unsupportedOperation = false;
    private Buffer originalBuffer = null;
    private BufferWrapper bufferImpl = null;
    private int bufferType = 0;

    public J3DBuffer() {
        this(null);
    }

    public J3DBuffer(Buffer buffer) {
        if (unsupportedOperation) {
            throw new UnsupportedOperationException(J3dI18N.getString("J3DBuffer0"));
        }
        this.setBuffer(buffer);
    }

    public void setBuffer(Buffer buffer) {
        int n2 = 0;
        boolean bl = false;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if (buffer == null) {
            n2 = 0;
        } else if (buffer instanceof ByteBuffer) {
            n2 = 2;
            bl = ((ByteBuffer)buffer).isDirect();
            byteOrder = ((ByteBuffer)buffer).order();
        } else if (buffer instanceof CharBuffer) {
            n2 = 3;
            bl = ((CharBuffer)buffer).isDirect();
            byteOrder = ((CharBuffer)buffer).order();
        } else if (buffer instanceof ShortBuffer) {
            n2 = 4;
            bl = ((ShortBuffer)buffer).isDirect();
            byteOrder = ((ShortBuffer)buffer).order();
        } else if (buffer instanceof IntBuffer) {
            n2 = 5;
            bl = ((IntBuffer)buffer).isDirect();
            byteOrder = ((IntBuffer)buffer).order();
        } else if (buffer instanceof LongBuffer) {
            n2 = 6;
            bl = ((LongBuffer)buffer).isDirect();
            byteOrder = ((LongBuffer)buffer).order();
        } else if (buffer instanceof FloatBuffer) {
            n2 = 7;
            bl = ((FloatBuffer)buffer).isDirect();
            byteOrder = ((FloatBuffer)buffer).order();
        } else if (buffer instanceof DoubleBuffer) {
            n2 = 8;
            bl = ((DoubleBuffer)buffer).isDirect();
            byteOrder = ((DoubleBuffer)buffer).order();
        } else {
            n2 = 1;
        }
        if (buffer != null) {
            if (!bl) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer1"));
            }
            if (byteOrder != ByteOrder.nativeOrder()) {
                throw new IllegalArgumentException(J3dI18N.getString("J3DBuffer2"));
            }
        }
        this.bufferType = n2;
        this.originalBuffer = buffer;
        switch (this.bufferType) {
            case 2: {
                ByteBuffer byteBuffer = ((ByteBuffer)buffer).asReadOnlyBuffer();
                byteBuffer.rewind();
                this.bufferImpl = new ByteBufferWrapper(byteBuffer);
                break;
            }
            case 7: {
                FloatBuffer floatBuffer = ((FloatBuffer)buffer).asReadOnlyBuffer();
                floatBuffer.rewind();
                this.bufferImpl = new FloatBufferWrapper(floatBuffer);
                break;
            }
            case 8: {
                DoubleBuffer doubleBuffer = ((DoubleBuffer)buffer).asReadOnlyBuffer();
                doubleBuffer.rewind();
                this.bufferImpl = new DoubleBufferWrapper(doubleBuffer);
                break;
            }
            default: {
                this.bufferImpl = null;
            }
        }
    }

    public Buffer getBuffer() {
        return this.originalBuffer;
    }

    int getBufferType() {
        return this.bufferType;
    }

    BufferWrapper getBufferImpl() {
        return this.bufferImpl;
    }

    private static boolean checkNativeBufferAccess(Buffer buffer) {
        return buffer != null;
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        if (!J3DBuffer.checkNativeBufferAccess(byteBuffer)) {
            unsupportedOperation = true;
        }
    }
}

