/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;

abstract class J3dStructure {
    UnorderList messageList = new UnorderList(5, J3dMessage.class);
    StructureUpdateThread updateThread = null;
    int threadType = -1;
    VirtualUniverse universe = null;
    J3dThreadData threadData = new J3dThreadData();
    int nMessage = 0;
    J3dMessage[] msgList = new J3dMessage[5];

    J3dStructure(VirtualUniverse virtualUniverse, int n2) {
        this.universe = virtualUniverse;
        this.threadType = n2;
        this.threadData.threadType = n2;
    }

    final J3dThreadData getUpdateThreadData() {
        return this.threadData;
    }

    final void addMessage(J3dMessage j3dMessage) {
        if (this.threadData != null) {
            this.threadData.lastUpdateTime = j3dMessage.time;
        } else {
            j3dMessage.time = -1L;
        }
        j3dMessage.incRefcount();
        this.messageList.add(j3dMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final J3dMessage[] getMessages(long l2) {
        int n2 = 0;
        UnorderList unorderList = this.messageList;
        synchronized (unorderList) {
            int n3 = this.messageList.size();
            if (n3 > 0) {
                J3dMessage[] j3dMessageArray = (J3dMessage[])this.messageList.toArray(false);
                for (n2 = 0; n2 < n3 && j3dMessageArray[n2].time <= l2; ++n2) {
                }
                if (n2 > 0) {
                    if (this.msgList.length < n2) {
                        this.msgList = new J3dMessage[n2];
                    }
                    this.messageList.shift(this.msgList, n2);
                }
            }
        }
        this.nMessage = n2;
        return this.msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clearMessages() {
        UnorderList unorderList = this.messageList;
        synchronized (unorderList) {
            int n2 = this.messageList.size();
            if (n2 > 0) {
                J3dMessage[] j3dMessageArray = (J3dMessage[])this.messageList.toArray(false);
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    j3dMessageArray[i2].decRefcount();
                }
                this.messageList.clear();
            }
            this.nMessage = 0;
            this.msgList = new J3dMessage[5];
        }
    }

    int getNumMessage() {
        return this.nMessage;
    }

    abstract void processMessages(long var1);

    abstract void removeNodes(J3dMessage var1);

    abstract void cleanup();
}

