/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CgGL;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.j3d.Context;
import javax.media.j3d.JoglCgShaderProgramInfo;
import javax.media.j3d.JoglShaderObject;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

class JoglContext
implements Context {
    private GLContext context;
    private int maxTexCoordSets;
    private float alphaClearValue;
    private int currentTextureUnit;
    private int currentCombinerUnit;
    private boolean hasMultisample;
    private JoglShaderObject shaderProgram;
    private VertexAttributeImpl vertexAttrImpl;
    private int glslVertexAttrOffset;
    private CGcontext cgContext;
    private int cgVertexProfile;
    private int cgFragmentProfile;

    JoglContext(GLContext gLContext) {
        this.context = gLContext;
    }

    GLContext getGLContext() {
        return this.context;
    }

    int getMaxTexCoordSets() {
        return this.maxTexCoordSets;
    }

    void setMaxTexCoordSets(int n2) {
        this.maxTexCoordSets = n2;
    }

    float getAlphaClearValue() {
        return this.alphaClearValue;
    }

    void setAlphaClearValue(float f2) {
        this.alphaClearValue = f2;
    }

    int getCurrentTextureUnit() {
        return this.currentTextureUnit;
    }

    void setCurrentTextureUnit(int n2) {
        this.currentTextureUnit = n2;
    }

    int getCurrentCombinerUnit() {
        return this.currentCombinerUnit;
    }

    void setCurrentCombinerUnit(int n2) {
        this.currentCombinerUnit = n2;
    }

    boolean getHasMultisample() {
        return this.hasMultisample;
    }

    void setHasMultisample(boolean bl) {
        this.hasMultisample = bl;
    }

    void initCgVertexAttributeImpl() {
        if (this.vertexAttrImpl != null) {
            throw new RuntimeException("Should not initialize the vertex attribute implementation twice");
        }
        this.vertexAttrImpl = new CgVertexAttributeImpl();
    }

    void initGLSLVertexAttributeImpl() {
        if (this.vertexAttrImpl != null) {
            throw new RuntimeException("Should not initialize the vertex attribute implementation twice");
        }
        this.vertexAttrImpl = new GLSLVertexAttributeImpl();
    }

    void vertexAttrPointer(GL gL, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.vertexAttrImpl.vertexAttrPointer(gL, n2, n3, n4, n5, buffer);
    }

    void enableVertexAttrArray(GL gL, int n2) {
        this.vertexAttrImpl.enableVertexAttrArray(gL, n2);
    }

    void disableVertexAttrArray(GL gL, int n2) {
        this.vertexAttrImpl.disableVertexAttrArray(gL, n2);
    }

    void vertexAttr1fv(GL gL, int n2, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr1fv(gL, n2, floatBuffer);
    }

    void vertexAttr2fv(GL gL, int n2, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr2fv(gL, n2, floatBuffer);
    }

    void vertexAttr3fv(GL gL, int n2, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr3fv(gL, n2, floatBuffer);
    }

    void vertexAttr4fv(GL gL, int n2, FloatBuffer floatBuffer) {
        this.vertexAttrImpl.vertexAttr4fv(gL, n2, floatBuffer);
    }

    JoglShaderObject getShaderProgram() {
        return this.shaderProgram;
    }

    void setShaderProgram(JoglShaderObject joglShaderObject) {
        this.shaderProgram = joglShaderObject;
    }

    int getGLSLVertexAttrOffset() {
        return this.glslVertexAttrOffset;
    }

    void setGLSLVertexAttrOffset(int n2) {
        this.glslVertexAttrOffset = n2;
    }

    CGcontext getCgContext() {
        return this.cgContext;
    }

    void setCgContext(CGcontext cGcontext) {
        this.cgContext = cGcontext;
    }

    int getCgVertexProfile() {
        return this.cgVertexProfile;
    }

    void setCgVertexProfile(int n2) {
        this.cgVertexProfile = n2;
    }

    int getCgFragmentProfile() {
        return this.cgFragmentProfile;
    }

    void setCgFragmentProfile(int n2) {
        this.cgFragmentProfile = n2;
    }

    class CgVertexAttributeImpl
    implements VertexAttributeImpl {
        CgVertexAttributeImpl() {
        }

        public void vertexAttrPointer(GL gL, int n2, int n3, int n4, int n5, Buffer buffer) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n2 < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLSetParameterPointer((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n2], (int)n3, (int)n4, (int)n5, (Buffer)buffer);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n2 + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void enableVertexAttrArray(GL gL, int n2) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n2 < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLEnableClientState((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n2]);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n2 + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void disableVertexAttrArray(GL gL, int n2) {
            JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)JoglContext.this.shaderProgram;
            if (joglCgShaderProgramInfo != null && n2 < joglCgShaderProgramInfo.getNumVertexAttributes()) {
                CgGL.cgGLDisableClientState((CGparameter)joglCgShaderProgramInfo.getVertexAttributes()[n2]);
            } else if (joglCgShaderProgramInfo == null) {
                System.err.println("    shaderProgramInfo is null");
            } else {
                System.err.println("    index (" + n2 + ") out of range: numVtxAttrs = " + joglCgShaderProgramInfo.getNumVertexAttributes());
            }
        }

        public void vertexAttr1fv(GL gL, int n2, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr1fv");
        }

        public void vertexAttr2fv(GL gL, int n2, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr2fv");
        }

        public void vertexAttr3fv(GL gL, int n2, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr3fv");
        }

        public void vertexAttr4fv(GL gL, int n2, FloatBuffer floatBuffer) {
            throw new RuntimeException("Java 3D ERROR : Assertion failed: invalid call to cgVertexAttr4fv");
        }
    }

    class GLSLVertexAttributeImpl
    implements VertexAttributeImpl {
        GLSLVertexAttributeImpl() {
        }

        public void vertexAttrPointer(GL gL, int n2, int n3, int n4, int n5, Buffer buffer) {
            gL.glVertexAttribPointerARB(n2 + JoglContext.this.glslVertexAttrOffset, n3, n4, false, n5, buffer);
        }

        public void enableVertexAttrArray(GL gL, int n2) {
            gL.glEnableVertexAttribArrayARB(n2 + JoglContext.this.glslVertexAttrOffset);
        }

        public void disableVertexAttrArray(GL gL, int n2) {
            gL.glDisableVertexAttribArrayARB(n2 + JoglContext.this.glslVertexAttrOffset);
        }

        public void vertexAttr1fv(GL gL, int n2, FloatBuffer floatBuffer) {
            gL.glVertexAttrib1fvARB(n2 + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr2fv(GL gL, int n2, FloatBuffer floatBuffer) {
            gL.glVertexAttrib2fvARB(n2 + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr3fv(GL gL, int n2, FloatBuffer floatBuffer) {
            gL.glVertexAttrib3fvARB(n2 + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }

        public void vertexAttr4fv(GL gL, int n2, FloatBuffer floatBuffer) {
            gL.glVertexAttrib4fvARB(n2 + JoglContext.this.glslVertexAttrOffset, floatBuffer);
        }
    }

    static interface VertexAttributeImpl {
        public void vertexAttrPointer(GL var1, int var2, int var3, int var4, int var5, Buffer var6);

        public void enableVertexAttrArray(GL var1, int var2);

        public void disableVertexAttrArray(GL var1, int var2);

        public void vertexAttr1fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr2fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr3fv(GL var1, int var2, FloatBuffer var3);

        public void vertexAttr4fv(GL var1, int var2, FloatBuffer var3);
    }
}

