/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.opengl.cg.CGcontext;
import com.sun.opengl.cg.CGparameter;
import com.sun.opengl.cg.CGprogram;
import com.sun.opengl.cg.CgGL;
import com.sun.opengl.util.BufferUtil;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.Drawable;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.JoglCgShaderInfo;
import javax.media.j3d.JoglCgShaderParameter;
import javax.media.j3d.JoglCgShaderProgramInfo;
import javax.media.j3d.JoglContext;
import javax.media.j3d.JoglDrawable;
import javax.media.j3d.JoglDrawingSurfaceObject;
import javax.media.j3d.JoglGraphicsConfiguration;
import javax.media.j3d.JoglShaderObject;
import javax.media.j3d.Pipeline;
import javax.media.j3d.ShaderAttrLoc;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderId;
import javax.media.j3d.ShaderProgramId;
import javax.media.j3d.VirtualUniverse;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.AbstractGraphicsConfiguration;
import javax.media.opengl.AbstractGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;
import javax.media.opengl.glu.GLU;

class JoglPipeline
extends Pipeline {
    private boolean cgLibraryAvailable = false;
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean EXTRA_DEBUGGING = false;
    private static final int WAIT_TIME = 1000;
    private static final int MIN_FRAME_SIZE = 1;
    private static final float[] black;
    private static final int[][] screen_door;
    private static final ByteBuffer[] screen_door_table;
    private static final int[] blendFunctionTable;
    private static final int[] _gl_combineRgbSrcIndex;
    private static final int[] _gl_combineAlphaSrcIndex;
    private static final int[] _gl_combineRgbOpIndex;
    private static final int[] _gl_combineAlphaOpIndex;
    private static final int[] _gl_combineSrc;
    private static final int[] _gl_combineFcn;
    private static final int[] _gl_textureCubeMapFace;
    int numInvalidLists = 0;
    private static final int DISABLE_STEREO = 1;
    private static final int DISABLE_AA = 2;
    private static final int DISABLE_DOUBLE_BUFFER = 3;
    private boolean checkedForGetScreenMethod = false;
    private Method getScreenMethod = null;
    private static ThreadLocal nioVertexTemp;
    private static ThreadLocal nioVertexDoubleTemp;
    private static ThreadLocal nioColorTemp;
    private static ThreadLocal nioColorByteTemp;
    private static ThreadLocal nioNormalTemp;
    private static ThreadLocal nioTexCoordSetTemp;
    private static ThreadLocal nioVertexAttrSetTemp;

    protected JoglPipeline() {
    }

    void initialize(Pipeline.Type type) {
        super.initialize(type);
        assert (type == Pipeline.Type.JOGL);
        Threading.disableSingleThreading();
    }

    void loadLibraries(int n2) {
        if (n2 == 2) {
            try {
                Class.forName("com.sun.opengl.cg.CgGL");
                this.cgLibraryAvailable = true;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            catch (Error error) {
                System.err.println(error);
            }
        }
    }

    boolean isCgLibraryAvailable() {
        return this.cgLibraryAvailable;
    }

    boolean isGLSLLibraryAvailable() {
        return true;
    }

    void freeD3DArray(GeometryArrayRetained geometryArrayRetained, boolean bl) {
    }

    void execute(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int n9, int[] nArray3, float[] fArray, float[] fArray2, int n10) {
        this.executeGeometryArray(context, geometryArrayRetained, n2, bl, bl2, bl3, n3, n4, n5, n6, nArray, n7, nArray2, n8, n9, nArray3, fArray, null, fArray2, n10);
    }

    void executeVA(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float[] fArray, double[] dArray, int n7, float[] fArray2, byte[] byArray, int n8, float[] fArray3, int n9, int[] nArray, int[] nArray2, float[][] fArray4, int n10, int[] nArray3, int n11, int[] nArray4, int n12, Object[] objectArray, int n13) {
        boolean bl3 = (n5 & 1) != 0;
        boolean bl4 = (n5 & 2) != 0;
        boolean bl5 = (n5 & 4) != 0;
        boolean bl6 = (n5 & 8) != 0;
        boolean bl7 = (n5 & 0x10) != 0;
        boolean bl8 = (n5 & 0x40) != 0;
        boolean bl9 = (n5 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl9) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        if (bl3) {
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (bl4) {
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray);
        }
        if (bl5) {
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2);
        } else if (bl6) {
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray);
        }
        if (bl7) {
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3);
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n14 = 0;
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n14 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n2, bl, bl2, n3, n4, n5, n6, floatBuffer, doubleBuffer, n7, floatBuffer2, byteBuffer, n8, floatBuffer3, n9, nArray, nArray2, floatBufferArray2, n10, nArray3, n11, nArray4, n12, floatBufferArray, n13, nArray5, n14, nArray6);
    }

    void executeVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, Object object, int n7, Object object2, float[] fArray, byte[] byArray, int n8, Object object3, int n9, int[] nArray, int[] nArray2, Object[] objectArray, int n10, int[] nArray3, int n11, int[] nArray4, int n12, Object[] objectArray2, int n13) {
        boolean bl3 = (n5 & 1) != 0;
        boolean bl4 = (n5 & 2) != 0;
        boolean bl5 = (n5 & 4) != 0;
        boolean bl6 = (n5 & 8) != 0;
        boolean bl7 = (n5 & 0x10) != 0;
        boolean bl8 = (n5 & 0x40) != 0;
        boolean bl9 = (n5 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer(objectArray);
        }
        if (bl9) {
            floatBufferArray = new FloatBuffer[objectArray2.length];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                floatBufferArray[i2] = (FloatBuffer)objectArray2[i2];
            }
        }
        if (bl3) {
            floatBuffer = (FloatBuffer)object;
        } else if (bl4) {
            doubleBuffer = (DoubleBuffer)object;
        }
        if (floatBuffer == null && doubleBuffer == null) {
            return;
        }
        if (bl5) {
            floatBuffer2 = fArray != null ? JoglPipeline.getColorArrayBuffer(fArray) : (FloatBuffer)object2;
        } else if (bl6) {
            byteBuffer = byArray != null ? JoglPipeline.getColorArrayBuffer(byArray) : (ByteBuffer)object2;
        }
        if (bl7) {
            floatBuffer3 = (FloatBuffer)object3;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n14 = 0;
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n14 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n2, bl, bl2, n3, n4, n5, n6, floatBuffer, doubleBuffer, n7, floatBuffer2, byteBuffer, n8, floatBuffer3, n9, nArray, nArray2, floatBufferArray2, n10, nArray3, n11, nArray4, n12, floatBufferArray, n13, nArray5, n14, nArray6);
    }

    void executeInterleavedBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, Object object, float[] fArray, int n9) {
        this.executeGeometryArray(context, geometryArrayRetained, n2, bl, bl2, bl3, n3, n4, n5, n6, nArray, n7, nArray2, n8, 0, null, null, (Buffer)object, fArray, n9);
    }

    void setVertexFormat(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2) {
        GL gL = this.context(context).getGL();
        if ((n2 & 2) != 0) {
            gL.glEnableClientState(32885);
        } else {
            gL.glDisableClientState(32885);
        }
        if (!bl2 && (n2 & 4) != 0) {
            gL.glEnableClientState(32886);
        } else {
            gL.glDisableClientState(32886);
        }
        if (gL.isExtensionAvailable("GL_SUN_global_alpha")) {
            if (bl) {
                gL.glEnable(33241);
            } else {
                gL.glDisable(33241);
            }
        }
        if ((n2 & 1) != 0) {
            gL.glEnableClientState(32884);
        } else {
            gL.glDisableClientState(32884);
        }
    }

    void disableGlobalAlpha(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2) {
        GL gL = this.context(context).getGL();
        if (gL.isExtensionAvailable("GL_SUN_global_alpha") && !bl2 && (n2 & 4) != 0 && bl) {
            gL.glDisable(33241);
        }
    }

    void buildGA(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, float f2, boolean bl3, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray) {
        int n9;
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(context).getGL();
        FloatBuffer floatBuffer = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        if ((n5 & 1) != 0) {
            n10 += 3;
        }
        if ((n5 & 2) != 0) {
            n10 += 3;
            n11 += 3;
        }
        if ((n5 & 4) != 0) {
            if ((n5 & 0x80) != 0) {
                if ((n5 & 8) != 0) {
                    n10 += 4;
                    n12 += 4;
                    n11 += 4;
                } else {
                    n10 += 3;
                    n12 += 3;
                    n11 += 3;
                }
            } else {
                n10 += 4;
                n12 += 4;
                n11 += 4;
            }
        }
        if ((n5 & 0x460) != 0) {
            if ((n5 & 0x20) != 0) {
                n15 = 2 * n6;
            } else if ((n5 & 0x40) != 0) {
                n15 = 3 * n6;
            } else if ((n5 & 0x400) != 0) {
                n15 = 4 * n6;
            }
            n10 += n15;
            n12 += n15;
            n13 += n15;
            n11 += n15;
        }
        int n17 = 0;
        if ((n5 & 0x1000) != 0) {
            for (n9 = 0; n9 < n8; ++n9) {
                n17 += nArray3[n9];
            }
            n10 += n17;
            n12 += n17;
            n13 += n17;
            n11 += n17;
            n14 += n17;
        }
        n9 = n10 * 4;
        int n18 = n3 * n10;
        n12 += n18;
        n13 += n18;
        n11 += n18;
        n14 += n18;
        n16 += n18;
        boolean bl4 = false;
        if (bl2 && !bl3) {
            bl4 = true;
        }
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            int[] nArray4 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            int n19 = 0;
            switch (n2) {
                case 5: {
                    n19 = 5;
                    break;
                }
                case 6: {
                    n19 = 6;
                    break;
                }
                case 7: {
                    n19 = 3;
                }
            }
            if (bl3) {
                n5 &= 0xFFFFFFFB;
            }
            for (int i2 = 0; i2 < nArray4.length; ++i2) {
                gL.glBegin(n19);
                for (int i3 = 0; i3 < nArray4[i2]; ++i3) {
                    float f3;
                    float f4;
                    float f5;
                    if ((n5 & 2) != 0) {
                        if (dArray2 != null) {
                            f5 = (float)(dArray2[0] * (double)fArray[n12] + dArray2[1] * (double)fArray[n12 + 1] + dArray2[2] * (double)fArray[n12 + 2]);
                            f4 = (float)(dArray2[4] * (double)fArray[n12] + dArray2[5] * (double)fArray[n12 + 1] + dArray2[6] * (double)fArray[n12 + 2]);
                            f3 = (float)(dArray2[8] * (double)fArray[n12] + dArray2[9] * (double)fArray[n12 + 1] + dArray2[10] * (double)fArray[n12 + 2]);
                            gL.glNormal3f(f5, f4, f3);
                        } else {
                            gL.glNormal3f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2]);
                        }
                    }
                    if ((n5 & 4) != 0) {
                        if (bl4) {
                            gL.glColor4f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2], fArray[n13 + 3] * f2);
                        } else if ((n5 & 8) != 0) {
                            gL.glColor4f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2], fArray[n13 + 3]);
                        } else {
                            gL.glColor3f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2]);
                        }
                    }
                    if ((n5 & 0x1000) != 0) {
                        int n20 = n16;
                        if (floatBuffer == null) {
                            floatBuffer = FloatBuffer.wrap(fArray);
                        }
                        for (int i4 = 0; i4 < n8; ++i4) {
                            switch (nArray3[i4]) {
                                case 1: {
                                    floatBuffer.position(n20);
                                    joglContext.vertexAttr1fv(gL, i4, floatBuffer);
                                    break;
                                }
                                case 2: {
                                    floatBuffer.position(n20);
                                    joglContext.vertexAttr2fv(gL, i4, floatBuffer);
                                    break;
                                }
                                case 3: {
                                    floatBuffer.position(n20);
                                    joglContext.vertexAttr3fv(gL, i4, floatBuffer);
                                    break;
                                }
                                case 4: {
                                    floatBuffer.position(n20);
                                    joglContext.vertexAttr4fv(gL, i4, floatBuffer);
                                }
                            }
                            n20 += nArray3[i4];
                        }
                    }
                    if ((n5 & 0x460) != 0 && n7 > 0) {
                        if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
                            if ((n5 & 0x20) != 0) {
                                for (int i5 = 0; i5 < n7; ++i5) {
                                    if (nArray2[i5] == -1) continue;
                                    int n21 = n14 + nArray2[i5];
                                    gL.glMultiTexCoord2f(33984 + i5, fArray[n21], fArray[n21 + 1]);
                                }
                            } else if ((n5 & 0x40) != 0) {
                                for (int i6 = 0; i6 < n7; ++i6) {
                                    if (nArray2[i6] == -1) continue;
                                    int n22 = n14 + nArray2[i6];
                                    gL.glMultiTexCoord3f(33984 + i6, fArray[n22], fArray[n22 + 1], fArray[n22 + 2]);
                                }
                            } else {
                                for (int i7 = 0; i7 < n7; ++i7) {
                                    if (nArray2[i7] == -1) continue;
                                    int n23 = n14 + nArray2[i7];
                                    gL.glMultiTexCoord4f(33984 + i7, fArray[n23], fArray[n23 + 1], fArray[n23 + 2], fArray[n23 + 3]);
                                }
                            }
                        } else if (nArray2[0] != -1) {
                            int n24 = n14 + nArray2[0];
                            if ((n5 & 0x20) != 0) {
                                gL.glTexCoord2f(fArray[n24], fArray[n24 + 1]);
                            } else if ((n5 & 0x40) != 0) {
                                gL.glTexCoord3f(fArray[n24], fArray[n24 + 1], fArray[n24 + 2]);
                            } else {
                                gL.glTexCoord4f(fArray[n24], fArray[n24 + 1], fArray[n24 + 2], fArray[n24 + 3]);
                            }
                        }
                    }
                    if ((n5 & 1) != 0) {
                        if (dArray != null) {
                            f5 = (float)(dArray[12] * (double)fArray[n11] + dArray[13] * (double)fArray[n11 + 1] + dArray[14] * (double)fArray[n11 + 2] + dArray[15]);
                            f4 = 1.0f / f5;
                            f3 = (float)(dArray[0] * (double)fArray[n11] + dArray[1] * (double)fArray[n11 + 1] + dArray[2] * (double)fArray[n11 + 2] + dArray[3]) * f4;
                            float f6 = (float)(dArray[4] * (double)fArray[n11] + dArray[5] * (double)fArray[n11 + 1] + dArray[6] * (double)fArray[n11 + 2] + dArray[7]) * f4;
                            float f7 = (float)(dArray[8] * (double)fArray[n11] + dArray[9] * (double)fArray[n11 + 1] + dArray[10] * (double)fArray[n11 + 2] + dArray[11]) * f4;
                            gL.glVertex3f(f3, f6, f7);
                        } else {
                            gL.glVertex3f(fArray[n11], fArray[n11 + 1], fArray[n11 + 2]);
                        }
                    }
                    n12 += n10;
                    n13 += n10;
                    n11 += n10;
                    n14 += n10;
                    n16 += n10;
                }
                gL.glEnd();
            }
        } else if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4) {
            int n25 = 0;
            switch (n2) {
                case 1: {
                    n25 = 7;
                    break;
                }
                case 2: {
                    n25 = 4;
                    break;
                }
                case 3: {
                    n25 = 0;
                    break;
                }
                case 4: {
                    n25 = 1;
                }
            }
            if (bl3) {
                n5 &= 0xFFFFFFFB;
            }
            gL.glBegin(n25);
            for (int i8 = 0; i8 < n4; ++i8) {
                float f8;
                float f9;
                if ((n5 & 2) != 0) {
                    if (dArray2 != null) {
                        float f10 = (float)(dArray2[0] * (double)fArray[n12] + dArray2[1] * (double)fArray[n12 + 1] + dArray2[2] * (double)fArray[n12 + 2]);
                        float f11 = (float)(dArray2[4] * (double)fArray[n12] + dArray2[5] * (double)fArray[n12 + 1] + dArray2[6] * (double)fArray[n12 + 2]);
                        f9 = (float)(dArray2[8] * (double)fArray[n12] + dArray2[9] * (double)fArray[n12 + 1] + dArray2[10] * (double)fArray[n12 + 2]);
                        gL.glNormal3f(f10, f11, f9);
                    } else {
                        gL.glNormal3f(fArray[n12], fArray[n12 + 1], fArray[n12 + 2]);
                    }
                }
                if ((n5 & 4) != 0) {
                    if (bl4) {
                        float f12;
                        float f13;
                        if ((n5 & 8) != 0) {
                            f13 = fArray[n13];
                            f12 = fArray[n13 + 1];
                            f9 = fArray[n13 + 2];
                            f8 = fArray[n13 + 3] * f2;
                        } else {
                            f13 = fArray[n13];
                            f12 = fArray[n13 + 1];
                            f9 = fArray[n13 + 2];
                            f8 = f2;
                        }
                        gL.glColor4f(f13, f12, f9, f8);
                    } else if ((n5 & 8) != 0) {
                        gL.glColor4f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2], fArray[n13 + 3]);
                    } else {
                        gL.glColor3f(fArray[n13], fArray[n13 + 1], fArray[n13 + 2]);
                    }
                }
                if ((n5 & 0x1000) != 0) {
                    int n26 = n16;
                    if (floatBuffer == null) {
                        floatBuffer = FloatBuffer.wrap(fArray);
                    }
                    for (int i9 = 0; i9 < n8; ++i9) {
                        switch (nArray3[i9]) {
                            case 1: {
                                floatBuffer.position(n26);
                                joglContext.vertexAttr1fv(gL, i9, floatBuffer);
                                break;
                            }
                            case 2: {
                                floatBuffer.position(n26);
                                joglContext.vertexAttr2fv(gL, i9, floatBuffer);
                                break;
                            }
                            case 3: {
                                floatBuffer.position(n26);
                                joglContext.vertexAttr3fv(gL, i9, floatBuffer);
                                break;
                            }
                            case 4: {
                                floatBuffer.position(n26);
                                joglContext.vertexAttr4fv(gL, i9, floatBuffer);
                            }
                        }
                        n26 += nArray3[i9];
                    }
                }
                if ((n5 & 0x460) != 0 && n7 > 0) {
                    if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
                        if ((n5 & 0x20) != 0) {
                            for (int i10 = 0; i10 < n7; ++i10) {
                                if (nArray2[i10] == -1) continue;
                                int n27 = n14 + nArray2[i10];
                                gL.glMultiTexCoord2f(33984 + i10, fArray[n27], fArray[n27 + 1]);
                            }
                        } else if ((n5 & 0x40) != 0) {
                            for (int i11 = 0; i11 < n7; ++i11) {
                                if (nArray2[i11] == -1) continue;
                                int n28 = n14 + nArray2[i11];
                                gL.glMultiTexCoord3f(33984 + i11, fArray[n28], fArray[n28 + 1], fArray[n28 + 2]);
                            }
                        } else {
                            for (int i12 = 0; i12 < n7; ++i12) {
                                if (nArray2[i12] == -1) continue;
                                int n29 = n14 + nArray2[i12];
                                gL.glMultiTexCoord4f(33984 + i12, fArray[n29], fArray[n29 + 1], fArray[n29 + 2], fArray[n29 + 3]);
                            }
                        }
                    } else if (nArray2[0] != -1) {
                        int n30 = n14 + nArray2[0];
                        if ((n5 & 0x20) != 0) {
                            gL.glTexCoord2f(fArray[n30], fArray[n30 + 1]);
                        } else if ((n5 & 0x40) != 0) {
                            gL.glTexCoord3f(fArray[n30], fArray[n30 + 1], fArray[n30 + 2]);
                        } else {
                            gL.glTexCoord4f(fArray[n30], fArray[n30 + 1], fArray[n30 + 2], fArray[n30 + 3]);
                        }
                    }
                }
                if ((n5 & 1) != 0) {
                    if (dArray != null) {
                        float f14 = (float)(dArray[12] * (double)fArray[n11] + dArray[13] * (double)fArray[n11 + 1] + dArray[14] * (double)fArray[n11 + 2] + dArray[15]);
                        float f15 = 1.0f / f14;
                        f9 = (float)(dArray[0] * (double)fArray[n11] + dArray[1] * (double)fArray[n11 + 1] + dArray[2] * (double)fArray[n11 + 2] + dArray[3]) * f15;
                        f8 = (float)(dArray[4] * (double)fArray[n11] + dArray[5] * (double)fArray[n11 + 1] + dArray[6] * (double)fArray[n11 + 2] + dArray[7]) * f15;
                        float f16 = (float)(dArray[8] * (double)fArray[n11] + dArray[9] * (double)fArray[n11 + 1] + dArray[10] * (double)fArray[n11 + 2] + dArray[11]) * f15;
                        gL.glVertex3f(f9, f8, f16);
                    } else {
                        gL.glVertex3f(fArray[n11], fArray[n11 + 1], fArray[n11 + 2]);
                    }
                }
                n12 += n10;
                n13 += n10;
                n11 += n10;
                n14 += n10;
                n16 += n10;
            }
            gL.glEnd();
        }
    }

    void buildGAForByRef(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, float f2, boolean bl3, int n3, int n4, int n5, int n6, float[] fArray, double[] dArray, int n7, float[] fArray2, byte[] byArray, int n8, float[] fArray3, int n9, int[] nArray, int[] nArray2, float[][] fArray4, int n10, int[] nArray3, int[] nArray4, int n11, Object[] objectArray, double[] dArray2, double[] dArray3) {
        int n12;
        int n13;
        GL gL = this.context(context).getGL();
        boolean bl4 = (n5 & 1) != 0;
        boolean bl5 = (n5 & 2) != 0;
        boolean bl6 = (n5 & 4) != 0;
        boolean bl7 = (n5 & 8) != 0;
        boolean bl8 = (n5 & 0x10) != 0;
        boolean bl9 = (n5 & 0x40) != 0;
        boolean bl10 = (n5 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl9) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl10) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        boolean bl11 = false;
        if (bl2 && !bl3) {
            bl11 = true;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int n14 = 0;
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            n14 = nArray5.length;
            nArray6 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        if (bl3) {
            n4 &= 0xFFFFFFFB;
            bl6 = false;
            bl7 = false;
        }
        if (bl4) {
            gL.glEnableClientState(32884);
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray, dArray2 == null);
            if (dArray2 != null) {
                for (n13 = n6; n13 < n3 * 3; n13 += 3) {
                    floatBuffer.put(n13, (float)(dArray2[0] * (double)fArray[n13] + dArray2[1] * (double)fArray[n13 + 1] + dArray2[2] * (double)fArray[n13 + 2]));
                    floatBuffer.put(n13 + 1, (float)(dArray2[4] * (double)fArray[n13] + dArray2[5] * (double)fArray[n13 + 1] + dArray2[6] * (double)fArray[n13 + 2]));
                    floatBuffer.put(n13 + 2, (float)(dArray2[8] * (double)fArray[n13] + dArray2[9] * (double)fArray[n13 + 1] + dArray2[10] * (double)fArray[n13 + 2]));
                }
            }
        } else if (bl5) {
            gL.glEnableClientState(32884);
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray, dArray2 == null);
            if (dArray2 != null) {
                for (n13 = n6; n13 < n3 * 3; n13 += 3) {
                    doubleBuffer.put(n13, dArray2[0] * dArray[n13] + dArray2[1] * dArray[n13 + 1] + dArray2[2] * dArray[n13 + 2]);
                    doubleBuffer.put(n13 + 1, dArray2[4] * dArray[n13] + dArray2[5] * dArray[n13 + 1] + dArray2[6] * dArray[n13 + 2]);
                    doubleBuffer.put(n13 + 2, dArray2[8] * dArray[n13] + dArray2[9] * dArray[n13 + 1] + dArray2[10] * dArray[n13 + 2]);
                }
            }
        } else {
            gL.glDisableClientState(32884);
        }
        if (bl6) {
            gL.glEnableClientState(32886);
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2, !bl11);
            if (bl11) {
                if ((n4 & 8) != 0) {
                    for (n13 = n7; n13 < n3 * 4; n13 += 4) {
                        floatBuffer2.put(n13, fArray2[n13]);
                        floatBuffer2.put(n13 + 1, fArray2[n13 + 1]);
                        floatBuffer2.put(n13 + 2, fArray2[n13 + 2]);
                        floatBuffer2.put(n13 + 3, f2 * fArray2[n13 + 3]);
                    }
                } else {
                    n13 = 0;
                    for (n12 = n7; n12 < n3 * 4; n12 += 4) {
                        floatBuffer2.put(n12, fArray2[n13++]);
                        floatBuffer2.put(n12 + 1, fArray2[n13++]);
                        floatBuffer2.put(n12 + 2, fArray2[n13++]);
                        floatBuffer2.put(n12 + 3, f2);
                    }
                }
                n4 |= 8;
            }
        } else if (bl7) {
            gL.glEnableClientState(32886);
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray, !bl11);
            if (bl11) {
                if ((n4 & 8) != 0) {
                    for (n13 = n7; n13 < n3 * 4; n13 += 4) {
                        byteBuffer.put(n13, byArray[n13]);
                        byteBuffer.put(n13 + 1, byArray[n13 + 1]);
                        byteBuffer.put(n13 + 2, byArray[n13 + 2]);
                        byteBuffer.put(n13 + 3, (byte)(f2 * (float)(byArray[n13 + 3] & 0xFF)));
                    }
                } else {
                    n13 = 0;
                    for (n12 = n7; n12 < n3 * 4; n12 += 4) {
                        byteBuffer.put(n12, byArray[n13++]);
                        byteBuffer.put(n12 + 1, byArray[n13++]);
                        byteBuffer.put(n12 + 2, byArray[n13++]);
                        byteBuffer.put(n12 + 3, (byte)(f2 * 255.0f));
                    }
                }
                n4 |= 8;
            }
        } else {
            gL.glDisableClientState(32886);
        }
        if (bl8) {
            gL.glEnableClientState(32885);
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3, dArray3 == null);
            if (dArray3 != null) {
                for (n13 = n8; n13 < n3 * 3; n13 += 3) {
                    floatBuffer3.put(n13, (float)(dArray3[0] * (double)fArray3[n13] + dArray3[1] * (double)fArray3[n13 + 1] + dArray3[2] * (double)fArray3[n13 + 2]));
                    floatBuffer3.put(n13 + 1, (float)(dArray3[4] * (double)fArray3[n13] + dArray3[5] * (double)fArray3[n13 + 1] + dArray3[6] * (double)fArray3[n13 + 2]));
                    floatBuffer3.put(n13 + 2, (float)(dArray3[8] * (double)fArray3[n13] + dArray3[9] * (double)fArray3[n13 + 1] + dArray3[10] * (double)fArray3[n13 + 2]));
                }
            }
        } else {
            gL.glDisableClientState(32885);
        }
        this.executeGeometryArrayVA(context, geometryArrayRetained, n2, bl, bl3, n3, n4, n5, n6, floatBuffer, doubleBuffer, n7, floatBuffer2, byteBuffer, n8, floatBuffer3, n9, nArray, nArray2, floatBufferArray2, n10, nArray3, n10, nArray4, n11, floatBufferArray, 0, nArray5, n14, nArray6);
    }

    private void testForInterleavedArrays(int n2, boolean[] blArray, int[] nArray) {
        blArray[0] = true;
        switch (n2) {
            case 1: {
                nArray[0] = 10785;
                break;
            }
            case 3: {
                nArray[0] = 10789;
                break;
            }
            case 33: {
                nArray[0] = 10791;
                break;
            }
            case 7: 
            case 15: {
                nArray[0] = 10790;
                break;
            }
            case 35: {
                nArray[0] = 10795;
                break;
            }
            case 39: 
            case 47: {
                nArray[0] = 10796;
                break;
            }
            default: {
                blArray[0] = false;
            }
        }
    }

    private void enableTexCoordPointer(GL gL, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.clientActiveTextureUnit(gL, n2);
        gL.glEnableClientState(32888);
        gL.glTexCoordPointer(n3, n4, n5, buffer);
    }

    private void disableTexCoordPointer(GL gL, int n2) {
        this.clientActiveTextureUnit(gL, n2);
        gL.glDisableClientState(32888);
    }

    private void clientActiveTextureUnit(GL gL, int n2) {
        if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glClientActiveTexture(n2 + 33984);
        }
    }

    private void executeTexture(int n2, int n3, int n4, int n5, int[] nArray, int n6, FloatBuffer floatBuffer, GL gL) {
        int n7 = 0;
        for (int i2 = 0; i2 < n6; ++i2) {
            n7 = i2;
            if (n7 < n2 && nArray[n7] != -1) {
                floatBuffer.position(n5 + nArray[n7]);
                this.enableTexCoordPointer(gL, i2, n3, 5126, n4, floatBuffer);
                continue;
            }
            this.disableTexCoordPointer(gL, i2);
        }
    }

    private void resetTexture(GL gL, JoglContext joglContext) {
        for (int i2 = 0; i2 < joglContext.getMaxTexCoordSets(); ++i2) {
            this.disableTexCoordPointer(gL, i2);
        }
        this.clientActiveTextureUnit(gL, 0);
    }

    private void executeGeometryArray(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int[] nArray, int n7, int[] nArray2, int n8, int n9, int[] nArray3, float[] fArray, Buffer buffer, float[] fArray2, int n10) {
        int n11;
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(joglContext);
        GL gL = gLContext.getGL();
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        FloatBuffer floatBuffer = null;
        FloatBuffer floatBuffer2 = null;
        int[] nArray4 = null;
        int[] nArray5 = null;
        if ((n5 & 1) != 0) {
            n14 += 3;
        }
        if ((n5 & 2) != 0) {
            n14 += 3;
            n15 += 3;
        }
        if ((n5 & 4) != 0) {
            if ((n5 & 8) != 0) {
                n14 += 4;
                n16 += 4;
                n15 += 4;
            } else {
                n14 += 3;
                n16 += 3;
                n15 += 3;
            }
        }
        if ((n5 & 0x460) != 0) {
            if ((n5 & 0x20) != 0) {
                n19 = 2;
                n20 = 2 * n6;
            } else if ((n5 & 0x40) != 0) {
                n19 = 3;
                n20 = 3 * n6;
            } else if ((n5 & 0x400) != 0) {
                n19 = 4;
                n20 = 4 * n6;
            }
            n14 += n20;
            n16 += n20;
            n17 += n20;
            n15 += n20;
        }
        if ((n5 & 0x1000) != 0) {
            for (n11 = 0; n11 < n9; ++n11) {
                n22 += nArray3[n11];
            }
            n14 += n22;
            n16 += n22;
            n17 += n22;
            n15 += n22;
            n18 += n22;
        }
        n23 = n14 * 4;
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            nArray4 = ((GeometryStripArrayRetained)geometryArrayRetained).stripVertexCounts;
            nArray5 = ((GeometryStripArrayRetained)geometryArrayRetained).stripStartOffsetIndices;
        }
        if (fArray != null) {
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (buffer != null) {
            floatBuffer = (FloatBuffer)buffer;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        n11 = n14;
        if (fArray2 != null) {
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2);
            n11 = 4;
        } else {
            floatBuffer2 = floatBuffer;
        }
        n24 = n11 * 4;
        if (bl) {
            gL.glEnable(2977);
        }
        int n25 = n14 * n3;
        int n26 = n11 * n3;
        if (floatBuffer2 == floatBuffer) {
            n26 += n17;
        }
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            boolean bl4;
            if (bl3 || fArray2 != null || (n5 & 0x460) != 0 && (n7 > 1 || n6 > 1)) {
                bl4 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n5, blArray, nArray6);
                bl4 = blArray[0];
                n12 = nArray6[0];
            }
            if (bl4) {
                floatBuffer.position(n25);
                gL.glInterleavedArrays(n12, n23, (Buffer)floatBuffer);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer.position(n25 + n16);
                    gL.glNormalPointer(5126, n23, (Buffer)floatBuffer);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    floatBuffer2.position(n26);
                    if ((n5 & 8) != 0 || bl2) {
                        gL.glColorPointer(4, 5126, n24, (Buffer)floatBuffer2);
                    } else {
                        gL.glColorPointer(3, 5126, n24, (Buffer)floatBuffer2);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer.position(n25 + n15);
                    gL.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n7, n19, n23, n18, nArray2, n8, floatBuffer, gL);
                }
                if ((n5 & 0x1000) != 0) {
                    int n27 = n25 + n21;
                    for (int i2 = 0; i2 < n9; ++i2) {
                        joglContext.enableVertexAttrArray(gL, i2);
                        floatBuffer.position(n27);
                        joglContext.vertexAttrPointer(gL, i2, nArray3[i2], 5126, n23, floatBuffer);
                        n27 += nArray3[i2];
                    }
                }
            }
            switch (n2) {
                case 5: {
                    n13 = 5;
                    break;
                }
                case 6: {
                    n13 = 6;
                    break;
                }
                case 7: {
                    n13 = 3;
                }
            }
            if (gL.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gL.glMultiDrawArraysEXT(n13, nArray5, 0, nArray4, 0, nArray4.length);
            } else {
                for (int i3 = 0; i3 < nArray4.length; ++i3) {
                    gL.glDrawArrays(n13, nArray5[i3], nArray4[i3]);
                }
            }
        } else if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4) {
            boolean bl5;
            if (bl3 || fArray2 != null || (n5 & 0x460) != 0 && (n7 > 1 || n6 > 1)) {
                bl5 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray7 = new int[1];
                this.testForInterleavedArrays(n5, blArray, nArray7);
                bl5 = blArray[0];
                n12 = nArray7[0];
            }
            if (bl5) {
                floatBuffer.position(n25);
                gL.glInterleavedArrays(n12, n23, (Buffer)floatBuffer);
            } else {
                if ((n5 & 2) != 0) {
                    floatBuffer.position(n25 + n16);
                    gL.glNormalPointer(5126, n23, (Buffer)floatBuffer);
                }
                if (!bl3 && (n5 & 4) != 0) {
                    floatBuffer2.position(n26);
                    if ((n5 & 8) != 0 || bl2) {
                        gL.glColorPointer(4, 5126, n24, (Buffer)floatBuffer2);
                    } else {
                        gL.glColorPointer(3, 5126, n24, (Buffer)floatBuffer2);
                    }
                }
                if ((n5 & 1) != 0) {
                    floatBuffer.position(n25 + n15);
                    gL.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer);
                }
                if ((n5 & 0x460) != 0) {
                    this.executeTexture(n7, n19, n23, n18, nArray2, n8, floatBuffer, gL);
                }
                if ((n5 & 0x1000) != 0) {
                    int n28 = n25 + n21;
                    for (int i4 = 0; i4 < n9; ++i4) {
                        joglContext.enableVertexAttrArray(gL, i4);
                        floatBuffer.position(n28);
                        joglContext.vertexAttrPointer(gL, i4, nArray3[i4], 5126, n23, floatBuffer);
                        n28 += nArray3[i4];
                    }
                }
            }
            switch (n2) {
                case 1: {
                    gL.glDrawArrays(7, 0, n4);
                    break;
                }
                case 2: {
                    gL.glDrawArrays(4, 0, n4);
                    break;
                }
                case 3: {
                    gL.glDrawArrays(0, 0, n4);
                    break;
                }
                case 4: {
                    gL.glDrawArrays(1, 0, n4);
                }
            }
        }
        if (bl) {
            gL.glDisable(2977);
        }
        if ((n5 & 0x1000) != 0) {
            this.resetVertexAttrs(gL, joglContext, n9);
        }
        if ((n5 & 0x460) != 0) {
            this.resetTexture(gL, joglContext);
        }
    }

    private void lockArray(GL gL, int n2) {
        if (gL.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gL.glLockArraysEXT(0, n2);
        }
    }

    private void unlockArray(GL gL) {
        if (gL.isExtensionAvailable("GL_EXT_compiled_vertex_array")) {
            gL.glUnlockArraysEXT();
        }
    }

    private void executeGeometryArrayVA(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, FloatBuffer floatBuffer, DoubleBuffer doubleBuffer, int n7, FloatBuffer floatBuffer2, ByteBuffer byteBuffer, int n8, FloatBuffer floatBuffer3, int n9, int[] nArray, int[] nArray2, FloatBuffer[] floatBufferArray, int n10, int[] nArray3, int n11, int[] nArray4, int n12, FloatBuffer[] floatBufferArray2, int n13, int[] nArray5, int n14, int[] nArray6) {
        int n15;
        int n16;
        boolean bl3;
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(joglContext);
        GL gL = gLContext.getGL();
        boolean bl4 = (n5 & 1) != 0;
        boolean bl5 = (n5 & 2) != 0;
        boolean bl6 = (n5 & 4) != 0;
        boolean bl7 = (n5 & 8) != 0;
        boolean bl8 = (n5 & 0x10) != 0;
        boolean bl9 = (n5 & 0x40) != 0;
        boolean bl10 = bl3 = (n5 & 0x20) != 0;
        if (bl) {
            gL.glEnable(2977);
        }
        int n17 = 3 * n6;
        if (bl4) {
            floatBuffer.position(n17);
            gL.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
        } else if (bl5) {
            doubleBuffer.position(n17);
            gL.glVertexPointer(3, 5130, 0, (Buffer)doubleBuffer);
        }
        if (bl6) {
            if ((n4 & 8) != 0) {
                n16 = 4 * n7;
                n15 = 4;
            } else {
                n16 = 3 * n7;
                n15 = 3;
            }
            floatBuffer2.position(n16);
            gL.glColorPointer(n15, 5126, 0, (Buffer)floatBuffer2);
        } else if (bl7) {
            if ((n4 & 8) != 0) {
                n16 = 4 * n7;
                n15 = 4;
            } else {
                n16 = 3 * n7;
                n15 = 3;
            }
            byteBuffer.position(n16);
            gL.glColorPointer(n15, 5121, 0, (Buffer)byteBuffer);
        }
        if (bl8) {
            n16 = 3 * n8;
            floatBuffer3.position(n16);
            gL.glNormalPointer(5126, 0, (Buffer)floatBuffer3);
        }
        if (bl9) {
            for (n16 = 0; n16 < n9; ++n16) {
                FloatBuffer floatBuffer4 = floatBufferArray[n16];
                int n18 = nArray[n16];
                int n19 = nArray2[n16];
                joglContext.enableVertexAttrArray(gL, n16);
                floatBuffer4.position(n19 * n18);
                joglContext.vertexAttrPointer(gL, n16, n18, 5126, 0, floatBuffer4);
            }
        }
        if (bl3) {
            n16 = 0;
            for (n15 = 0; n15 < n11; ++n15) {
                if (n15 < n10 && (n16 = nArray3[n15]) != -1) {
                    FloatBuffer floatBuffer5 = floatBufferArray2[n16];
                    floatBuffer5.position(n12 * nArray4[n16]);
                    this.enableTexCoordPointer(gL, n15, n12, 5126, 0, floatBuffer5);
                    continue;
                }
                this.disableTexCoordPointer(gL, n15);
            }
            this.clientActiveTextureUnit(gL, 0);
        }
        if (n2 == 5 || n2 == 6 || n2 == 7) {
            n16 = 0;
            switch (n2) {
                case 5: {
                    n16 = 5;
                    break;
                }
                case 6: {
                    n16 = 6;
                    break;
                }
                case 7: {
                    n16 = 3;
                }
            }
            if (gL.isExtensionAvailable("GL_EXT_multi_draw_arrays")) {
                gL.glMultiDrawArraysEXT(n16, nArray6, 0, nArray5, 0, n14);
            } else if (gL.isExtensionAvailable("GL_VERSION_1_4")) {
                gL.glMultiDrawArrays(n16, nArray6, 0, nArray5, 0, n14);
            } else {
                for (n15 = 0; n15 < n14; ++n15) {
                    gL.glDrawArrays(n16, nArray6[n15], nArray5[n15]);
                }
            }
        } else {
            switch (n2) {
                case 1: {
                    gL.glDrawArrays(7, 0, n3);
                    break;
                }
                case 2: {
                    gL.glDrawArrays(4, 0, n3);
                    break;
                }
                case 3: {
                    gL.glDrawArrays(0, 0, n3);
                    break;
                }
                case 4: {
                    gL.glDrawArrays(1, 0, n3);
                }
            }
        }
        if (bl) {
            gL.glDisable(2977);
        }
        if (bl9) {
            this.resetVertexAttrs(gL, joglContext, n9);
        }
        if (bl3) {
            this.resetTexture(gL, joglContext);
        }
    }

    private String getVertexDescription(int n2) {
        String string = "";
        if ((n2 & 1) != 0) {
            string = string + "COORDINATES ";
        }
        if ((n2 & 2) != 0) {
            string = string + "NORMALS ";
        }
        if ((n2 & 4) != 0) {
            string = string + "COLOR ";
        }
        if ((n2 & 8) != 0) {
            string = string + "(WITH_ALPHA) ";
        }
        if ((n2 & 0x460) != 0) {
            string = string + "TEXTURE_COORDINATE ";
        }
        if ((n2 & 0x20) != 0) {
            string = string + "(2) ";
        }
        if ((n2 & 0x40) != 0) {
            string = string + "(3) ";
        }
        if ((n2 & 0x400) != 0) {
            string = string + "(4) ";
        }
        if ((n2 & 0x1000) != 0) {
            string = string + "VERTEX_ATTRIBUTES ";
        }
        return string;
    }

    private String getGeometryDescription(int n2) {
        switch (n2) {
            case 5: {
                return "GEO_TYPE_TRI_STRIP_SET";
            }
            case 6: {
                return "GEO_TYPE_TRI_FAN_SET";
            }
            case 7: {
                return "GEO_TYPE_LINE_STRIP_SET";
            }
            case 1: {
                return "GEO_TYPE_QUAD_SET";
            }
            case 2: {
                return "GEO_TYPE_TRI_SET";
            }
            case 3: {
                return "GEO_TYPE_POINT_SET";
            }
            case 4: {
                return "GEO_TYPE_LINE_SET";
            }
        }
        return "(unknown " + n2 + ")";
    }

    private void resetVertexAttrs(GL gL, JoglContext joglContext, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            joglContext.disableVertexAttrArray(gL, i2);
        }
    }

    void executeIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int n7, int[] nArray, int n8, int[] nArray2, int n9, int[] nArray3, int n10, float[] fArray, float[] fArray2, int n11, int[] nArray4) {
        this.executeIndexedGeometryArray(context, geometryArrayRetained, n2, bl, bl2, bl3, n3, n4, n5, n6, n7, nArray, n8, nArray2, n9, nArray3, n10, fArray, null, fArray2, n11, nArray4);
    }

    void executeIndexedGeometryBuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int n7, int[] nArray, int n8, int[] nArray2, int n9, Object object, float[] fArray, int n10, int[] nArray3) {
        this.executeIndexedGeometryArray(context, geometryArrayRetained, n2, bl, bl2, bl3, n3, n4, n5, n6, 0, null, n7, nArray, n8, nArray2, n9, null, (FloatBuffer)object, fArray, n10, nArray3);
    }

    void executeIndexedGeometryVA(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, float[] fArray, double[] dArray, float[] fArray2, byte[] byArray, float[] fArray3, int n8, int[] nArray, float[][] fArray4, int n9, int[] nArray2, int n10, int n11, Object[] objectArray, int n12, int[] nArray3) {
        boolean bl3 = (n7 & 1) != 0;
        boolean bl4 = (n7 & 2) != 0;
        boolean bl5 = (n7 & 4) != 0;
        boolean bl6 = (n7 & 8) != 0;
        boolean bl7 = (n7 & 0x10) != 0;
        boolean bl8 = (n7 & 0x40) != 0;
        boolean bl9 = (n7 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer((Object[])fArray4);
        }
        if (bl9) {
            floatBufferArray = JoglPipeline.getTexCoordSetBuffer(objectArray);
        }
        int[] nArray4 = null;
        int n13 = 0;
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            nArray4 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n13 = nArray4.length;
        }
        if (bl3) {
            floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (bl4) {
            doubleBuffer = JoglPipeline.getVertexArrayBuffer(dArray);
        }
        if (bl5) {
            floatBuffer2 = JoglPipeline.getColorArrayBuffer(fArray2);
        } else if (bl6) {
            byteBuffer = JoglPipeline.getColorArrayBuffer(byArray);
        }
        if (bl7) {
            floatBuffer3 = JoglPipeline.getNormalArrayBuffer(fArray3);
        }
        this.executeIndexedGeometryArrayVA(context, geometryArrayRetained, n2, bl, bl2, n3, n4, n5, n6, n7, floatBuffer, doubleBuffer, floatBuffer2, byteBuffer, floatBuffer3, n8, nArray, floatBufferArray2, n9, nArray2, n10, n11, floatBufferArray, n12, nArray3, nArray4, n13);
    }

    void executeIndexedGeometryVABuffer(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, Object object, Object object2, float[] fArray, byte[] byArray, Object object3, int n8, int[] nArray, Object[] objectArray, int n9, int[] nArray2, int n10, int n11, Object[] objectArray2, int n12, int[] nArray3) {
        boolean bl3 = (n7 & 1) != 0;
        boolean bl4 = (n7 & 2) != 0;
        boolean bl5 = (n7 & 4) != 0;
        boolean bl6 = (n7 & 8) != 0;
        boolean bl7 = (n7 & 0x10) != 0;
        boolean bl8 = (n7 & 0x40) != 0;
        boolean bl9 = (n7 & 0x20) != 0;
        FloatBuffer floatBuffer = null;
        DoubleBuffer doubleBuffer = null;
        FloatBuffer floatBuffer2 = null;
        ByteBuffer byteBuffer = null;
        FloatBuffer[] floatBufferArray = null;
        FloatBuffer floatBuffer3 = null;
        FloatBuffer[] floatBufferArray2 = null;
        if (bl8) {
            floatBufferArray2 = JoglPipeline.getVertexAttrSetBuffer(objectArray);
        }
        if (bl9) {
            floatBufferArray = new FloatBuffer[objectArray2.length];
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                floatBufferArray[i2] = (FloatBuffer)objectArray2[i2];
            }
        }
        if (bl3) {
            floatBuffer = (FloatBuffer)object;
        } else if (bl4) {
            doubleBuffer = (DoubleBuffer)object;
        }
        if (floatBuffer == null && doubleBuffer == null) {
            return;
        }
        int[] nArray4 = null;
        int n13 = 0;
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            nArray4 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n13 = nArray4.length;
        }
        if (bl5) {
            floatBuffer2 = fArray != null ? JoglPipeline.getColorArrayBuffer(fArray) : (FloatBuffer)object2;
        } else if (bl6) {
            byteBuffer = byArray != null ? JoglPipeline.getColorArrayBuffer(byArray) : (ByteBuffer)object2;
        }
        if (bl7) {
            floatBuffer3 = (FloatBuffer)object3;
        }
        this.executeIndexedGeometryArrayVA(context, geometryArrayRetained, n2, bl, bl2, n3, n4, n5, n6, n7, floatBuffer, doubleBuffer, floatBuffer2, byteBuffer, floatBuffer3, n8, nArray, floatBufferArray2, n9, nArray2, n10, n11, floatBufferArray, n12, nArray3, nArray4, n13);
    }

    void buildIndexedGeometry(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, float f2, boolean bl3, int n3, int n4, int n5, int n6, int n7, int[] nArray, int n8, int[] nArray2, int n9, int[] nArray3, double[] dArray, double[] dArray2, float[] fArray, int[] nArray4) {
        int n10;
        int n11;
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        boolean bl4 = false;
        FloatBuffer floatBuffer = null;
        Object var39_38 = null;
        int[] nArray5 = null;
        int n24 = 0;
        boolean bl5 = false;
        if ((n6 & 1) != 0) {
            gL.glEnableClientState(32884);
            n14 += 3;
        } else {
            gL.glDisableClientState(32884);
        }
        if ((n6 & 2) != 0) {
            gL.glEnableClientState(32885);
            n14 += 3;
            n15 += 3;
        } else {
            gL.glDisableClientState(32885);
        }
        if ((n6 & 4) != 0) {
            gL.glEnableClientState(32886);
            n14 += 4;
            n16 += 4;
            n15 += 4;
        } else {
            gL.glDisableClientState(32886);
        }
        if ((n6 & 0x460) != 0) {
            if ((n6 & 0x20) != 0) {
                n19 = 2;
                n20 = 2 * n8;
            } else if ((n6 & 0x40) != 0) {
                n19 = 3;
                n20 = 3 * n8;
            } else if ((n6 & 0x400) != 0) {
                n19 = 4;
                n20 = 4 * n8;
            }
            n14 += n20;
            n16 += n20;
            n17 += n20;
            n15 += n20;
        }
        if ((n6 & 0x1000) != 0) {
            for (n11 = 0; n11 < n7; ++n11) {
                n22 += nArray[n11];
            }
            n14 += n22;
            n16 += n22;
            n17 += n22;
            n15 += n22;
            n18 += n22;
        }
        n23 = n14 * 4;
        if (bl2 && !bl3) {
            bl5 = true;
        }
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            nArray5 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n24 = nArray5.length;
        }
        floatBuffer = JoglPipeline.getVertexArrayBuffer(fArray);
        if ((n6 & 2) != 0 && dArray2 != null) {
            n11 = n16;
            for (n10 = 0; n10 < n5 * 3; n10 += 3) {
                floatBuffer.put(n11, (float)(dArray2[0] * (double)fArray[n11] + dArray2[1] * (double)fArray[n11 + 1] + dArray2[2] * (double)fArray[n11 + 2]));
                floatBuffer.put(n11 + 1, (float)(dArray2[4] * (double)fArray[n11] + dArray2[5] * (double)fArray[n11 + 1] + dArray2[6] * (double)fArray[n11 + 2]));
                floatBuffer.put(n11 + 2, (float)(dArray2[8] * (double)fArray[n11] + dArray2[9] * (double)fArray[n11 + 1] + dArray2[10] * (double)fArray[n11 + 2]));
                n11 += n14;
            }
        }
        if ((n6 & 1) != 0 && dArray != null) {
            n11 = n15;
            for (n10 = 0; n10 < n5 * 3; n10 += 3) {
                floatBuffer.put(n11, (float)(dArray[0] * (double)fArray[n11] + dArray[1] * (double)fArray[n11 + 1] + dArray[2] * (double)fArray[n11 + 2]));
                floatBuffer.put(n11 + 1, (float)(dArray[4] * (double)fArray[n11] + dArray[5] * (double)fArray[n11 + 1] + dArray[6] * (double)fArray[n11 + 2]));
                floatBuffer.put(n11 + 2, (float)(dArray[8] * (double)fArray[n11] + dArray[9] * (double)fArray[n11 + 1] + dArray[10] * (double)fArray[n11 + 2]));
                n11 += n14;
            }
        }
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            boolean bl6;
            if (bl3 || (n6 & 0x460) != 0 && (n9 > 1 || n8 > 1)) {
                bl6 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n6, blArray, nArray6);
                bl6 = blArray[0];
                n12 = nArray6[0];
            }
            if (bl6) {
                floatBuffer.position(0);
                gL.glInterleavedArrays(n12, n23, (Buffer)floatBuffer);
            } else {
                if ((n6 & 2) != 0) {
                    floatBuffer.position(n16);
                    gL.glNormalPointer(5126, n23, (Buffer)floatBuffer);
                }
                if (!bl3 && (n6 & 4) != 0) {
                    floatBuffer.position(n17);
                    if ((n6 & 8) != 0 || bl5) {
                        gL.glColorPointer(4, 5126, n23, (Buffer)floatBuffer);
                    } else {
                        gL.glColorPointer(3, 5126, n23, (Buffer)floatBuffer);
                    }
                }
                if ((n6 & 1) != 0) {
                    floatBuffer.position(n15);
                    gL.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer);
                }
                if ((n6 & 0x460) != 0) {
                    this.executeTexture(n9, n19, n23, n18, nArray3, n9, floatBuffer, gL);
                }
                if ((n6 & 0x1000) != 0) {
                    int n25 = n21;
                    for (int i2 = 0; i2 < n7; ++i2) {
                        joglContext.enableVertexAttrArray(gL, i2);
                        floatBuffer.position(n25);
                        joglContext.vertexAttrPointer(gL, i2, nArray[i2], 5126, n23, floatBuffer);
                        n25 += nArray[i2];
                    }
                }
            }
            switch (n2) {
                case 12: {
                    n13 = 5;
                    break;
                }
                case 13: {
                    n13 = 6;
                    break;
                }
                case 14: {
                    n13 = 3;
                }
            }
            this.lockArray(gL, n5);
            int n26 = n3;
            IntBuffer intBuffer = IntBuffer.wrap(nArray4);
            for (int i3 = 0; i3 < n24; ++i3) {
                intBuffer.position(n26);
                int n27 = nArray5[i3];
                gL.glDrawElements(n13, n27, 5125, (Buffer)intBuffer);
                n26 += n27;
            }
        } else if (n2 == 8 || n2 == 9 || n2 == 10 || n2 == 11) {
            boolean bl7;
            if (bl3 || (n6 & 0x460) != 0 && (n9 > 1 || n8 > 1)) {
                bl7 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray7 = new int[1];
                this.testForInterleavedArrays(n6, blArray, nArray7);
                bl7 = blArray[0];
                n12 = nArray7[0];
            }
            if (bl7) {
                floatBuffer.position(0);
                gL.glInterleavedArrays(n12, n23, (Buffer)floatBuffer);
            } else {
                if ((n6 & 2) != 0) {
                    floatBuffer.position(n16);
                    gL.glNormalPointer(5126, n23, (Buffer)floatBuffer);
                }
                if (!bl3 && (n6 & 4) != 0) {
                    floatBuffer.position(n17);
                    if ((n6 & 8) != 0 || bl5) {
                        gL.glColorPointer(4, 5126, n23, (Buffer)floatBuffer);
                    } else {
                        gL.glColorPointer(3, 5126, n23, (Buffer)floatBuffer);
                    }
                }
                if ((n6 & 1) != 0) {
                    floatBuffer.position(n15);
                    gL.glVertexPointer(3, 5126, n23, (Buffer)floatBuffer);
                }
                if ((n6 & 0x460) != 0) {
                    this.executeTexture(n9, n19, n23, n18, nArray3, n9, floatBuffer, gL);
                }
                if ((n6 & 0x1000) != 0) {
                    int n28 = n21;
                    for (int i4 = 0; i4 < n7; ++i4) {
                        joglContext.enableVertexAttrArray(gL, i4);
                        floatBuffer.position(n28);
                        joglContext.vertexAttrPointer(gL, i4, nArray[i4], 5126, n23, floatBuffer);
                        n28 += nArray[i4];
                    }
                }
                switch (n2) {
                    case 8: {
                        n13 = 7;
                        break;
                    }
                    case 9: {
                        n13 = 4;
                        break;
                    }
                    case 10: {
                        n13 = 0;
                        break;
                    }
                    case 11: {
                        n13 = 1;
                    }
                }
                this.lockArray(gL, n5);
                IntBuffer intBuffer = IntBuffer.wrap(nArray4);
                intBuffer.position(n3);
                gL.glDrawElements(n13, n4, 5125, (Buffer)intBuffer);
            }
        }
        this.unlockArray(gL);
        if ((n6 & 0x1000) != 0) {
            this.resetVertexAttrs(gL, joglContext, n7);
        }
        if ((n6 & 0x460) != 0) {
            this.resetTexture(gL, joglContext);
        }
    }

    private void executeIndexedGeometryArray(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, boolean bl3, int n3, int n4, int n5, int n6, int n7, int[] nArray, int n8, int[] nArray2, int n9, int[] nArray3, int n10, float[] fArray, FloatBuffer floatBuffer, float[] fArray2, int n11, int[] nArray4) {
        int n12;
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        FloatBuffer floatBuffer2 = null;
        FloatBuffer floatBuffer3 = null;
        int[] nArray5 = null;
        int n26 = 0;
        if ((n6 & 1) != 0) {
            n15 += 3;
        }
        if ((n6 & 2) != 0) {
            n15 += 3;
            n16 += 3;
        }
        if ((n6 & 4) != 0) {
            if ((n6 & 8) != 0) {
                n15 += 4;
                n17 += 4;
                n16 += 4;
            } else {
                n15 += 3;
                n17 += 3;
                n16 += 3;
            }
        }
        if ((n6 & 0x460) != 0) {
            if ((n6 & 0x20) != 0) {
                n20 = 2;
                n21 = 2 * n8;
            } else if ((n6 & 0x40) != 0) {
                n20 = 3;
                n21 = 3 * n8;
            } else if ((n6 & 0x400) != 0) {
                n20 = 4;
                n21 = 4 * n8;
            }
            n15 += n21;
            n17 += n21;
            n18 += n21;
            n16 += n21;
        }
        if ((n6 & 0x1000) != 0) {
            for (n12 = 0; n12 < n7; ++n12) {
                n23 += nArray[n12];
            }
            n15 += n23;
            n17 += n23;
            n18 += n23;
            n16 += n23;
            n19 += n23;
        }
        n24 = n15 * 4;
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            nArray5 = ((IndexedGeometryStripArrayRetained)geometryArrayRetained).stripIndexCounts;
            n26 = nArray5.length;
        }
        if (fArray != null) {
            floatBuffer2 = JoglPipeline.getVertexArrayBuffer(fArray);
        } else if (floatBuffer != null) {
            floatBuffer2 = floatBuffer;
        } else {
            throw new AssertionError((Object)"Unable to get vertex pointer");
        }
        n12 = n15;
        if (fArray2 != null) {
            floatBuffer3 = JoglPipeline.getColorArrayBuffer(fArray2);
            n12 = 4;
        } else {
            floatBuffer3 = floatBuffer2;
        }
        n25 = n12 * 4;
        if (bl) {
            gL.glEnable(2977);
        }
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            Object object;
            boolean bl4;
            if (bl3 || fArray2 != null || (n6 & 0x460) != 0 && (n9 > 1 || n8 > 1)) {
                bl4 = false;
            } else {
                boolean[] blArray = new boolean[1];
                object = new int[1];
                this.testForInterleavedArrays(n6, blArray, (int[])object);
                bl4 = blArray[0];
                n13 = object[0];
            }
            if (bl4) {
                floatBuffer2.position(0);
                gL.glInterleavedArrays(n13, n24, (Buffer)floatBuffer2);
            } else {
                if ((n6 & 2) != 0) {
                    floatBuffer2.position(n17);
                    gL.glNormalPointer(5126, n24, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n6 & 4) != 0) {
                    if (floatBuffer3 == floatBuffer2) {
                        floatBuffer3.position(n18);
                    }
                    if ((n6 & 8) != 0 || bl2) {
                        gL.glColorPointer(4, 5126, n25, (Buffer)floatBuffer3);
                    } else {
                        gL.glColorPointer(3, 5126, n25, (Buffer)floatBuffer3);
                    }
                }
                if ((n6 & 1) != 0) {
                    floatBuffer2.position(n16);
                    gL.glVertexPointer(3, 5126, n24, (Buffer)floatBuffer2);
                }
                if ((n6 & 0x460) != 0) {
                    this.executeTexture(n9, n20, n24, n19, nArray3, n10, floatBuffer2, gL);
                }
                if ((n6 & 0x1000) != 0) {
                    int n27 = n22;
                    for (int i2 = 0; i2 < n7; ++i2) {
                        joglContext.enableVertexAttrArray(gL, i2);
                        floatBuffer2.position(n27);
                        joglContext.vertexAttrPointer(gL, i2, nArray[i2], 5126, n24, floatBuffer2);
                        n27 += nArray[i2];
                    }
                }
            }
            switch (n2) {
                case 12: {
                    n14 = 5;
                    break;
                }
                case 13: {
                    n14 = 6;
                    break;
                }
                case 14: {
                    n14 = 3;
                }
            }
            this.lockArray(gL, n5);
            int n28 = n3;
            object = IntBuffer.wrap(nArray4);
            for (int i3 = 0; i3 < n26; ++i3) {
                ((IntBuffer)object).position(n28);
                int n29 = nArray5[i3];
                gL.glDrawElements(n14, n29, 5125, (Buffer)object);
                n28 += n29;
            }
        } else if (n2 == 8 || n2 == 9 || n2 == 10 || n2 == 11) {
            boolean bl5;
            if (bl3 || fArray2 != null || (n6 & 0x460) != 0 && (n9 > 1 || n8 > 1)) {
                bl5 = false;
            } else {
                boolean[] blArray = new boolean[1];
                int[] nArray6 = new int[1];
                this.testForInterleavedArrays(n6, blArray, nArray6);
                bl5 = blArray[0];
                n13 = nArray6[0];
            }
            if (bl5) {
                floatBuffer2.position(0);
                gL.glInterleavedArrays(n13, n24, (Buffer)floatBuffer2);
            } else {
                if ((n6 & 2) != 0) {
                    floatBuffer2.position(n17);
                    gL.glNormalPointer(5126, n24, (Buffer)floatBuffer2);
                }
                if (!bl3 && (n6 & 4) != 0) {
                    if (floatBuffer3 == floatBuffer2) {
                        floatBuffer3.position(n18);
                    }
                    if ((n6 & 8) != 0 || bl2) {
                        gL.glColorPointer(4, 5126, n25, (Buffer)floatBuffer3);
                    } else {
                        gL.glColorPointer(3, 5126, n25, (Buffer)floatBuffer3);
                    }
                }
                if ((n6 & 1) != 0) {
                    floatBuffer2.position(n16);
                    gL.glVertexPointer(3, 5126, n24, (Buffer)floatBuffer2);
                }
                if ((n6 & 0x460) != 0) {
                    this.executeTexture(n9, n20, n24, n19, nArray3, n10, floatBuffer2, gL);
                }
                if ((n6 & 0x1000) != 0) {
                    int n30 = n22;
                    for (int i4 = 0; i4 < n7; ++i4) {
                        joglContext.enableVertexAttrArray(gL, i4);
                        floatBuffer2.position(n30);
                        joglContext.vertexAttrPointer(gL, i4, nArray[i4], 5126, n24, floatBuffer2);
                        n30 += nArray[i4];
                    }
                }
            }
            this.lockArray(gL, n5);
            IntBuffer intBuffer = IntBuffer.wrap(nArray4);
            intBuffer.position(n3);
            switch (n2) {
                case 8: {
                    gL.glDrawElements(7, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 9: {
                    gL.glDrawElements(4, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 10: {
                    gL.glDrawElements(0, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 11: {
                    gL.glDrawElements(1, n4, 5125, (Buffer)intBuffer);
                }
            }
        }
        this.unlockArray(gL);
        if ((n6 & 0x1000) != 0) {
            this.resetVertexAttrs(gL, joglContext, n7);
        }
        if ((n6 & 0x460) != 0) {
            this.resetTexture(gL, joglContext);
        }
        if (bl) {
            gL.glDisable(2977);
        }
    }

    private void executeIndexedGeometryArrayVA(Context context, GeometryArrayRetained geometryArrayRetained, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, FloatBuffer floatBuffer, DoubleBuffer doubleBuffer, FloatBuffer floatBuffer2, ByteBuffer byteBuffer, FloatBuffer floatBuffer3, int n8, int[] nArray, FloatBuffer[] floatBufferArray, int n9, int[] nArray2, int n10, int n11, FloatBuffer[] floatBufferArray2, int n12, int[] nArray3, int[] nArray4, int n13) {
        int n14;
        boolean bl3;
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        boolean bl4 = (n7 & 1) != 0;
        boolean bl5 = (n7 & 2) != 0;
        boolean bl6 = (n7 & 4) != 0;
        boolean bl7 = (n7 & 8) != 0;
        boolean bl8 = (n7 & 0x10) != 0;
        boolean bl9 = (n7 & 0x40) != 0;
        boolean bl10 = bl3 = (n7 & 0x20) != 0;
        if (bl) {
            gL.glEnable(2977);
        }
        if (bl4) {
            floatBuffer.position(0);
            gL.glVertexPointer(3, 5126, 0, (Buffer)floatBuffer);
        } else if (bl5) {
            doubleBuffer.position(0);
            gL.glVertexPointer(3, 5130, 0, (Buffer)doubleBuffer);
        }
        if (bl6) {
            floatBuffer2.position(0);
            if ((n6 & 8) != 0) {
                gL.glColorPointer(4, 5126, 0, (Buffer)floatBuffer2);
            } else {
                gL.glColorPointer(3, 5126, 0, (Buffer)floatBuffer2);
            }
        } else if (bl7) {
            byteBuffer.position(0);
            if ((n6 & 8) != 0) {
                gL.glColorPointer(4, 5121, 0, (Buffer)byteBuffer);
            } else {
                gL.glColorPointer(3, 5121, 0, (Buffer)byteBuffer);
            }
        }
        if (bl8) {
            floatBuffer3.position(0);
            gL.glNormalPointer(5126, 0, (Buffer)floatBuffer3);
        }
        if (bl9) {
            for (n14 = 0; n14 < n8; ++n14) {
                FloatBuffer floatBuffer4 = floatBufferArray[n14];
                int n15 = nArray[n14];
                joglContext.enableVertexAttrArray(gL, n14);
                floatBuffer4.position(0);
                joglContext.vertexAttrPointer(gL, n14, n15, 5126, 0, floatBuffer4);
            }
        }
        if (bl3) {
            n14 = 0;
            for (int i2 = 0; i2 < n10; ++i2) {
                if (i2 < n9 && (n14 = nArray2[i2]) != -1) {
                    FloatBuffer floatBuffer5 = floatBufferArray2[n14];
                    floatBuffer5.position(0);
                    this.enableTexCoordPointer(gL, i2, n11, 5126, 0, floatBuffer5);
                    continue;
                }
                this.disableTexCoordPointer(gL, i2);
            }
            this.clientActiveTextureUnit(gL, 0);
        }
        this.lockArray(gL, n5);
        if (n2 == 12 || n2 == 13 || n2 == 14) {
            n14 = 0;
            switch (n2) {
                case 12: {
                    n14 = 5;
                    break;
                }
                case 13: {
                    n14 = 6;
                    break;
                }
                case 14: {
                    n14 = 3;
                }
            }
            int n16 = n3;
            IntBuffer intBuffer = IntBuffer.wrap(nArray3);
            for (int i3 = 0; i3 < n13; ++i3) {
                intBuffer.position(n16);
                int n17 = nArray4[i3];
                gL.glDrawElements(n14, n17, 5125, (Buffer)intBuffer);
                n16 += n17;
            }
        } else {
            IntBuffer intBuffer = IntBuffer.wrap(nArray3);
            intBuffer.position(n3);
            switch (n2) {
                case 8: {
                    gL.glDrawElements(7, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 9: {
                    gL.glDrawElements(4, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 10: {
                    gL.glDrawElements(0, n4, 5125, (Buffer)intBuffer);
                    break;
                }
                case 11: {
                    gL.glDrawElements(1, n4, 5125, (Buffer)intBuffer);
                }
            }
        }
        this.unlockArray(gL);
        if (bl) {
            gL.glDisable(2977);
        }
        if (bl9) {
            this.resetVertexAttrs(gL, joglContext, n8);
        }
        if (bl3) {
            this.resetTexture(gL, joglContext);
        }
    }

    void readRaster(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, int n10, Object object2) {
        GL gL = this.context(context).getGL();
        gL.glPixelStorei(3330, n5);
        gL.glPixelStorei(3333, 1);
        int n11 = n7 - n6 - n4;
        if ((n2 & 1) != 0) {
            int n12 = 0;
            if (n8 == 4096) {
                switch (n9) {
                    case 1: {
                        n12 = 32992;
                        break;
                    }
                    case 2: {
                        n12 = 6407;
                        break;
                    }
                    case 4: {
                        if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                            n12 = 32768;
                            break;
                        }
                        assert (false);
                        return;
                    }
                    case 8: {
                        n12 = 6408;
                        break;
                    }
                    case 16: {
                        n12 = 6410;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                gL.glReadPixels(n3, n11, n5, n6, n12, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else if (n8 == 8192) {
                int n13 = 32821;
                boolean bl = false;
                switch (n9) {
                    case 128: {
                        n12 = 6408;
                        n13 = 33639;
                        bl = true;
                        break;
                    }
                    case 256: {
                        bl = true;
                    }
                    case 512: {
                        n12 = 32993;
                        n13 = 33639;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                if (bl) {
                    gL.glPixelTransferf(3356, 0.0f);
                    gL.glPixelTransferf(3357, 1.0f);
                }
                gL.glReadPixels(n3, n11, n5, n6, n12, n13, (Buffer)IntBuffer.wrap((int[])object));
                if (bl) {
                    gL.glPixelTransferf(3356, 1.0f);
                    gL.glPixelTransferf(3357, 0.0f);
                }
            } else assert (false);
        }
        if ((n2 & 2) != 0) {
            if (n10 == 1) {
                gL.glReadPixels(n3, n11, n5, n6, 6402, 5125, (Buffer)IntBuffer.wrap((int[])object2));
            } else {
                gL.glReadPixels(n3, n11, n5, n6, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])object2));
            }
        }
    }

    ShaderError setCgUniform1i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter1i((CGparameter)joglCgShaderParameter.vParam(), (int)n2);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter1i((CGparameter)joglCgShaderParameter.fParam(), (int)n2);
        }
        return null;
    }

    ShaderError setCgUniform1f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float f2) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter1f((CGparameter)joglCgShaderParameter.vParam(), (float)f2);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter1f((CGparameter)joglCgShaderParameter.fParam(), (float)f2);
        }
        return null;
    }

    ShaderError setCgUniform2i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter2i((CGparameter)joglCgShaderParameter.vParam(), (int)nArray[0], (int)nArray[1]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter2i((CGparameter)joglCgShaderParameter.fParam(), (int)nArray[0], (int)nArray[1]);
        }
        return null;
    }

    ShaderError setCgUniform2f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter2f((CGparameter)joglCgShaderParameter.vParam(), (float)fArray[0], (float)fArray[1]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter2f((CGparameter)joglCgShaderParameter.fParam(), (float)fArray[0], (float)fArray[1]);
        }
        return null;
    }

    ShaderError setCgUniform3i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter3i((CGparameter)joglCgShaderParameter.vParam(), (int)nArray[0], (int)nArray[1], (int)nArray[2]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter3i((CGparameter)joglCgShaderParameter.fParam(), (int)nArray[0], (int)nArray[1], (int)nArray[2]);
        }
        return null;
    }

    ShaderError setCgUniform3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter3f((CGparameter)joglCgShaderParameter.vParam(), (float)fArray[0], (float)fArray[1], (float)fArray[2]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter3f((CGparameter)joglCgShaderParameter.fParam(), (float)fArray[0], (float)fArray[1], (float)fArray[2]);
        }
        return null;
    }

    ShaderError setCgUniform4i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter4i((CGparameter)joglCgShaderParameter.vParam(), (int)nArray[0], (int)nArray[1], (int)nArray[2], (int)nArray[3]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter4i((CGparameter)joglCgShaderParameter.fParam(), (int)nArray[0], (int)nArray[1], (int)nArray[2], (int)nArray[3]);
        }
        return null;
    }

    ShaderError setCgUniform4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgSetParameter4f((CGparameter)joglCgShaderParameter.vParam(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3]);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgSetParameter4f((CGparameter)joglCgShaderParameter.fParam(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3]);
        }
        return null;
    }

    ShaderError setCgUniformMatrix3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)joglCgShaderParameter.vParam(), (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)joglCgShaderParameter.fParam(), (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniformMatrix4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)joglCgShaderParameter.vParam(), (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetMatrixParameterfr((CGparameter)joglCgShaderParameter.fParam(), (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform1iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray1f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray1f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform1fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray1f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray1f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform2iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform2fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform3iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray3f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray3f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform4iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray4f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray4f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniform4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetParameterArray2f((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniformMatrix3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetMatrixParameterArrayfr((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetMatrixParameterArrayfr((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError setCgUniformMatrix4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        JoglCgShaderParameter joglCgShaderParameter = (JoglCgShaderParameter)shaderAttrLoc;
        if (joglCgShaderParameter.vParam() != null) {
            CgGL.cgGLSetMatrixParameterArrayfr((CGparameter)joglCgShaderParameter.vParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        if (joglCgShaderParameter.fParam() != null) {
            CgGL.cgGLSetMatrixParameterArrayfr((CGparameter)joglCgShaderParameter.fParam(), (long)0L, (long)n2, (float[])fArray, (int)0);
        }
        return null;
    }

    ShaderError createCgShader(Context context, int n2, ShaderId[] shaderIdArray) {
        JoglContext joglContext = (JoglContext)context;
        JoglCgShaderInfo joglCgShaderInfo = new JoglCgShaderInfo();
        joglCgShaderInfo.setJ3DShaderType(n2);
        if (n2 == 1) {
            joglCgShaderInfo.setShaderProfile(joglContext.getCgVertexProfile());
        } else if (n2 == 2) {
            joglCgShaderInfo.setShaderProfile(joglContext.getCgFragmentProfile());
        } else {
            throw new AssertionError((Object)("unrecognized shaderType " + n2));
        }
        shaderIdArray[0] = joglCgShaderInfo;
        return null;
    }

    ShaderError destroyCgShader(Context context, ShaderId shaderId) {
        JoglCgShaderInfo joglCgShaderInfo = (JoglCgShaderInfo)shaderId;
        CGprogram cGprogram = joglCgShaderInfo.getCgShader();
        if (cGprogram != null) {
            CgGL.cgDestroyProgram((CGprogram)cGprogram);
        }
        return null;
    }

    ShaderError compileCgShader(Context context, ShaderId shaderId, String string) {
        if (string == null) {
            throw new AssertionError((Object)"shader program string is null");
        }
        JoglCgShaderInfo joglCgShaderInfo = (JoglCgShaderInfo)shaderId;
        JoglContext joglContext = (JoglContext)context;
        CGprogram cGprogram = CgGL.cgCreateProgram((CGcontext)joglContext.getCgContext(), (int)4112, (String)string, (int)joglCgShaderInfo.getShaderProfile(), null, null);
        int n2 = 0;
        n2 = CgGL.cgGetError();
        if (n2 != 0) {
            ShaderError shaderError = new ShaderError(1, "Cg shader compile error");
            shaderError.setDetailMessage(this.getCgErrorLog(joglContext, n2));
            return shaderError;
        }
        joglCgShaderInfo.setCgShader(cGprogram);
        return null;
    }

    ShaderError createCgShaderProgram(Context context, ShaderProgramId[] shaderProgramIdArray) {
        JoglCgShaderProgramInfo joglCgShaderProgramInfo = new JoglCgShaderProgramInfo();
        shaderProgramIdArray[0] = joglCgShaderProgramInfo;
        return null;
    }

    ShaderError destroyCgShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        return null;
    }

    ShaderError linkCgShaderProgram(Context context, ShaderProgramId shaderProgramId, ShaderId[] shaderIdArray) {
        JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)shaderProgramId;
        joglCgShaderProgramInfo.setVertexShader(null);
        joglCgShaderProgramInfo.setFragmentShader(null);
        for (int i2 = 0; i2 < shaderIdArray.length; ++i2) {
            JoglCgShaderInfo joglCgShaderInfo = (JoglCgShaderInfo)shaderIdArray[i2];
            if (joglCgShaderInfo.getJ3DShaderType() == 1) {
                joglCgShaderProgramInfo.setVertexShader(joglCgShaderInfo);
            } else {
                joglCgShaderProgramInfo.setFragmentShader(joglCgShaderInfo);
            }
            CgGL.cgGLLoadProgram((CGprogram)joglCgShaderInfo.getCgShader());
            int n2 = 0;
            n2 = CgGL.cgGetError();
            if (n2 != 0) {
                ShaderError shaderError = new ShaderError(2, "Cg shader link/load error");
                shaderError.setDetailMessage(this.getCgErrorLog((JoglContext)context, n2));
                return shaderError;
            }
            CgGL.cgGLBindProgram((CGprogram)joglCgShaderInfo.getCgShader());
            n2 = CgGL.cgGetError();
            if (n2 == 0) continue;
            ShaderError shaderError = new ShaderError(2, "Cg shader link/bind error");
            shaderError.setDetailMessage(this.getCgErrorLog((JoglContext)context, n2));
            return shaderError;
        }
        return null;
    }

    void lookupCgVertexAttrNames(Context context, ShaderProgramId shaderProgramId, int n2, String[] stringArray, boolean[] blArray) {
        JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)shaderProgramId;
        if (joglCgShaderProgramInfo.getVertexShader() == null) {
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                blArray[i2] = false;
            }
            return;
        }
        joglCgShaderProgramInfo.setVertexAttributes(new CGparameter[n2]);
        for (int i3 = 0; i3 < n2; ++i3) {
            String string = stringArray[i3];
            joglCgShaderProgramInfo.getVertexAttributes()[i3] = CgGL.cgGetNamedParameter((CGprogram)joglCgShaderProgramInfo.getVertexShader().getCgShader(), (String)string);
            if (joglCgShaderProgramInfo.getVertexAttributes()[i3] != null) continue;
            blArray[i3] = true;
        }
    }

    void lookupCgShaderAttrNames(Context context, ShaderProgramId shaderProgramId, int n2, String[] stringArray, ShaderAttrLoc[] shaderAttrLocArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)shaderProgramId;
        for (int i2 = 0; i2 < n2; ++i2) {
            shaderAttrLocArray[i2] = null;
            nArray[i2] = -1;
            nArray2[i2] = -1;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        boolean[] blArray2 = new boolean[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        boolean[] blArray3 = new boolean[1];
        boolean bl = false;
        for (int i3 = 0; i3 < n2; ++i3) {
            String string = stringArray[i3];
            CGparameter cGparameter = null;
            if (joglCgShaderProgramInfo.getVertexShader() != null && (cGparameter = this.lookupCgParams(joglCgShaderProgramInfo.getVertexShader(), string, nArray3, nArray4, blArray2)) != null) {
                nArray2[i3] = nArray4[0];
                blArray[i3] = blArray2[0];
                nArray[i3] = this.cgToJ3dType(nArray3[0]);
            }
            CGparameter cGparameter2 = null;
            if (joglCgShaderProgramInfo.getVertexShader() != null && (cGparameter2 = this.lookupCgParams(joglCgShaderProgramInfo.getFragmentShader(), string, nArray5, nArray6, blArray3)) != null) {
                nArray2[i3] = nArray6[0];
                blArray[i3] = blArray3[0];
                nArray[i3] = this.cgToJ3dType(nArray5[0]);
            }
            if (cGparameter != null && cGparameter2 != null && (nArray3 != nArray5 || nArray4 != nArray6 || blArray2 != blArray3)) {
                System.err.println("JAVA 3D : error shader attribute type mismatch: " + string);
                System.err.println("    1 : type = " + nArray3[0] + ", size = " + nArray4[0] + ", isArray = " + blArray2[0]);
                System.err.println("    0 : type = " + nArray5[0] + ", size = " + nArray6[0] + ", isArray = " + blArray3[0]);
                bl = true;
            }
            if (bl || cGparameter == null && cGparameter2 == null) continue;
            shaderAttrLocArray[i3] = new JoglCgShaderParameter(cGparameter, cGparameter2);
        }
    }

    ShaderError useCgShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        JoglCgShaderProgramInfo joglCgShaderProgramInfo = (JoglCgShaderProgramInfo)shaderProgramId;
        JoglContext joglContext = (JoglContext)context;
        CgGL.cgGLDisableProfile((int)joglContext.getCgVertexProfile());
        CgGL.cgGLDisableProfile((int)joglContext.getCgFragmentProfile());
        if (joglCgShaderProgramInfo != null) {
            if (joglCgShaderProgramInfo.getVertexShader() != null) {
                CgGL.cgGLBindProgram((CGprogram)joglCgShaderProgramInfo.getVertexShader().getCgShader());
                CgGL.cgGLEnableProfile((int)joglCgShaderProgramInfo.getVertexShader().getShaderProfile());
            } else {
                CgGL.cgGLUnbindProgram((int)joglContext.getCgVertexProfile());
            }
            if (joglCgShaderProgramInfo.getFragmentShader() != null) {
                CgGL.cgGLBindProgram((CGprogram)joglCgShaderProgramInfo.getFragmentShader().getCgShader());
                CgGL.cgGLEnableProfile((int)joglCgShaderProgramInfo.getFragmentShader().getShaderProfile());
            } else {
                CgGL.cgGLUnbindProgram((int)joglContext.getCgFragmentProfile());
            }
        } else {
            CgGL.cgGLUnbindProgram((int)joglContext.getCgVertexProfile());
            CgGL.cgGLUnbindProgram((int)joglContext.getCgFragmentProfile());
        }
        joglContext.setShaderProgram(joglCgShaderProgramInfo);
        return null;
    }

    private String getCgErrorLog(JoglContext joglContext, int n2) {
        if (n2 == 0) {
            throw new AssertionError((Object)"lastError == 0");
        }
        String string = CgGL.cgGetErrorString((int)n2);
        String string2 = CgGL.cgGetLastListing((CGcontext)joglContext.getCgContext());
        return string + System.getProperty("line.separator") + string2;
    }

    private int cgToJ3dType(int n2) {
        switch (n2) {
            case 1025: 
            case 1070: 
            case 1090: 
            case 1092: 
            case 1093: 
            case 1094: 
            case 1114: 
            case 1115: {
                return 0;
            }
            case 1026: 
            case 1071: 
            case 1095: 
            case 1116: {
                return 2;
            }
            case 1027: 
            case 1072: 
            case 1096: 
            case 1117: {
                return 4;
            }
            case 1028: 
            case 1073: 
            case 1097: 
            case 1118: {
                return 6;
            }
            case 1045: 
            case 1091: {
                return 1;
            }
            case 1046: {
                return 3;
            }
            case 1047: {
                return 5;
            }
            case 1048: {
                return 7;
            }
            case 1059: {
                return 8;
            }
            case 1064: {
                return 9;
            }
        }
        return -1;
    }

    private CGparameter lookupCgParams(JoglCgShaderInfo joglCgShaderInfo, String string, int[] nArray, int[] nArray2, boolean[] blArray) {
        CGparameter cGparameter = CgGL.cgGetNamedParameter((CGprogram)joglCgShaderInfo.getCgShader(), (String)string);
        if (cGparameter != null) {
            nArray[0] = CgGL.cgGetParameterType((CGparameter)cGparameter);
            if (nArray[0] == 2) {
                blArray[0] = true;
                nArray2[0] = CgGL.cgGetArraySize((CGparameter)cGparameter, (int)0);
                CGparameter cGparameter2 = CgGL.cgGetArrayParameter((CGparameter)cGparameter, (int)0);
                nArray[0] = CgGL.cgGetParameterType((CGparameter)cGparameter2);
            } else {
                blArray[0] = false;
                nArray2[0] = 1;
            }
        }
        return cGparameter;
    }

    ShaderError setGLSLUniform1i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2) {
        this.context(context).getGL().glUniform1iARB(this.unbox(shaderAttrLoc), n2);
        return null;
    }

    ShaderError setGLSLUniform1f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float f2) {
        this.context(context).getGL().glUniform1fARB(this.unbox(shaderAttrLoc), f2);
        return null;
    }

    ShaderError setGLSLUniform2i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        this.context(context).getGL().glUniform2iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1]);
        return null;
    }

    ShaderError setGLSLUniform2f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        this.context(context).getGL().glUniform2fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1]);
        return null;
    }

    ShaderError setGLSLUniform3i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        this.context(context).getGL().glUniform3iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1], nArray[2]);
        return null;
    }

    ShaderError setGLSLUniform3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        this.context(context).getGL().glUniform3fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1], fArray[2]);
        return null;
    }

    ShaderError setGLSLUniform4i(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int[] nArray) {
        this.context(context).getGL().glUniform4iARB(this.unbox(shaderAttrLoc), nArray[0], nArray[1], nArray[2], nArray[3]);
        return null;
    }

    ShaderError setGLSLUniform4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        this.context(context).getGL().glUniform4fARB(this.unbox(shaderAttrLoc), fArray[0], fArray[1], fArray[2], fArray[3]);
        return null;
    }

    ShaderError setGLSLUniformMatrix3f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        this.context(context).getGL().glUniformMatrix3fvARB(this.unbox(shaderAttrLoc), 1, true, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniformMatrix4f(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, float[] fArray) {
        this.context(context).getGL().glUniformMatrix4fvARB(this.unbox(shaderAttrLoc), 1, true, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniform1iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        this.context(context).getGL().glUniform1ivARB(this.unbox(shaderAttrLoc), n2, nArray, 0);
        return null;
    }

    ShaderError setGLSLUniform1fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniform1fvARB(this.unbox(shaderAttrLoc), n2, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniform2iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        this.context(context).getGL().glUniform2ivARB(this.unbox(shaderAttrLoc), n2, nArray, 0);
        return null;
    }

    ShaderError setGLSLUniform2fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniform2fvARB(this.unbox(shaderAttrLoc), n2, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniform3iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        this.context(context).getGL().glUniform3ivARB(this.unbox(shaderAttrLoc), n2, nArray, 0);
        return null;
    }

    ShaderError setGLSLUniform3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniform3fvARB(this.unbox(shaderAttrLoc), n2, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniform4iArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, int[] nArray) {
        this.context(context).getGL().glUniform4ivARB(this.unbox(shaderAttrLoc), n2, nArray, 0);
        return null;
    }

    ShaderError setGLSLUniform4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniform4fvARB(this.unbox(shaderAttrLoc), n2, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniformMatrix3fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniformMatrix3fvARB(this.unbox(shaderAttrLoc), n2, true, fArray, 0);
        return null;
    }

    ShaderError setGLSLUniformMatrix4fArray(Context context, ShaderProgramId shaderProgramId, ShaderAttrLoc shaderAttrLoc, int n2, float[] fArray) {
        this.context(context).getGL().glUniformMatrix4fvARB(this.unbox(shaderAttrLoc), n2, true, fArray, 0);
        return null;
    }

    ShaderError createGLSLShader(Context context, int n2, ShaderId[] shaderIdArray) {
        GL gL = this.context(context).getGL();
        int n3 = 0;
        if (n2 == 1) {
            n3 = gL.glCreateShaderObjectARB(35633);
        } else if (n2 == 2) {
            n3 = gL.glCreateShaderObjectARB(35632);
        }
        if (n3 == 0) {
            return new ShaderError(1, "Unable to create native shader object");
        }
        shaderIdArray[0] = new JoglShaderObject(n3);
        return null;
    }

    ShaderError destroyGLSLShader(Context context, ShaderId shaderId) {
        GL gL = this.context(context).getGL();
        gL.glDeleteObjectARB(this.unbox(shaderId));
        return null;
    }

    ShaderError compileGLSLShader(Context context, ShaderId shaderId, String string) {
        int n2 = this.unbox(shaderId);
        if (n2 == 0) {
            throw new AssertionError((Object)"shaderId == 0");
        }
        if (string == null) {
            throw new AssertionError((Object)"shader program string is null");
        }
        GL gL = this.context(context).getGL();
        gL.glShaderSourceARB(n2, 1, new String[]{string}, null, 0);
        gL.glCompileShaderARB(n2);
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35713, nArray, 0);
        if (nArray[0] == 0) {
            String string2 = this.getInfoLog(gL, n2);
            ShaderError shaderError = new ShaderError(1, "GLSL shader compile error");
            shaderError.setDetailMessage(string2);
            return shaderError;
        }
        return null;
    }

    ShaderError createGLSLShaderProgram(Context context, ShaderProgramId[] shaderProgramIdArray) {
        GL gL = this.context(context).getGL();
        int n2 = gL.glCreateProgramObjectARB();
        if (n2 == 0) {
            return new ShaderError(2, "Unable to create native shader program object");
        }
        shaderProgramIdArray[0] = new JoglShaderObject(n2);
        return null;
    }

    ShaderError destroyGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        this.context(context).getGL().glDeleteObjectARB(this.unbox(shaderProgramId));
        return null;
    }

    ShaderError linkGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId, ShaderId[] shaderIdArray) {
        GL gL = this.context(context).getGL();
        int n2 = this.unbox(shaderProgramId);
        for (int i2 = 0; i2 < shaderIdArray.length; ++i2) {
            gL.glAttachObjectARB(n2, this.unbox(shaderIdArray[i2]));
        }
        gL.glLinkProgramARB(n2);
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35714, nArray, 0);
        if (nArray[0] == 0) {
            String string = this.getInfoLog(gL, n2);
            ShaderError shaderError = new ShaderError(2, "GLSL shader program link error");
            shaderError.setDetailMessage(string);
            return shaderError;
        }
        return null;
    }

    ShaderError bindGLSLVertexAttrName(Context context, ShaderProgramId shaderProgramId, String string, int n2) {
        JoglContext joglContext = (JoglContext)context;
        this.context(context).getGL().glBindAttribLocationARB(this.unbox(shaderProgramId), n2 + VirtualUniverse.mc.glslVertexAttrOffset, string);
        return null;
    }

    void lookupGLSLShaderAttrNames(Context context, ShaderProgramId shaderProgramId, int n2, String[] stringArray, ShaderAttrLoc[] shaderAttrLocArray, int[] nArray, int[] nArray2, boolean[] blArray) {
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            shaderAttrLocArray[n5] = null;
            nArray[n5] = -1;
            nArray2[n5] = -1;
        }
        n5 = this.unbox(shaderProgramId);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        GL gL = this.context(context).getGL();
        gL.glGetObjectParameterivARB(n5, 35718, nArray3, 0);
        int n6 = nArray3[0];
        gL.glGetObjectParameterivARB(n5, 35719, nArray3, 0);
        int n7 = nArray3[0];
        byte[] byArray = new byte[n7];
        block3: for (n4 = 0; n4 < n6; ++n4) {
            gL.glGetActiveUniformARB(n5, n4, n7, nArray5, 0, nArray3, 0, nArray4, 0, byArray, 0);
            n3 = nArray3[0];
            int n8 = nArray4[0];
            String string = null;
            try {
                string = new String(byArray, 0, nArray5[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            if (string.length() >= 3 && string.endsWith("]")) {
                if (!string.endsWith("[0]")) continue;
                string = string.substring(0, string.length() - 3);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!string.equals(stringArray[i2])) continue;
                nArray2[i2] = n3;
                blArray[i2] = n3 > 1;
                nArray[i2] = this.glslToJ3dType(n8);
                continue block3;
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = gL.glGetUniformLocationARB(n5, stringArray[n4]);
            shaderAttrLocArray[n4] = new JoglShaderObject(n3);
        }
    }

    ShaderError useGLSLShaderProgram(Context context, ShaderProgramId shaderProgramId) {
        this.context(context).getGL().glUseProgramObjectARB(this.unbox(shaderProgramId));
        ((JoglContext)context).setShaderProgram((JoglShaderObject)shaderProgramId);
        return null;
    }

    private int unbox(ShaderAttrLoc shaderAttrLoc) {
        if (shaderAttrLoc == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderAttrLoc).getValue();
    }

    private int unbox(ShaderProgramId shaderProgramId) {
        if (shaderProgramId == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderProgramId).getValue();
    }

    private int unbox(ShaderId shaderId) {
        if (shaderId == null) {
            return 0;
        }
        return ((JoglShaderObject)shaderId).getValue();
    }

    private String getInfoLog(GL gL, int n2) {
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35716, nArray, 0);
        if (nArray[0] > 0) {
            byte[] byArray = new byte[nArray[0]];
            int[] nArray2 = new int[1];
            gL.glGetInfoLogARB(n2, nArray[0], nArray2, 0, byArray, 0);
            try {
                return new String(byArray, 0, nArray2[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return null;
    }

    private int glslToJ3dType(int n2) {
        switch (n2) {
            case 5124: 
            case 35670: 
            case 35678: 
            case 35679: 
            case 35680: {
                return 0;
            }
            case 5126: {
                return 1;
            }
            case 35667: 
            case 35671: {
                return 2;
            }
            case 35664: {
                return 3;
            }
            case 35668: 
            case 35672: {
                return 4;
            }
            case 35665: {
                return 5;
            }
            case 35669: 
            case 35673: {
                return 6;
            }
            case 35666: {
                return 7;
            }
            case 35675: {
                return 8;
            }
            case 35676: {
                return 9;
            }
        }
        return -1;
    }

    void cleanupRenderer() {
    }

    void updateColoringAttributes(Context context, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl, int n2) {
        float f9;
        float f10;
        float f11;
        GL gL = this.context(context).getGL();
        if (bl) {
            f11 = f2;
            f10 = f3;
            f9 = f4;
        } else {
            f11 = f5;
            f10 = f6;
            f9 = f7;
        }
        gL.glColor4f(f11, f10, f9, f8);
        if (n2 == 2) {
            gL.glShadeModel(7424);
        } else {
            gL.glShadeModel(7425);
        }
    }

    void updateDirectionalLight(Context context, int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        GL gL = this.context(context).getGL();
        int n3 = 16384 + n2;
        float[] fArray = new float[]{f2, f3, f4, 1.0f};
        gL.glLightfv(n3, 4609, fArray, 0);
        gL.glLightfv(n3, 4610, fArray, 0);
        fArray[0] = -f5;
        fArray[1] = -f6;
        fArray[2] = -f7;
        fArray[3] = 0.0f;
        gL.glLightfv(n3, 4611, fArray, 0);
        gL.glLightfv(n3, 4608, black, 0);
        gL.glLightf(n3, 4615, 1.0f);
        gL.glLightf(n3, 4616, 0.0f);
        gL.glLightf(n3, 4617, 0.0f);
        gL.glLightf(n3, 4613, 0.0f);
        gL.glLightf(n3, 4614, 180.0f);
    }

    void updatePointLight(Context context, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        GL gL = this.context(context).getGL();
        int n3 = 16384 + n2;
        float[] fArray = new float[]{f2, f3, f4, 1.0f};
        gL.glLightfv(n3, 4609, fArray, 0);
        gL.glLightfv(n3, 4610, fArray, 0);
        gL.glLightfv(n3, 4608, black, 0);
        fArray[0] = f8;
        fArray[1] = f9;
        fArray[2] = f10;
        gL.glLightfv(n3, 4611, fArray, 0);
        gL.glLightf(n3, 4615, f5);
        gL.glLightf(n3, 4616, f6);
        gL.glLightf(n3, 4617, f7);
        gL.glLightf(n3, 4613, 0.0f);
        gL.glLightf(n3, 4614, 180.0f);
    }

    void updateSpotLight(Context context, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        GL gL = this.context(context).getGL();
        int n3 = 16384 + n2;
        float[] fArray = new float[]{f2, f3, f4, 1.0f};
        gL.glLightfv(n3, 4609, fArray, 0);
        gL.glLightfv(n3, 4610, fArray, 0);
        gL.glLightfv(n3, 4608, black, 0);
        fArray[0] = f8;
        fArray[1] = f9;
        fArray[2] = f10;
        gL.glLightfv(n3, 4611, fArray, 0);
        gL.glLightf(n3, 4615, f5);
        gL.glLightf(n3, 4616, f6);
        gL.glLightf(n3, 4617, f7);
        fArray[0] = f13;
        fArray[1] = f14;
        fArray[2] = f15;
        gL.glLightfv(n3, 4612, fArray, 0);
        gL.glLightf(n3, 4613, f12);
        gL.glLightf(n3, 4614, (float)((double)(f11 * 180.0f) / Math.PI));
    }

    void updateExponentialFog(Context context, float f2, float f3, float f4, float f5) {
        GL gL = this.context(context).getGL();
        float[] fArray = new float[]{f2, f3, f4};
        gL.glFogi(2917, 2048);
        gL.glFogfv(2918, fArray, 0);
        gL.glFogf(2914, f5);
        gL.glEnable(2912);
    }

    void updateLinearFog(Context context, float f2, float f3, float f4, double d2, double d3) {
        GL gL = this.context(context).getGL();
        float[] fArray = new float[]{f2, f3, f4};
        gL.glFogi(2917, 9729);
        gL.glFogfv(2918, fArray, 0);
        gL.glFogf(2915, (float)d2);
        gL.glFogf(2916, (float)d3);
        gL.glEnable(2912);
    }

    void updateLineAttributes(Context context, float f2, int n2, int n3, int n4, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glLineWidth(f2);
        if (n2 == 0) {
            gL.glDisable(2852);
        } else {
            if (n2 == 1) {
                gL.glLineStipple(1, (short)255);
            } else if (n2 == 2) {
                gL.glLineStipple(1, (short)257);
            } else if (n2 == 3) {
                gL.glLineStipple(1, (short)2175);
            } else if (n2 == 4) {
                gL.glLineStipple(n4, (short)n3);
            }
            gL.glEnable(2852);
        }
        if (bl) {
            gL.glEnable(2848);
        } else {
            gL.glDisable(2848);
        }
    }

    void updateMaterial(Context context, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, int n2, boolean bl) {
        float[] fArray = new float[4];
        GL gL = this.context(context).getGL();
        gL.glMaterialf(1032, 5633, f18);
        switch (n2) {
            case 2: {
                gL.glColorMaterial(1032, 4609);
                break;
            }
            case 0: {
                gL.glColorMaterial(1032, 4608);
                break;
            }
            case 1: {
                gL.glColorMaterial(1032, 5632);
                break;
            }
            case 3: {
                gL.glColorMaterial(1032, 4610);
                break;
            }
            case 4: {
                gL.glColorMaterial(1032, 5634);
            }
        }
        fArray[0] = f9;
        fArray[1] = f10;
        fArray[2] = f11;
        gL.glMaterialfv(1032, 5632, fArray, 0);
        fArray[0] = f6;
        fArray[1] = f7;
        fArray[2] = f8;
        gL.glMaterialfv(1032, 4608, fArray, 0);
        fArray[0] = f15;
        fArray[1] = f16;
        fArray[2] = f17;
        gL.glMaterialfv(1032, 4610, fArray, 0);
        if (bl) {
            fArray[0] = f12;
            fArray[1] = f13;
            fArray[2] = f14;
        } else {
            fArray[0] = f2;
            fArray[1] = f3;
            fArray[2] = f4;
        }
        fArray[3] = f5;
        gL.glMaterialfv(1032, 4609, fArray, 0);
        gL.glColor4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        if (bl) {
            gL.glEnable(2896);
        } else {
            gL.glDisable(2896);
        }
    }

    void updateModelClip(Context context, int n2, boolean bl, double d2, double d3, double d4, double d5) {
        GL gL = this.context(context).getGL();
        double[] dArray = new double[4];
        int n3 = 12288 + n2;
        if (bl) {
            dArray[0] = -d2;
            dArray[1] = -d3;
            dArray[2] = -d4;
            dArray[3] = -d5;
            gL.glClipPlane(n3, DoubleBuffer.wrap(dArray));
            gL.glEnable(n3);
        } else {
            gL.glDisable(n3);
        }
    }

    void updatePointAttributes(Context context, float f2, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glPointSize(f2);
        if (bl) {
            gL.glEnable(2832);
        } else {
            gL.glDisable(2832);
        }
    }

    void updatePolygonAttributes(Context context, int n2, int n3, boolean bl, float f2, float f3) {
        GL gL = this.context(context).getGL();
        if (n3 == 0) {
            gL.glDisable(2884);
        } else {
            if (n3 == 1) {
                gL.glCullFace(1029);
            } else {
                gL.glCullFace(1028);
            }
            gL.glEnable(2884);
        }
        if (bl && n3 != 1) {
            gL.glLightModeli(2898, 1);
        } else {
            gL.glLightModeli(2898, 0);
        }
        if (n2 == 0) {
            gL.glPolygonMode(1032, 6912);
        } else if (n2 == 1) {
            gL.glPolygonMode(1032, 6913);
        } else {
            gL.glPolygonMode(1032, 6914);
        }
        gL.glPolygonOffset(f3, f2);
        if ((double)f3 != 0.0 || (double)f2 != 0.0) {
            switch (n2) {
                case 0: {
                    gL.glEnable(10753);
                    gL.glDisable(10754);
                    gL.glDisable(32823);
                    break;
                }
                case 1: {
                    gL.glEnable(10754);
                    gL.glDisable(10753);
                    gL.glDisable(32823);
                    break;
                }
                case 2: {
                    gL.glEnable(32823);
                    gL.glDisable(10753);
                    gL.glDisable(10754);
                }
            }
        } else {
            gL.glDisable(10753);
            gL.glDisable(10754);
            gL.glDisable(32823);
        }
    }

    void updateRenderingAttributes(Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, float f2, int n3, boolean bl5, boolean bl6, int n4, boolean bl7, boolean bl8, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        GL gL = this.context(context).getGL();
        if (!bl2) {
            if (bl3) {
                gL.glEnable(2929);
                gL.glDepthFunc(this.getFunctionValue(n2));
            } else {
                gL.glDisable(2929);
            }
        }
        if (!bl) {
            if (bl4) {
                gL.glDepthMask(true);
            } else {
                gL.glDepthMask(false);
            }
        }
        if (n3 == 0) {
            gL.glDisable(3008);
        } else {
            gL.glEnable(3008);
            gL.glAlphaFunc(this.getFunctionValue(n3), f2);
        }
        if (bl5) {
            gL.glDisable(2903);
        } else {
            gL.glEnable(2903);
        }
        if (bl6) {
            gL.glEnable(3058);
            switch (n4) {
                case 0: {
                    gL.glLogicOp(5376);
                    break;
                }
                case 1: {
                    gL.glLogicOp(5377);
                    break;
                }
                case 2: {
                    gL.glLogicOp(5378);
                    break;
                }
                case 3: {
                    gL.glLogicOp(5379);
                    break;
                }
                case 4: {
                    gL.glLogicOp(5380);
                    break;
                }
                case 5: {
                    gL.glLogicOp(5381);
                    break;
                }
                case 6: {
                    gL.glLogicOp(5382);
                    break;
                }
                case 7: {
                    gL.glLogicOp(5383);
                    break;
                }
                case 8: {
                    gL.glLogicOp(5384);
                    break;
                }
                case 9: {
                    gL.glLogicOp(5385);
                    break;
                }
                case 10: {
                    gL.glLogicOp(5386);
                    break;
                }
                case 11: {
                    gL.glLogicOp(5387);
                    break;
                }
                case 12: {
                    gL.glLogicOp(5388);
                    break;
                }
                case 13: {
                    gL.glLogicOp(5389);
                    break;
                }
                case 14: {
                    gL.glLogicOp(5390);
                    break;
                }
                case 15: {
                    gL.glLogicOp(5391);
                }
            }
        } else {
            gL.glDisable(3058);
        }
        if (bl7) {
            if (bl8) {
                gL.glEnable(2960);
                gL.glStencilOp(this.getStencilOpValue(n5), this.getStencilOpValue(n6), this.getStencilOpValue(n7));
                gL.glStencilFunc(this.getFunctionValue(n8), n9, n10);
                gL.glStencilMask(n11);
            } else {
                gL.glDisable(2960);
            }
        }
    }

    private int getFunctionValue(int n2) {
        switch (n2) {
            case 0: {
                n2 = 519;
                break;
            }
            case 1: {
                n2 = 512;
                break;
            }
            case 2: {
                n2 = 514;
                break;
            }
            case 3: {
                n2 = 517;
                break;
            }
            case 4: {
                n2 = 513;
                break;
            }
            case 5: {
                n2 = 515;
                break;
            }
            case 6: {
                n2 = 516;
                break;
            }
            case 7: {
                n2 = 518;
            }
        }
        return n2;
    }

    private int getStencilOpValue(int n2) {
        switch (n2) {
            case 1: {
                n2 = 7680;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 7681;
                break;
            }
            case 4: {
                n2 = 7682;
                break;
            }
            case 5: {
                n2 = 7683;
                break;
            }
            case 6: {
                n2 = 5386;
            }
        }
        return n2;
    }

    void updateTexCoordGeneration(Context context, boolean bl, int n2, int n3, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, double[] dArray) {
        GL gL = this.context(context).getGL();
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        if (bl) {
            gL.glEnable(3168);
            gL.glEnable(3169);
            if (n3 == 1) {
                gL.glEnable(3170);
                gL.glDisable(3171);
            } else if (n3 == 2) {
                gL.glEnable(3170);
                gL.glEnable(3171);
            } else {
                gL.glDisable(3170);
                gL.glDisable(3171);
            }
            if (n2 != 2) {
                fArray[0] = f2;
                fArray[1] = f3;
                fArray[2] = f4;
                fArray[3] = f5;
                fArray2[0] = f6;
                fArray2[1] = f7;
                fArray2[2] = f8;
                fArray2[3] = f9;
                if (n3 == 1) {
                    fArray3[0] = f10;
                    fArray3[1] = f11;
                    fArray3[2] = f12;
                    fArray3[3] = f13;
                } else if (n3 == 2) {
                    fArray3[0] = f10;
                    fArray3[1] = f11;
                    fArray3[2] = f12;
                    fArray3[3] = f13;
                    fArray4[0] = f14;
                    fArray4[1] = f15;
                    fArray4[2] = f16;
                    fArray4[3] = f17;
                }
            }
            switch (n2) {
                case 0: {
                    gL.glTexGeni(8192, 9472, 9217);
                    gL.glTexGeni(8193, 9472, 9217);
                    gL.glTexGenfv(8192, 9473, fArray, 0);
                    gL.glTexGenfv(8193, 9473, fArray2, 0);
                    if (n3 == 1) {
                        gL.glTexGeni(8194, 9472, 9217);
                        gL.glTexGenfv(8194, 9473, fArray3, 0);
                        break;
                    }
                    if (n3 != 2) break;
                    gL.glTexGeni(8194, 9472, 9217);
                    gL.glTexGenfv(8194, 9473, fArray3, 0);
                    gL.glTexGeni(8195, 9472, 9217);
                    gL.glTexGenfv(8195, 9473, fArray4, 0);
                    break;
                }
                case 1: {
                    gL.glMatrixMode(5888);
                    gL.glPushMatrix();
                    if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
                        gL.glLoadTransposeMatrixd(dArray, 0);
                    } else {
                        double[] dArray2 = new double[16];
                        this.copyTranspose(dArray, dArray2);
                        gL.glLoadMatrixd(dArray2, 0);
                    }
                    gL.glTexGeni(8192, 9472, 9216);
                    gL.glTexGeni(8193, 9472, 9216);
                    gL.glTexGenfv(8192, 9474, fArray, 0);
                    gL.glTexGenfv(8193, 9474, fArray2, 0);
                    if (n3 == 1) {
                        gL.glTexGeni(8194, 9472, 9216);
                        gL.glTexGenfv(8194, 9474, fArray3, 0);
                    } else if (n3 == 2) {
                        gL.glTexGeni(8194, 9472, 9216);
                        gL.glTexGenfv(8194, 9474, fArray3, 0);
                        gL.glTexGeni(8195, 9472, 9216);
                        gL.glTexGenfv(8195, 9474, fArray4, 0);
                    }
                    gL.glPopMatrix();
                    break;
                }
                case 2: {
                    gL.glTexGeni(8192, 9472, 9218);
                    gL.glTexGeni(8193, 9472, 9218);
                    if (n3 == 1) {
                        gL.glTexGeni(8194, 9472, 9218);
                        break;
                    }
                    if (n3 != 2) break;
                    gL.glTexGeni(8194, 9472, 9218);
                    gL.glTexGeni(8195, 9472, 9218);
                    break;
                }
                case 3: {
                    gL.glTexGeni(8192, 9472, 34065);
                    gL.glTexGeni(8193, 9472, 34065);
                    if (n3 == 1) {
                        gL.glTexGeni(8194, 9472, 34065);
                        break;
                    }
                    if (n3 != 2) break;
                    gL.glTexGeni(8194, 9472, 34065);
                    gL.glTexGeni(8195, 9472, 34065);
                    break;
                }
                case 4: {
                    gL.glTexGeni(8192, 9472, 34066);
                    gL.glTexGeni(8193, 9472, 34066);
                    if (n3 == 1) {
                        gL.glTexGeni(8194, 9472, 34066);
                        break;
                    }
                    if (n3 != 2) break;
                    gL.glTexGeni(8194, 9472, 34066);
                    gL.glTexGeni(8195, 9472, 34066);
                }
            }
        } else {
            gL.glDisable(3168);
            gL.glDisable(3169);
            gL.glDisable(3170);
            gL.glDisable(3171);
        }
    }

    void updateTransparencyAttributes(Context context, float f2, int n2, int n3, boolean bl, boolean bl2, int n4, int n5, int n6) {
        GL gL = this.context(context).getGL();
        if (n4 != 3) {
            gL.glDisable(2882);
        } else {
            gL.glEnable(2882);
            gL.glPolygonStipple(screen_door_table[(int)(f2 * 16.0f)]);
        }
        if (n4 < 3 || ((n2 & 2) != 0 || n3 == 1) && bl || ((n2 & 1) != 0 || n3 == 0) && bl2) {
            gL.glEnable(3042);
            gL.glBlendFunc(blendFunctionTable[n5], blendFunctionTable[n6]);
        } else {
            gL.glDisable(3042);
        }
    }

    void updateTextureAttributes(Context context, double[] dArray, boolean bl, int n2, int n3, float f2, float f3, float f4, float f5, int n4) {
        Object[] objectArray;
        GL gL = this.context(context).getGL();
        gL.glHint(3152, n3 == 1 ? 4354 : 4353);
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5890);
        if (bl) {
            gL.glLoadIdentity();
        } else if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glLoadTransposeMatrixd(dArray, 0);
        } else {
            objectArray = new double[16];
            this.copyTranspose(dArray, (double[])objectArray);
            gL.glLoadMatrixd(objectArray, 0);
        }
        gL.glPopAttrib();
        objectArray = new float[4];
        objectArray[0] = f2;
        objectArray[1] = f3;
        objectArray[2] = f4;
        objectArray[3] = f5;
        gL.glTexEnvfv(8960, 8705, (float[])objectArray, 0);
        switch (n2) {
            case 2: {
                gL.glTexEnvi(8960, 8704, 8448);
                break;
            }
            case 3: {
                gL.glTexEnvi(8960, 8704, 8449);
                break;
            }
            case 4: {
                gL.glTexEnvi(8960, 8704, 3042);
                break;
            }
            case 5: {
                gL.glTexEnvi(8960, 8704, 7681);
                break;
            }
            case 6: {
                gL.glTexEnvi(8960, 8704, 34160);
            }
        }
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table")) {
            gL.glDisable(32956);
        }
    }

    void updateRegisterCombiners(Context context, double[] dArray, boolean bl, int n2, int n3, float f2, float f3, float f4, float f5, int n4, int n5, int n6, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n7, int n8) {
        Object[] objectArray;
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        if (n3 == 1) {
            gL.glHint(3152, 4354);
        } else {
            gL.glHint(3152, 4353);
        }
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5890);
        if (bl) {
            gL.glLoadIdentity();
        } else if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glLoadTransposeMatrixd(dArray, 0);
        } else {
            objectArray = new double[16];
            this.copyTranspose(dArray, (double[])objectArray);
            gL.glLoadMatrixd(objectArray, 0);
        }
        gL.glPopAttrib();
        objectArray = new float[4];
        objectArray[0] = f2;
        objectArray[1] = f3;
        objectArray[2] = f4;
        objectArray[3] = f5;
        gL.glTexEnvfv(8960, 8705, (float[])objectArray, 0);
        gL.glEnable(34082);
        int n9 = joglContext.getCurrentTextureUnit();
        int n10 = joglContext.getCurrentCombinerUnit();
        int n11 = n10 == 34128 ? 34092 : 34094;
        switch (n2) {
            case 2: {
                gL.glCombinerInputNV(n10, 6407, 34083, n11, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34084, n9, 34102, 6407);
                gL.glCombinerInputNV(n10, 6406, 34083, n11, 34102, 6406);
                gL.glCombinerInputNV(n10, 6406, 34084, n9, 34102, 6406);
                gL.glCombinerOutputNV(n10, 6407, 34094, 34096, 34096, 0, 0, false, false, false);
                gL.glCombinerOutputNV(n10, 6406, 34094, 34096, 34096, 0, 0, false, false, false);
                break;
            }
            case 3: {
                gL.glCombinerInputNV(n10, 6407, 34083, n11, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34084, n9, 34103, 6406);
                gL.glCombinerInputNV(n10, 6407, 34085, n9, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34086, n9, 34102, 6406);
                gL.glCombinerInputNV(n10, 6406, 34083, n11, 34102, 6406);
                gL.glCombinerInputNV(n10, 6406, 34084, 0, 34103, 6406);
                gL.glCombinerOutputNV(n10, 6407, 34096, 34096, 34094, 0, 0, false, false, false);
                gL.glCombinerOutputNV(n10, 6406, 34094, 34096, 34096, 0, 0, false, false, false);
                break;
            }
            case 4: {
                gL.glCombinerParameterfvNV(34090, (float[])objectArray, 0);
                gL.glCombinerInputNV(n10, 6407, 34083, n11, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34084, n9, 34103, 6407);
                gL.glCombinerInputNV(n10, 6407, 34085, 34090, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34086, n9, 34102, 6407);
                gL.glCombinerInputNV(n10, 6406, 34083, n11, 34102, 6406);
                gL.glCombinerInputNV(n10, 6406, 34084, n9, 34102, 6406);
                gL.glCombinerOutputNV(n10, 6407, 34096, 34096, 34094, 0, 0, false, false, false);
                gL.glCombinerOutputNV(n10, 6406, 34094, 34096, 34096, 0, 0, false, false, false);
                break;
            }
            case 5: {
                gL.glCombinerInputNV(n10, 6407, 34083, n9, 34102, 6407);
                gL.glCombinerInputNV(n10, 6407, 34084, 0, 34103, 6407);
                gL.glCombinerInputNV(n10, 6406, 34083, n9, 34102, 6406);
                gL.glCombinerInputNV(n10, 6406, 34084, 0, 34103, 6406);
                gL.glCombinerOutputNV(n10, 6407, 34094, 34096, 34096, 0, 0, false, false, false);
                gL.glCombinerOutputNV(n10, 6406, 34094, 34096, 34096, 0, 0, false, false, false);
                break;
            }
            case 6: {
                if (n5 != 6) break;
                int n12 = this.getCombinerArg(gL, nArray[0], n9, n10);
                gL.glCombinerInputNV(n10, 6407, 34083, n12, 34104, 6407);
                int n13 = this.getCombinerArg(gL, nArray[1], n9, n10);
                gL.glCombinerInputNV(n10, 6407, 34084, n13, 34104, 6407);
                gL.glCombinerInputNV(n10, 6406, 34083, 0, 34103, 6406);
                gL.glCombinerInputNV(n10, 6406, 34084, 0, 34103, 6406);
                gL.glCombinerOutputNV(n10, 6407, 34094, 34096, 34096, 0, 0, true, false, false);
                gL.glCombinerOutputNV(n10, 6406, 34094, 34096, 34096, 0, 0, false, false, false);
            }
        }
        gL.glFinalCombinerInputNV(34083, 34094, 34102, 6407);
        gL.glFinalCombinerInputNV(34084, 0, 34103, 6407);
        gL.glFinalCombinerInputNV(34085, 0, 34102, 6407);
        gL.glFinalCombinerInputNV(34086, 0, 34102, 6407);
        gL.glFinalCombinerInputNV(34087, 0, 34102, 6407);
        gL.glFinalCombinerInputNV(34088, 0, 34102, 6407);
        gL.glFinalCombinerInputNV(34089, 34094, 34102, 6406);
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table")) {
            gL.glDisable(32956);
        }
    }

    void updateTextureColorTable(Context context, int n2, int n3, int[] nArray) {
        GL gL = this.context(context).getGL();
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table")) {
            if (n2 == 3) {
                gL.glColorTable(32956, 6407, n3, 6407, 5124, (Buffer)IntBuffer.wrap(nArray));
            } else {
                gL.glColorTable(32956, 6408, n3, 6408, 5124, (Buffer)IntBuffer.wrap(nArray));
            }
            gL.glEnable(32956);
        }
    }

    void updateCombiner(Context context, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n4, int n5) {
        int n6;
        GL gL = this.context(context).getGL();
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        this.getGLCombineMode(gL, n2, n3, nArray5, nArray6);
        gL.glTexEnvi(8960, 34161, nArray5[0]);
        gL.glTexEnvi(8960, 34162, nArray6[0]);
        int n7 = n2 == 0 ? 1 : (n2 == 5 ? 3 : 2);
        for (n6 = 0; n6 < n7; ++n6) {
            gL.glTexEnvi(8960, _gl_combineRgbSrcIndex[n6], _gl_combineSrc[nArray[n6]]);
            gL.glTexEnvi(8960, _gl_combineRgbOpIndex[n6], _gl_combineFcn[nArray3[n6]]);
        }
        n7 = n3 == 0 ? 1 : (n3 == 5 ? 3 : 2);
        for (n6 = 0; n6 < n7; ++n6) {
            gL.glTexEnvi(8960, _gl_combineAlphaSrcIndex[n6], _gl_combineSrc[nArray2[n6]]);
            gL.glTexEnvi(8960, _gl_combineAlphaOpIndex[n6], _gl_combineFcn[nArray4[n6]]);
        }
        gL.glTexEnvi(8960, 34163, n4);
        gL.glTexEnvi(8960, 3356, n5);
    }

    private void getGLCombineMode(GL gL, int n2, int n3, int[] nArray, int[] nArray2) {
        switch (n2) {
            case 0: {
                nArray[0] = 7681;
                break;
            }
            case 1: {
                nArray[0] = 8448;
                break;
            }
            case 2: {
                nArray[0] = 260;
                break;
            }
            case 3: {
                nArray[0] = 34164;
                break;
            }
            case 4: {
                nArray[0] = 34023;
                break;
            }
            case 5: {
                nArray[0] = 34165;
                break;
            }
            case 6: {
                nArray[0] = 34478;
                break;
            }
        }
        switch (n3) {
            case 0: {
                nArray2[0] = 7681;
                break;
            }
            case 1: {
                nArray2[0] = 8448;
                break;
            }
            case 2: {
                nArray2[0] = 260;
                break;
            }
            case 3: {
                nArray2[0] = 34164;
                break;
            }
            case 4: {
                nArray2[0] = 34023;
                break;
            }
            case 5: {
                nArray2[0] = 34165;
                break;
            }
            case 6: {
                if (n2 == 6) {
                    nArray[0] = 34479;
                    break;
                }
                nArray2[0] = 7681;
                break;
            }
        }
    }

    private int getCombinerArg(GL gL, int n2, int n3, int n4) {
        int n5 = 0;
        switch (n2) {
            case 0: {
                if (n4 == 34128) {
                    n5 = 34092;
                    break;
                }
                n5 = 34094;
                break;
            }
            case 1: {
                n5 = n3;
                break;
            }
            case 2: {
                n5 = 34090;
                break;
            }
            case 3: {
                n5 = n3 - 1;
            }
        }
        return n5;
    }

    void updateTextureUnitState(Context context, int n2, boolean bl) {
        GL gL = this.context(context).getGL();
        JoglContext joglContext = (JoglContext)context;
        if (n2 >= 0 && gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glActiveTexture(n2 + 33984);
            gL.glClientActiveTexture(33984 + n2);
            if (gL.isExtensionAvailable("GL_NV_register_combiners")) {
                joglContext.setCurrentTextureUnit(n2 + 33984);
                joglContext.setCurrentCombinerUnit(n2 + 34128);
                gL.glCombinerParameteriNV(34126, n2 + 1);
            }
        }
        if (!bl) {
            gL.glDisable(3552);
            gL.glDisable(3553);
            gL.glDisable(32879);
            gL.glDisable(34067);
        }
    }

    void bindTexture2D(Context context, int n2, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(34067);
        gL.glDisable(32879);
        if (!bl) {
            gL.glDisable(3553);
        } else {
            gL.glBindTexture(3553, n2);
            gL.glEnable(3553);
        }
    }

    void updateTexture2DImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object, boolean bl) {
        this.updateTexture2DImage(context, 3553, n2, n3, n4, n5, n6, n7, n8, n9, object, bl);
    }

    void updateTexture2DSubImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Object object, boolean bl) {
        this.updateTexture2DSubImage(context, 3553, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, object);
    }

    void updateTexture2DLodRange(Context context, int n2, int n3, float f2, float f3) {
        this.updateTextureLodRange(context, 3553, n2, n3, f2, f3);
    }

    void updateTexture2DLodOffset(Context context, float f2, float f3, float f4) {
        this.updateTextureLodOffset(context, 3553, f2, f3, f4);
    }

    void updateTexture2DBoundary(Context context, int n2, int n3, float f2, float f3, float f4, float f5) {
        this.updateTextureBoundary(context, 3553, n2, n3, -1, f2, f3, f4, f5);
    }

    void updateTexture2DFilterModes(Context context, int n2, int n3) {
        this.updateTextureFilterModes(context, 3553, n2, n3);
    }

    void updateTexture2DSharpenFunc(Context context, int n2, float[] fArray) {
        this.updateTextureSharpenFunc(context, 3553, n2, fArray);
    }

    void updateTexture2DFilter4Func(Context context, int n2, float[] fArray) {
        this.updateTextureFilter4Func(context, 3553, n2, fArray);
    }

    void updateTexture2DAnisotropicFilter(Context context, float f2) {
        this.updateTextureAnisotropicFilter(context, 3553, f2);
    }

    private void updateTextureLodRange(Context context, int n2, int n3, int n4, float f2, float f3) {
        GL gL = this.context(context).getGL();
        gL.glTexParameteri(n2, 33084, n3);
        gL.glTexParameteri(n2, 33085, n4);
        gL.glTexParameterf(n2, 33082, f2);
        gL.glTexParameterf(n2, 33083, f3);
    }

    private void updateTextureLodOffset(Context context, int n2, float f2, float f3, float f4) {
        GL gL = this.context(context).getGL();
        gL.glTexParameterf(n2, 33166, f2);
        gL.glTexParameterf(n2, 33167, f3);
        gL.glTexParameterf(n2, 33168, f4);
    }

    private void updateTextureAnisotropicFilter(Context context, int n2, float f2) {
        GL gL = this.context(context).getGL();
        gL.glTexParameterf(n2, 34046, f2);
    }

    void bindTexture3D(Context context, int n2, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(34067);
        if (!bl) {
            gL.glDisable(32879);
        } else {
            gL.glBindTexture(32879, n2);
            gL.glEnable(32879);
        }
    }

    void updateTexture3DImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object, boolean bl) {
        GL gL = this.context(context).getGL();
        int n11 = 0;
        int n12 = 0;
        int n13 = 32821;
        boolean bl2 = false;
        switch (n4) {
            case 1: {
                n12 = 32841;
                break;
            }
            case 2: {
                n12 = 6409;
                break;
            }
            case 3: {
                n12 = 6406;
                break;
            }
            case 4: {
                n12 = 6410;
                break;
            }
            case 5: {
                n12 = 6407;
                break;
            }
            case 6: {
                n12 = 6408;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (bl) {
            gL.glTexParameteri(32879, 33169, 1);
        } else {
            gL.glTexParameteri(32879, 33169, 0);
        }
        if (n10 == 4096 || n10 == 16384) {
            switch (n5) {
                case 1: {
                    n11 = 32992;
                    break;
                }
                case 2: {
                    n11 = 6407;
                    break;
                }
                case 4: {
                    if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                        n11 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n11 = 6408;
                    break;
                }
                case 16: {
                    n11 = 6410;
                    break;
                }
                case 32: {
                    if (n12 == 6406) {
                        n11 = 6406;
                        break;
                    }
                    n11 = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (n10 == 4096) {
                gL.glTexImage3D(32879, n3, n12, n6, n7, n8, n9, n11, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else {
                gL.glTexImage3D(32879, n3, n12, n6, n7, n8, n9, n11, 5121, (Buffer)((ByteBuffer)object));
            }
        } else if (n10 == 8192 || n10 == 32768) {
            switch (n5) {
                case 128: {
                    n11 = 6408;
                    n13 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n11 = 32993;
                    n13 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL.glPixelTransferf(3356, 0.0f);
                gL.glPixelTransferf(3357, 1.0f);
            }
            if (n10 == 8192) {
                gL.glTexImage3D(32879, n3, n12, n6, n7, n8, n9, n11, n13, (Buffer)IntBuffer.wrap((int[])object));
            } else {
                gL.glTexImage3D(32879, n3, n12, n6, n7, n8, n9, n11, n13, (Buffer)object);
            }
            if (bl2) {
                gL.glPixelTransferf(3356, 1.0f);
                gL.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    void updateTexture3DSubImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, Object object, boolean bl) {
        GL gL = this.context(context).getGL();
        int n17 = 0;
        int n18 = 0;
        int n19 = 32821;
        int n20 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n8 > 0 || n13 < n11) {
            bl3 = true;
            gL.glPixelStorei(3314, n11);
        }
        switch (n6) {
            case 1: {
                n18 = 32841;
                break;
            }
            case 2: {
                n18 = 6409;
                break;
            }
            case 3: {
                n18 = 6406;
                break;
            }
            case 4: {
                n18 = 6410;
                break;
            }
            case 5: {
                n18 = 6407;
                break;
            }
            case 6: {
                n18 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (n16 == 4096 || n16 == 16384) {
            switch (n7) {
                case 1: {
                    n17 = 32992;
                    n20 = 3;
                    break;
                }
                case 2: {
                    n17 = 6407;
                    n20 = 3;
                    break;
                }
                case 4: {
                    if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                        n17 = 32768;
                        n20 = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n17 = 6408;
                    n20 = 4;
                    break;
                }
                case 16: {
                    n17 = 6410;
                    n20 = 2;
                    break;
                }
                case 32: {
                    if (n18 == 6406) {
                        n17 = 6406;
                        n20 = 1;
                        break;
                    }
                    n17 = 6409;
                    n20 = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer byteBuffer = null;
            byteBuffer = n16 == 4096 ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
            int n21 = (n11 * n12 * n10 + n11 * n9 + n8) * n20;
            byteBuffer.position(n21);
            gL.glTexSubImage3D(32879, n2, n3, n4, n5, n13, n14, n15, n17, 5121, (Buffer)byteBuffer);
        } else if (n16 == 8192 || n16 == 32768) {
            switch (n7) {
                case 128: {
                    n17 = 6408;
                    n19 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n17 = 32993;
                    n19 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL.glPixelTransferf(3356, 0.0f);
                gL.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer intBuffer = null;
            intBuffer = n16 == 8192 ? IntBuffer.wrap((int[])object) : (IntBuffer)object;
            int n22 = n11 * n12 * n10 + n11 * n9 + n8;
            intBuffer.position(n22);
            gL.glTexSubImage3D(32879, n2, n3, n4, n5, n13, n14, n15, n17, n19, (Buffer)intBuffer);
            if (bl2) {
                gL.glPixelTransferf(3356, 1.0f);
                gL.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (bl3) {
            gL.glPixelStorei(3314, 0);
        }
    }

    void updateTexture3DLodRange(Context context, int n2, int n3, float f2, float f3) {
        this.updateTextureLodRange(context, 32879, n2, n3, f2, f3);
    }

    void updateTexture3DLodOffset(Context context, float f2, float f3, float f4) {
        this.updateTextureLodOffset(context, 32879, f2, f3, f4);
    }

    void updateTexture3DBoundary(Context context, int n2, int n3, int n4, float f2, float f3, float f4, float f5) {
        this.updateTextureBoundary(context, 3553, n2, n3, n4, f2, f3, f4, f5);
    }

    void updateTexture3DFilterModes(Context context, int n2, int n3) {
        this.updateTextureFilterModes(context, 32879, n2, n3);
    }

    void updateTexture3DSharpenFunc(Context context, int n2, float[] fArray) {
        this.updateTextureSharpenFunc(context, 32879, n2, fArray);
    }

    void updateTexture3DFilter4Func(Context context, int n2, float[] fArray) {
        this.updateTextureFilter4Func(context, 32879, n2, fArray);
    }

    void updateTexture3DAnisotropicFilter(Context context, float f2) {
        this.updateTextureAnisotropicFilter(context, 32879, f2);
    }

    void bindTextureCubeMap(Context context, int n2, boolean bl) {
        GL gL = this.context(context).getGL();
        if (!bl) {
            gL.glDisable(34067);
        } else {
            gL.glBindTexture(34067, n2);
            gL.glEnable(34067);
        }
    }

    void updateTextureCubeMapImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object, boolean bl) {
        this.updateTexture2DImage(context, _gl_textureCubeMapFace[n2], n3, n4, n5, n6, n7, n8, n9, n10, object, bl);
    }

    void updateTextureCubeMapSubImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, Object object, boolean bl) {
        this.updateTexture2DSubImage(context, _gl_textureCubeMapFace[n2], n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, object);
    }

    void updateTextureCubeMapLodRange(Context context, int n2, int n3, float f2, float f3) {
        this.updateTextureLodRange(context, 34067, n2, n3, f2, f3);
    }

    void updateTextureCubeMapLodOffset(Context context, float f2, float f3, float f4) {
        this.updateTextureLodOffset(context, 34067, f2, f3, f4);
    }

    void updateTextureCubeMapBoundary(Context context, int n2, int n3, float f2, float f3, float f4, float f5) {
        this.updateTextureBoundary(context, 34067, n2, n3, -1, f2, f3, f4, f5);
    }

    void updateTextureCubeMapFilterModes(Context context, int n2, int n3) {
        this.updateTextureFilterModes(context, 34067, n2, n3);
    }

    void updateTextureCubeMapSharpenFunc(Context context, int n2, float[] fArray) {
        this.updateTextureSharpenFunc(context, 34067, n2, fArray);
    }

    void updateTextureCubeMapFilter4Func(Context context, int n2, float[] fArray) {
        this.updateTextureFilter4Func(context, 34067, n2, fArray);
    }

    void updateTextureCubeMapAnisotropicFilter(Context context, float f2) {
        this.updateTextureAnisotropicFilter(context, 34067, f2);
    }

    private void updateTexture2DImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object, boolean bl) {
        GL gL = this.context(context).getGL();
        int n11 = 0;
        int n12 = 0;
        int n13 = 32821;
        boolean bl2 = false;
        switch (n5) {
            case 1: {
                n12 = 32841;
                break;
            }
            case 2: {
                n12 = 6409;
                break;
            }
            case 3: {
                n12 = 6406;
                break;
            }
            case 4: {
                n12 = 6410;
                break;
            }
            case 5: {
                n12 = 6407;
                break;
            }
            case 6: {
                n12 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (bl) {
            gL.glTexParameteri(n2, 33169, 1);
        } else {
            gL.glTexParameteri(n2, 33169, 0);
        }
        if (n10 == 4096 || n10 == 16384) {
            switch (n6) {
                case 1: {
                    n11 = 32992;
                    break;
                }
                case 2: {
                    n11 = 6407;
                    break;
                }
                case 4: {
                    if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                        n11 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n11 = 6408;
                    break;
                }
                case 16: {
                    n11 = 6410;
                    break;
                }
                case 32: {
                    if (n12 == 6406) {
                        n11 = 6406;
                        break;
                    }
                    n11 = 6409;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (n10 == 4096) {
                gL.glTexImage2D(n2, n4, n12, n7, n8, n9, n11, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
            } else {
                gL.glTexImage2D(n2, n4, n12, n7, n8, n9, n11, 5121, (Buffer)object);
            }
        } else if (n10 == 8192 || n10 == 32768) {
            switch (n6) {
                case 128: {
                    n11 = 6408;
                    n13 = 33639;
                    bl2 = true;
                    break;
                }
                case 256: {
                    bl2 = true;
                }
                case 512: {
                    n11 = 32993;
                    n13 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl2) {
                gL.glPixelTransferf(3356, 0.0f);
                gL.glPixelTransferf(3357, 1.0f);
            }
            if (n10 == 8192) {
                gL.glTexImage2D(n2, n4, n12, n7, n8, n9, n11, n13, (Buffer)IntBuffer.wrap((int[])object));
            } else {
                gL.glTexImage2D(n2, n4, n12, n7, n8, n9, n11, n13, (Buffer)object);
            }
            if (bl2) {
                gL.glPixelTransferf(3356, 1.0f);
                gL.glPixelTransferf(3357, 0.0f);
            }
        } else assert (false);
    }

    private void updateTexture2DSubImage(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, Object object) {
        GL gL = this.context(context).getGL();
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 32821;
        boolean bl = false;
        boolean bl2 = false;
        if (n8 > 0 || n11 < n10) {
            bl2 = true;
            gL.glPixelStorei(3314, n10);
        }
        switch (n6) {
            case 1: {
                n15 = 32841;
                break;
            }
            case 2: {
                n15 = 6409;
                break;
            }
            case 3: {
                n15 = 6406;
                break;
            }
            case 4: {
                n15 = 6410;
                break;
            }
            case 5: {
                n15 = 6407;
                break;
            }
            case 6: {
                n15 = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (n13 == 4096 || n13 == 16384) {
            switch (n7) {
                case 1: {
                    n14 = 32992;
                    n16 = 3;
                    break;
                }
                case 2: {
                    n14 = 6407;
                    n16 = 3;
                    break;
                }
                case 4: {
                    if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                        n14 = 32768;
                        n16 = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n14 = 6408;
                    n16 = 4;
                    break;
                }
                case 16: {
                    n14 = 6410;
                    n16 = 2;
                    break;
                }
                case 32: {
                    if (n15 == 6406) {
                        n14 = 6406;
                        n16 = 1;
                        break;
                    }
                    n14 = 6409;
                    n16 = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer byteBuffer = null;
            byteBuffer = n13 == 4096 ? ByteBuffer.wrap((byte[])object) : (ByteBuffer)object;
            byteBuffer.position((n10 * n9 + n8) * n16);
            gL.glTexSubImage2D(n2, n3, n4, n5, n11, n12, n14, 5121, (Buffer)byteBuffer);
        } else if (n13 == 8192 || n13 == 32768) {
            switch (n7) {
                case 128: {
                    n14 = 6408;
                    n17 = 33639;
                    bl = true;
                    break;
                }
                case 256: {
                    bl = true;
                }
                case 512: {
                    n14 = 32993;
                    n17 = 33639;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (bl) {
                gL.glPixelTransferf(3356, 0.0f);
                gL.glPixelTransferf(3357, 1.0f);
            }
            IntBuffer intBuffer = null;
            intBuffer = n13 == 8192 ? IntBuffer.wrap((int[])object) : (IntBuffer)object;
            intBuffer.position(n10 * n9 + n8);
            gL.glTexSubImage2D(n2, n3, n4, n5, n11, n12, n14, n17, (Buffer)intBuffer);
            if (bl) {
                gL.glPixelTransferf(3356, 1.0f);
                gL.glPixelTransferf(3357, 0.0f);
            }
        } else {
            assert (false);
            return;
        }
        if (bl2) {
            gL.glPixelStorei(3314, 0);
        }
    }

    void updateTextureFilterModes(Context context, int n2, int n3, int n4) {
        GL gL = this.context(context).getGL();
        switch (n3) {
            case 0: 
            case 2: {
                gL.glTexParameteri(n2, 10241, 9728);
                break;
            }
            case 3: {
                gL.glTexParameteri(n2, 10241, 9729);
                break;
            }
            case 4: {
                gL.glTexParameteri(n2, 10241, 9984);
                break;
            }
            case 1: 
            case 5: {
                gL.glTexParameteri(n2, 10241, 9987);
                break;
            }
            case 12: {
                gL.glTexParameteri(n2, 10241, 33094);
            }
        }
        switch (n4) {
            case 0: 
            case 2: {
                gL.glTexParameteri(n2, 10240, 9728);
                break;
            }
            case 1: 
            case 3: {
                gL.glTexParameteri(n2, 10240, 9729);
                break;
            }
            case 9: {
                gL.glTexParameteri(n2, 10240, 32941);
                break;
            }
            case 10: {
                gL.glTexParameteri(n2, 10240, 32943);
                break;
            }
            case 11: {
                gL.glTexParameteri(n2, 10240, 32942);
                break;
            }
            case 6: {
                gL.glTexParameteri(n2, 10240, 32919);
                break;
            }
            case 7: {
                gL.glTexParameteri(n2, 10240, 32921);
                break;
            }
            case 8: {
                gL.glTexParameteri(n2, 10240, 32920);
                break;
            }
            case 12: {
                gL.glTexParameteri(n2, 10240, 33094);
            }
        }
    }

    void updateTextureBoundary(Context context, int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5) {
        GL gL = this.context(context).getGL();
        switch (n3) {
            case 3: {
                gL.glTexParameteri(n2, 10242, 10497);
                break;
            }
            case 2: {
                gL.glTexParameteri(n2, 10242, 10496);
                break;
            }
            case 4: {
                gL.glTexParameteri(n2, 10242, 33071);
                break;
            }
            case 5: {
                gL.glTexParameteri(n2, 10242, 33069);
            }
        }
        switch (n4) {
            case 3: {
                gL.glTexParameteri(n2, 10243, 10497);
                break;
            }
            case 2: {
                gL.glTexParameteri(n2, 10243, 10496);
                break;
            }
            case 4: {
                gL.glTexParameteri(n2, 10243, 33071);
                break;
            }
            case 5: {
                gL.glTexParameteri(n2, 10243, 33069);
            }
        }
        if (n5 != -1) {
            switch (n5) {
                case 3: {
                    gL.glTexParameteri(n2, 32882, 10497);
                    break;
                }
                case 2: {
                    gL.glTexParameteri(n2, 32882, 10496);
                    break;
                }
                case 4: {
                    gL.glTexParameteri(n2, 32882, 33071);
                    break;
                }
                case 5: {
                    gL.glTexParameteri(n2, 32882, 33069);
                }
            }
        }
        if (n3 == 2 || n4 == 2 || n5 == 2) {
            float[] fArray = new float[]{f2, f3, f4, f5};
            gL.glTexParameterfv(n2, 4100, fArray, 0);
        }
    }

    private static final String getFilterName(int n2) {
        switch (n2) {
            case 0: {
                return "Texture.FASTEST";
            }
            case 1: {
                return "Texture.NICEST";
            }
            case 2: {
                return "Texture.BASE_LEVEL_POINT";
            }
            case 3: {
                return "Texture.BASE_LEVEL_LINEAR";
            }
            case 4: {
                return "Texture.MULTI_LEVEL_POINT";
            }
            case 5: {
                return "Texture.MULTI_LEVEL_LINEAR";
            }
            case 12: {
                return "Texture.FILTER4";
            }
            case 9: {
                return "Texture.LINEAR_SHARPEN";
            }
            case 10: {
                return "Texture.LINEAR_SHARPEN_RGB";
            }
            case 11: {
                return "Texture.LINEAR_SHARPEN_ALPHA";
            }
            case 6: {
                return "Texture.LINEAR_DETAIL";
            }
            case 7: {
                return "Texture.LINEAR_DETAIL_RGB";
            }
            case 8: {
                return "Texture.LINEAR_DETAIL_ALPHA";
            }
        }
        return "(unknown)";
    }

    private void updateTextureSharpenFunc(Context context, int n2, int n3, float[] fArray) {
        GL gL = this.context(context).getGL();
        gL.glSharpenTexFuncSGIS(n2, n3, fArray, 0);
    }

    private void updateTextureFilter4Func(Context context, int n2, int n3, float[] fArray) {
        GL gL = this.context(context).getGL();
        gL.glTexFilterFuncSGIS(n2, 33094, n3, fArray, 0);
    }

    long getAWT() {
        return 0L;
    }

    boolean initializeJ3D(boolean bl) {
        return true;
    }

    int getMaximumLights() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context createNewContext(Canvas3D canvas3D, long l2, Drawable drawable, long l3, Context context, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GLDrawable gLDrawable = null;
        IndexCapabilitiesChooser indexCapabilitiesChooser = null;
        JoglGraphicsConfiguration joglGraphicsConfiguration = (JoglGraphicsConfiguration)canvas3D.graphicsConfiguration;
        if (joglGraphicsConfiguration.getChosenIndex() >= 0) {
            indexCapabilitiesChooser = new IndexCapabilitiesChooser(joglGraphicsConfiguration.getChosenIndex());
        }
        if (canvas3D.drawable == null) {
            gLDrawable = GLDrawableFactory.getFactory().getGLDrawable((Object)canvas3D, joglGraphicsConfiguration.getGLCapabilities(), (GLCapabilitiesChooser)indexCapabilitiesChooser);
            canvas3D.drawable = new JoglDrawable(gLDrawable);
        } else {
            gLDrawable = this.drawable(canvas3D.drawable);
        }
        gLDrawable.setRealized(true);
        GLContext gLContext = gLDrawable.createContext(this.context(context));
        boolean bl5 = false;
        int n2 = 0;
        int n3 = 5;
        do {
            bl5 = false;
            int n4 = gLContext.makeCurrent();
            if (n4 != 0) continue;
            bl5 = true;
            ++n2;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (bl5 && n2 < n3);
        if (n2 == n3) {
            throw new IllegalRenderingStateException("Unable to make new context current after " + n2 + "tries");
        }
        GL gL = gLContext.getGL();
        JoglContext joglContext = new JoglContext(gLContext);
        try {
            if (!this.getPropertiesFromCurrentContext(joglContext)) {
                throw new IllegalRenderingStateException("Unable to fetch properties from current OpenGL context");
            }
            if (!bl) {
                this.setupCanvasProperties(canvas3D, joglContext, gL, bl3, bl4);
            }
            gL.glEnable(32826);
            gL.glColorMaterial(1032, 4609);
            gL.glDepthFunc(515);
            gL.glEnable(2903);
            gL.glReadBuffer(1028);
            gL.glPixelStorei(3317, 1);
            gL.glLightModeli(33272, 33274);
        }
        finally {
            gLContext.release();
        }
        return joglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createQueryContext(Canvas3D canvas3D, long l2, Drawable drawable, long l3, boolean bl, int n2, int n3, boolean bl2, boolean bl3) {
        Frame frame = new Frame();
        frame.setUndecorated(true);
        frame.setLayout(new BorderLayout());
        GLCapabilities gLCapabilities = new GLCapabilities();
        ContextQuerier contextQuerier = new ContextQuerier(canvas3D, bl2, bl3);
        QueryCanvas queryCanvas = new QueryCanvas(gLCapabilities, contextQuerier, null);
        frame.add((Component)queryCanvas, "Center");
        frame.setSize(1, 1);
        frame.setVisible(true);
        queryCanvas.doQuery();
        if (!EventQueue.isDispatchThread()) {
            ContextQuerier contextQuerier2 = contextQuerier;
            synchronized (contextQuerier2) {
                if (!contextQuerier.done()) {
                    try {
                        contextQuerier.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.disposeOnEDT(frame);
    }

    Drawable createOffScreenBuffer(Canvas3D canvas3D, Context context, long l2, long l3, int n2, int n3) {
        JoglGraphicsConfiguration joglGraphicsConfiguration = (JoglGraphicsConfiguration)canvas3D.graphicsConfiguration;
        GLCapabilities gLCapabilities = joglGraphicsConfiguration.getGLCapabilities();
        if (!GLDrawableFactory.getFactory().canCreateGLPbuffer()) {
            return null;
        }
        GLPbuffer gLPbuffer = GLDrawableFactory.getFactory().createGLPbuffer(gLCapabilities, null, n2, n3, null);
        return new JoglDrawable((GLDrawable)gLPbuffer);
    }

    void destroyOffScreenBuffer(Canvas3D canvas3D, Context context, long l2, long l3, Drawable drawable) {
        JoglDrawable joglDrawable = (JoglDrawable)drawable;
        GLPbuffer gLPbuffer = (GLPbuffer)joglDrawable.getGLDrawable();
        gLPbuffer.destroy();
    }

    void readOffScreenBuffer(Canvas3D canvas3D, Context context, int n2, int n3, Object object, int n4, int n5) {
        GL gL = this.context(context).getGL();
        gL.glPixelStorei(3330, n4);
        gL.glPixelStorei(3333, 1);
        int n6 = 0;
        if (n3 == 4096 || n3 == 16384) {
            switch (n2) {
                case 1: {
                    n6 = 32992;
                    break;
                }
                case 2: {
                    n6 = 6407;
                    break;
                }
                case 4: {
                    if (gL.isExtensionAvailable("GL_EXT_abgr")) {
                        n6 = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    n6 = 6408;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + n2));
                }
            }
            gL.glReadPixels(0, 0, n4, n5, n6, 5121, (Buffer)ByteBuffer.wrap((byte[])object));
        } else if (n3 == 8192 || n3 == 32768) {
            int n7 = 32821;
            boolean bl = false;
            switch (n2) {
                case 128: {
                    n6 = 6408;
                    n7 = 33639;
                    bl = true;
                    break;
                }
                case 256: {
                    bl = true;
                }
                case 512: {
                    n6 = 32993;
                    n7 = 33639;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + n2));
                }
            }
            if (bl) {
                gL.glPixelTransferf(3356, 0.0f);
                gL.glPixelTransferf(3357, 1.0f);
            }
            gL.glReadPixels(0, 0, n4, n5, n6, n7, (Buffer)IntBuffer.wrap((int[])object));
            if (bl) {
                gL.glPixelTransferf(3356, 1.0f);
                gL.glPixelTransferf(3357, 0.0f);
            }
        } else {
            throw new AssertionError((Object)("illegal image data type " + n3));
        }
    }

    int swapBuffers(Canvas3D canvas3D, Context context, long l2, Drawable drawable) {
        GLDrawable gLDrawable = this.drawable(drawable);
        gLDrawable.swapBuffers();
        return 0;
    }

    int resizeD3DCanvas(Canvas3D canvas3D, Context context) {
        return 0;
    }

    int toggleFullScreenMode(Canvas3D canvas3D, Context context) {
        return 0;
    }

    void updateMaterialColor(Context context, float f2, float f3, float f4, float f5) {
        GL gL = this.context(context).getGL();
        gL.glColor4f(f2, f3, f4, f5);
        gL.glDisable(2896);
    }

    void destroyContext(long l2, Drawable drawable, Context context) {
        GLDrawable gLDrawable = this.drawable(drawable);
        GLContext gLContext = this.context(context);
        if (GLContext.getCurrent() == gLContext) {
            gLContext.release();
        }
        gLContext.destroy();
        gLDrawable.setRealized(false);
    }

    void accum(Context context, float f2) {
        GL gL = this.context(context).getGL();
        gL.glReadBuffer(1029);
        gL.glAccum(256, f2);
        gL.glReadBuffer(1028);
    }

    void accumReturn(Context context) {
        GL gL = this.context(context).getGL();
        gL.glAccum(258, 1.0f);
    }

    void clearAccum(Context context) {
        GL gL = this.context(context).getGL();
        gL.glClear(512);
    }

    int getNumCtxLights(Context context) {
        GL gL = this.context(context).getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(3377, nArray, 0);
        return nArray[0];
    }

    boolean decal1stChildSetup(Context context) {
        GL gL = this.context(context).getGL();
        gL.glEnable(2960);
        gL.glClearStencil(0);
        gL.glClear(1024);
        gL.glStencilFunc(519, 1, 1);
        gL.glStencilOp(7680, 7680, 7681);
        return gL.glIsEnabled(2929);
    }

    void decalNthChildSetup(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2929);
        gL.glStencilFunc(514, 1, 1);
        gL.glStencilOp(7680, 7680, 7680);
    }

    void decalReset(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2960);
        if (bl) {
            gL.glEnable(2929);
        }
    }

    void ctxUpdateEyeLightingEnable(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glLightModeli(2897, 1);
        } else {
            gL.glLightModeli(2897, 0);
        }
    }

    void setBlendColor(Context context, float f2, float f3, float f4, float f5) {
        GL gL = this.context(context).getGL();
        if (gL.isExtensionAvailable("GL_ARB_imaging")) {
            gL.glBlendColor(f2, f3, f4, f5);
        }
    }

    void setBlendFunc(Context context, int n2, int n3) {
        GL gL = this.context(context).getGL();
        gL.glEnable(3042);
        gL.glBlendFunc(blendFunctionTable[n2], blendFunctionTable[n3]);
    }

    void setFogEnableFlag(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glEnable(2912);
        } else {
            gL.glDisable(2912);
        }
    }

    void setFullSceneAntialiasing(Context context, boolean bl) {
        JoglContext joglContext = (JoglContext)context;
        GL gL = this.context(joglContext).getGL();
        if (joglContext.getHasMultisample() && !VirtualUniverse.mc.implicitAntialiasing) {
            if (bl) {
                gL.glEnable(32925);
            } else {
                gL.glDisable(32925);
            }
        }
    }

    void setGlobalAlpha(Context context, float f2) {
        GL gL = this.context(context).getGL();
        if (gL.isExtensionAvailable("GL_SUN_global_alpha")) {
            gL.glEnable(33241);
            gL.glGlobalAlphaFactorfSUN(f2);
        }
    }

    void updateSeparateSpecularColorEnable(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glLightModeli(33272, 33274);
        } else {
            gL.glLightModeli(33272, 33273);
        }
    }

    void beginScene(Context context) {
    }

    void endScene(Context context) {
    }

    boolean validGraphicsMode() {
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return displayMode.getBitDepth() < 0 || displayMode.getBitDepth() > 8;
    }

    void setLightEnables(Context context, long l2, int n2) {
        GL gL = this.context(context).getGL();
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((l2 & (long)(1 << i2)) != 0L) {
                gL.glEnable(16384 + i2);
                continue;
            }
            gL.glDisable(16384 + i2);
        }
    }

    void setSceneAmbient(Context context, float f2, float f3, float f4) {
        GL gL = this.context(context).getGL();
        float[] fArray = new float[]{f2, f3, f4, 1.0f};
        gL.glLightModelfv(2899, fArray, 0);
    }

    void disableFog(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(2912);
    }

    void disableModelClip(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(12288);
        gL.glDisable(12289);
        gL.glDisable(12290);
        gL.glDisable(12291);
        gL.glDisable(12292);
        gL.glDisable(12293);
    }

    void resetRenderingAttributes(Context context, boolean bl, boolean bl2) {
        GL gL = this.context(context).getGL();
        if (!bl) {
            gL.glDepthMask(true);
        }
        if (!bl2) {
            gL.glEnable(2929);
        }
        gL.glAlphaFunc(519, 0.0f);
        gL.glDepthFunc(515);
        gL.glEnable(2903);
        gL.glDisable(3058);
    }

    void resetTextureNative(Context context, int n2) {
        GL gL = this.context(context).getGL();
        if (n2 >= 0 && gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glActiveTexture(n2 + 33984);
            gL.glClientActiveTexture(n2 + 33984);
        }
        gL.glDisable(3552);
        gL.glDisable(3553);
        gL.glDisable(32879);
        gL.glDisable(34067);
    }

    void activeTextureUnit(Context context, int n2) {
        GL gL = this.context(context).getGL();
        if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glActiveTexture(n2 + 33984);
            gL.glClientActiveTexture(n2 + 33984);
        }
    }

    void resetTexCoordGeneration(Context context) {
        GL gL = this.context(context).getGL();
        gL.glDisable(3168);
        gL.glDisable(3169);
        gL.glDisable(3170);
        gL.glDisable(3171);
    }

    void resetTextureAttributes(Context context) {
        GL gL = this.context(context).getGL();
        float[] fArray = new float[4];
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5890);
        gL.glLoadIdentity();
        gL.glPopAttrib();
        gL.glTexEnvfv(8960, 8705, fArray, 0);
        gL.glTexEnvi(8960, 8704, 7681);
        gL.glHint(3152, 4354);
        if (gL.isExtensionAvailable("GL_NV_register_combiners")) {
            gL.glDisable(34082);
        }
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table")) {
            gL.glDisable(32956);
        }
    }

    void resetPolygonAttributes(Context context) {
        GL gL = this.context(context).getGL();
        gL.glCullFace(1029);
        gL.glEnable(2884);
        gL.glLightModeli(2898, 0);
        gL.glPolygonMode(1032, 6914);
        gL.glPolygonOffset(0.0f, 0.0f);
        gL.glDisable(10753);
        gL.glDisable(10754);
        gL.glDisable(32823);
    }

    void resetLineAttributes(Context context) {
        GL gL = this.context(context).getGL();
        gL.glLineWidth(1.0f);
        gL.glDisable(2852);
        gL.glDisable(2848);
    }

    void resetPointAttributes(Context context) {
        GL gL = this.context(context).getGL();
        gL.glPointSize(1.0f);
        gL.glDisable(2832);
    }

    void resetTransparency(Context context, int n2, int n3, boolean bl, boolean bl2) {
        GL gL = this.context(context).getGL();
        if (((n2 & 2) != 0 || n3 == 1) && bl || ((n2 & 1) != 0 || n3 == 0) && bl2) {
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
        } else {
            gL.glDisable(3042);
        }
        gL.glDisable(2882);
    }

    void resetColoringAttributes(Context context, float f2, float f3, float f4, float f5, boolean bl) {
        GL gL = this.context(context).getGL();
        if (!bl) {
            gL.glColor4f(f2, f3, f4, f5);
        }
        gL.glShadeModel(7425);
    }

    void syncRender(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glFinish();
        } else {
            gL.glFlush();
        }
    }

    boolean useCtx(Context context, long l2, Drawable drawable) {
        GLContext gLContext = this.context(context);
        int n2 = gLContext.makeCurrent();
        return n2 != 0;
    }

    boolean releaseCtx(Context context, long l2) {
        GLContext gLContext = this.context(context);
        gLContext.release();
        return true;
    }

    void clear(Context context, float f2, float f3, float f4, boolean bl) {
        JoglContext joglContext = (JoglContext)context;
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        int n2 = 16640;
        if (bl) {
            gL.glPushAttrib(1280);
            gL.glClearStencil(0);
            gL.glStencilMask(-1);
            n2 |= 0x400;
        } else {
            gL.glPushAttrib(256);
        }
        gL.glDepthMask(true);
        gL.glClearColor(f2, f3, f4, joglContext.getAlphaClearValue());
        gL.glClear(n2);
        gL.glPopAttrib();
    }

    void textureFillBackground(Context context, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        gL.glPushAttrib(270344);
        this.disableAttribFor2D(gL);
        gL.glDepthMask(false);
        gL.glEnable(3553);
        if (bl) {
            gL.glTexParameteri(3553, 10241, 9729);
            gL.glTexParameteri(3553, 10240, 9729);
        }
        gL.glPolygonMode(1032, 6914);
        gL.glPixelStorei(3317, 1);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glMatrixMode(5890);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glBegin(7);
        gL.glTexCoord2f(f2, f4);
        gL.glVertex2f(f6, f8);
        gL.glTexCoord2f(f3, f4);
        gL.glVertex2f(f7, f8);
        gL.glTexCoord2f(f3, f5);
        gL.glVertex2f(f7, f9);
        gL.glTexCoord2f(f2, f5);
        gL.glVertex2f(f6, f9);
        gL.glEnd();
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopAttrib();
    }

    void textureFillRaster(Context context, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl) {
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        gL.glPushAttrib(270345);
        this.disableAttribForRaster(gL);
        if (bl) {
            gL.glTexParameteri(3553, 10241, 9729);
            gL.glTexParameteri(3553, 10240, 9729);
        }
        gL.glTexEnvi(8960, 8704, 8448);
        gL.glColor4f(1.0f, 1.0f, 1.0f, f11);
        gL.glPolygonMode(1032, 6914);
        gL.glPixelStorei(3317, 1);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
        gL.glBegin(7);
        gL.glTexCoord2f(f2, f4);
        gL.glVertex3f(f6, f8, f10);
        gL.glTexCoord2f(f3, f4);
        gL.glVertex3f(f7, f8, f10);
        gL.glTexCoord2f(f3, f5);
        gL.glVertex3f(f7, f9, f10);
        gL.glTexCoord2f(f2, f5);
        gL.glVertex3f(f6, f9, f10);
        gL.glEnd();
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    void executeRasterDepth(Context context, float f2, float f3, float f4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        gL.glRasterPos3f(f2, f3, f4);
        int[] nArray = new int[1];
        gL.glGetIntegerv(3073, nArray, 0);
        gL.glDrawBuffer(0);
        gL.glPixelZoom(1.0f, -1.0f);
        gL.glPixelStorei(3314, n6);
        if (n2 >= 0) {
            gL.glPixelStorei(3316, n2);
            if (n2 + n4 > n6) {
                n4 = n6 - n2;
            }
        } else if ((n4 += n2) > n6) {
            n4 = n6;
        }
        if (n3 >= 0) {
            gL.glPixelStorei(3315, n3);
            if (n3 + n5 > n5) {
                n5 -= n3;
            }
        } else if ((n5 += n3) > n5) {
            // empty if block
        }
        if (n8 == 1) {
            gL.glDrawPixels(n4, n5, 6402, 5125, (Buffer)IntBuffer.wrap((int[])object));
        } else {
            gL.glDrawPixels(n4, n5, 6402, 5126, (Buffer)FloatBuffer.wrap((float[])object));
        }
        gL.glDrawBuffer(nArray[0]);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3315, 0);
    }

    void setModelViewMatrix(Context context, double[] dArray, double[] dArray2) {
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        gL.glMatrixMode(5888);
        if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            gL.glLoadTransposeMatrixd(dArray, 0);
            gL.glMultTransposeMatrixd(dArray2, 0);
        } else {
            double[] dArray3 = new double[16];
            double[] dArray4 = new double[16];
            this.copyTranspose(dArray, dArray3);
            this.copyTranspose(dArray2, dArray4);
            gL.glLoadMatrixd(dArray3, 0);
            gL.glMultMatrixd(dArray4, 0);
        }
    }

    void setProjectionMatrix(Context context, double[] dArray) {
        GLContext gLContext = this.context(context);
        GL gL = gLContext.getGL();
        gL.glMatrixMode(5889);
        if (gL.isExtensionAvailable("GL_VERSION_1_3")) {
            dArray[8] = dArray[8] * -1.0;
            dArray[9] = dArray[9] * -1.0;
            dArray[10] = dArray[10] * -1.0;
            dArray[11] = dArray[11] * -1.0;
            gL.glLoadTransposeMatrixd(dArray, 0);
            dArray[8] = dArray[8] * -1.0;
            dArray[9] = dArray[9] * -1.0;
            dArray[10] = dArray[10] * -1.0;
            dArray[11] = dArray[11] * -1.0;
        } else {
            double[] dArray2 = new double[16];
            this.copyTranspose(dArray, dArray2);
            dArray2[2] = dArray2[2] * -1.0;
            dArray2[6] = dArray2[6] * -1.0;
            dArray2[10] = dArray2[10] * -1.0;
            dArray2[14] = dArray2[14] * -1.0;
            gL.glLoadMatrixd(dArray2, 0);
        }
    }

    void setViewport(Context context, int n2, int n3, int n4, int n5) {
        GL gL = this.context(context).getGL();
        gL.glViewport(n2, n3, n4, n5);
    }

    void newDisplayList(Context context, int n2) {
        if (n2 <= 0) {
            System.err.println("JAVA 3D ERROR : glNewList(" + n2 + ") -- IGNORED");
        }
        GL gL = this.context(context).getGL();
        gL.glNewList(n2, 4864);
    }

    void endDisplayList(Context context) {
        GL gL = this.context(context).getGL();
        gL.glEndList();
    }

    void callDisplayList(Context context, int n2, boolean bl) {
        if (n2 <= 0) {
            if (this.numInvalidLists < 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D ERROR : glCallList(" + n2 + ") -- IGNORED");
            } else if (this.numInvalidLists == 3) {
                ++this.numInvalidLists;
                System.err.println("JAVA 3D : further glCallList error messages discarded");
            }
            return;
        }
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glEnable(2977);
        }
        gL.glCallList(n2);
        if (bl) {
            gL.glDisable(2977);
        }
    }

    void freeDisplayList(Context context, int n2) {
        if (n2 <= 0) {
            System.err.println("JAVA 3D ERROR : glDeleteLists(" + n2 + ",1) -- IGNORED");
        }
        GL gL = this.context(context).getGL();
        gL.glDeleteLists(n2, 1);
    }

    void freeTexture(Context context, int n2) {
        GL gL = this.context(context).getGL();
        if (n2 > 0) {
            int[] nArray = new int[]{n2};
            gL.glDeleteTextures(1, nArray, 0);
        } else {
            System.err.println("tried to delete tex with texid <= 0");
        }
    }

    void texturemapping(Context context, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, byte[] byArray, int n13, int n14) {
        GL gL = this.context(context).getGL();
        int n15 = 6408;
        gL.glPushAttrib(270600);
        this.disableAttribFor2D(gL);
        gL.glPolygonMode(1032, 6914);
        gL.glDepthMask(false);
        gL.glPixelStorei(3317, 1);
        gL.glBindTexture(3553, n12);
        gL.glTexParameteri(3553, 10240, 9728);
        gL.glTexParameteri(3553, 10241, 9728);
        gL.glTexParameteri(3553, 10242, 10497);
        gL.glTexParameteri(3553, 10243, 10497);
        gL.glTexEnvf(8960, 8704, 7681.0f);
        gL.glEnable(3042);
        gL.glBlendFunc(770, 771);
        gL.glEnable(3553);
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n13, 0.0, (double)n14, 0.0, 0.0);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        if (gL.isExtensionAvailable("GL_EXT_abgr")) {
            n15 = 32768;
        } else {
            switch (n11) {
                case 8: {
                    n15 = 6408;
                    break;
                }
                case 2: {
                    n15 = 6407;
                }
            }
        }
        gL.glPixelStorei(3314, n10);
        gL.glPixelStorei(3316, n4);
        gL.glPixelStorei(3315, n5);
        gL.glTexSubImage2D(3553, 0, n4, n5, n6 - n4, n7 - n5, n15, 5121, (Buffer)ByteBuffer.wrap(byArray));
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3315, 0);
        float f2 = (float)n4 / (float)n8;
        float f3 = (float)n5 / (float)n9;
        float f4 = (float)n6 / (float)n8;
        float f5 = (float)n7 / (float)n9;
        float f6 = (float)n13 / 2.0f;
        float f7 = (float)n14 / 2.0f;
        float f8 = ((float)(n2 + n4) - f6) / f6;
        float f9 = (f7 - (float)(n3 + n7)) / f7;
        float f10 = ((float)(n2 + n6) - f6) / f6;
        float f11 = (f7 - (float)(n3 + n5)) / f7;
        gL.glBegin(7);
        gL.glTexCoord2f(f2, f5);
        gL.glVertex2f(f8, f9);
        gL.glTexCoord2f(f4, f5);
        gL.glVertex2f(f10, f9);
        gL.glTexCoord2f(f4, f3);
        gL.glVertex2f(f10, f11);
        gL.glTexCoord2f(f2, f3);
        gL.glVertex2f(f8, f11);
        gL.glEnd();
        gL.glDepthMask(true);
        gL.glClear(256);
        gL.glPopAttrib();
    }

    boolean initTexturemapping(Context context, int n2, int n3, int n4) {
        GL gL = this.context(context).getGL();
        int n5 = gL.isExtensionAvailable("GL_EXT_abgr") ? 32768 : 6408;
        gL.glBindTexture(3553, n4);
        gL.glTexImage2D(32868, 0, 6408, n2, n3, 0, n5, 5121, null);
        int[] nArray = new int[1];
        gL.glGetTexLevelParameteriv(32868, 0, 4096, nArray, 0);
        if (nArray[0] <= 0) {
            return false;
        }
        gL.glTexImage2D(3553, 0, 6408, n2, n3, 0, n5, 5121, null);
        return true;
    }

    void setRenderMode(Context context, int n2, boolean bl) {
        GL gL = this.context(context).getGL();
        int n3 = 0;
        if (bl) {
            n3 = 1029;
            switch (n2) {
                case 0: {
                    n3 = 1026;
                    break;
                }
                case 1: {
                    n3 = 1027;
                    break;
                }
                case 2: {
                    n3 = 1029;
                }
            }
        } else {
            n3 = 1028;
            switch (n2) {
                case 0: {
                    n3 = 1024;
                    break;
                }
                case 1: {
                    n3 = 1025;
                    break;
                }
                case 2: {
                    n3 = 1028;
                }
            }
        }
        gL.glDrawBuffer(n3);
    }

    void setDepthBufferWriteEnable(Context context, boolean bl) {
        GL gL = this.context(context).getGL();
        if (bl) {
            gL.glDepthMask(true);
        } else {
            gL.glDepthMask(false);
        }
    }

    private boolean getPropertiesFromCurrentContext(JoglContext joglContext) {
        GL gL = GLU.getCurrentGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(34018, nArray, 0);
        joglContext.setMaxTexCoordSets(nArray[0]);
        if (VirtualUniverse.mc.transparentOffScreen) {
            joglContext.setAlphaClearValue(0.0f);
        } else {
            joglContext.setAlphaClearValue(1.0f);
        }
        if (gL.isExtensionAvailable("GL_ARB_vertex_shader")) {
            gL.glGetIntegerv(34929, nArray, 0);
            joglContext.setMaxTexCoordSets(nArray[0]);
        }
        return true;
    }

    private int[] extractVersionInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n2 = Integer.valueOf(stringTokenizer.nextToken());
        int n3 = Integer.valueOf(stringTokenizer.nextToken());
        stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            Pattern pattern;
            Matcher matcher;
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens() && (matcher = (pattern = Pattern.compile("\\D*(\\d+)\\.(\\d+)\\.?(\\d*).*")).matcher(stringTokenizer.nextToken())).matches()) {
                int n4 = Integer.valueOf(matcher.group(1));
                int n5 = Integer.valueOf(matcher.group(2));
                if (n4 == n2 && n5 > n3) {
                    n3 = n5;
                }
            }
        }
        return new int[]{n2, n3};
    }

    private int getTextureColorTableSize(GL gL) {
        if (!gL.isExtensionAvailable("GL_ARB_imaging")) {
            return 0;
        }
        gL.glColorTable(32957, 6408, 256, 6407, 5124, null);
        int[] nArray = new int[1];
        gL.glGetColorTableParameteriv(32957, 32985, nArray, 0);
        return nArray[0];
    }

    private void checkTextureExtensions(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl) {
        Object[] objectArray;
        if (bl) {
            canvas3D.textureExtendedFeatures |= 4;
            canvas3D.multiTexAccelerated = true;
            objectArray = new int[1];
            gL.glGetIntegerv(34018, objectArray, 0);
            canvas3D.maxTexCoordSets = canvas3D.maxTextureUnits = objectArray[0];
            if (gL.isExtensionAvailable("GL_ARB_vertex_shader")) {
                gL.glGetIntegerv(34929, objectArray, 0);
                canvas3D.maxTexCoordSets = objectArray[0];
            }
        }
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table") || gL.isExtensionAvailable("GL_ARB_imaging")) {
            canvas3D.textureExtendedFeatures |= 2;
            canvas3D.textureColorTableSize = this.getTextureColorTableSize(gL);
            if (canvas3D.textureColorTableSize <= 0) {
                canvas3D.textureExtendedFeatures &= 0xFFFFFFFD;
            }
            if (canvas3D.textureColorTableSize > 256) {
                canvas3D.textureColorTableSize = 256;
            }
        }
        if (gL.isExtensionAvailable("GL_ARB_texture_env_combine")) {
            canvas3D.textureExtendedFeatures |= 8;
            canvas3D.textureExtendedFeatures |= 0x20;
        } else if (gL.isExtensionAvailable("GL_EXT_texture_env_combine")) {
            canvas3D.textureExtendedFeatures |= 8;
        }
        if (gL.isExtensionAvailable("GL_NV_register_combiners")) {
            canvas3D.textureExtendedFeatures |= 0x40;
        }
        if (gL.isExtensionAvailable("GL_ARB_texture_env_dot3") || gL.isExtensionAvailable("GL_EXT_texture_env_dot3")) {
            canvas3D.textureExtendedFeatures |= 0x10;
        }
        if (bl) {
            canvas3D.textureExtendedFeatures |= 0x80;
        }
        if (gL.isExtensionAvailable("GL_SGIS_sharpen_texture")) {
            canvas3D.textureExtendedFeatures |= 0x100;
        }
        if (gL.isExtensionAvailable("GL_SGIS_detail_texture")) {
            canvas3D.textureExtendedFeatures |= 0x200;
        }
        if (gL.isExtensionAvailable("GL_SGIS_texture_filter4")) {
            canvas3D.textureExtendedFeatures |= 0x400;
        }
        if (gL.isExtensionAvailable("GL_EXT_texture_filter_anisotropic")) {
            canvas3D.textureExtendedFeatures |= 0x800;
            objectArray = new float[1];
            gL.glGetFloatv(34047, (float[])objectArray, 0);
            canvas3D.anisotropicDegreeMax = objectArray[0];
        }
        if (gL.isExtensionAvailable("GL_SGIX_texture_lod_bias")) {
            canvas3D.textureExtendedFeatures |= 0x2000;
        }
        if (!VirtualUniverse.mc.enforcePowerOfTwo && gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two")) {
            canvas3D.textureExtendedFeatures |= 0x8000;
        }
        if (gL.isExtensionAvailable("GL_SGIS_generate_mipmap")) {
            canvas3D.textureExtendedFeatures |= 0x10000;
        }
    }

    private void checkGLSLShaderExtensions(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl) {
        if (bl && gL.isExtensionAvailable("GL_ARB_shader_objects") && gL.isExtensionAvailable("GL_ARB_shading_language_100")) {
            joglContext.initGLSLVertexAttributeImpl();
            int[] nArray = new int[1];
            gL.glGetIntegerv(34930, nArray, 0);
            canvas3D.maxTextureImageUnits = nArray[0];
            gL.glGetIntegerv(35660, nArray, 0);
            canvas3D.maxVertexTextureImageUnits = nArray[0];
            gL.glGetIntegerv(35661, nArray, 0);
            canvas3D.maxCombinedTextureImageUnits = nArray[0];
            int n2 = VirtualUniverse.mc.glslVertexAttrOffset;
            joglContext.setGLSLVertexAttrOffset(n2);
            gL.glGetIntegerv(34921, nArray, 0);
            canvas3D.maxVertexAttrs = nArray[0];
            canvas3D.maxVertexAttrs -= n2;
            if (canvas3D.maxVertexAttrs < 0) {
                canvas3D.maxVertexAttrs = 0;
            }
            canvas3D.shadingLanguageGLSL = true;
        }
    }

    private boolean createCgContext(JoglContext joglContext) {
        CGcontext cGcontext = CgGL.cgCreateContext();
        int n2 = CgGL.cgGetError();
        if (n2 != 0) {
            String string = CgGL.cgGetErrorString((int)n2);
            System.err.println("JAVA 3D ERROR : Fatal error in creating Cg context: \"" + string + "\"");
            return false;
        }
        if (cGcontext == null) {
            System.err.println("JAVA 3D ERROR : Invalid null Cg context");
            return false;
        }
        joglContext.setCgContext(cGcontext);
        if (CgGL.cgGLIsProfileSupported((int)6150)) {
            joglContext.setCgVertexProfile(6150);
        } else if (CgGL.cgGLIsProfileSupported((int)6146)) {
            joglContext.setCgVertexProfile(6146);
        } else {
            System.err.println("JAVA 3D ERROR : No CG vertex program profile is supported");
            joglContext.setCgContext(null);
            return false;
        }
        if (CgGL.cgGLIsProfileSupported((int)7000)) {
            joglContext.setCgFragmentProfile(7000);
        } else if (CgGL.cgGLIsProfileSupported((int)6147)) {
            joglContext.setCgFragmentProfile(6147);
        } else {
            System.err.println("JAVA 3D ERROR : No CG fragment program profile is supported");
            joglContext.setCgContext(null);
            return false;
        }
        return true;
    }

    private void checkCgShaderExtensions(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl) {
        if (bl) {
            if (!this.createCgContext(joglContext)) {
                return;
            }
            canvas3D.shadingLanguageCg = true;
            canvas3D.maxTextureImageUnits = canvas3D.maxTextureUnits;
            canvas3D.maxVertexTextureImageUnits = 0;
            canvas3D.maxCombinedTextureImageUnits = canvas3D.maxTextureUnits;
            canvas3D.maxVertexAttrs = 7;
            joglContext.initCgVertexAttributeImpl();
        }
    }

    private void setupCanvasProperties(Canvas3D canvas3D, JoglContext joglContext, GL gL, boolean bl, boolean bl2) {
        canvas3D.multiTexAccelerated = false;
        canvas3D.maxTextureUnits = 1;
        canvas3D.maxTexCoordSets = 1;
        canvas3D.maxTextureImageUnits = 0;
        canvas3D.maxVertexTextureImageUnits = 0;
        canvas3D.maxCombinedTextureImageUnits = 0;
        canvas3D.maxVertexAttrs = 0;
        canvas3D.extensionsSupported = 0;
        canvas3D.textureExtendedFeatures = 0;
        canvas3D.textureColorTableSize = 0;
        canvas3D.anisotropicDegreeMax = 0.0f;
        canvas3D.textureBoundaryWidthMax = 0;
        canvas3D.textureWidthMax = 0;
        canvas3D.textureHeightMax = 0;
        canvas3D.texture3DWidthMax = 0;
        canvas3D.texture3DHeightMax = 0;
        canvas3D.texture3DDepthMax = 0;
        canvas3D.shadingLanguageGLSL = false;
        canvas3D.shadingLanguageCg = false;
        String string = gL.glGetString(7938);
        String string2 = gL.glGetString(7936);
        String string3 = gL.glGetString(7937);
        canvas3D.nativeGraphicsVersion = string;
        canvas3D.nativeGraphicsVendor = string2;
        canvas3D.nativeGraphicsRenderer = string3;
        int[] nArray = this.extractVersionInfo(string);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n2 < 1 || n2 == 1 && n3 < 2) {
            throw new IllegalRenderingStateException("Java 3D ERROR : OpenGL 1.2 or better is required (GL_VERSION=" + n2 + "." + n3 + ")");
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n2 == 1) {
            if (n3 == 2) {
                System.err.println("JAVA 3D: OpenGL 1.2 detected; will run with reduced functionality");
            }
            if (n3 >= 3) {
                bl5 = true;
            }
            if (n3 >= 4) {
                bl4 = true;
            }
        } else {
            bl5 = true;
            bl4 = true;
            bl3 = true;
        }
        if (bl3) {
            assert (bl5);
            assert (bl4);
            assert (gL.isExtensionAvailable("GL_VERSION_2_0"));
        }
        if (bl4) {
            assert (bl5);
            assert (gL.isExtensionAvailable("GL_VERSION_1_4"));
        }
        if (bl5) assert (gL.isExtensionAvailable("GL_VERSION_1_3"));
        canvas3D.textureExtendedFeatures |= 1;
        canvas3D.textureExtendedFeatures |= 0x1000;
        if (bl4) {
            canvas3D.textureExtendedFeatures |= 0x10000;
        }
        if (gL.isExtensionAvailable("GL_EXT_abgr")) {
            canvas3D.extensionsSupported |= 2;
        }
        canvas3D.extensionsSupported |= 4;
        if (bl5) {
            canvas3D.extensionsSupported |= 8;
            joglContext.setHasMultisample(true);
        }
        if ((canvas3D.extensionsSupported & 8) != 0 && !VirtualUniverse.mc.implicitAntialiasing) {
            gL.glDisable(32925);
        }
        this.checkTextureExtensions(canvas3D, joglContext, gL, bl5);
        if (bl5) {
            this.checkGLSLShaderExtensions(canvas3D, joglContext, gL, bl);
            this.checkCgShaderExtensions(canvas3D, joglContext, gL, bl2);
        } else {
            this.checkGLSLShaderExtensions(canvas3D, joglContext, gL, false);
            this.checkCgShaderExtensions(canvas3D, joglContext, gL, false);
        }
        if (gL.isExtensionAvailable("GL_SUN_gloabl_alpha")) {
            canvas3D.extensionsSupported |= 1;
        }
        canvas3D.textureBoundaryWidthMax = 1;
        int[] nArray2 = new int[1];
        gL.glGetIntegerv(3379, nArray2, 0);
        canvas3D.textureWidthMax = nArray2[0];
        canvas3D.textureHeightMax = nArray2[0];
        nArray2[0] = -1;
        gL.glGetIntegerv(32883, nArray2, 0);
        canvas3D.texture3DWidthMax = nArray2[0];
        canvas3D.texture3DHeightMax = nArray2[0];
        canvas3D.texture3DDepthMax = nArray2[0];
    }

    private void disableAttribFor2D(GL gL) {
        gL.glDisable(3008);
        gL.glDisable(3042);
        gL.glDisable(3058);
        gL.glDisable(2903);
        gL.glDisable(2884);
        gL.glDisable(2929);
        gL.glDisable(2912);
        gL.glDisable(2896);
        gL.glDisable(32823);
        gL.glDisable(2882);
        gL.glDisable(2960);
        gL.glDisable(3553);
        gL.glDisable(3171);
        gL.glDisable(3170);
        gL.glDisable(3168);
        gL.glDisable(3169);
        for (int i2 = 0; i2 < 6; ++i2) {
            gL.glDisable(12288 + i2);
        }
        gL.glDisable(32879);
        gL.glDisable(34067);
        if (gL.isExtensionAvailable("GL_NV_register_combiners")) {
            gL.glDisable(34082);
        }
        if (gL.isExtensionAvailable("GL_SGI_texture_color_table")) {
            gL.glDisable(32956);
        }
        if (gL.isExtensionAvailable("GL_SUN_global_alpha")) {
            gL.glDisable(33241);
        }
    }

    private void disableAttribForRaster(GL gL) {
        gL.glDisable(2903);
        gL.glDisable(2884);
        gL.glDisable(2896);
        gL.glDisable(32823);
        gL.glDisable(2882);
        if (gL.isExtensionAvailable("GL_SUN_global_alpha")) {
            gL.glDisable(33241);
        }
    }

    private void copyTranspose(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[4];
        dArray2[2] = dArray[8];
        dArray2[3] = dArray[12];
        dArray2[4] = dArray[1];
        dArray2[5] = dArray[5];
        dArray2[6] = dArray[9];
        dArray2[7] = dArray[13];
        dArray2[8] = dArray[2];
        dArray2[9] = dArray[6];
        dArray2[10] = dArray[10];
        dArray2[11] = dArray[14];
        dArray2[12] = dArray[3];
        dArray2[13] = dArray[7];
        dArray2[14] = dArray[11];
        dArray2[15] = dArray[15];
    }

    GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration graphicsConfiguration) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        JoglGraphicsConfiguration joglGraphicsConfiguration = (JoglGraphicsConfiguration)graphicsConfiguration;
        IndexCapabilitiesChooser indexCapabilitiesChooser = null;
        if (joglGraphicsConfiguration.getChosenIndex() >= 0) {
            indexCapabilitiesChooser = new IndexCapabilitiesChooser(joglGraphicsConfiguration.getChosenIndex());
        }
        if ((abstractGraphicsConfiguration = GLDrawableFactory.getFactory().chooseGraphicsConfiguration(joglGraphicsConfiguration.getGLCapabilities(), (GLCapabilitiesChooser)indexCapabilitiesChooser, (AbstractGraphicsDevice)new AWTGraphicsDevice(joglGraphicsConfiguration.getDevice()))) == null) {
            return null;
        }
        return ((AWTGraphicsConfiguration)abstractGraphicsConfiguration).getGraphicsConfiguration();
    }

    long getFbConfig(GraphicsConfigInfo graphicsConfigInfo) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Object object;
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(graphicsConfigTemplate3D.getDoubleBuffer() <= 2);
        gLCapabilities.setStereo(graphicsConfigTemplate3D.getStereo() <= 2);
        gLCapabilities.setDepthBits(graphicsConfigTemplate3D.getDepthSize());
        gLCapabilities.setStencilBits(graphicsConfigTemplate3D.getStencilSize());
        gLCapabilities.setRedBits(Math.max(5, graphicsConfigTemplate3D.getRedSize()));
        gLCapabilities.setGreenBits(Math.max(5, graphicsConfigTemplate3D.getGreenSize()));
        gLCapabilities.setBlueBits(Math.max(5, graphicsConfigTemplate3D.getBlueSize()));
        gLCapabilities.setSampleBuffers(graphicsConfigTemplate3D.getSceneAntialiasing() <= 2);
        gLCapabilities.setNumSamples(4);
        if (VirtualUniverse.mc.transparentOffScreen) {
            gLCapabilities.setAlphaBits(1);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (graphicsConfigTemplate3D.getStereo() == 2) {
            arrayList.add(new Integer(1));
        }
        if (graphicsConfigTemplate3D.getSceneAntialiasing() == 2) {
            arrayList.add(new Integer(2));
        }
        if (graphicsConfigTemplate3D.getDoubleBuffer() == 2) {
            arrayList.add(new Integer(3));
        }
        GraphicsDevice graphicsDevice = graphicsConfigurationArray[0].getDevice();
        boolean bl = true;
        CapabilitiesCapturer capabilitiesCapturer = null;
        block15: while (bl) {
            Frame frame = new Frame(graphicsDevice.getDefaultConfiguration());
            frame.setUndecorated(true);
            frame.setLayout(new BorderLayout());
            capabilitiesCapturer = new CapabilitiesCapturer();
            try {
                object = new QueryCanvas(gLCapabilities, capabilitiesCapturer, graphicsDevice);
                frame.add((Component)object, "Center");
                frame.setSize(1, 1);
                frame.setVisible(true);
                ((QueryCanvas)object).doQuery();
                if (!EventQueue.isDispatchThread()) {
                    CapabilitiesCapturer capabilitiesCapturer2 = capabilitiesCapturer;
                    synchronized (capabilitiesCapturer2) {
                        if (!capabilitiesCapturer.done()) {
                            try {
                                capabilitiesCapturer.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                this.disposeOnEDT(frame);
                bl = false;
            }
            catch (GLException gLException) {
                if (arrayList.size() == 0) {
                    bl = false;
                    continue;
                }
                int n2 = (Integer)arrayList.remove(0);
                switch (n2) {
                    case 1: {
                        gLCapabilities.setStereo(false);
                        continue block15;
                    }
                    case 2: {
                        gLCapabilities.setSampleBuffers(false);
                        continue block15;
                    }
                    case 3: {
                        gLCapabilities.setDoubleBuffered(false);
                        continue block15;
                    }
                }
                throw new AssertionError((Object)"missing case statement");
            }
        }
        int n3 = capabilitiesCapturer.getChosenIndex();
        object = null;
        object = n3 < 0 ? gLCapabilities : capabilitiesCapturer.getCapabilities();
        JoglGraphicsConfiguration joglGraphicsConfiguration = new JoglGraphicsConfiguration((GLCapabilities)object, n3, graphicsDevice);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            GraphicsConfigInfo graphicsConfigInfo = new GraphicsConfigInfo(graphicsConfigTemplate3D);
            Canvas3D.graphicsConfigTable.put(joglGraphicsConfiguration, graphicsConfigInfo);
        }
        return joglGraphicsConfiguration;
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        return true;
    }

    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        return this.caps(canvas3D).getDoubleBuffered();
    }

    boolean hasStereo(Canvas3D canvas3D) {
        return this.caps(canvas3D).getStereo();
    }

    int getStencilSize(Canvas3D canvas3D) {
        return this.caps(canvas3D).getStencilBits();
    }

    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        return this.caps(canvas3D).getSampleBuffers();
    }

    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        GLCapabilities gLCapabilities = this.caps(canvas3D);
        return gLCapabilities.getAccumRedBits() > 0 && gLCapabilities.getAccumGreenBits() > 0 && gLCapabilities.getAccumBlueBits() > 0;
    }

    long getDisplay() {
        return 0L;
    }

    int getScreen(final GraphicsDevice graphicsDevice) {
        if (!this.checkedForGetScreenMethod) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        JoglPipeline.this.getScreenMethod = graphicsDevice.getClass().getDeclaredMethod("getScreen", new Class[0]);
                        JoglPipeline.this.getScreenMethod.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JoglPipeline.this.checkedForGetScreenMethod = true;
                    return null;
                }
            });
        }
        if (this.getScreenMethod != null) {
            try {
                return (Integer)this.getScreenMethod.invoke((Object)graphicsDevice, (Object[])null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return 0;
    }

    private static GraphicsConfiguration unwrap(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        if (aWTGraphicsConfiguration == null) {
            return null;
        }
        return aWTGraphicsConfiguration.getGraphicsConfiguration();
    }

    private void disposeOnEDT(final Frame frame) {
        Runnable runnable = new Runnable(){

            public void run() {
                frame.setVisible(false);
                frame.dispose();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D canvas3D) {
        return new JoglDrawingSurfaceObject(canvas3D);
    }

    void freeDrawingSurface(Canvas3D canvas3D, DrawingSurfaceObject drawingSurfaceObject) {
    }

    void freeDrawingSurfaceNative(Object object) {
    }

    GLContext context(Context context) {
        if (context == null) {
            return null;
        }
        return ((JoglContext)context).getGLContext();
    }

    GLDrawable drawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((JoglDrawable)drawable).getGLDrawable();
    }

    GLCapabilities caps(Canvas3D canvas3D) {
        return ((JoglGraphicsConfiguration)canvas3D.graphicsConfiguration).getGLCapabilities();
    }

    private static FloatBuffer getVertexArrayBuffer(float[] fArray) {
        return JoglPipeline.getVertexArrayBuffer(fArray, true);
    }

    private static FloatBuffer getVertexArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioVertexTemp, bl);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] dArray) {
        return JoglPipeline.getVertexArrayBuffer(dArray, true);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] dArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(dArray, nioVertexDoubleTemp, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] fArray) {
        return JoglPipeline.getColorArrayBuffer(fArray, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioColorTemp, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] byArray) {
        return JoglPipeline.getColorArrayBuffer(byArray, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] byArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(byArray, nioColorByteTemp, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] fArray) {
        return JoglPipeline.getNormalArrayBuffer(fArray, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] fArray, boolean bl) {
        return JoglPipeline.getNIOBuffer(fArray, nioNormalTemp, true);
    }

    private static FloatBuffer[] getTexCoordSetBuffer(Object[] objectArray) {
        return JoglPipeline.getNIOBuffer(objectArray, nioTexCoordSetTemp);
    }

    private static FloatBuffer[] getVertexAttrSetBuffer(Object[] objectArray) {
        return JoglPipeline.getNIOBuffer(objectArray, nioVertexAttrSetTemp);
    }

    private static FloatBuffer getNIOBuffer(float[] fArray, ThreadLocal threadLocal, boolean bl) {
        if (fArray == null) {
            return null;
        }
        FloatBuffer floatBuffer = (FloatBuffer)threadLocal.get();
        if (floatBuffer == null) {
            floatBuffer = BufferUtil.newFloatBuffer((int)fArray.length);
            threadLocal.set(floatBuffer);
        } else {
            floatBuffer.rewind();
            if (floatBuffer.remaining() < fArray.length) {
                int n2 = Math.max(2 * floatBuffer.remaining(), fArray.length);
                floatBuffer = BufferUtil.newFloatBuffer((int)n2);
                threadLocal.set(floatBuffer);
            }
        }
        if (bl) {
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBuffer;
    }

    private static DoubleBuffer getNIOBuffer(double[] dArray, ThreadLocal threadLocal, boolean bl) {
        if (dArray == null) {
            return null;
        }
        DoubleBuffer doubleBuffer = (DoubleBuffer)threadLocal.get();
        if (doubleBuffer == null) {
            doubleBuffer = BufferUtil.newDoubleBuffer((int)dArray.length);
            threadLocal.set(doubleBuffer);
        } else {
            doubleBuffer.rewind();
            if (doubleBuffer.remaining() < dArray.length) {
                int n2 = Math.max(2 * doubleBuffer.remaining(), dArray.length);
                doubleBuffer = BufferUtil.newDoubleBuffer((int)n2);
                threadLocal.set(doubleBuffer);
            }
        }
        if (bl) {
            doubleBuffer.put(dArray);
            doubleBuffer.rewind();
        }
        return doubleBuffer;
    }

    private static ByteBuffer getNIOBuffer(byte[] byArray, ThreadLocal threadLocal, boolean bl) {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = (ByteBuffer)threadLocal.get();
        if (byteBuffer == null) {
            byteBuffer = BufferUtil.newByteBuffer((int)byArray.length);
            threadLocal.set(byteBuffer);
        } else {
            byteBuffer.rewind();
            if (byteBuffer.remaining() < byArray.length) {
                int n2 = Math.max(2 * byteBuffer.remaining(), byArray.length);
                byteBuffer = BufferUtil.newByteBuffer((int)n2);
                threadLocal.set(byteBuffer);
            }
        }
        if (bl) {
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    private static FloatBuffer[] getNIOBuffer(Object[] objectArray, ThreadLocal threadLocal) {
        if (objectArray == null) {
            return null;
        }
        FloatBuffer[] floatBufferArray = (FloatBuffer[])threadLocal.get();
        if (floatBufferArray == null) {
            floatBufferArray = new FloatBuffer[objectArray.length];
            threadLocal.set(floatBufferArray);
        } else if (floatBufferArray.length < objectArray.length) {
            FloatBuffer[] floatBufferArray2 = new FloatBuffer[objectArray.length];
            System.arraycopy(floatBufferArray, 0, floatBufferArray2, 0, floatBufferArray.length);
            floatBufferArray = floatBufferArray2;
            threadLocal.set(floatBufferArray);
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            float[] fArray = (float[])objectArray[i2];
            FloatBuffer floatBuffer = floatBufferArray[i2];
            if (floatBuffer == null) {
                floatBufferArray[i2] = floatBuffer = BufferUtil.newFloatBuffer((int)fArray.length);
            } else {
                floatBuffer.rewind();
                if (floatBuffer.remaining() < fArray.length) {
                    int n2 = Math.max(2 * floatBuffer.remaining(), fArray.length);
                    floatBufferArray[i2] = floatBuffer = BufferUtil.newFloatBuffer((int)n2);
                }
            }
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
        return floatBufferArray;
    }

    static {
        int n2;
        black = new float[4];
        screen_door = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0, 0, 0x22222222, 0, 0}, {0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072, 0, 0x22222222, 0, -2004318072}, {0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072, 0, -1431655766, 0, -2004318072}, {0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766, 0x11111111, -1431655766, 0, -1431655766}, {0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766, 0x11111111, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766, 0x55555555, -1431655766, 0x44444444, -1431655766}, {0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766, 0x77777777, -1431655766, 0x55555555, -1431655766}, {0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766, 0x77777777, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766, -1, -1431655766, -572662307, -1431655766}, {-1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766, -1, -1431655766}, {-1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766, -1, -1145324613, -1, -1431655766}, {-1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154, -1, -1145324613, -1, -286331154}, {-1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154, -1, -1, -1, -286331154}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        screen_door_table = new ByteBuffer[screen_door.length];
        int n3 = screen_door[0].length * 4;
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(screen_door.length * n3));
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        for (n2 = 0; n2 < screen_door.length; ++n2) {
            intBuffer.put(screen_door[n2]);
        }
        byteBuffer.rewind();
        for (n2 = 0; n2 < screen_door.length; ++n2) {
            byteBuffer.position(n2 * n3);
            byteBuffer.limit((n2 + 1) * n3);
            JoglPipeline.screen_door_table[n2] = byteBuffer.slice();
        }
        blendFunctionTable = new int[9];
        JoglPipeline.blendFunctionTable[0] = 0;
        JoglPipeline.blendFunctionTable[1] = 1;
        JoglPipeline.blendFunctionTable[2] = 770;
        JoglPipeline.blendFunctionTable[3] = 771;
        JoglPipeline.blendFunctionTable[4] = 774;
        JoglPipeline.blendFunctionTable[5] = 775;
        JoglPipeline.blendFunctionTable[6] = 768;
        JoglPipeline.blendFunctionTable[7] = 769;
        JoglPipeline.blendFunctionTable[8] = 32769;
        _gl_combineRgbSrcIndex = new int[]{34176, 34177, 34178};
        _gl_combineAlphaSrcIndex = new int[]{34184, 34185, 34186};
        _gl_combineRgbOpIndex = new int[]{34192, 34193, 34194};
        _gl_combineAlphaOpIndex = new int[]{34200, 34201, 34202};
        _gl_combineSrc = new int[]{34167, 5890, 34166, 34168};
        _gl_combineFcn = new int[]{768, 769, 770, 771};
        _gl_textureCubeMapFace = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
        nioVertexTemp = new ThreadLocal();
        nioVertexDoubleTemp = new ThreadLocal();
        nioColorTemp = new ThreadLocal();
        nioColorByteTemp = new ThreadLocal();
        nioNormalTemp = new ThreadLocal();
        nioTexCoordSetTemp = new ThreadLocal();
        nioVertexAttrSetTemp = new ThreadLocal();
    }

    class CapabilitiesCapturer
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private boolean done;
        private GLCapabilities capabilities;
        private int chosenIndex = -1;

        CapabilitiesCapturer() {
        }

        public boolean done() {
            return this.done;
        }

        public GLCapabilities getCapabilities() {
            return this.capabilities;
        }

        public int getChosenIndex() {
            return this.chosenIndex;
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, GLCapabilities[] gLCapabilitiesArray, int n2) {
            int n3 = super.chooseCapabilities(gLCapabilities, gLCapabilitiesArray, n2);
            this.capabilities = gLCapabilitiesArray[n3];
            this.chosenIndex = n3;
            this.markDone();
            return n3;
        }

        public void init(GLContext gLContext) {
            this.kick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kick() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.notifyAll();
            }
        }
    }

    class ContextQuerier
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private Canvas3D canvas;
        private boolean glslLibraryAvailable;
        private boolean cgLibraryAvailable;
        private boolean done;

        public ContextQuerier(Canvas3D canvas3D, boolean bl, boolean bl2) {
            this.canvas = canvas3D;
            this.glslLibraryAvailable = bl;
            this.cgLibraryAvailable = bl2;
        }

        public boolean done() {
            return this.done;
        }

        public void init(GLContext gLContext) {
            JoglContext joglContext = new JoglContext(gLContext);
            if (JoglPipeline.this.getPropertiesFromCurrentContext(joglContext)) {
                JoglPipeline.this.setupCanvasProperties(this.canvas, joglContext, gLContext.getGL(), this.glslLibraryAvailable, this.cgLibraryAvailable);
            }
            this.markDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            ContextQuerier contextQuerier = this;
            synchronized (contextQuerier) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    static interface ExtendedCapabilitiesChooser
    extends GLCapabilitiesChooser {
        public void init(GLContext var1);
    }

    class IndexCapabilitiesChooser
    implements GLCapabilitiesChooser {
        private int indexToChoose;

        IndexCapabilitiesChooser(int n2) {
            this.indexToChoose = n2;
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, GLCapabilities[] gLCapabilitiesArray, int n2) {
            return this.indexToChoose;
        }
    }

    class QueryCanvas
    extends Canvas {
        private GLDrawable drawable;
        private ExtendedCapabilitiesChooser chooser;
        private boolean alreadyRan;

        public QueryCanvas(GLCapabilities gLCapabilities, ExtendedCapabilitiesChooser extendedCapabilitiesChooser, GraphicsDevice graphicsDevice) {
            super(JoglPipeline.unwrap((AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration(gLCapabilities, (GLCapabilitiesChooser)extendedCapabilitiesChooser, (AbstractGraphicsDevice)new AWTGraphicsDevice(graphicsDevice))));
            this.drawable = GLDrawableFactory.getFactory().getGLDrawable((Object)this, gLCapabilities, (GLCapabilitiesChooser)extendedCapabilitiesChooser);
            this.chooser = extendedCapabilitiesChooser;
        }

        public void addNotify() {
            super.addNotify();
            this.drawable.setRealized(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doQuery() {
            if (this.alreadyRan) {
                return;
            }
            GLContext gLContext = this.drawable.createContext(null);
            int n2 = gLContext.makeCurrent();
            if (n2 != 0) {
                try {
                    this.chooser.init(gLContext);
                }
                finally {
                    gLContext.release();
                }
            }
            gLContext.destroy();
            this.alreadyRan = true;
        }
    }
}

