/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class PointAttributesRetained
extends NodeComponentRetained {
    static final int POINT_SIZE_CHANGED = 1;
    static final int POINT_AA_CHANGED = 2;
    float pointSize = 1.0f;
    boolean pointAntialiasing = false;

    PointAttributesRetained() {
    }

    final void initPointSize(float f2) {
        this.pointSize = f2;
    }

    final void setPointSize(float f2) {
        this.initPointSize(f2);
        this.sendMessage(1, new Float(f2));
    }

    final float getPointSize() {
        return this.pointSize;
    }

    final void initPointAntialiasingEnable(boolean bl) {
        this.pointAntialiasing = bl;
    }

    final void setPointAntialiasingEnable(boolean bl) {
        this.initPointAntialiasingEnable(this.pointAntialiasing);
        this.sendMessage(2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final boolean getPointAntialiasingEnable() {
        return this.pointAntialiasing;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PointAttributesRetained pointAttributesRetained = new PointAttributesRetained();
                pointAttributesRetained.set(this);
                pointAttributesRetained.source = this.source;
                this.mirror = pointAttributesRetained;
            }
        } else {
            ((PointAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context) {
        Pipeline.getPipeline().updatePointAttributes(context, this.pointSize, this.pointAntialiasing);
    }

    synchronized void initMirrorObject() {
        ((PointAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        PointAttributesRetained pointAttributesRetained = (PointAttributesRetained)this.mirror;
        if ((n2 & 1) != 0) {
            pointAttributesRetained.pointSize = ((Float)object).floatValue();
        } else if ((n2 & 2) != 0) {
            pointAttributesRetained.pointAntialiasing = (Boolean)object;
        }
    }

    boolean equivalent(PointAttributesRetained pointAttributesRetained) {
        return pointAttributesRetained != null && pointAttributesRetained.pointSize == this.pointSize && pointAttributesRetained.pointAntialiasing == this.pointAntialiasing;
    }

    protected void set(PointAttributesRetained pointAttributesRetained) {
        super.set(pointAttributesRetained);
        this.pointSize = pointAttributesRetained.pointSize;
        this.pointAntialiasing = pointAttributesRetained.pointAntialiasing;
    }

    final void sendMessage(int n2, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 8;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 8;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n2);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 1 || n2 == 3) {
            this.setFrequencyChangeMask(n2, 1);
        }
    }
}

