/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class PositionPathInterpolator
extends PathInterpolator {
    private Transform3D position = new Transform3D();
    private Vector3f pos = new Vector3f();
    private Point3f[] positions;
    private float prevInterpolationValue = Float.NaN;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    PositionPathInterpolator() {
    }

    public PositionPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Point3f[] point3fArray) {
        super(alpha, transformGroup, transform3D, fArray);
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setPathArrays(point3fArray);
    }

    public void setPosition(int n2, Point3f point3f) {
        this.positions[n2].set(point3f);
    }

    public void getPosition(int n2, Point3f point3f) {
        point3f.set(this.positions[n2]);
    }

    public void setPathArrays(float[] fArray, Point3f[] point3fArray) {
        if (fArray.length != point3fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("PositionPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(point3fArray);
    }

    private void setPathArrays(Point3f[] point3fArray) {
        this.positions = new Point3f[point3fArray.length];
        for (int i2 = 0; i2 < point3fArray.length; ++i2) {
            this.positions[i2] = new Point3f();
            this.positions[i2].set(point3fArray[i2]);
        }
    }

    public void getPositions(Point3f[] point3fArray) {
        for (int i2 = 0; i2 < this.positions.length; ++i2) {
            point3fArray[i2].set(this.positions[i2]);
        }
    }

    public void setAxisOfTranslation(Transform3D transform3D) {
        this.setTransformAxis(transform3D);
    }

    public Transform3D getAxisOfTranslation() {
        return this.getTransformAxis();
    }

    public void computeTransform(float f2, Transform3D transform3D) {
        this.computePathInterpolation(f2);
        if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
            this.pos.x = this.positions[0].x;
            this.pos.y = this.positions[0].y;
            this.pos.z = this.positions[0].z;
        } else {
            this.pos.x = this.positions[this.currentKnotIndex].x + (this.positions[this.currentKnotIndex + 1].x - this.positions[this.currentKnotIndex].x) * this.currentInterpolationValue;
            this.pos.y = this.positions[this.currentKnotIndex].y + (this.positions[this.currentKnotIndex + 1].y - this.positions[this.currentKnotIndex].y) * this.currentInterpolationValue;
            this.pos.z = this.positions[this.currentKnotIndex].z + (this.positions[this.currentKnotIndex + 1].z - this.positions[this.currentKnotIndex].z) * this.currentInterpolationValue;
        }
        this.position.setIdentity();
        this.position.setTranslation(this.pos);
        transform3D.mul(this.axis, this.position);
        transform3D.mul(transform3D, this.axisInverse);
    }

    public Node cloneNode(boolean bl) {
        PositionPathInterpolator positionPathInterpolator = new PositionPathInterpolator();
        positionPathInterpolator.duplicateNode(this, bl);
        return positionPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PositionPathInterpolator positionPathInterpolator = (PositionPathInterpolator)node;
        int n2 = positionPathInterpolator.getArrayLengths();
        this.positions = new Point3f[n2];
        Point3f point3f = new Point3f();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.positions[i2] = new Point3f();
            positionPathInterpolator.getPosition(i2, point3f);
            this.setPosition(i2, point3f);
        }
    }
}

