/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class QuadArrayRetained
extends GeometryArrayRetained {
    QuadArrayRetained() {
        this.geoType = 1;
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        Point3d[] point3dArray = new Point3d[4];
        double[] dArray = new double[1];
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int[] nArray = new int[4];
        int n4 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        point3dArray[3] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n4 < this.validVertexCount) {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        nArray[i2] = n4;
                        this.getVertexData(n4++, point3dArray[i2]);
                    }
                    if (!this.intersectRay(point3dArray, pickRay, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (n4 < this.validVertexCount) {
                    for (int i3 = 0; i3 < 4; ++i3) {
                        nArray[i3] = n4;
                        this.getVertexData(n4++, point3dArray[i3]);
                    }
                    if (!this.intersectSegment(point3dArray, pickSegment.start, pickSegment.end, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n4 < this.validVertexCount) {
                    for (int i4 = 0; i4 < 4; ++i4) {
                        nArray[i4] = n4;
                        this.getVertexData(n4++, point3dArray[i4]);
                    }
                    if (!this.intersectBoundingBox(point3dArray, boundingBox, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n4 < this.validVertexCount) {
                    for (int i5 = 0; i5 < 4; ++i5) {
                        nArray[i5] = n4;
                        this.getVertexData(n4++, point3dArray[i5]);
                    }
                    if (!this.intersectBoundingSphere(point3dArray, boundingSphere, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n4 < this.validVertexCount) {
                    for (int i6 = 0; i6 < 4; ++i6) {
                        nArray[i6] = n4;
                        this.getVertexData(n4++, point3dArray[i6]);
                    }
                    if (!this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n4 < this.validVertexCount) {
                    for (int i7 = 0; i7 < 4; ++i7) {
                        nArray[i7] = n4;
                        this.getVertexData(n4++, point3dArray[i7]);
                    }
                    if (!this.intersectCylinder(point3dArray, pickCylinder, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n4 < this.validVertexCount) {
                    for (int i8 = 0; i8 < 4; ++i8) {
                        nArray[i8] = n4;
                        this.getVertexData(n4++, point3dArray[i8]);
                    }
                    if (!this.intersectCone(point3dArray, pickCone, dArray, point3d)) continue;
                    if (n2 == 0) {
                        return true;
                    }
                    if (dArray[0] < d2) {
                        d2 = dArray[0];
                        d3 = point3d.x;
                        d4 = point3d.y;
                        d5 = point3d.z;
                        if ((n2 & 0x20) != 0) {
                            this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                        }
                    }
                    if ((n2 & 0x40) == 0) continue;
                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("QuadArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection ");
            }
        }
        if (d2 < Double.MAX_VALUE) {
            point3d.x = d3;
            point3d.y = d4;
            point3d.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[4];
        double[] dArray = new double[1];
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        point3dArray2[2] = new Point3d();
        point3dArray2[3] = new Point3d();
        switch (point3dArray.length) {
            case 3: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray2[0]);
                    this.getVertexData(n2++, point3dArray2[1]);
                    this.getVertexData(n2++, point3dArray2[2]);
                    this.getVertexData(n2++, point3dArray2[3]);
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2]) && !this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[1], point3dArray[2])) continue;
                    return true;
                }
                break;
            }
            case 4: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray2[0]);
                    this.getVertexData(n2++, point3dArray2[1]);
                    this.getVertexData(n2++, point3dArray2[2]);
                    this.getVertexData(n2++, point3dArray2[3]);
                    if (!this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[1], point3dArray[2]) && !this.intersectTriTri(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0], point3dArray[2], point3dArray[3]) && !this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[1], point3dArray[2]) && !this.intersectTriTri(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0], point3dArray[2], point3dArray[3])) continue;
                    return true;
                }
                break;
            }
            case 2: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray2[0]);
                    this.getVertexData(n2++, point3dArray2[1]);
                    this.getVertexData(n2++, point3dArray2[2]);
                    this.getVertexData(n2++, point3dArray2[3]);
                    if (!this.intersectSegment(point3dArray2, point3dArray[0], point3dArray[1], dArray, null)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray2[0]);
                    this.getVertexData(n2++, point3dArray2[1]);
                    this.getVertexData(n2++, point3dArray2[2]);
                    this.getVertexData(n2++, point3dArray2[3]);
                    if (!this.intersectTriPnt(point3dArray2[0], point3dArray2[1], point3dArray2[2], point3dArray[0]) && !this.intersectTriPnt(point3dArray2[0], point3dArray2[2], point3dArray2[3], point3dArray[0])) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[4];
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        point3dArray[3] = new Point3d();
        while (n2 < this.validVertexCount) {
            this.getVertexData(n2++, point3dArray[0]);
            this.getVertexData(n2++, point3dArray[1]);
            this.getVertexData(n2++, point3dArray[2]);
            this.getVertexData(n2++, point3dArray[3]);
            transform3D.transform(point3dArray[0]);
            transform3D.transform(point3dArray[1]);
            transform3D.transform(point3dArray[2]);
            transform3D.transform(point3dArray[3]);
            if (!geometryRetained.intersect(point3dArray)) continue;
            return true;
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        Point3d[] point3dArray = new Point3d[4];
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        point3dArray[2] = new Point3d();
        point3dArray[3] = new Point3d();
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray[0]);
                    this.getVertexData(n2++, point3dArray[1]);
                    this.getVertexData(n2++, point3dArray[2]);
                    this.getVertexData(n2++, point3dArray[3]);
                    if (!this.intersectBoundingBox(point3dArray, boundingBox, null, null)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray[0]);
                    this.getVertexData(n2++, point3dArray[1]);
                    this.getVertexData(n2++, point3dArray[2]);
                    this.getVertexData(n2++, point3dArray[3]);
                    if (!this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) continue;
                    return true;
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n2 < this.validVertexCount) {
                    this.getVertexData(n2++, point3dArray[0]);
                    this.getVertexData(n2++, point3dArray[1]);
                    this.getVertexData(n2++, point3dArray[2]);
                    this.getVertexData(n2++, point3dArray[3]);
                    if (!this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    void computeCentroid() {
        double d2;
        int n2 = (this.vertexFormat & 0x80) == 0 ? this.initialVertexIndex : this.initialCoordIndex;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d3 = 0.0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (n2 < this.validVertexCount) {
            this.getVertexData(n2++, point3d);
            this.getVertexData(n2++, point3d2);
            this.getVertexData(n2++, point3d3);
            this.getVertexData(n2++, point3d4);
            vector3d3.sub(point3d, point3d2);
            vector3d.sub(point3d2, point3d3);
            vector3d2.cross(vector3d3, vector3d);
            vector3d2.normalize();
            if (Double.isNaN(vector3d2.x + vector3d2.y + vector3d2.z)) continue;
            vector3d3.set(0.0, 0.0, 0.0);
            this.getCrossValue(point3d, point3d2, vector3d3);
            this.getCrossValue(point3d2, point3d3, vector3d3);
            this.getCrossValue(point3d3, point3d, vector3d3);
            d2 = vector3d2.dot(vector3d3);
            d3 += d2;
            this.centroid.x += (point3d.x + point3d2.x + point3d3.x) * d2;
            this.centroid.y += (point3d.y + point3d2.y + point3d3.y) * d2;
            this.centroid.z += (point3d.z + point3d2.z + point3d3.z) * d2;
            vector3d3.set(0.0, 0.0, 0.0);
            this.getCrossValue(point3d, point3d3, vector3d3);
            this.getCrossValue(point3d3, point3d4, vector3d3);
            this.getCrossValue(point3d4, point3d, vector3d3);
            d2 = vector3d2.dot(vector3d3);
            d3 += d2;
            this.centroid.x += (point3d4.x + point3d.x + point3d3.x) * d2;
            this.centroid.y += (point3d4.y + point3d.y + point3d3.y) * d2;
            this.centroid.z += (point3d4.z + point3d.z + point3d3.z) * d2;
        }
        if (d3 != 0.0) {
            d2 = 1.0 / (3.0 * d3);
            this.centroid.x *= d2;
            this.centroid.y *= d2;
            this.centroid.z *= d2;
        }
    }

    int getClassType() {
        return 4;
    }
}

