/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;

public class SensorRead {
    public static final int MAXIMUM_SENSOR_BUTTON_COUNT = 12;
    long time;
    Transform3D read = new Transform3D();
    int[] buttonValues;
    int numButtons;

    public SensorRead() {
        this(0);
    }

    public SensorRead(int n2) {
        this.numButtons = n2;
        this.buttonValues = new int[n2];
        this.time = J3dClock.currentTimeMillis();
    }

    final void set(SensorRead sensorRead) {
        this.time = sensorRead.time;
        this.numButtons = sensorRead.numButtons;
        this.read.set(sensorRead.read);
        if (this.numButtons > 0) {
            System.arraycopy(sensorRead.buttonValues, 0, this.buttonValues, 0, sensorRead.numButtons);
        }
    }

    public void set(Transform3D transform3D) {
        this.read.set(transform3D);
    }

    public void get(Transform3D transform3D) {
        transform3D.set(this.read);
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public long getTime() {
        return this.time;
    }

    public void setButtons(int[] nArray) {
        if (this.numButtons == 0) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SensorRead1"));
        }
        if (nArray.length < this.numButtons) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("SensorRead0"));
        }
        System.arraycopy(nArray, 0, this.buttonValues, 0, this.numButtons);
    }

    public void getButtons(int[] nArray) {
        if (this.numButtons > 0) {
            System.arraycopy(this.buttonValues, 0, nArray, 0, this.numButtons);
        }
    }

    public int getNumButtons() {
        return this.numButtons;
    }
}

