/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;

class SoundStructure
extends J3dStructure {
    UnorderList nonViewScopedSounds = new UnorderList(SoundRetained.class);
    HashMap viewScopedSounds = new HashMap();
    UnorderList nonViewScopedSoundscapes = new UnorderList(SoundscapeRetained.class);
    HashMap viewScopedSoundscapes = new HashMap();
    UnorderList viewPlatforms = new UnorderList(ViewPlatformRetained.class);
    BoundingSphere tempSphere = new BoundingSphere();
    BoundingSphere vpsphere = new BoundingSphere();
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList switchChangeLeafNodes = new ArrayList();
    ArrayList switchChangeLeafMasks = new ArrayList();
    boolean transformMsg = false;
    UpdateTargets targets = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundStructure(VirtualUniverse virtualUniverse) {
        super(virtualUniverse, 512);
    }

    void processMessages(long l2) {
        Object[] objectArray = this.getMessages(l2);
        int n2 = this.getNumMessage();
        if (n2 <= 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            J3dMessage j3dMessage = objectArray[i2];
            switch (j3dMessage.type) {
                case 0: {
                    this.insertNodes(j3dMessage);
                    break;
                }
                case 1: {
                    this.removeNodes(j3dMessage);
                    break;
                }
                case 38: {
                    this.changeNodeAttrib(j3dMessage);
                    break;
                }
                case 45: {
                    this.changeNodeState(j3dMessage);
                    break;
                }
                case 39: 
                case 40: {
                    this.changeNodeAttrib(j3dMessage);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(j3dMessage);
                }
            }
            j3dMessage.decRefcount();
        }
        if (this.transformMsg) {
            this.targets = this.universe.transformStructure.getTargetList();
            this.updateTransformChange(this.targets, l2);
            this.transformMsg = false;
            this.targets = null;
        }
        Arrays.fill(objectArray, 0, n2, null);
    }

    void insertNodes(J3dMessage j3dMessage) {
        Object object;
        int n2;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object = objectArray[n2];
            if (object instanceof SoundRetained) {
                this.addNonScopedSound((SoundRetained)object);
            }
            if (!(object instanceof SoundscapeRetained)) continue;
            this.addNonSoundscape((SoundscapeRetained)object);
        }
        if (arrayList != null) {
            n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view;
                int n3;
                object = (NodeRetained)arrayList.get(i2);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
                int n4 = arrayList3.size();
                if (object instanceof SoundRetained) {
                    ((SoundRetained)object).isViewScoped = true;
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList3.get(n3);
                        this.addScopedSound((SoundRetained)object, view);
                    }
                    continue;
                }
                if (!(object instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)object).isViewScoped = true;
                for (n3 = 0; n3 < n4; ++n3) {
                    view = (View)arrayList3.get(n3);
                    this.addScopedSoundscape((SoundscapeRetained)object, view);
                }
            }
        }
    }

    void addScopedSound(SoundRetained soundRetained, View view) {
        ArrayList<SoundRetained> arrayList = (ArrayList<SoundRetained>)this.viewScopedSounds.get(view);
        if (arrayList == null) {
            arrayList = new ArrayList<SoundRetained>();
            this.viewScopedSounds.put(view, arrayList);
        }
        arrayList.add(soundRetained);
    }

    void addNonScopedSound(SoundRetained soundRetained) {
        this.nonViewScopedSounds.add(soundRetained);
    }

    void addScopedSoundscape(SoundscapeRetained soundscapeRetained, View view) {
        ArrayList<SoundscapeRetained> arrayList = (ArrayList<SoundscapeRetained>)this.viewScopedSoundscapes.get(view);
        if (arrayList == null) {
            arrayList = new ArrayList<SoundscapeRetained>();
            this.viewScopedSoundscapes.put(view, arrayList);
        }
        arrayList.add(soundscapeRetained);
    }

    void addNonSoundscape(SoundscapeRetained soundscapeRetained) {
        this.nonViewScopedSoundscapes.add(soundscapeRetained);
    }

    void removeNodes(J3dMessage j3dMessage) {
        Object object;
        int n2;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object = objectArray[n2];
            if (object instanceof SoundRetained) {
                this.deleteNonScopedSound((SoundRetained)object);
            }
            if (!(object instanceof SoundscapeRetained)) continue;
            this.deleteNonScopedSoundscape((SoundscapeRetained)object);
        }
        if (arrayList != null) {
            n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                View view;
                int n3;
                object = (NodeRetained)arrayList.get(i2);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
                int n4 = arrayList3.size();
                if (object instanceof SoundRetained) {
                    ((SoundRetained)object).isViewScoped = false;
                    for (n3 = 0; n3 < n4; ++n3) {
                        view = (View)arrayList3.get(n3);
                        this.deleteScopedSound((SoundRetained)object, view);
                    }
                    continue;
                }
                if (!(object instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)object).isViewScoped = false;
                for (n3 = 0; n3 < n4; ++n3) {
                    view = (View)arrayList3.get(n3);
                    this.deleteScopedSoundscape((SoundscapeRetained)object, view);
                }
            }
        }
    }

    void deleteNonScopedSound(SoundRetained soundRetained) {
        if (!this.nonViewScopedSounds.isEmpty()) {
            int n2 = this.nonViewScopedSounds.indexOf(soundRetained);
            this.nonViewScopedSounds.remove(n2);
        }
    }

    void deleteNonScopedSoundscape(SoundscapeRetained soundscapeRetained) {
        boolean bl = this.nonViewScopedSoundscapes.remove(soundscapeRetained);
    }

    void deleteScopedSound(SoundRetained soundRetained, View view) {
        ArrayList arrayList = (ArrayList)this.viewScopedSounds.get(view);
        if (!arrayList.isEmpty()) {
            int n2 = arrayList.indexOf(soundRetained);
            arrayList.remove(n2);
        }
        if (arrayList.isEmpty()) {
            this.viewScopedSounds.remove(view);
        }
    }

    void deleteScopedSoundscape(SoundscapeRetained soundscapeRetained, View view) {
        ArrayList arrayList = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (!arrayList.isEmpty()) {
            int n2 = arrayList.indexOf(soundscapeRetained);
            arrayList.remove(n2);
        }
        if (arrayList.isEmpty()) {
            this.viewScopedSoundscapes.remove(view);
        }
    }

    void changeNodeAttrib(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained) {
            int n2 = (Integer)object2;
            if ((n2 & 0x20) > 0) {
                // empty if block
            }
            if ((n2 & 1) > 0) {
                this.loadSound((SoundRetained)object, true);
            }
            ((SoundRetained)object).updateMirrorObject(j3dMessage.args);
        }
        if (object instanceof SoundscapeRetained) {
            ((SoundscapeRetained)object).updateTransformChange();
        }
    }

    void changeNodeState(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained) {
            int n2 = (Integer)object2;
            if ((n2 & 1) > 0) {
                this.loadSound((SoundRetained)object, false);
            }
            if ((n2 & 0x20) > 0) {
                this.enableSound((SoundRetained)object);
            }
            ((SoundRetained)object).updateMirrorObject(j3dMessage.args);
        }
    }

    boolean intersect(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            viewPlatformRetainedArray[i2].schedSphere.getWithLock(this.tempSphere);
            if (!this.tempSphere.intersect(bounds)) continue;
            return true;
        }
        return false;
    }

    void loadSound(SoundRetained soundRetained, boolean bl) {
        MediaContainer mediaContainer = soundRetained.getSoundData();
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] viewArray = viewPlatformRetainedArray[i2].getViewList();
            for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                View view = viewArray[i3];
                view.soundScheduler.loadSound(soundRetained, bl);
            }
        }
    }

    void enableSound(SoundRetained soundRetained) {
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] viewArray = viewPlatformRetainedArray[i2].getViewList();
            for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                View view = viewArray[i3];
                view.soundScheduler.enableSound(soundRetained);
            }
        }
    }

    void muteSound(SoundRetained soundRetained) {
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] viewArray = viewPlatformRetainedArray[i2].getViewList();
            for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                View view = viewArray[i3];
                view.soundScheduler.muteSound(soundRetained);
            }
        }
    }

    void pauseSound(SoundRetained soundRetained) {
        ViewPlatformRetained[] viewPlatformRetainedArray = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] viewArray = viewPlatformRetainedArray[i2].getViewList();
            for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                View view = viewArray[i3];
                view.soundScheduler.pauseSound(soundRetained);
            }
        }
    }

    void processSwitchChanged(J3dMessage j3dMessage) {
    }

    UnorderList getSoundList(View view) {
        ArrayList arrayList = (ArrayList)this.viewScopedSounds.get(view);
        if (arrayList == null) {
            return this.nonViewScopedSounds;
        }
        UnorderList unorderList = (UnorderList)this.nonViewScopedSounds.clone();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            unorderList.add(arrayList.get(i2));
        }
        return unorderList;
    }

    UnorderList getSoundscapeList(View view) {
        ArrayList arrayList = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (arrayList == null) {
            return this.nonViewScopedSoundscapes;
        }
        UnorderList unorderList = (UnorderList)this.nonViewScopedSoundscapes.clone();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            unorderList.add(arrayList.get(i2));
        }
        return unorderList;
    }

    void updateTransformChange(UpdateTargets updateTargets, long l2) {
        UnorderList unorderList = updateTargets.targetList[3];
        if (unorderList != null) {
            int n2 = unorderList.size();
            Object[] objectArray = unorderList.toArray(false);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object[] objectArray2 = (Object[])objectArray[i2];
                for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                    LeafRetained leafRetained;
                    if (objectArray2[i3] instanceof ConeSoundRetained) {
                        this.xformChangeList.add(objectArray2[i3]);
                        leafRetained = (ConeSoundRetained)objectArray2[i3];
                        ((ConeSoundRetained)leafRetained).updateTransformChange();
                        continue;
                    }
                    if (objectArray2[i3] instanceof PointSoundRetained) {
                        this.xformChangeList.add(objectArray2[i3]);
                        leafRetained = (PointSoundRetained)objectArray2[i3];
                        ((PointSoundRetained)leafRetained).updateTransformChange();
                        continue;
                    }
                    if (objectArray2[i3] instanceof SoundRetained) {
                        this.xformChangeList.add(objectArray2[i3]);
                        leafRetained = (SoundRetained)objectArray2[i3];
                        ((SoundRetained)leafRetained).updateTransformChange();
                        continue;
                    }
                    if (objectArray2[i3] instanceof SoundscapeRetained) {
                        this.xformChangeList.add(objectArray2[i3]);
                        leafRetained = (SoundscapeRetained)objectArray2[i3];
                        ((SoundscapeRetained)leafRetained).updateTransformChange();
                        continue;
                    }
                    if (!(objectArray2[i3] instanceof AuralAttributesRetained)) continue;
                    this.xformChangeList.add(objectArray2[i3]);
                }
            }
        }
    }

    void debugPrint(String string) {
    }

    boolean isSoundScopedToView(Object object, View view) {
        ArrayList arrayList;
        SoundRetained soundRetained = (SoundRetained)object;
        return !soundRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedSounds.get(view)).contains(soundRetained);
    }

    boolean isSoundscapeScopedToView(Object object, View view) {
        ArrayList arrayList;
        SoundscapeRetained soundscapeRetained = (SoundscapeRetained)object;
        return !soundscapeRetained.isViewScoped || (arrayList = (ArrayList)this.viewScopedSoundscapes.get(view)).contains(soundscapeRetained);
    }

    void updateViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e2;
        int n2;
        int n3;
        Object object;
        Object object2;
        int n4 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if ((n4 & 2) != 0 || (n4 & 1) != 0) {
            object2 = (View)objectArray[0];
            object = (ArrayList)objectArray[2];
            n3 = ((ArrayList)object).size();
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    e2 = ((ArrayList)object).get(n2);
                    if (e2 instanceof SoundRetained) {
                        if (arrayList == null && (arrayList = (ArrayList)this.viewScopedSounds.get(object2)) == null) {
                            arrayList = new ArrayList();
                            this.viewScopedSounds.put(object2, arrayList);
                        }
                        arrayList.add(e2);
                        continue;
                    }
                    if (!(e2 instanceof SoundscapeRetained)) continue;
                    if (arrayList2 == null && (arrayList2 = (ArrayList)this.viewScopedSoundscapes.get(object2)) == null) {
                        arrayList2 = new ArrayList();
                        this.viewScopedSoundscapes.put(object2, arrayList2);
                    }
                    arrayList2.add(e2);
                }
            }
        }
        if ((n4 & 4) != 0 || (n4 & 1) != 0) {
            if ((n4 & 4) != 0) {
                object = (View)objectArray[0];
                object2 = (ArrayList)objectArray[2];
            } else {
                object = (View)objectArray[4];
                object2 = (ArrayList)objectArray[6];
            }
            n3 = ((ArrayList)object2).size();
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    e2 = ((ArrayList)object2).get(n2);
                    if (e2 instanceof SoundRetained) {
                        if (arrayList == null) {
                            arrayList = (ArrayList)this.viewScopedSounds.get(object);
                        }
                        arrayList.remove(e2);
                    }
                    if (!(e2 instanceof SoundscapeRetained)) continue;
                    if (arrayList2 == null) {
                        arrayList2 = (ArrayList)this.viewScopedSoundscapes.get(object);
                    }
                    arrayList2.remove(e2);
                }
                if (arrayList != null && arrayList.size() == 0) {
                    this.viewScopedSounds.remove(object);
                }
                if (arrayList2 != null && arrayList2.size() == 0) {
                    this.viewScopedSoundscapes.remove(object);
                }
            }
        }
    }

    void cleanup() {
    }
}

