/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CachedTargets;

class SwitchState {
    long[] compositeSwitchMask = new long[]{0L};
    boolean cachedSwitchOn = true;
    boolean currentSwitchOn = true;
    boolean lastSwitchOn = true;
    boolean initialized = false;
    CachedTargets cachedTargets = null;
    boolean inSwitch = false;

    public SwitchState(boolean bl) {
        this.inSwitch = bl;
        this.initialized = !bl;
    }

    void dump() {
        System.err.println(" MASK " + this.compositeSwitchMask[0] + " CACH " + this.cachedSwitchOn + " CURR " + this.currentSwitchOn + " LAST " + this.lastSwitchOn);
    }

    void updateCompositeSwitchMask(int n2, boolean bl) {
        if (n2 < 64) {
            this.compositeSwitchMask[0] = bl ? this.compositeSwitchMask[0] & (long)(~(1 << n2)) : this.compositeSwitchMask[0] | (long)(1 << n2);
        } else {
            int n3 = n2 / 64;
            int n4 = n2 % 64;
            if (n3 > this.compositeSwitchMask.length) {
                long[] lArray = new long[n3 + 1];
                System.arraycopy(this.compositeSwitchMask, 0, lArray, 0, n3);
                this.compositeSwitchMask = lArray;
            }
            if (bl) {
                int n5 = n3;
                this.compositeSwitchMask[n5] = this.compositeSwitchMask[n5] & (long)(~(1 << n4));
            } else {
                int n6 = n3;
                this.compositeSwitchMask[n6] = this.compositeSwitchMask[n6] | (long)(1 << n4);
            }
        }
    }

    void initSwitchOn() {
        boolean bl;
        this.lastSwitchOn = this.cachedSwitchOn = (bl = this.evalCompositeSwitchOn());
        this.currentSwitchOn = this.cachedSwitchOn;
        this.initialized = true;
    }

    void updateCurrentSwitchOn() {
        this.currentSwitchOn = !this.currentSwitchOn;
    }

    void updateLastSwitchOn() {
        this.lastSwitchOn = this.currentSwitchOn;
    }

    void updateCachedSwitchOn() {
        this.cachedSwitchOn = !this.cachedSwitchOn;
    }

    boolean evalCompositeSwitchOn() {
        boolean bl;
        if (this.compositeSwitchMask.length == 1) {
            bl = this.compositeSwitchMask[0] == 0L;
        } else {
            bl = true;
            for (int i2 = 0; i2 < this.compositeSwitchMask.length; ++i2) {
                if (this.compositeSwitchMask[i2] == 0L) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

