/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class Targets {
    static final int MAX_NODELIST = 7;
    static final int GEO_TARGETS = 0;
    static final int ENV_TARGETS = 1;
    static final int BEH_TARGETS = 2;
    static final int SND_TARGETS = 3;
    static final int VPF_TARGETS = 4;
    static final int BLN_TARGETS = 5;
    static final int GRP_TARGETS = 6;
    ArrayList[] targetList = new ArrayList[7];

    Targets() {
    }

    void addNode(NnuId nnuId, int n2) {
        if (this.targetList[n2] == null) {
            this.targetList[n2] = new ArrayList(1);
        }
        this.targetList[n2].add(nnuId);
    }

    void addNodeArray(NnuId[] nnuIdArray, int n2) {
        if (this.targetList[n2] == null) {
            this.targetList[n2] = new ArrayList(1);
        }
        this.targetList[n2].add(nnuIdArray);
    }

    void removeNode(int n2, int n3) {
        if (this.targetList[n3] != null) {
            this.targetList[n3].remove(n2);
        }
    }

    void addNodes(ArrayList arrayList, int n2) {
        if (this.targetList[n2] == null) {
            this.targetList[n2] = new ArrayList(1);
        }
        this.targetList[n2].addAll(arrayList);
    }

    void clearNodes() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            this.targetList[i2].clear();
        }
    }

    CachedTargets snapShotInit() {
        CachedTargets cachedTargets = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] != null) {
                int n2 = this.targetList[i2].size();
                NnuId[] nnuIdArray = new NnuId[n2];
                this.targetList[i2].toArray(nnuIdArray);
                cachedTargets.targetArr[i2] = nnuIdArray;
                NnuIdManager.sort(cachedTargets.targetArr[i2]);
                continue;
            }
            cachedTargets.targetArr[i2] = null;
        }
        this.clearNodes();
        return cachedTargets;
    }

    CachedTargets snapShotAdd(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            NnuId[] nnuIdArray;
            int n2;
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] == null) {
                n2 = this.targetList[i2].size();
                nnuIdArray = new NnuId[n2];
                this.targetList[i2].toArray(nnuIdArray);
                cachedTargets2.targetArr[i2] = nnuIdArray;
                NnuIdManager.sort(cachedTargets2.targetArr[i2]);
                continue;
            }
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] != null) {
                n2 = this.targetList[i2].size();
                nnuIdArray = new NnuId[n2];
                this.targetList[i2].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[i2] = NnuIdManager.merge(cachedTargets.targetArr[i2], nnuIdArray);
                continue;
            }
            if (this.targetList[i2] != null || cachedTargets.targetArr[i2] == null) continue;
            cachedTargets2.targetArr[i2] = cachedTargets.targetArr[i2];
        }
        this.clearNodes();
        return cachedTargets2;
    }

    CachedTargets snapShotRemove(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] != null && cachedTargets.targetArr[i2] != null) {
                int n2 = this.targetList[i2].size();
                NnuId[] nnuIdArray = new NnuId[n2];
                this.targetList[i2].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[i2] = NnuIdManager.delete(cachedTargets.targetArr[i2], nnuIdArray);
                continue;
            }
            if (this.targetList[i2] == null && cachedTargets.targetArr[i2] != null) {
                cachedTargets2.targetArr[i2] = cachedTargets.targetArr[i2];
                continue;
            }
            if (this.targetList[i2] == null || cachedTargets.targetArr[i2] != null) continue;
            System.err.println("You can't remove something that isn't there");
        }
        this.clearNodes();
        return cachedTargets2;
    }

    boolean isEmpty() {
        boolean bl = true;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    void addCachedTargets(CachedTargets cachedTargets) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (cachedTargets.targetArr[i2] == null) continue;
            this.addNodeArray(cachedTargets.targetArr[i2], i2);
        }
    }

    void dump() {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.targetList[i2] == null) continue;
            System.err.println("  " + CachedTargets.typeString[i2]);
            for (int i3 = 0; i3 < this.targetList[i2].size(); ++i3) {
                System.err.println("  " + this.targetList[i2].get(i3));
            }
        }
    }
}

