/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.Context;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Pipeline;
import javax.media.j3d.TextureRetained;

class TextureCubeMapRetained
extends TextureRetained {
    static final int NUMFACES = 6;

    TextureCubeMapRetained() {
    }

    void initialize(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.numFaces = 6;
        super.initialize(n2, n3, n4, n5, n6, n7, n8);
    }

    void initImage(int n2, int n3, ImageComponent imageComponent) {
        this.checkImageSize(n2, imageComponent);
        if (this.images == null) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureRetained0"));
        }
        if (imageComponent instanceof ImageComponent3D) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap3"));
        }
        if (n3 < 0 || n3 > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        if (this.source.isLive()) {
            if (this.images[n3][n2] != null) {
                this.images[n3][n2].clearLive(this.refCount);
            }
            if (imageComponent != null) {
                ((ImageComponentRetained)imageComponent.retained).setLive(this.inBackgroundGroup, this.refCount);
            }
        }
        this.images[n3][n2] = imageComponent != null ? (ImageComponentRetained)imageComponent.retained : null;
    }

    final void setImage(int n2, int n3, ImageComponent imageComponent) {
        this.initImage(n2, n3, imageComponent);
        Object[] objectArray = new Object[]{new Integer(n2), imageComponent, new Integer(n3)};
        this.sendMessage(4, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            if (imageComponent != null && n2 < this.maxLevels) {
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponent.retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) == null) {
                        this.enable = false;
                    }
                } else if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() == null) {
                    this.enable = false;
                }
                if (!this.enable) {
                    this.sendMessage(1, Boolean.FALSE);
                }
            }
        }
    }

    void initImages(int n2, ImageComponent[] imageComponentArray) {
        if (imageComponentArray.length != this.maxLevels) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        for (int i2 = 0; i2 < imageComponentArray.length; ++i2) {
            this.initImage(i2, n2, imageComponentArray[i2]);
        }
    }

    final void setImages(int n2, ImageComponent[] imageComponentArray) {
        int n3;
        this.initImages(n2, imageComponentArray);
        ImageComponent[] imageComponentArray2 = new ImageComponent[imageComponentArray.length];
        for (n3 = 0; n3 < imageComponentArray.length; ++n3) {
            imageComponentArray2[n3] = imageComponentArray[n3];
        }
        Object[] objectArray = new Object[]{imageComponentArray2, new Integer(n2)};
        this.sendMessage(32, objectArray);
        if (this.userSpecifiedEnable) {
            this.enable = this.userSpecifiedEnable;
            for (n3 = 0; this.enable && n3 < this.maxLevels; ++n3) {
                if (imageComponentArray[n3] == null) continue;
                ImageComponentRetained imageComponentRetained = (ImageComponentRetained)imageComponentArray[n3].retained;
                if (imageComponentRetained.isByReference()) {
                    if (imageComponentRetained.getRefImage(0) != null) continue;
                    this.enable = false;
                    continue;
                }
                if (imageComponentRetained.getImageData(this.isUseAsRaster()).get() != null) continue;
                this.enable = false;
            }
            if (!this.enable) {
                this.sendMessage(1, Boolean.FALSE);
            }
        }
    }

    final ImageComponent getImage(int n2, int n3) {
        if (n3 < 0 || n3 > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        return this.images != null && this.images[n3][n2] != null ? (ImageComponent)this.images[n3][n2].source : null;
    }

    final ImageComponent[] getImages(int n2) {
        if (this.images == null) {
            return null;
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureCubeMap4"));
        }
        ImageComponent[] imageComponentArray = new ImageComponent[this.images[n2].length];
        for (int i2 = 0; i2 < this.images[n2].length; ++i2) {
            imageComponentArray[i2] = this.images[n2][i2] != null ? (ImageComponent)this.images[n2][i2].source : null;
        }
        return imageComponentArray;
    }

    void bindTexture(Context context, int n2, boolean bl) {
        Pipeline.getPipeline().bindTextureCubeMap(context, n2, bl);
    }

    void updateTextureBoundary(Context context, int n2, int n3, float f2, float f3, float f4, float f5) {
        Pipeline.getPipeline().updateTextureCubeMapBoundary(context, n2, n3, f2, f3, f4, f5);
    }

    void updateTextureFilterModes(Context context, int n2, int n3) {
        Pipeline.getPipeline().updateTextureCubeMapFilterModes(context, n2, n3);
    }

    void updateTextureSharpenFunc(Context context, int n2, float[] fArray) {
        Pipeline.getPipeline().updateTextureCubeMapSharpenFunc(context, n2, fArray);
    }

    void updateTextureFilter4Func(Context context, int n2, float[] fArray) {
        Pipeline.getPipeline().updateTextureCubeMapFilter4Func(context, n2, fArray);
    }

    void updateTextureAnisotropicFilter(Context context, float f2) {
        Pipeline.getPipeline().updateTextureCubeMapAnisotropicFilter(context, f2);
    }

    void updateTextureLodRange(Context context, int n2, int n3, float f2, float f3) {
        Pipeline.getPipeline().updateTextureCubeMapLodRange(context, n2, n3, f2, f3);
    }

    void updateTextureLodOffset(Context context, float f2, float f3, float f4) {
        Pipeline.getPipeline().updateTextureCubeMapLodOffset(context, f2, f3, f4);
    }

    void updateTextureDimensions(Canvas3D canvas3D) {
        if (this.images[0][0] != null) {
            int n2 = this.images[0][0].getImageFormatTypeIntValue(false);
            int n3 = this.images[0][0].getImageDataTypeIntValue();
            for (int i2 = 0; i2 < 6; ++i2) {
                this.updateTextureImage(canvas3D, i2, this.maxLevels, 0, this.format, n2, this.width, this.height, this.boundaryWidth, n3, null);
            }
        }
    }

    void updateTextureImage(Canvas3D canvas3D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Object object) {
        Pipeline.getPipeline().updateTextureCubeMapImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, n10, object, this.useAutoMipMapGeneration(canvas3D));
    }

    void updateTextureSubImage(Canvas3D canvas3D, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, Object object) {
        Pipeline.getPipeline().updateTextureCubeMapSubImage(canvas3D.ctx, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, object, this.useAutoMipMapGeneration(canvas3D));
    }
}

