/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupData;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnTransformChange;

class TransformGroupRetained
extends GroupRetained
implements TargetsInterface {
    Transform3D transform = new Transform3D();
    Transform3D invTransform = null;
    Transform3D normalTransform = null;
    Transform3D currentTransform = new Transform3D();
    Transform3D[][] childLocalToVworld = null;
    int[][] childLocalToVworldIndex = null;
    Transform3D[][] childTrans = null;
    int[][] childTransIndex = null;
    int localTargetThreads = 0;
    int targetThreads = 0;
    WakeupIndexedList transformChange = null;
    ArrayList childTransformLinks = new ArrayList(1);
    boolean needNormalsTransform = false;
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;
    int maxTransformLevel = -1;
    int[] transformLevels = null;
    CachedTargets[] j3dCTs = null;
    CachedTargets[] cachedTargets = null;
    TransformGroupData[] perPathData = null;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    void setTransform(Transform3D transform3D) {
        J3dMessage j3dMessage = null;
        Transform3D transform3D2 = null;
        if (this.staticTransform != null) {
            transform3D2 = new Transform3D(this.staticTransform.transform);
            transform3D2.mul(transform3D);
            this.transform.setWithLock(transform3D2);
        } else {
            transform3D2 = new Transform3D(transform3D);
            this.transform.setWithLock(transform3D);
        }
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            j3dMessage = new J3dMessage();
            j3dMessage.type = 3;
            j3dMessage.threads = this.targetThreads;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = transform3D2;
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.dirtyBoundsCache();
    }

    void getTransform(Transform3D transform3D) {
        this.transform.getWithLock(transform3D);
        if (this.staticTransform != null) {
            Transform3D transform3D2 = this.staticTransform.getInvTransform();
            transform3D.mul(transform3D2, transform3D);
        }
    }

    Transform3D getInvTransform() {
        if (this.invTransform == null) {
            this.invTransform = new Transform3D(this.transform);
            this.invTransform.invert();
        }
        return this.invTransform;
    }

    Transform3D getNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D(this.transform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
        return this.normalTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setNodeData(SetLiveState setLiveState) {
        int n2;
        super.setNodeData(setLiveState);
        this.childTrans = new Transform3D[setLiveState.currentTransforms.length][2];
        this.childTransIndex = new int[setLiveState.currentTransforms.length][2];
        for (n2 = 0; n2 < setLiveState.currentTransforms.length; ++n2) {
            this.childTrans[n2][0] = new Transform3D();
            this.childTrans[n2][0].mul(setLiveState.currentTransforms[n2][setLiveState.currentTransformsIndex[n2][1]], this.currentTransform);
            this.childTrans[n2][1] = new Transform3D(this.childTrans[n2][0]);
            this.childTransIndex[n2][0] = 0;
            this.childTransIndex[n2][1] = 0;
        }
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] + 1;
            this.maxTransformLevel = setLiveState.transformLevels[0];
        } else {
            for (n2 = 0; n2 < setLiveState.keys.length; ++n2) {
                int n3 = n2;
                setLiveState.transformLevels[n3] = setLiveState.transformLevels[n3] + 1;
                if (setLiveState.transformLevels[n2] <= this.maxTransformLevel) continue;
                this.maxTransformLevel = setLiveState.transformLevels[n2];
            }
        }
        if (!this.inSharedGroup) {
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[1][];
                this.childLocalToVworldIndex = new int[1][];
                this.transformLevels = new int[1];
                this.cachedTargets = new CachedTargets[1];
                this.perPathData = new TransformGroupData[1];
            }
            this.childLocalToVworld[0] = this.childTrans[0];
            this.childLocalToVworldIndex[0] = this.childTransIndex[0];
            this.transformLevels[0] = setLiveState.transformLevels[0];
            this.setAuxData(setLiveState, 0, 0);
        } else {
            int n4;
            int n5;
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[setLiveState.keys.length][];
                this.childLocalToVworldIndex = new int[setLiveState.keys.length][];
                this.transformLevels = new int[setLiveState.keys.length];
                this.cachedTargets = new CachedTargets[setLiveState.keys.length];
                this.perPathData = new TransformGroupData[setLiveState.keys.length];
                n5 = 0;
            } else {
                n5 = this.localToVworld.length - setLiveState.keys.length;
                n4 = this.localToVworld.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n4][];
                int[][] nArrayArray = new int[n4][];
                int[] nArray = new int[n4];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n4];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n4];
                System.arraycopy(this.childLocalToVworld, 0, transform3DArrayArray, 0, this.childLocalToVworld.length);
                System.arraycopy(this.childLocalToVworldIndex, 0, nArrayArray, 0, this.childLocalToVworldIndex.length);
                System.arraycopy(this.transformLevels, 0, nArray, 0, this.transformLevels.length);
                System.arraycopy(this.cachedTargets, 0, cachedTargetsArray, 0, this.cachedTargets.length);
                System.arraycopy(this.perPathData, 0, transformGroupDataArray, 0, this.perPathData.length);
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            n2 = n5;
            int n6 = 0;
            while (n2 < this.localToVworld.length) {
                n4 = setLiveState.keys[n6].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n4 < 0) {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                    break;
                }
                if (n4 >= n2) {
                    this.childLocalToVworld[n2] = this.childTrans[n6];
                    this.childLocalToVworldIndex[n2] = this.childTransIndex[n6];
                    this.transformLevels[n2] = setLiveState.transformLevels[n6];
                } else {
                    int n7 = n4 + 1;
                    int n8 = n2 - n4;
                    System.arraycopy(this.childLocalToVworld, n4, this.childLocalToVworld, n7, n8);
                    System.arraycopy(this.childLocalToVworldIndex, n4, this.childLocalToVworldIndex, n7, n8);
                    System.arraycopy(this.transformLevels, n4, this.transformLevels, n7, n8);
                    System.arraycopy(this.cachedTargets, n4, this.cachedTargets, n7, n8);
                    System.arraycopy(this.perPathData, n4, this.perPathData, n7, n8);
                    this.childLocalToVworld[n4] = this.childTrans[n6];
                    this.childLocalToVworldIndex[n4] = this.childTransIndex[n6];
                    this.transformLevels[n4] = setLiveState.transformLevels[n6];
                }
                this.setAuxData(setLiveState, n6, n4);
                ++n2;
                ++n6;
            }
        }
        if (setLiveState.childTransformLinks != null) {
            ArrayList arrayList = setLiveState.childTransformLinks;
            synchronized (arrayList) {
                if (!this.inSharedGroup || !setLiveState.childTransformLinks.contains(this)) {
                    setLiveState.childTransformLinks.add(this);
                }
            }
        }
        setLiveState.localToVworld = this.childLocalToVworld;
        setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        setLiveState.currentTransforms = this.childTrans;
        setLiveState.currentTransformsIndex = this.childTransIndex;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.parentTransformLink = this;
    }

    void setAuxData(SetLiveState setLiveState, int n2, int n3) {
        super.setAuxData(setLiveState, n2, n3);
        this.perPathData[n3] = new TransformGroupData();
        this.perPathData[n3].switchState = (SwitchState)setLiveState.switchStates.get(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.remove(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.add(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConditions() {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            WakeupOnTransformChange[] wakeupOnTransformChangeArray = (WakeupOnTransformChange[])this.transformChange.toArray(false);
            for (int i2 = this.transformChange.size() - 1; i2 >= 0; --i2) {
                wakeupOnTransformChangeArray[i2].setTriggered();
            }
        }
    }

    boolean isStatic() {
        return super.isStatic() && !this.source.getCapability(17) && !this.source.getCapability(18);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        this.transform.mul(transformGroupRetained.transform, this.transform);
    }

    void traverse(boolean bl, int n2) {
        System.err.println();
        for (int i2 = 0; i2 < n2; ++i2) {
            System.err.print(".");
        }
        System.err.print(this);
        if (this.isStatic()) {
            System.err.print(" (s)");
        } else {
            System.err.print(" (w)");
        }
        System.err.println();
        System.err.println(this.transform.toString());
        super.traverse(true, n2);
    }

    void compile(CompileState compileState) {
        boolean bl = compileState.keepTG;
        compileState.keepTG = false;
        boolean bl2 = compileState.needNormalsTransform;
        compileState.needNormalsTransform = false;
        super.compile(compileState);
        if (compileState.keepTG) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 0) {
            compileState.staticTransform = null;
            compileState.parentGroup = null;
            super.merge(compileState);
        } else {
            this.mergeFlag = 1;
        }
        compileState.keepTG = bl;
        this.needNormalsTransform = compileState.needNormalsTransform;
        compileState.needNormalsTransform = bl2;
    }

    void merge(CompileState compileState) {
        Transform3D transform3D;
        if (compileState.staticTransform != null) {
            this.staticTransform = compileState.staticTransform;
            this.mergeTransform(compileState.staticTransform);
        }
        if (this.mergeFlag == 1 && this.needNormalsTransform && !(transform3D = this.getNormalTransform()).isCongruent()) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 1) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = this;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
        this.mergeFlag = 2;
    }

    void setLive(SetLiveState setLiveState) {
        int n2;
        Transform3D transform3D = null;
        Targets[] targetsArray = null;
        Targets[] targetsArray2 = null;
        int n3 = 0;
        n3 = setLiveState.traverseFlags;
        targetsArray2 = setLiveState.transformTargets;
        int n4 = setLiveState.inSharedGroup ? setLiveState.keys.length : 1;
        targetsArray = new Targets[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            targetsArray[n2] = new Targets();
        }
        setLiveState.transformTargets = targetsArray;
        setLiveState.traverseFlags = 0;
        this.inSharedGroup = setLiveState.inSharedGroup;
        transform3D = new Transform3D();
        this.transform.getWithLock(transform3D);
        this.currentTransform.set(transform3D);
        ArrayList arrayList = setLiveState.childTransformLinks;
        GroupRetained groupRetained = setLiveState.parentTransformLink;
        Transform3D[][] transform3DArray = setLiveState.currentTransforms;
        int[][] nArray = setLiveState.currentTransformsIndex;
        super.doSetLive(setLiveState);
        if (!this.inSharedGroup) {
            if (setLiveState.transformTargets[0] != null) {
                this.cachedTargets[0] = setLiveState.transformTargets[0].snapShotInit();
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(this, 6);
            }
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                if (setLiveState.transformTargets[n2] != null) {
                    int n5 = setLiveState.keys[n2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    this.cachedTargets[n5] = setLiveState.transformTargets[n2].snapShotInit();
                }
                if (setLiveState.switchTargets == null || setLiveState.switchTargets[n2] == null) continue;
                setLiveState.switchTargets[n2].addNode(this, 6);
            }
        }
        this.j3dCTs = new CachedTargets[this.cachedTargets.length];
        this.copyCachedTargets(0, this.j3dCTs);
        this.computeTargetThreads(0, this.cachedTargets);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.currentTransforms = transform3DArray;
        setLiveState.currentTransformsIndex = nArray;
        setLiveState.childTransformLinks = arrayList;
        setLiveState.parentTransformLink = groupRetained;
        setLiveState.transformTargets = targetsArray2;
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] - 1;
        } else {
            n2 = 0;
            while (n2 < setLiveState.keys.length) {
                int n6 = n2++;
                setLiveState.transformLevels[n6] = setLiveState.transformLevels[n6] - 1;
            }
        }
        if ((setLiveState.traverseFlags & 1) != 0) {
            this.aboveAViewPlatform = true;
        }
        setLiveState.traverseFlags |= n3;
        if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNodeData(SetLiveState setLiveState) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.refCount <= 0) {
                this.childLocalToVworld = null;
                this.childLocalToVworldIndex = null;
                this.transformLevels = null;
                this.cachedTargets = null;
                this.perPathData = null;
                this.targetThreads = 0;
                if (this.parentTransformLink != null) {
                    ArrayList arrayList = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                    ArrayList arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.remove(this);
                    }
                }
                this.aboveAViewPlatform = false;
            } else {
                int n2;
                int n3 = this.localToVworld.length - setLiveState.keys.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n3][];
                int[][] nArrayArray = new int[n3][];
                int[] nArray = new int[n3];
                ArrayList[] arrayListArray = new ArrayList[n3];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n3];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n3];
                int[] nArray2 = new int[setLiveState.keys.length];
                int n4 = 0;
                int n5 = 0;
                boolean bl = false;
                for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                    int n6;
                    nArray2[i2] = n6 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    if (n6 >= 0) {
                        bl = true;
                        if (n6 == n4) {
                            ++n4;
                            continue;
                        }
                        n2 = n6 - n4;
                        System.arraycopy(this.childLocalToVworld, n4, transform3DArrayArray, n5, n2);
                        System.arraycopy(this.childLocalToVworldIndex, n4, nArrayArray, n5, n2);
                        System.arraycopy(this.transformLevels, n4, nArray, n5, n2);
                        System.arraycopy(this.cachedTargets, n4, cachedTargetsArray, n5, n2);
                        System.arraycopy(this.perPathData, n4, transformGroupDataArray, n5, n2);
                        n4 = n6 + 1;
                        n5 += n2;
                        continue;
                    }
                    bl = false;
                    MasterControl.getCoreLogger().severe("TG.removeNodeData-Can't find matching hashKey.");
                }
                if (bl && n4 < this.localToVworld.length) {
                    n2 = this.localToVworld.length - n4;
                    System.arraycopy(this.childLocalToVworld, n4, transform3DArrayArray, n5, n2);
                    System.arraycopy(this.childLocalToVworldIndex, n4, nArrayArray, n5, n2);
                    System.arraycopy(this.transformLevels, n4, nArray, n5, n2);
                    System.arraycopy(this.cachedTargets, n4, cachedTargetsArray, n5, n2);
                    System.arraycopy(this.perPathData, n4, transformGroupDataArray, n5, n2);
                }
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            super.removeNodeData(setLiveState);
            setLiveState.localToVworld = this.childLocalToVworld;
            setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLive(SetLiveState setLiveState) {
        Targets[] targetsArray = null;
        targetsArray = setLiveState.transformTargets;
        setLiveState.transformTargets = null;
        super.clearLive(setLiveState);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.transformTargets = targetsArray;
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                int n2;
                if (this.transformLevels != null) {
                    this.maxTransformLevel = this.transformLevels[0];
                    for (n2 = 1; n2 < this.transformLevels.length; ++n2) {
                        if (this.transformLevels[n2] <= this.maxTransformLevel) continue;
                        this.maxTransformLevel = this.transformLevels[n2];
                    }
                } else {
                    this.maxTransformLevel = -1;
                }
                if (setLiveState.switchTargets != null) {
                    for (n2 = 0; n2 < setLiveState.switchTargets.length; ++n2) {
                        if (setLiveState.switchTargets[n2] == null) continue;
                        setLiveState.switchTargets[n2].addNode(this, 6);
                    }
                }
            } else {
                this.maxTransformLevel = -1;
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                    setLiveState.switchTargets[0].addNode(this, 6);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeCombineBounds(Bounds bounds) {
        if (this.cachedBounds != null && this.boundsAutoCompute) {
            Bounds bounds2 = (Bounds)this.cachedBounds.clone();
            Transform3D transform3D = this.transform;
            synchronized (transform3D) {
                bounds2.transform(this.transform);
            }
            bounds.combine(bounds2);
            return;
        }
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(-1.0);
        if (this.boundsAutoCompute) {
            for (int i2 = this.children.size() - 1; i2 >= 0; --i2) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
                if (nodeRetained == null) continue;
                nodeRetained.computeCombineBounds(boundingSphere);
            }
            if (VirtualUniverse.mc.cacheAutoComputedBounds) {
                this.cachedBounds = (Bounds)boundingSphere.clone();
            }
        } else {
            Bounds bounds3 = this.localBounds;
            synchronized (bounds3) {
                boundingSphere.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            boundingSphere.transform(this.transform);
        }
        bounds.combine(boundingSphere);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                if (this.localToVworldKeys != null) {
                    for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                        if (!this.perPathData[i2].markedDirty) continue;
                        this.updateChildLocalToVworld(this.localToVworldKeys[i2], i2, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            } else if (this.perPathData != null && this.perPathData[0].markedDirty) {
                this.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(HashKey hashKey, int n2, ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[n2].markedDirty = false;
                if (this.perPathData[n2].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(n2);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(n2);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    arrayList2.add(hashKey);
                    CachedTargets cachedTargets = this.j3dCTs[n2];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[n2].switchDirty = true;
                }
                ArrayList arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    for (int i2 = 0; i2 < this.childTransformLinks.size(); ++i2) {
                        Object e2 = this.childTransformLinks.get(i2);
                        if (e2 instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e2;
                            transformGroupRetained2.updateChildLocalToVworld(transformGroupRetained2.localToVworldKeys[n2], n2, arrayList, arrayList2, updateTargets, arrayList3);
                            continue;
                        }
                        LinkRetained linkRetained = (LinkRetained)e2;
                        this.currentKey.set(this.localToVworldKeys[n2]);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup == null || linkRetained.sharedGroup.localToVworldKeys == null) continue;
                        int n3 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                        if (n3 < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (n3 >= linkRetained.sharedGroup.localToVworldKeys.length) continue;
                        linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n3], n3, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[0].markedDirty = false;
                if (this.perPathData[0].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(0);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(0);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    CachedTargets cachedTargets = this.j3dCTs[0];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[0].switchDirty = true;
                }
                ArrayList arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    for (int i2 = 0; i2 < this.childTransformLinks.size(); ++i2) {
                        Object e2 = this.childTransformLinks.get(i2);
                        if (e2 instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)e2;
                            transformGroupRetained2.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
                            continue;
                        }
                        LinkRetained linkRetained = (LinkRetained)e2;
                        this.currentKey.reset();
                        this.currentKey.append(this.locale.nodeId);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup == null || linkRetained.sharedGroup.localToVworldKeys == null) continue;
                        int n2 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                        if (n2 < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (n2 >= linkRetained.sharedGroup.localToVworldKeys.length) continue;
                        linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n2], n2, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            }
        }
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentChildLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentChildLocalToVworld(hashKey));
        }
    }

    Transform3D getUpdateChildLocalToVworld(int n2) {
        int n3 = this.childLocalToVworldIndex[n2][1];
        if (n3 == this.childLocalToVworldIndex[n2][0]) {
            this.childLocalToVworldIndex[n2][1] = n3 ^= 1;
        }
        return this.childLocalToVworld[n2][n3];
    }

    Transform3D getCurrentChildLocalToVworld() {
        return this.getCurrentChildLocalToVworld(0);
    }

    Transform3D getCurrentChildLocalToVworld(int n2) {
        return this.childLocalToVworld[n2][this.childLocalToVworldIndex[n2][1]];
    }

    Transform3D getCurrentChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][1]];
        }
        int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n2 >= 0) {
            return this.childLocalToVworld[n2][this.childLocalToVworldIndex[n2][1]];
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][0]];
        }
        int n2 = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n2 >= 0) {
            return this.childLocalToVworld[n2][this.childLocalToVworldIndex[n2][0]];
        }
        return new Transform3D();
    }

    public int getTargetThreads(int n2) {
        if (n2 == 0) {
            return this.targetThreads;
        }
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    public CachedTargets getCachedTargets(int n2, int n3, int n4) {
        if (n2 == 0) {
            return this.cachedTargets[n3];
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    TargetsInterface getClosestTargetsInterface(int n2) {
        return n2 == 0 ? this : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    public void computeTargetThreads(int n2, CachedTargets[] cachedTargetsArray) {
        if (n2 == 0) {
            int n3;
            this.localTargetThreads = 8192;
            for (n3 = 0; n3 < cachedTargetsArray.length; ++n3) {
                if (cachedTargetsArray[n3] == null) continue;
                this.localTargetThreads |= cachedTargetsArray[n3].computeTargetThreads();
            }
            this.targetThreads = this.localTargetThreads;
            n3 = this.childTransformLinks.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                NodeRetained nodeRetained = (NodeRetained)this.childTransformLinks.get(i2);
                TargetsInterface targetsInterface = nodeRetained.nodeType == 9 ? ((LinkRetained)nodeRetained).sharedGroup : (TargetsInterface)((Object)nodeRetained);
                if (targetsInterface == null) continue;
                this.targetThreads |= targetsInterface.getTargetThreads(0);
            }
        } else {
            System.err.println("computeTargetsThreads: wrong arguments");
        }
    }

    public void updateTargetThreads(int n2, CachedTargets[] cachedTargetsArray) {
        if (n2 == 0) {
            this.computeTargetThreads(n2, cachedTargetsArray);
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("updateTargetThreads: wrong arguments");
        }
    }

    public void propagateTargetThreads(int n2, int n3) {
        if (n2 == 0) {
            this.targetThreads |= n3;
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("propagateTargetThreads: wrong arguments");
        }
    }

    public void updateCachedTargets(int n2, CachedTargets[] cachedTargetsArray) {
        if (n2 == 0) {
            this.j3dCTs = cachedTargetsArray;
        } else {
            System.err.println("updateCachedTargets: wrong arguments");
        }
    }

    public void copyCachedTargets(int n2, CachedTargets[] cachedTargetsArray) {
        if (n2 == 0) {
            for (CachedTargets cachedTargetsArray[var4_4] : this.cachedTargets) {
            }
        } else {
            System.err.println("copyCachedTargets: wrong arguments");
        }
    }

    public void resetCachedTargets(int n2, CachedTargets[] cachedTargetsArray, int n3) {
        if (n2 == 0) {
            this.cachedTargets = cachedTargetsArray;
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    public ArrayList getTargetsData(int n2, int n3) {
        return null;
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n2, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        setLiveState.currentTransforms = this.childLocalToVworld;
        setLiveState.currentTransformsIndex = this.childLocalToVworldIndex;
        setLiveState.parentTransformLink = this;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.localToVworld = setLiveState.currentTransforms;
        setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
        nodeRetained.setLive(setLiveState);
    }
}

