/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Context;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class TransparencyAttributesRetained
extends NodeComponentRetained {
    static final int MODE_CHANGED = 1;
    static final int VALUE_CHANGED = 2;
    static final int SRC_BLEND_FUNCTION_CHANGED = 4;
    static final int DST_BLEND_FUNCTION_CHANGED = 8;
    int isDirty = 65535;
    int transparencyMode = 4;
    float transparency = 0.0f;
    int srcBlendFunction = 2;
    int dstBlendFunction = 3;

    TransparencyAttributesRetained() {
    }

    final void initTransparencyMode(int n2) {
        this.transparencyMode = n2;
    }

    final void setTransparencyMode(int n2) {
        this.initTransparencyMode(n2);
        this.sendMessage(1, new Integer(n2));
    }

    final int getTransparencyMode() {
        return this.transparencyMode;
    }

    final void initTransparency(float f2) {
        this.transparency = f2;
    }

    final void setTransparency(float f2) {
        this.initTransparency(f2);
        this.sendMessage(2, new Float(f2));
    }

    final float getTransparency() {
        return this.transparency;
    }

    final void initSrcBlendFunction(int n2) {
        this.srcBlendFunction = n2;
    }

    final void setSrcBlendFunction(int n2) {
        this.initSrcBlendFunction(n2);
        this.sendMessage(4, new Integer(n2));
    }

    final int getSrcBlendFunction() {
        return this.srcBlendFunction;
    }

    final void initDstBlendFunction(int n2) {
        this.dstBlendFunction = n2;
    }

    final void setDstBlendFunction(int n2) {
        this.initDstBlendFunction(n2);
        this.sendMessage(8, new Integer(n2));
    }

    final int getDstBlendFunction() {
        return this.dstBlendFunction;
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TransparencyAttributesRetained transparencyAttributesRetained = new TransparencyAttributesRetained();
                transparencyAttributesRetained.source = this.source;
                transparencyAttributesRetained.set(this);
                this.mirror = transparencyAttributesRetained;
            }
        } else {
            ((TransparencyAttributesRetained)this.mirror).set(this);
        }
    }

    void updateNative(Context context, float f2, int n2, int n3, boolean bl, boolean bl2) {
        Pipeline.getPipeline().updateTransparencyAttributes(context, f2, n2, n3, bl, bl2, this.transparencyMode, this.srcBlendFunction, this.dstBlendFunction);
    }

    synchronized void initMirrorObject() {
        ((TransparencyAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int n2, Object object) {
        TransparencyAttributesRetained transparencyAttributesRetained = (TransparencyAttributesRetained)this.mirror;
        if ((n2 & 1) != 0) {
            transparencyAttributesRetained.transparencyMode = (Integer)object;
        } else if ((n2 & 2) != 0) {
            transparencyAttributesRetained.transparency = ((Float)object).floatValue();
        } else if ((n2 & 4) != 0) {
            transparencyAttributesRetained.srcBlendFunction = (Integer)object;
        } else if ((n2 & 8) != 0) {
            transparencyAttributesRetained.dstBlendFunction = (Integer)object;
        }
    }

    boolean equivalent(TransparencyAttributesRetained transparencyAttributesRetained) {
        return transparencyAttributesRetained != null && transparencyAttributesRetained.transparencyMode == this.transparencyMode && transparencyAttributesRetained.transparency == this.transparency && transparencyAttributesRetained.srcBlendFunction == this.srcBlendFunction && transparencyAttributesRetained.dstBlendFunction == this.dstBlendFunction;
    }

    protected void set(TransparencyAttributesRetained transparencyAttributesRetained) {
        super.set(transparencyAttributesRetained);
        this.transparencyMode = transparencyAttributesRetained.transparencyMode;
        this.transparency = transparencyAttributesRetained.transparency;
        this.srcBlendFunction = transparencyAttributesRetained.srcBlendFunction;
        this.dstBlendFunction = transparencyAttributesRetained.dstBlendFunction;
    }

    final void sendMessage(int n2, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 12;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 12;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(i2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n2);
            j3dMessage.args[2] = object;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i2);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void handleFrequencyChange(int n2) {
        if (n2 == 1 || n2 == 3 || n2 == 5) {
            this.setFrequencyChangeMask(n2, 1);
        }
    }
}

