/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnElapsedFrames;

public class TransparencyInterpolator
extends Interpolator {
    TransparencyAttributes target;
    float minimumTransparency;
    float maximumTransparency;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    TransparencyInterpolator() {
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes transparencyAttributes) {
        super(alpha);
        this.target = transparencyAttributes;
        this.minimumTransparency = 0.0f;
        this.maximumTransparency = 1.0f;
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes transparencyAttributes, float f2, float f3) {
        super(alpha);
        this.target = transparencyAttributes;
        this.minimumTransparency = f2;
        this.maximumTransparency = f3;
    }

    public void setMinimumTransparency(float f2) {
        this.minimumTransparency = f2;
    }

    public float getMinimumTransparency() {
        return this.minimumTransparency;
    }

    public void setMaximumTransparency(float f2) {
        this.maximumTransparency = f2;
    }

    public float getMaximumTransparency() {
        return this.maximumTransparency;
    }

    public void setTarget(TransparencyAttributes transparencyAttributes) {
        this.target = transparencyAttributes;
    }

    public TransparencyAttributes getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        WakeupCriterion wakeupCriterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float f2 = this.alpha.value();
            if (f2 != this.prevAlphaValue) {
                float f3 = (float)((1.0 - (double)f2) * (double)this.minimumTransparency + (double)(f2 * this.maximumTransparency));
                this.target.setTransparency(f3);
                this.prevAlphaValue = f2;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                wakeupCriterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(wakeupCriterion);
    }

    public Node cloneNode(boolean bl) {
        TransparencyInterpolator transparencyInterpolator = new TransparencyInterpolator();
        transparencyInterpolator.duplicateNode(this, bl);
        return transparencyInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        TransparencyInterpolator transparencyInterpolator = (TransparencyInterpolator)node;
        this.setMinimumTransparency(transparencyInterpolator.getMinimumTransparency());
        this.setMaximumTransparency(transparencyInterpolator.getMaximumTransparency());
        this.setTarget(transparencyInterpolator.getTarget());
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransparencyAttributes transparencyAttributes = this.getTarget();
        if (transparencyAttributes != null) {
            this.setTarget((TransparencyAttributes)nodeReferenceTable.getNewObjectReference(transparencyAttributes));
        }
    }
}

