/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray;

import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.jdesktop.jdic.tray.internal.ServiceManager;
import org.jdesktop.jdic.tray.internal.TrayIconService;

public class TrayIcon {
    TrayIconService tis = (TrayIconService)ServiceManager.getService("TrayIconService");
    public static final int INFO_MESSAGE_TYPE = 0;
    public static final int ERROR_MESSAGE_TYPE = 1;
    public static final int WARNING_MESSAGE_TYPE = 2;
    public static final int NONE_MESSAGE_TYPE = 3;

    public TrayIcon(Icon icon) {
        this(icon, null, null);
    }

    public TrayIcon(Icon icon, String string) {
        this(icon, string, null);
    }

    public TrayIcon(Icon icon, String string, JPopupMenu jPopupMenu) {
        this.setIcon(icon);
        this.setCaption(string);
        this.setPopupMenu(jPopupMenu);
    }

    public void setIcon(Icon icon) {
        if (this.tis != null) {
            this.tis.setIcon(icon);
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        if (this.tis != null) {
            this.tis.setPopupMenu(jPopupMenu);
        }
    }

    public void setToolTip(String string) {
        this.setCaption(string);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.tis != null) {
            this.tis.addActionListener(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.tis != null) {
            this.tis.removeActionListener(actionListener);
        }
    }

    public void setCaption(String string) {
        if (this.tis != null) {
            this.tis.setCaption(string);
        }
    }

    public void setIconAutoSize(boolean bl) {
        if (this.tis != null) {
            this.tis.setIconAutoSize(bl);
        }
    }

    TrayIconService getTrayIconService() {
        return this.tis;
    }

    public Point getLocationOnScreen() {
        Point point = null;
        if (this.tis != null) {
            point = this.tis.getLocationOnScreen();
        }
        return point;
    }

    public void displayMessage(String string, String string2, int n2) throws NullPointerException {
        if (string == null && string2 == null) {
            throw new NullPointerException("Both caption and text are null.");
        }
        if (this.tis != null) {
            this.tis.showBalloonMessage(string, string2, n2);
        }
    }

    public void addBalloonActionListener(ActionListener actionListener) {
        if (this.tis != null) {
            this.tis.addBalloonActionListener(actionListener);
        }
    }

    public void removeBalloonActionListener(ActionListener actionListener) {
        if (this.tis != null) {
            this.tis.removeBalloonActionListener(actionListener);
        }
    }
}

