/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.factories.GreekAlphabetFactory;

public class GreekList
extends List {
    public GreekList() {
        super(true);
        this.setGreekFont();
    }

    public GreekList(int symbolIndent) {
        super(true, symbolIndent);
        this.setGreekFont();
    }

    public GreekList(boolean greeklower, int symbolIndent) {
        super(true, symbolIndent);
        this.lowercase = greeklower;
        this.setGreekFont();
    }

    protected void setGreekFont() {
        float fontsize = this.symbol.getFont().getSize();
        this.symbol.setFont(FontFactory.getFont("Symbol", fontsize, 0));
    }

    public boolean add(Element o2) {
        if (o2 instanceof ListItem) {
            ListItem item = (ListItem)o2;
            Chunk chunk = new Chunk(this.preSymbol, this.symbol.getFont());
            chunk.setAttributes(this.symbol.getAttributes());
            chunk.append(GreekAlphabetFactory.getString(this.first + this.list.size(), this.lowercase));
            chunk.append(this.postSymbol);
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent, this.autoindent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else if (o2 instanceof List) {
            List nested = (List)o2;
            nested.setIndentationLeft(nested.getIndentationLeft() + this.symbolIndent);
            --this.first;
            return this.list.add(nested);
        }
        return false;
    }
}

