/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class ContourCompositeContext
implements CompositeContext {
    private int offset;

    public ContourCompositeContext(int offset, ColorModel srcColorModel, ColorModel dstColorModel) {
        this.offset = offset;
    }

    public void dispose() {
    }

    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int x = src.getMinX();
        int y = src.getMinY();
        int w = src.getWidth();
        int h2 = src.getHeight();
        int[] srcPix = null;
        int[] srcPix2 = null;
        int[] dstInPix = null;
        int[] dstOutPix = new int[w * 4];
        for (int i2 = 0; i2 < h2; ++i2) {
            srcPix = src.getPixels(x, y, w, 1, srcPix);
            dstInPix = dstIn.getPixels(x, y, w, 1, dstInPix);
            int lastAlpha = 0;
            int k2 = 0;
            for (int j2 = 0; j2 < w; ++j2) {
                int alphaAbove;
                int alpha = srcPix[k2 + 3];
                int n2 = alphaAbove = i2 != 0 ? srcPix2[k2 + 3] : alpha;
                if (i2 != 0 && j2 != 0 && ((alpha ^ lastAlpha) & 0x80) != 0 || ((alpha ^ alphaAbove) & 0x80) != 0) {
                    if ((this.offset + i2 + j2) % 10 > 4) {
                        dstOutPix[k2] = 0;
                        dstOutPix[k2 + 1] = 0;
                        dstOutPix[k2 + 2] = 0;
                    } else {
                        dstOutPix[k2] = 255;
                        dstOutPix[k2 + 1] = 255;
                        dstOutPix[k2 + 2] = 127;
                    }
                    dstOutPix[k2 + 3] = 255;
                } else {
                    dstOutPix[k2] = dstInPix[k2];
                    dstOutPix[k2 + 1] = dstInPix[k2 + 1];
                    dstOutPix[k2 + 2] = dstInPix[k2 + 2];
                    dstOutPix[k2] = 255;
                    dstOutPix[k2 + 1] = 0;
                    dstOutPix[k2 + 2] = 0;
                    dstOutPix[k2 + 3] = 0;
                }
                lastAlpha = alpha;
                k2 += 4;
            }
            dstOut.setPixels(x, y, w, 1, dstOutPix);
            int[] t = srcPix;
            srcPix = srcPix2;
            srcPix2 = t;
            ++y;
        }
    }
}

