/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Histogram;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;
import java.io.Serializable;

public class EqualizeFilter
extends WholeImageFilter
implements Serializable {
    protected int[][] lut;

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int i2;
        Histogram histogram = new Histogram(inPixels, width, height, 0, width);
        if (histogram.getNumSamples() > 0) {
            float scale = 255.0f / (float)histogram.getNumSamples();
            this.lut = new int[3][256];
            for (i2 = 0; i2 < 3; ++i2) {
                int j2;
                this.lut[i2][0] = histogram.getFrequency(i2, 0);
                for (j2 = 1; j2 < 256; ++j2) {
                    this.lut[i2][j2] = this.lut[i2][j2 - 1] + histogram.getFrequency(i2, j2);
                }
                for (j2 = 0; j2 < 256; ++j2) {
                    this.lut[i2][j2] = Math.round((float)this.lut[i2][j2] * scale);
                }
            }
        } else {
            this.lut = null;
        }
        i2 = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                inPixels[i2] = this.filterRGB(x, y, inPixels[i2]);
                ++i2;
            }
        }
        this.lut = null;
        return inPixels;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (this.lut != null) {
            int a2 = rgb & 0xFF000000;
            int r = this.lut[0][rgb >> 16 & 0xFF];
            int g2 = this.lut[1][rgb >> 8 & 0xFF];
            int b2 = this.lut[2][rgb & 0xFF];
            return a2 | r << 16 | g2 << 8 | b2;
        }
        return rgb;
    }

    public String toString() {
        return "Colors/Equalize";
    }
}

