/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class MirrorFilter
extends AbstractBufferedImageOp {
    private float opacity = 1.0f;
    private float centreY = 0.5f;
    private float distance;
    private float angle;
    private float rotation;
    private float gap;

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setGap(float gap) {
        this.gap = gap;
    }

    public float getGap() {
        return this.gap;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setCentreY(float centreY) {
        this.centreY = centreY;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        BufferedImage tsrc = src;
        int width = src.getWidth();
        int height = src.getHeight();
        int h2 = (int)(this.centreY * (float)height);
        int d2 = (int)(this.gap * (float)height);
        Graphics2D g2 = dst.createGraphics();
        Shape clip = g2.getClip();
        g2.clipRect(0, 0, width, h2);
        g2.drawRenderedImage(src, null);
        g2.setClip(clip);
        g2.clipRect(0, h2 + d2, width, height - h2 - d2);
        g2.translate(0, 2 * h2 + d2);
        g2.scale(1.0, -1.0);
        g2.drawRenderedImage(src, null);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(1.0f, 0.0f, 0.0f, 0.0f), 0.0f, h2, new Color(0.0f, 1.0f, 0.0f, this.opacity)));
        g2.setComposite(AlphaComposite.getInstance(6));
        g2.fillRect(0, 0, width, h2);
        g2.setClip(clip);
        g2.dispose();
        return dst;
    }

    public String toString() {
        return "Effects/Mirror...";
    }
}

