/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PointFilter;
import java.io.Serializable;
import java.util.Random;

public class SparkleFilter
extends PointFilter
implements Serializable {
    static final long serialVersionUID = 1692413049411710802L;
    private int rays = 50;
    private int radius = 25;
    private int amount = 50;
    private int color = -1;
    private int randomness = 25;
    private int width;
    private int height;
    private int centreX;
    private int centreY;
    private long seed = 371L;
    private float[] rayLengths;
    private Random randomNumbers = new Random();

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public void setRandomness(int randomness) {
        this.randomness = randomness;
    }

    public int getRandomness() {
        return this.randomness;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setRays(int rays) {
        this.rays = rays;
    }

    public int getRays() {
        return this.rays;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.centreX = width / 2;
        this.centreY = height / 2;
        super.setDimensions(width, height);
        this.randomNumbers.setSeed(this.seed);
        this.rayLengths = new float[this.rays];
        for (int i2 = 0; i2 < this.rays; ++i2) {
            this.rayLengths[i2] = (float)this.radius + (float)this.randomness / 100.0f * (float)this.radius * (float)this.randomNumbers.nextGaussian();
        }
    }

    public int filterRGB(int x, int y, int rgb) {
        float dx = x - this.centreX;
        float dy = y - this.centreY;
        float distance = dx * dx + dy * dy;
        float angle = (float)Math.atan2(dy, dx);
        float d2 = (angle + (float)Math.PI) / ((float)Math.PI * 2) * (float)this.rays;
        int i2 = (int)d2;
        float f2 = d2 - (float)i2;
        if (this.radius != 0) {
            float length = ImageMath.lerp(f2, this.rayLengths[i2 % this.rays], this.rayLengths[(i2 + 1) % this.rays]);
            float g2 = length * length / (distance + 1.0E-4f);
            g2 = (float)Math.pow(g2, (double)(100 - this.amount) / 50.0);
            f2 -= 0.5f;
            f2 = 1.0f - f2 * f2;
            f2 *= g2;
        }
        f2 = ImageMath.clamp(f2, 0.0f, 1.0f);
        return ImageMath.mixColors(f2, rgb, this.color);
    }

    public String toString() {
        return "Stylize/Sparkle...";
    }
}

