/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BaseButtonUI
extends BasicButtonUI {
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();
    protected static Color[] defaultColors = null;

    public static ComponentUI createUI(JComponent c2) {
        return new BaseButtonUI();
    }

    protected void installKeyboardActions(AbstractButton b2) {
        super.installKeyboardActions(b2);
        InputMap im = (InputMap)UIManager.get("Button.focusInputMap");
        im.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        im.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        Color[] cArr = AbstractLookAndFeel.getTheme().getButtonColors();
        defaultColors = new Color[cArr.length];
        for (int i2 = 0; i2 < cArr.length; ++i2) {
            BaseButtonUI.defaultColors[i2] = ColorHelper.brighter(cArr[i2], 20.0);
        }
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setOpaque(false);
        b2.setRolloverEnabled(true);
    }

    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        b2.setOpaque(true);
        b2.setRolloverEnabled(false);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BaseButtonListener(b2);
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        ButtonModel model = b2.getModel();
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (b2.isEnabled()) {
            Color background = b2.getBackground();
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    colors = AbstractLookAndFeel.getTheme().getPressedColors();
                } else if (b2.isRolloverEnabled() && model.isRollover()) {
                    colors = AbstractLookAndFeel.getTheme().getRolloverColors();
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus()) {
                    colors = AbstractLookAndFeel.getTheme().getFocusColors();
                } else if (JTattooUtilities.isFrameActive(b2) && b2.getRootPane() != null && b2.equals(b2.getRootPane().getDefaultButton())) {
                    colors = defaultColors;
                }
            } else {
                colors = model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b2.isRolloverEnabled() && model.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20));
            }
        } else {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        }
        if (b2.isBorderPainted() && b2.getBorder() != null && !(b2.getBorder() instanceof EmptyBorder)) {
            Insets insets = b2.getBorder().getBorderInsets(b2);
            int x = insets.left > 0 ? 1 : 0;
            int y = insets.top > 0 ? 1 : 0;
            int w = insets.right > 0 ? width - 1 : width;
            int h2 = insets.bottom > 0 ? height - 1 : height;
            JTattooUtilities.fillHorGradient(g2, colors, x, y, w - x, h2 - y);
        } else {
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
        }
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        ButtonModel model = b2.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Object sc;
            Color foreground = b2.getForeground();
            Color background = b2.getBackground();
            int offs = 0;
            if (model.isArmed() && model.isPressed()) {
                offs = 1;
            }
            if (!(model.isPressed() && model.isArmed() || !((sc = b2.getClientProperty("shadowColor")) instanceof Color))) {
                g2.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    g2.setColor(AbstractLookAndFeel.getTheme().getPressedForegroundColor());
                } else if (model.isRollover()) {
                    g2.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g2.setColor(foreground);
                }
            } else {
                g2.setColor(foreground);
            }
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            if (ColorHelper.getGrayValue(b2.getForeground()) < 128) {
                g2.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g2.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g2, 4, 3, b2.getWidth() - 8, b2.getHeight() - 6);
    }

    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g2D = (Graphics2D)g2;
        AbstractButton b2 = (AbstractButton)c2;
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        Insets insets = c2.getInsets();
        BaseButtonUI.viewRect.x = insets.left;
        BaseButtonUI.viewRect.y = insets.top;
        BaseButtonUI.viewRect.width = b2.getWidth() - (insets.right + BaseButtonUI.viewRect.x);
        BaseButtonUI.viewRect.height = b2.getHeight() - (insets.bottom + BaseButtonUI.viewRect.y);
        BaseButtonUI.textRect.height = 0;
        BaseButtonUI.textRect.width = 0;
        BaseButtonUI.textRect.y = 0;
        BaseButtonUI.textRect.x = 0;
        BaseButtonUI.iconRect.height = 0;
        BaseButtonUI.iconRect.width = 0;
        BaseButtonUI.iconRect.y = 0;
        BaseButtonUI.iconRect.x = 0;
        int iconTextGap = this.defaultTextIconGap;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            iconTextGap = b2.getIconTextGap();
        }
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : iconTextGap);
        this.paintBackground(g2, b2);
        if (b2.getIcon() != null) {
            if (!b2.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g2, c2, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                if (b2.getModel().isPressed() && b2.getModel().isRollover()) {
                    ++BaseButtonUI.iconRect.x;
                    ++BaseButtonUI.iconRect.y;
                }
                this.paintIcon(g2, c2, iconRect);
            }
        }
        if (text != null && !text.equals("")) {
            View v = (View)c2.getClientProperty("html");
            if (v != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                v.paint(g2, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
    }
}

