/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class BaseInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements ActionListener {
    public static final String PAINT_ACTIVE = "paintActive";
    public static final String ICONIFY = "Iconify";
    public static final String MAXIMIZE = "Maximize";
    public static final String CLOSE = "Close";
    protected boolean isPalette = false;
    protected Icon paletteCloseIcon;
    protected int paletteTitleHeight;
    protected int buttonsWidth = 0;
    protected JPanel customTitlePanel;

    public BaseInternalFrameTitlePane(JInternalFrame f2) {
        super(f2);
    }

    protected void installDefaults() {
        super.installDefaults();
        this.setFont(UIManager.getFont("InternalFrame.font"));
        this.paletteTitleHeight = UIManager.getInt("InternalFrame.paletteTitleHeight");
        this.paletteCloseIcon = UIManager.getIcon("InternalFrame.paletteCloseIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        if (this.frame.getClientProperty("customTitlePanel") instanceof JPanel) {
            this.setCustomizedTitlePanel((JPanel)this.frame.getClientProperty("customTitlePanel"));
        }
    }

    public void setCustomizedTitlePanel(JPanel panel) {
        if (this.customTitlePanel != null) {
            this.remove(this.customTitlePanel);
            this.customTitlePanel = null;
        }
        if (panel != null) {
            this.customTitlePanel = panel;
            this.add(this.customTitlePanel);
        }
        this.frame.putClientProperty("customTitlePanel", this.customTitlePanel);
        this.revalidate();
        this.repaint();
    }

    protected void createButtons() {
        this.iconButton = new BaseTitleButton(this.iconifyAction, ICONIFY, this.iconIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.maximizeAction, MAXIMIZE, this.maxIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, CLOSE, this.closeIcon, 1.0f);
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        this.iconButton.setToolTipText(null);
        this.maxButton.setToolTipText(null);
        this.closeButton.setToolTipText(null);
    }

    protected void enableActions() {
        super.enableActions();
        this.maximizeAction.setEnabled(this.frame.isMaximizable());
    }

    protected void assembleSystemMenu() {
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
    }

    protected void addSubComponents() {
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasePropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new BaseTitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 3;
    }

    protected int getVerSpacing() {
        return 3;
    }

    protected boolean centerButtons() {
        return true;
    }

    public void activateFrame() {
    }

    public void deactivateFrame() {
    }

    protected boolean isMacStyleWindowDecoration() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn();
    }

    public boolean isActive() {
        return JTattooUtilities.isActive(this);
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void setPalette(boolean b2) {
        this.isPalette = b2;
        if (this.isPalette) {
            this.closeButton.setIcon(this.paletteCloseIcon);
            if (this.frame.isMaximizable()) {
                this.remove(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.remove(this.iconButton);
            }
        } else {
            this.closeButton.setIcon(this.closeIcon);
            if (this.frame.isMaximizable()) {
                this.add(this.maxButton);
            }
            if (this.frame.isIconifiable()) {
                this.add(this.iconButton);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent e2) {
        AbstractButton button = (AbstractButton)e2.getSource();
        button.getModel().setRollover(false);
    }

    public void paintPalette(Graphics g2) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (JTattooUtilities.isFrameActive(this)) {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, width, height);
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, width, height);
        }
    }

    public void paintBackground(Graphics g2) {
        if (this.isActive()) {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    private Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        if (icon != null) {
            int w = icon.getIconWidth();
            int h2 = icon.getIconHeight();
            BufferedImage image = new BufferedImage(w, h2, 2);
            Graphics2D g2 = image.createGraphics();
            icon.paintIcon(null, g2, 0, 0);
            g2.dispose();
            return image;
        }
        return null;
    }

    protected int getIconWidth() {
        Image image = this.iconToImage(this.frame.getFrameIcon());
        if (image != null) {
            int h2 = this.getHeight();
            int ih = image.getHeight(null);
            int iw = image.getWidth(null);
            if (ih > h2) {
                double fac = (double)iw / (double)ih;
                ih = h2 - 1;
                iw = (int)(fac * (double)ih);
            }
            return iw;
        }
        return 0;
    }

    protected int paintIcon(Graphics g2, int x) {
        Image image = this.iconToImage(this.frame.getFrameIcon());
        if (image != null) {
            Graphics2D g2D = (Graphics2D)g2;
            Object savedHint = g2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            int h2 = this.getHeight();
            int ih = image.getHeight(null);
            int iw = image.getWidth(null);
            if (ih <= h2) {
                g2D.drawImage(image, x, (h2 - ih) / 2, iw, ih, null);
            } else {
                double fac = (double)iw / (double)ih;
                ih = h2;
                iw = (int)(fac * (double)ih);
                g2D.drawImage(image, x, 0, iw, ih, null);
            }
            if (savedHint != null) {
                g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedHint);
            }
            return iw;
        }
        return 0;
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, g2, title, x, y);
    }

    public void paintBorder(Graphics g2) {
        ColorUIResource borderColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
        if (this.isActive() || this.isPalette) {
            borderColor = AbstractLookAndFeel.getWindowBorderColor();
        }
        JTattooUtilities.draw3DBorder(g2, ColorHelper.brighter(borderColor, 20.0), ColorHelper.darker(borderColor, 10.0), 0, 0, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics g2) {
        if (this.isPalette) {
            this.paintPalette(g2);
            return;
        }
        this.paintBackground(g2);
        g2.setFont(this.getFont());
        FontMetrics fm = JTattooUtilities.getFontMetrics(this, g2, this.getFont());
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        int y = (height - fm.getHeight()) / 2 + fm.getAscent();
        int titleWidth = width - this.buttonsWidth - 4;
        String frameTitle = this.frame.getTitle();
        if (JTattooUtilities.isLeftToRight(this.frame)) {
            if (this.isMacStyleWindowDecoration()) {
                int iconWidth = this.getIconWidth();
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                this.paintIcon(g2, x += this.buttonsWidth + (titleWidth - titleLength) / 2);
                x += iconWidth + 4;
            } else {
                int iconWidth = this.paintIcon(g2, x);
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                if (AbstractLookAndFeel.getTheme().isCenterWindowTitleOn()) {
                    int titleLength = fm.stringWidth(frameTitle);
                    x += iconWidth + 4;
                    x += (titleWidth - titleLength) / 2;
                } else {
                    x += iconWidth + 4;
                }
            }
        } else {
            int iconWidth = this.getIconWidth();
            if (this.isMacStyleWindowDecoration()) {
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                x = this.buttonsWidth + 4 + (titleWidth - titleLength) / 2;
                this.paintIcon(g2, x + titleLength + 4);
            } else {
                x = width - iconWidth;
                this.paintIcon(g2, x);
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                x = AbstractLookAndFeel.getTheme().isCenterWindowTitleOn() ? this.buttonsWidth + 4 + (titleWidth - titleLength) / 2 : width - iconWidth - 4 - titleLength;
            }
        }
        this.paintText(g2, x, y, frameTitle);
        this.paintBorder(g2);
    }

    class BaseTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        BaseTitlePaneLayout() {
            super(BaseInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            return this.minimumLayoutSize(c2);
        }

        public Dimension minimumLayoutSize(Container c2) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (BaseInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (BaseInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (BaseInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (BaseInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (BaseInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (BaseInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = JTattooUtilities.getFontMetrics(BaseInternalFrameTitlePane.this, null, BaseInternalFrameTitlePane.this.getFont());
            String frameTitle = BaseInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n2 = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(BaseInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = BaseInternalFrameTitlePane.this.paletteTitleHeight;
            if (!BaseInternalFrameTitlePane.this.isPalette) {
                Icon icon = BaseInternalFrameTitlePane.this.isMacStyleWindowDecoration() ? null : BaseInternalFrameTitlePane.this.frame.getFrameIcon();
                height = icon == null ? Math.max(fm.getHeight() + 6, 16) : Math.max(fm.getHeight() + 6, Math.min(icon.getIconHeight(), 24));
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            int btnHeight;
            boolean leftToRight = JTattooUtilities.isLeftToRight(BaseInternalFrameTitlePane.this.frame);
            int spacing = BaseInternalFrameTitlePane.this.getHorSpacing();
            int w = BaseInternalFrameTitlePane.this.getWidth();
            int h2 = BaseInternalFrameTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - BaseInternalFrameTitlePane.this.getVerSpacing();
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h2 - btnHeight) / 2 - 1);
            if (BaseInternalFrameTitlePane.this.frame.isClosable()) {
                BaseInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (BaseInternalFrameTitlePane.this.frame.isMaximizable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (BaseInternalFrameTitlePane.this.frame.isIconifiable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            int n2 = BaseInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (BaseInternalFrameTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - BaseInternalFrameTitlePane.this.buttonsWidth - spacing - 20;
                Icon icon = BaseInternalFrameTitlePane.this.frame.getFrameIcon();
                if (icon != null) {
                    maxWidth -= icon.getIconWidth();
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, BaseInternalFrameTitlePane.this.customTitlePanel.getPreferredSize().width);
                int cph = h2;
                int cpx = leftToRight ? w - BaseInternalFrameTitlePane.this.buttonsWidth - cpw : BaseInternalFrameTitlePane.this.buttonsWidth;
                int cpy = 0;
                BaseInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                BaseInternalFrameTitlePane.this.buttonsWidth += BaseInternalFrameTitlePane.this.customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c2) {
            int y;
            int btnHeight;
            int spacing = BaseInternalFrameTitlePane.this.getHorSpacing();
            int h2 = BaseInternalFrameTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - BaseInternalFrameTitlePane.this.getVerSpacing() - 1;
            int x = 2;
            int n2 = y = BaseInternalFrameTitlePane.this.centerButtons() ? Math.max(0, (h2 - btnHeight) / 2) : 0;
            if (BaseInternalFrameTitlePane.this.frame.isClosable()) {
                BaseInternalFrameTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += spacing + btnWidth;
            }
            if (BaseInternalFrameTitlePane.this.frame.isIconifiable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.iconButton.setBounds(x, y, btnWidth, btnHeight);
                x += spacing + btnWidth;
            }
            if (BaseInternalFrameTitlePane.this.frame.isMaximizable() && !BaseInternalFrameTitlePane.this.isPalette) {
                BaseInternalFrameTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += spacing + btnWidth;
            }
            BaseInternalFrameTitlePane.this.buttonsWidth = x;
            if (BaseInternalFrameTitlePane.this.customTitlePanel != null) {
                int cpx = BaseInternalFrameTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = BaseInternalFrameTitlePane.this.customTitlePanel.getPreferredSize().width;
                int cph = h2;
                BaseInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                BaseInternalFrameTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }

    class BasePropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        BasePropertyChangeHandler() {
            super(BaseInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b2 = (Boolean)evt.getNewValue();
                BaseInternalFrameTitlePane.this.iconButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, b2);
                BaseInternalFrameTitlePane.this.closeButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, b2);
                BaseInternalFrameTitlePane.this.maxButton.putClientProperty(BaseInternalFrameTitlePane.PAINT_ACTIVE, b2);
                if (b2.booleanValue()) {
                    BaseInternalFrameTitlePane.this.activateFrame();
                } else {
                    BaseInternalFrameTitlePane.this.deactivateFrame();
                }
                BaseInternalFrameTitlePane.this.repaint();
            }
            super.propertyChange(evt);
        }
    }
}

