/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.LazyImageIcon;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BaseInternalFrameUI
extends BasicInternalFrameUI {
    private static final PropertyChangeListener MY_PROPERTY_CHANGE_HANDLER = new MyPropertyChangeHandler();
    private static final WindowAdapter MY_WINDOW_HANDLER = new MyWindowHandler();
    private static final Border HANDY_EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private static final String IS_PALETTE = "JInternalFrame.isPalette";
    private static final String FRAME_TYPE = "JInternalFrame.frameType";
    private static final String FRAME_BORDER = "InternalFrame.border";
    private static final String FRAME_PALETTE_BORDER = "InternalFrame.paletteBorder";
    private static final String PALETTE_FRAME = "palette";

    public BaseInternalFrameUI(JInternalFrame b2) {
        super(b2);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new BaseInternalFrameUI((JInternalFrame)c2);
    }

    public void installUI(JComponent c2) {
        super.installUI(c2);
        Object paletteProp = c2.getClientProperty(IS_PALETTE);
        if (paletteProp != null) {
            this.setPalette((Boolean)paletteProp);
        }
        this.stripContentBorder();
    }

    public void uninstallUI(JComponent c2) {
        JComponent contentPane;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && (contentPane = (JComponent)cp).getBorder() == HANDY_EMPTY_BORDER) {
            contentPane.setBorder(null);
        }
        super.uninstallUI(c2);
    }

    protected void installDefaults() {
        super.installDefaults();
        Icon frameIcon = this.frame.getFrameIcon();
        if (frameIcon == null || frameIcon instanceof LazyImageIcon) {
            this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(MY_PROPERTY_CHANGE_HANDLER);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(MY_PROPERTY_CHANGE_HANDLER);
        super.uninstallListeners();
    }

    protected void uninstallComponents() {
        this.titlePane = null;
        super.uninstallComponents();
    }

    public void stripContentBorder() {
        JComponent contentPane;
        Border contentBorder;
        Container cp = this.frame.getContentPane();
        if (cp instanceof JComponent && ((contentBorder = (contentPane = (JComponent)cp).getBorder()) == null || contentBorder instanceof UIResource)) {
            contentPane.setBorder(HANDY_EMPTY_BORDER);
        }
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        return new BaseInternalFrameTitlePane(w);
    }

    public BaseInternalFrameTitlePane getTitlePane() {
        return (BaseInternalFrameTitlePane)this.titlePane;
    }

    public void setPalette(boolean isPalette) {
        if (isPalette) {
            this.frame.setBorder(UIManager.getBorder(FRAME_PALETTE_BORDER));
        } else {
            this.frame.setBorder(UIManager.getBorder(FRAME_BORDER));
        }
        this.getTitlePane().setPalette(isPalette);
    }

    private static class MyWindowHandler
    extends WindowAdapter {
        private MyWindowHandler() {
        }

        public void windowActivated(WindowEvent e2) {
            e2.getWindow().invalidate();
            e2.getWindow().repaint();
        }

        public void windowDeactivated(WindowEvent e2) {
            e2.getWindow().invalidate();
            e2.getWindow().repaint();
        }
    }

    private static class MyPropertyChangeHandler
    implements PropertyChangeListener {
        private MyPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            JInternalFrame jif = (JInternalFrame)e2.getSource();
            if (!(jif.getUI() instanceof BaseInternalFrameUI)) {
                return;
            }
            BaseInternalFrameUI ui = (BaseInternalFrameUI)jif.getUI();
            String name = e2.getPropertyName();
            if (name.equals(BaseInternalFrameUI.FRAME_TYPE)) {
                if (e2.getNewValue() instanceof String) {
                    if (BaseInternalFrameUI.PALETTE_FRAME.equals(e2.getNewValue())) {
                        LookAndFeel.installBorder(ui.frame, BaseInternalFrameUI.FRAME_PALETTE_BORDER);
                        ui.setPalette(true);
                    } else {
                        LookAndFeel.installBorder(ui.frame, BaseInternalFrameUI.FRAME_BORDER);
                        ui.setPalette(false);
                    }
                }
            } else if (name.equals(BaseInternalFrameUI.IS_PALETTE)) {
                if (e2.getNewValue() != null) {
                    ui.setPalette((Boolean)e2.getNewValue());
                } else {
                    ui.setPalette(false);
                }
            } else if (name.equals("contentPane")) {
                ui.stripContentBorder();
            } else if (name.equals("ancestor") && !AbstractLookAndFeel.isWindowDecorationOn()) {
                JDesktopPane jp;
                Window window;
                if (e2.getNewValue() instanceof JDesktopPane) {
                    JDesktopPane jp2 = (JDesktopPane)e2.getNewValue();
                    Window window2 = SwingUtilities.getWindowAncestor(jp2);
                    if (window2 != null) {
                        WindowListener[] wl = window2.getWindowListeners();
                        boolean doAdd = true;
                        for (int i2 = 0; i2 < wl.length; ++i2) {
                            if (!wl[i2].equals(MY_WINDOW_HANDLER)) continue;
                            doAdd = false;
                            break;
                        }
                        if (doAdd) {
                            window2.addWindowListener(MY_WINDOW_HANDLER);
                        }
                    }
                } else if (e2.getOldValue() instanceof JDesktopPane && (window = SwingUtilities.getWindowAncestor(jp = (JDesktopPane)e2.getOldValue())) != null) {
                    window.removeWindowListener(MY_WINDOW_HANDLER);
                }
            }
        }
    }
}

