/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPasswordFieldUI;

public class BasePasswordFieldUI
extends BasicPasswordFieldUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent c2) {
        return new BasePasswordFieldUI();
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (JTattooUtilities.isMac()) {
            InputMap im = (InputMap)UIManager.get("TextField.focusInputMap");
            int commandKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            im.put(KeyStroke.getKeyStroke(67, commandKey), "copy-to-clipboard");
            im.put(KeyStroke.getKeyStroke(86, commandKey), "paste-from-clipboard");
            im.put(KeyStroke.getKeyStroke(88, commandKey), "cut-to-clipboard");
            im.put(KeyStroke.getKeyStroke(39, 512), "caret-next-word");
            im.put(KeyStroke.getKeyStroke(37, 512), "caret-previous-word");
        }
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent e2) {
                    if (BasePasswordFieldUI.this.getComponent() != null) {
                        BasePasswordFieldUI.this.orgBorder = BasePasswordFieldUI.this.getComponent().getBorder();
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf instanceof AbstractLookAndFeel && BasePasswordFieldUI.this.orgBorder instanceof UIResource) {
                            Border focusBorder = ((AbstractLookAndFeel)laf).getBorderFactory().getFocusFrameBorder();
                            BasePasswordFieldUI.this.getComponent().setBorder(focusBorder);
                        }
                        BasePasswordFieldUI.this.getComponent().invalidate();
                        BasePasswordFieldUI.this.getComponent().repaint();
                    }
                }

                public void focusLost(FocusEvent e2) {
                    if (BasePasswordFieldUI.this.getComponent() != null) {
                        if (BasePasswordFieldUI.this.orgBorder instanceof UIResource) {
                            BasePasswordFieldUI.this.getComponent().setBorder(BasePasswordFieldUI.this.orgBorder);
                        }
                        BasePasswordFieldUI.this.getComponent().invalidate();
                        BasePasswordFieldUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics g2) {
        g2.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        g2.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    protected void paintSafely(Graphics g2) {
        Graphics2D g2D = (Graphics2D)g2;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(g2);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }
}

