/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        Color shadowColor = AbstractLookAndFeel.getWindowTitleColorDark();
        if (this.isActive()) {
            shadowColor = ColorHelper.darker(shadowColor, 30.0);
        }
        g2.setColor(shadowColor);
        JTattooUtilities.drawString(this.rootPane, g2, title, x - 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x - 1, y + 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x + 1, y - 1);
        JTattooUtilities.drawString(this.rootPane, g2, title, x + 1, y + 1);
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g2, title, x, y);
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c2) {
            return this.preferredLayoutSize(c2);
        }

        protected int computeHeight() {
            FontMetrics fm = JTattooUtilities.getFontMetrics(AcrylTitlePane.this, null, AcrylTitlePane.this.getFont());
            return fm.getHeight() + 5;
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            boolean leftToRight = AcrylTitlePane.this.isLeftToRight();
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int w = AcrylTitlePane.this.getWidth();
            int h2 = AcrylTitlePane.this.getHeight();
            int btnHeight = h2 - AcrylTitlePane.this.getVerSpacing();
            int btnWidth = btnHeight + 10;
            if (AcrylTitlePane.this.menuBar != null) {
                int mw = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                int mh = ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().height;
                if (leftToRight) {
                    AcrylTitlePane.this.menuBar.setBounds(2, (h2 - mh) / 2, mw, mh);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - mw, (h2 - mh) / 2, mw, mh);
                }
            }
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h2 - btnHeight) / 2 - 1);
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            AcrylTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - AcrylTitlePane.this.buttonsWidth - spacing - 20;
                if (AcrylTitlePane.this.menuBar != null) {
                    maxWidth -= ((AcrylTitlePane)AcrylTitlePane.this).menuBar.getPreferredSize().width;
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h2;
                int cpx = leftToRight ? w - AcrylTitlePane.this.buttonsWidth - cpw : AcrylTitlePane.this.buttonsWidth;
                int cpy = 0;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth += ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c2) {
            int btnHeight;
            int spacing = AcrylTitlePane.this.getHorSpacing();
            int h2 = AcrylTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - AcrylTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            AcrylTitlePane.this.buttonsWidth = x;
            if (AcrylTitlePane.this.customTitlePanel != null) {
                int cpx = AcrylTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((AcrylTitlePane)AcrylTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h2;
                AcrylTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

