/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class AeroTitlePane
extends BaseTitlePane {
    public AeroTitlePane(JRootPane root, BaseRootPaneUI ui) {
        super(root, ui);
    }

    protected int getHorSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 1 : 0;
    }

    protected int getVerSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 3 : 0;
    }

    public void createButtons() {
        if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
            super.createButtons();
        } else {
            this.iconifyButton = new TitleButton(this.iconifyAction, "Iconify", this.iconifyIcon);
            this.maxButton = new TitleButton(this.restoreAction, "Maximize", this.maximizeIcon);
            this.closeButton = new TitleButton(this.closeAction, "Close", this.closeIcon);
        }
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorDark(), 50.0));
        } else {
            g2.setColor(ColorHelper.darker(AbstractLookAndFeel.getWindowInactiveTitleColorDark(), 10.0));
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        if (this.isActive()) {
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
            if (ColorHelper.getGrayValue(titleColor) > 164) {
                g2.setColor(Color.black);
            } else {
                g2.setColor(Color.white);
            }
            JTattooUtilities.drawString(this.rootPane, g2, title, x + 1, y + 1);
            g2.setColor(titleColor);
            JTattooUtilities.drawString(this.rootPane, g2, title, x, y);
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, g2, title, x, y);
        }
    }

    private class TitleButton
    extends BaseTitleButton {
        public TitleButton(Action action, String accessibleName, Icon icon) {
            super(action, accessibleName, icon, 1.0f);
        }

        public void paint(Graphics g2) {
            boolean isPressed = this.getModel().isPressed();
            boolean isArmed = this.getModel().isArmed();
            boolean isRollover = this.getModel().isRollover();
            int width = this.getWidth();
            int height = this.getHeight();
            Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
            if (isRollover) {
                colors = AbstractLookAndFeel.getTheme().getRolloverColors();
            }
            if (isPressed && isArmed) {
                colors = AbstractLookAndFeel.getTheme().getPressedColors();
            }
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
            g2.setColor(Color.lightGray);
            g2.drawLine(0, 0, 0, height);
            g2.drawLine(0, height - 1, width, height - 1);
            g2.setColor(Color.white);
            g2.drawLine(1, 0, 1, height - 2);
            this.getIcon().paintIcon(this, g2, 1, 0);
        }
    }
}

