/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class BernsteinButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new BernsteinButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        ButtonModel model = b2.getModel();
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (b2.isEnabled()) {
            Color background = b2.getBackground();
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    colors = AbstractLookAndFeel.getTheme().getPressedColors();
                } else if (b2.isRolloverEnabled() && model.isRollover()) {
                    colors = AbstractLookAndFeel.getTheme().getRolloverColors();
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus()) {
                    colors = AbstractLookAndFeel.getTheme().getFocusColors();
                } else if (JTattooUtilities.isFrameActive(b2) && b2.getRootPane() != null && b2.equals(b2.getRootPane().getDefaultButton())) {
                    colors = AbstractLookAndFeel.getTheme().getSelectedColors();
                }
            } else {
                colors = model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b2.isRolloverEnabled() && model.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20));
            }
        } else {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        }
        if (b2.isBorderPainted() && b2.getBorder() != null) {
            Insets insets = b2.getBorder().getBorderInsets(b2);
            int x = insets.left > 0 ? 1 : 0;
            int y = insets.top > 0 ? 1 : 0;
            int w = insets.right > 0 ? width - 1 : width;
            int h2 = insets.bottom > 0 ? height - 1 : height;
            JTattooUtilities.fillHorGradient(g2, colors, x, y, w - x, h2 - y);
        } else {
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
        }
    }
}

