/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.XPScrollBarUI;
import com.jtattoo.plaf.hifi.HiFiScrollButton;
import java.awt.Color;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class HiFiScrollBarUI
extends XPScrollBarUI {
    public static ComponentUI createUI(JComponent c2) {
        return new HiFiScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Color[] colors = AbstractLookAndFeel.getTheme().getThumbColors();
        rolloverColors = new Color[colors.length];
        dragColors = new Color[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            HiFiScrollBarUI.rolloverColors[i2] = ColorHelper.brighter(colors[i2], 8.0);
            HiFiScrollBarUI.dragColors[i2] = ColorHelper.darker(colors[i2], 8.0);
        }
    }

    protected JButton createDecreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createDecreaseButton(orientation);
        }
        return new HiFiScrollButton(orientation, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int orientation) {
        if (AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
            return super.createIncreaseButton(orientation);
        }
        return new HiFiScrollButton(orientation, this.scrollBarWidth);
    }

    protected Color getFrameColor() {
        Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getButtonBackgroundColor(), 8.0);
        if (this.isDragging) {
            return ColorHelper.darker(frameColor, 8.0);
        }
        if (this.isRollover) {
            return ColorHelper.brighter(frameColor, 16.0);
        }
        return frameColor;
    }
}

