/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class SmartBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return SmartBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            if (JTattooUtilities.isFrameActive((JComponent)c2)) {
                g2.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
            }
            g2.drawRect(x, y, w - 1, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(PaletteBorder.insets.top, PaletteBorder.insets.left, PaletteBorder.insets.bottom, PaletteBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = PaletteBorder.insets.left;
            borderInsets.top = PaletteBorder.insets.top;
            borderInsets.right = PaletteBorder.insets.right;
            borderInsets.bottom = PaletteBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            ColorUIResource c22;
            ColorUIResource c1;
            Graphics2D g2D = (Graphics2D)g2;
            boolean active = this.isActive(c2);
            boolean resizable = this.isResizable(c2);
            int th = this.getTitleHeight(c2);
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
            if (active) {
                titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
                frameColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            if (!resizable) {
                Insets bi = this.getBorderInsets(c2);
                g2.setColor(frameColor);
                g2.drawRect(x, y, w - 1, h2 - 1);
                if (active) {
                    g2.setColor(AbstractLookAndFeel.getWindowTitleColorDark());
                } else {
                    g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i2 = 1; i2 < bi.left; ++i2) {
                    g2.drawRect(i2, i2, w - 2 * i2 - 1, h2 - 2 * i2 - 1);
                }
                g2.setColor(frameColor);
                g2.drawLine(bi.left - 1, y + th + bi.top, bi.left - 1, y + h2 - bi.bottom);
                g2.drawLine(w - bi.right, y + th + bi.top, w - bi.right, y + h2 - bi.bottom);
                g2.drawLine(bi.left - 1, y + h2 - bi.bottom, w - bi.right, y + h2 - bi.bottom);
                return;
            }
            g2.setColor(titleColor);
            g2.fillRect(x, y + 1, w, 4);
            g2.fillRect(x + 1, y + h2 - 5, w - 2, 4);
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorDark(), 30.0);
            if (active) {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                c22 = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h2 - th - 10, c22));
                g2.fillRect(1, 5 + th + 1, 4, h2 - th - 10);
                g2.fillRect(w - 5, 5 + th + 1, 4, h2 - th - 10);
                g2D.setPaint(null);
            } else {
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                c22 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h2 - th - 10, c22));
                g2.fillRect(1, 5 + th + 1, 4, h2 - th - 10);
                g2.fillRect(w - 5, 5 + th + 1, 4, h2 - th - 10);
                g2D.setPaint(null);
            }
            if (active && resizable) {
                int d2 = 17;
                color = AbstractLookAndFeel.getWindowTitleColorDark();
                Color cHi = ColorHelper.brighter(color, 30.0);
                Color cLo = ColorHelper.darker(color, 20.0);
                g2.setColor(color);
                g2.fillRect(x + 1, y + h2 - d2, 4, d2 - 1);
                g2.fillRect(x + 5, y + h2 - 5, d2 - 5 - 1, d2 - 5 - 1);
                g2.setColor(cLo);
                g2.drawLine(x + 1, y + h2 - d2 - 2, x + 5 - 2, y + h2 - d2 - 2);
                g2.drawLine(x + 5 - 2, y + h2 - d2 - 2, x + 5 - 2, y + h2 - 5);
                g2.drawLine(x + 5 - 2, y + h2 - 5, x + d2 - 1, y + h2 - 5);
                g2.drawLine(x + d2 - 1, y + h2 - 5, x + d2 - 1, y + h2 - 1);
                g2.setColor(cHi);
                g2.drawLine(x + 1, y + h2 - d2 - 1, x + 5 - 3, y + h2 - d2 - 1);
                g2.drawLine(x + 5 - 1, y + h2 - d2 - 1, x + 5 - 1, y + h2 - 5 - 1);
                g2.drawLine(x + 5 - 1, y + h2 - 5 + 1, x + d2 - 2, y + h2 - 5 + 1);
                g2.drawLine(x + d2 - 2, y + h2 - 5 + 1, x + d2 - 2, y + h2 - 1);
                g2.setColor(color);
                g2.fillRect(x + w - d2 - 1, y + h2 - 5, d2, 4);
                g2.fillRect(x + w - 5, y + h2 - d2 - 1, 4, d2);
                g2.setColor(cLo);
                g2.drawLine(x + w - 5 - 1, y + h2 - d2 - 2, x + w - 1, y + h2 - d2 - 2);
                g2.drawLine(x + w - 5, y + h2 - d2 - 2, x + w - 5, y + h2 - 5);
                g2.drawLine(x + w - d2 - 1, y + h2 - 5, x + w - 5, y + h2 - 5);
                g2.drawLine(x + w - d2 - 1, y + h2 - 5, x + w - d2 - 1, y + h2 - 1);
                g2.setColor(cHi);
                g2.drawLine(x + w - 5 + 1, y + h2 - d2 - 1, x + w - 1, y + h2 - d2 - 1);
                g2.drawLine(x + w - 5 + 1, y + h2 - d2 - 1, x + w - 5 + 1, y + h2 - 5);
                g2.drawLine(x + w - d2, y + h2 - 5 + 1, x + w - 5 + 1, y + h2 - 5 + 1);
                g2.drawLine(x + w - d2, y + h2 - 5 + 1, x + w - d2, y + h2 - 1);
            }
            g2.setColor(frameColor);
            g2.drawRect(x, y, w - 1, h2 - 1);
            g2.drawLine(x + 5 - 1, y + 5 + th, x + 5 - 1, y + h2 - 5);
            g2.drawLine(x + w - 5, y + 5 + th, x + w - 5, y + h2 - 5);
            g2.drawLine(x + 5 - 1, y + h2 - 5, x + w - 5, y + h2 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Color frameColor = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 30.0);
                    g2.setColor(frameColor);
                    g2.drawRect(x, y, w - 1, h2 - 1);
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.black);
                    g2.fillRect(x + 1, y + 1, w - 2, h2 - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = ColorHelper.darker(frameColor, 5.0);
                    Color frameLoColor = ColorHelper.darker(frameColor, 20.0);
                    JTattooUtilities.draw3DBorder(g2, frameHiColor, frameLoColor, x, y, w, h2);
                    frameHiColor = Color.white;
                    frameLoColor = ColorHelper.brighter(frameLoColor, 60.0);
                    JTattooUtilities.draw3DBorder(g2, frameHiColor, frameLoColor, x + 1, y + 1, w - 2, h2 - 2);
                    Graphics2D g2D = (Graphics2D)g2;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g2.setColor(Color.white);
                    g2.fillRect(x + 2, y + 2, w - 4, h2 - 4);
                    g2D.setComposite(composite);
                    g2.setColor(AbstractLookAndFeel.getFocusColor());
                    g2.drawLine(x + 1, y + 1, x + w - 1, y + 1);
                    g2.drawLine(x + 1, y + 2, x + w - 2, y + 2);
                } else if (model.isSelected()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = Color.white;
                    Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
                    JTattooUtilities.draw3DBorder(g2, frameLoColor, frameHiColor, x, y, w, h2);
                }
            }
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorLo = new Color(212, 224, 243);
        private static final Insets insets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            AbstractButton button = (AbstractButton)c2;
            Graphics2D g2D = (Graphics2D)g2;
            Color frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(button)) {
                frameColor = ColorHelper.brighter(frameColor, 40.0);
            }
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                g2D.setColor(Color.white);
                g2D.drawRect(x, y, w - 1, h2 - 1);
                if (button.getRootPane() != null && button.equals(button.getRootPane().getDefaultButton()) && !button.hasFocus()) {
                    g2D.setColor(ColorHelper.darker(frameColor, 20.0));
                    g2D.drawRect(x, y, w - 1, h2 - 2);
                    if (!button.getModel().isRollover()) {
                        g2D.setColor(defaultColorHi);
                        g2D.drawRect(x + 1, y + 1, w - 3, h2 - 4);
                        g2D.setColor(defaultColorLo);
                        g2D.drawRect(x + 2, y + 2, w - 5, h2 - 6);
                    }
                } else {
                    g2D.setColor(frameColor);
                    g2D.drawRect(x, y, w - 2, h2 - 2);
                }
            } else {
                Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (button.getRootPane() != null && button.equals(button.getRootPane().getDefaultButton()) && !button.getModel().isRollover()) {
                    g2D.setColor(defaultColorHi);
                    g2D.drawRoundRect(x + 1, y + 1, w - 4, h2 - 2, 6, 6);
                    g2D.setColor(defaultColorLo);
                    g2D.drawRoundRect(x + 2, y + 2, w - 6, h2 - 6, 6, 6);
                }
                g2D.setColor(Color.white);
                g2D.drawRoundRect(x, y, w - 1, h2 - 1, 6, 6);
                g2D.setColor(frameColor);
                g2D.drawRoundRect(x, y, w - 2, h2 - 2, 6, 6);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            }
        }

        public Insets getBorderInsets(Component c2) {
            return insets;
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

