/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class SmartTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c2) {
        return new SmartTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(0, 0, 0, 0);
    }

    protected Color getGapColor(int tabIndex) {
        if (tabIndex == this.tabPane.getSelectedIndex()) {
            return this.tabPane.getBackgroundAt(tabIndex);
        }
        return super.getGapColor(tabIndex);
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected boolean hasInnerBorder() {
        return true;
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x, int y, int w, int h2, boolean isSelected) {
        if (isSelected) {
            g2.setColor(this.tabPane.getBackgroundAt(tabIndex));
            if (tabPlacement == 1) {
                g2.fillRect(x + 1, y + 1, w - 1, h2 + 2);
            } else if (tabPlacement == 2) {
                g2.fillRect(x + 1, y + 1, w + 2, h2 - 1);
            } else if (tabPlacement == 3) {
                g2.fillRect(x + 1, y - 2, w - 1, h2 + 1);
            } else {
                g2.fillRect(x - 2, y + 1, w + 2, h2 - 1);
            }
        } else {
            super.paintTabBackground(g2, tabPlacement, tabIndex, x, y, w, h2, isSelected);
            if (!isSelected && tabIndex == this.rolloverIndex && this.tabPane.isEnabledAt(tabIndex)) {
                g2.setColor(AbstractLookAndFeel.getFocusColor());
                if (tabPlacement == 1) {
                    g2.fillRect(x + 2, y + 1, w - 3, 2);
                } else if (tabPlacement == 2) {
                    g2.fillRect(x, y + 1, w - 1, 2);
                } else if (tabPlacement == 3) {
                    g2.fillRect(x + 2, y + h2 - 3, w - 3, 2);
                } else {
                    g2.fillRect(x, y + 1, w - 1, 2);
                }
            }
        }
    }
}

