/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class NimRODDesktopIconUI
extends BasicDesktopIconUI {
    boolean hasFocus;
    private int width = UIManager.getInt("NimRODDesktopIcon.width");
    private int height = UIManager.getInt("NimRODDesktopIcon.height");
    private int bigWidth = UIManager.getInt("NimRODDesktopIconBig.width");
    private int bigHeight = UIManager.getInt("NimRODDesktopIconBig.height");
    private HackML hackML = new HackML();
    private Icon resizeIcon;
    private Icon antIcon;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODDesktopIconUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.uninstallBorder(this.desktopIcon);
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.frame != null) {
            this.desktopIcon.addMouseListener(this.hackML);
            this.desktopIcon.addMouseMotionListener(this.hackML);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.desktopIcon.removeMouseListener(this.hackML);
        this.desktopIcon.removeMouseMotionListener(this.hackML);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.frame.getFrameIcon() != this.antIcon) {
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, this.bigWidth, this.bigHeight);
        }
        String string = this.frame.getTitle();
        int n2 = 0;
        if (this.resizeIcon != null) {
            n2 = (this.width - this.resizeIcon.getIconWidth()) / 2;
            this.resizeIcon.paintIcon(jComponent, graphics, n2, 2);
        }
        graphics.setFont(UIManager.getFont("DesktopIcon.font"));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.hasFocus) {
            int n3 = 0;
            String string2 = this.getTitle(string, fontMetrics, this.width - 10);
            while (string2.length() > 0) {
                if (string2.endsWith("...")) {
                    string2 = string2.substring(0, string2.length() - 3);
                }
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string2, graphics);
                n2 = (int)((double)this.width - rectangle2D.getWidth()) / 2;
                n3 = (int)((double)n3 + rectangle2D.getHeight());
                NimRODUtils.paintShadowTitleFat(graphics, string2, n2, n3, Color.white);
                string = string.substring(string2.length());
                string2 = this.getTitle(string, fontMetrics, this.width - 10);
            }
        } else {
            string = this.getTitle(string, fontMetrics, this.width - 10);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            n2 = (int)((double)this.width - rectangle2D.getWidth()) / 2;
            NimRODUtils.paintShadowTitleFat(graphics, string, n2, this.height - 5, Color.white);
        }
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n2) {
        String string2;
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = fontMetrics.stringWidth(string);
        if (n3 <= n2) {
            return string;
        }
        int n4 = fontMetrics.stringWidth("...");
        if (n2 - n4 <= 0) {
            return "";
        }
        int n5 = 1;
        while ((n4 = fontMetrics.stringWidth(string2 = string.substring(0, n5++) + "...")) < n2) {
        }
        return string.substring(0, n5 - 1) + "...";
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(this.width, this.height);
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODDesktopIconUI.this.hasFocus = false;
            this.dodo(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            NimRODDesktopIconUI.this.hasFocus = true;
            this.dodo(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.dodo(mouseEvent);
        }

        void dodo(MouseEvent mouseEvent) {
            if (NimRODDesktopIconUI.this.desktopIcon != null) {
                NimRODDesktopIconUI.this.desktopIcon.getDesktopPane().updateUI();
            }
        }
    }
}

