/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsBorders;
import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsTheme;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.plaf.ThemeFactory;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jvnet.lafplugin.ComponentPluginManager;

public class PgsLookAndFeel
extends MetalLookAndFeel {
    public static final String PLUGIN_XML = "META-INF/pgslookandfeel-plugin.xml";
    protected static ComponentPluginManager componentPlugins;
    private static MetalTheme currentTheme;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadUserSettings() {
        InputStream inputStream = PgsLookAndFeel.class.getResourceAsStream("/pgs.properties");
        if (inputStream != null) {
            try {
                logger.finest("Found a pgs.properties! Going to setup from pgs.properties!");
                Properties properties = new Properties();
                properties.load(inputStream);
                PlafOptions.useShadowBorder(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.shadowBorder", "false"));
                PlafOptions.useBoldFonts(PgsLookAndFeel.getPropertyBoolValue(properties, "swing.boldMetal", "false"));
                PlafOptions.useBoldMenuFonts(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.boldMenuFonts", "false"));
                PlafOptions.useExtraMargin(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.extraMargin", "true"));
                PlafOptions.useDisabledIcon(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.useDisabledIcon", "true"));
                PlafOptions.useToolBarIcon(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.useToolBarIcon", "true"));
                PlafOptions.setAntialiasingEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.aaEnabled", "false"));
                PlafOptions.setClearBorderEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.clearBorderEnabled", "false"));
                PlafOptions.setFixHtmlDisplayEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.fixHtmlDisplayEnabled", "true"));
                PlafOptions.setWheelTabbedPaneEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.wheelTabEnabled", "true"));
                PlafOptions.setTabbedPaneRightClickSelectionEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.tabbedPaneRightClickSelectionEnabled", "false"));
                PlafOptions.setTabReorderingEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.tabReorderingEnabled", "false"));
                PlafOptions.setPaintRolloverButtonBorder(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.paintRolloverButtonBorder", "true"));
                PlafOptions.setOfficeScrollBarEnabled(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.officeScrollBarEnabled", "false"));
                PlafOptions.setVistaStyle(PgsLookAndFeel.getPropertyBoolValue(properties, "pgs.vistaStyle", "false"));
                PlafOptions.setStyle("MenuBar", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.menuBar", "flat"));
                PlafOptions.setStyle("MenuItem", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.menuitem", "flat"));
                PlafOptions.setStyle("MenuBarMenu", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.menuBarMenu", "flat"));
                PlafOptions.setStyle("ToolBar", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.toolBar", "gradient"));
                PlafOptions.setStyle("ToolBarButton", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.toolBarButton", "gradient"));
                PlafOptions.setStyle("Button", PgsLookAndFeel.getPropertyStyleValue(properties, "pgs.style.button", "gradient"));
                PgsTheme pgsTheme = null;
                String string = properties.getProperty("theme");
                pgsTheme = string != null ? ThemeFactory.getTheme(string) : ThemeFactory.createTheme(properties);
                if (pgsTheme != null) {
                    PgsLookAndFeel.setCurrentTheme(pgsTheme);
                } else {
                    logger.warning("Could not create theme from pgs.properties");
                }
                logger.finest("pgs.properties have been loaded.");
            }
            catch (IOException iOException) {
                logger.warning("Unexpected exception happened while loading properties: " + iOException.toString());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warning("Unexpected exception happened while closing the stream: " + iOException.toString());
                }
            }
        }
    }

    private static boolean getPropertyBoolValue(Properties properties, String string, String string2) {
        return "true".equals(properties.getProperty(string, string2).trim().toLowerCase());
    }

    private static int getPropertyStyleValue(Properties properties, String string, String string2) {
        return "flat".equals(properties.getProperty(string, string2).trim().toLowerCase()) ? 0 : 1;
    }

    public PgsLookAndFeel() {
        UIManager.put("swing.boldMetal", PlafOptions.useBoldFonts() ? Boolean.TRUE : Boolean.FALSE);
    }

    public void initialize() {
        super.initialize();
        componentPlugins = new ComponentPluginManager(PLUGIN_XML);
        MetalLookAndFeel.setCurrentTheme(PgsLookAndFeel.getCurrentTheme());
        componentPlugins.initializeAll();
    }

    public void uninitialize() {
        super.uninitialize();
        componentPlugins.uninitializeAll();
    }

    public static void setAsLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.pagosoft.plaf.PgsLookAndFeel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void updateAllUIs() {
        Frame[] frameArray = Frame.getFrames();
        for (int i2 = 0; i2 < frameArray.length; ++i2) {
            if (!(frameArray[i2] instanceof JFrame)) continue;
            SwingUtilities.updateComponentTreeUI(frameArray[i2]);
        }
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        if (metalTheme == null) {
            throw new IllegalArgumentException("theme must not be null!");
        }
        currentTheme = metalTheme;
        MetalLookAndFeel.setCurrentTheme(metalTheme);
    }

    public static MetalTheme getCurrentTheme() {
        if (currentTheme == null) {
            String string = null;
            try {
                string = System.getProperty("pgs.theme");
            }
            catch (Exception exception) {
                logger.warning("Could not read system property 'pgs.theme'");
            }
            currentTheme = string == null ? ThemeFactory.getDefaultTheme() : ThemeFactory.getTheme(string);
        }
        return currentTheme;
    }

    public String getID() {
        return "com.pagosoft.plaf.PgsLookAndFeel";
    }

    public String getName() {
        return "PgsLookAndFeel";
    }

    public String getDescription() {
        return "Much like the original MetalLookAndFeel, but with gradients on menus, buttons, etc.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.pagosoft.plaf.Pgs";
        Object[] objectArray = new Object[]{"ButtonUI", string + "ButtonUI", "ToggleButtonUI", string + "ToggleButtonUI", "CheckBoxUI", string + "CheckBoxUI", "RadioButtonUI", string + "RadioButtonUI", "ComboBoxUI", string + "ComboBoxUI", "ToolBarUI", string + "ToolBarUI", "MenuUI", string + "MenuUI", "MenuBarUI", string + "MenuBarUI", "MenuItemUI", string + "MenuItemUI", "CheckBoxMenuItemUI", string + "CheckBoxMenuItemUI", "RadioButtonMenuItemUI", string + "RadioButtonMenuItemUI", "TabbedPaneUI", string + "TabbedPaneUI", "ProgressBarUI", string + "ProgressBarUI", "ScrollBarUI", string + "ScrollBarUI", "SplitPaneUI", string + "SplitPaneUI", "LabelUI", string + "LabelUI", "TextFieldUI", string + "TextFieldUI", "ToolTipUI", string + "ToolTipUI", "EditorPaneUI", string + "EditorPaneUI", "FormattedTextFieldUI", string + "FormattedTextFieldUI", "PasswordFieldUI", string + "PasswordFieldUI", "TextAreaUI", string + "TextAreaUI", "ScrollPaneUI", string + "ScrollPaneUI", "TableHeaderUI", string + "TableHeaderUI"};
        uIDefaults.putDefaults(objectArray);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        MetalTheme metalTheme = PgsLookAndFeel.getCurrentTheme();
        InsetsUIResource insetsUIResource = new InsetsUIResource(0, 2, 0, 3);
        InsetsUIResource insetsUIResource2 = PlafOptions.useExtraMargin() ? new InsetsUIResource(1, 14, 1, 14) : new InsetsUIResource(1, 4, 1, 4);
        Color color = ColorUtils.getSimiliarColor(metalTheme.getControl(), 1.4f);
        Color color2 = ColorUtils.getSimiliarColor(metalTheme.getControl(), 0.9f);
        Color color3 = ColorUtils.getSimiliarColor(metalTheme.getPrimaryControlShadow(), 1.4f);
        Color color4 = ColorUtils.getSimiliarColor(metalTheme.getPrimaryControlShadow(), 0.9f);
        Object[] objectArray = new Object[]{"glow", ColorUtils.getTranslucentColor(metalTheme.getPrimaryControl(), 175), "Button.border", PgsBorders.getButtonBorder(), "Button.margin", insetsUIResource2, "Button.rolloverBackground", metalTheme.getControlShadow(), "Button.isFlat", PlafOptions.isFlat("Button"), "Button.gradientStart", color, "Button.gradientEnd", color2, "Button.rolloverGradientStart", color, "Button.rolloverGradientEnd", color2, "Button.selectedGradientStart", color2, "Button.selectedGradientEnd", color, "Button.rolloverVistaStyle", Boolean.FALSE, "ToggleButton.border", PgsBorders.getButtonBorder(), "ToggleButton.margin", insetsUIResource2, "ToggleButton.rolloverBackground", metalTheme.getControlShadow(), "ToggleButton.isFlat", PlafOptions.isFlat("Button"), "ToggleButton.gradientStart", color, "ToggleButton.gradientEnd", color2, "ToggleButton.rolloverGradientStart", color, "ToggleButton.rolloverGradientEnd", color2, "ToggleButton.selectedGradientStart", ColorUtils.getSimiliarColor(metalTheme.getControl(), 0.5f), "ToggleButton.selectedGradientEnd", ColorUtils.getSimiliarColor(metalTheme.getControl(), 0.9f), "RadioButton.border", PgsBorders.getButtonBorder(), "RadioButton.icon", PgsIconFactory.getRadioButtonIcon(), "CheckBox.border", PgsBorders.getButtonBorder(), "CheckBox.icon", PgsIconFactory.getCheckBoxIcon(), "TabbedPane.tabGradientStart", color, "TabbedPane.tabGradientEnd", color2, "TabbedPane.focusPainted", Boolean.FALSE, "TabbedPane.buttonStyle.background", metalTheme.getControl(), "TabbedPane.buttonStyle.selectedBackground", new ColorUIResource(ColorUtils.getTranslucentColor(metalTheme.getPrimaryControlDarkShadow(), 100)), "TabbedPane.buttonStyle.rolloverBackground", new ColorUIResource(ColorUtils.getTranslucentColor(metalTheme.getPrimaryControlShadow(), 100)), "TabbedPane.buttonStyle.selectedBorder", metalTheme.getPrimaryControlDarkShadow(), "TabbedPane.buttonStyle.rolloverBorder", metalTheme.getPrimaryControlDarkShadow(), "ToolBar.gradientStart", color, "ToolBar.gradientEnd", color2, "ToolBar.border", PgsBorders.getToolBarBorder(), "ToolBar.borderColor", metalTheme.getControlShadow(), "ToolBarButton.margin", new InsetsUIResource(3, 3, 3, 3), "ToolBarButton.rolloverBackground", metalTheme.getPrimaryControl(), "ToolBarButton.rolloverBorderColor", metalTheme.getPrimaryControlDarkShadow(), "ToolBarButton.isFlat", PlafOptions.isFlat("ToolBarButton"), "ToolBarButton.gradientStart", color, "ToolBarButton.gradientEnd", color2, "ToolBarButton.rolloverGradientStart", color3, "ToolBarButton.rolloverGradientEnd", color4, "ToolBarButton.selectedGradientStart", color4, "ToolBarButton.selectedGradientEnd", color3, "ComboBox.border", PgsBorders.getTextFieldBorder(), "ComboBox.editorBorder", null, "ComboBox.selectionBackground", metalTheme.getPrimaryControl(), "ComboBox.popup.border", BorderFactory.createLineBorder(metalTheme.getControlDarkShadow()), "Menu.submenuPopupOffsetX", new Integer(0), "Menu.selectionBackground", metalTheme.getPrimaryControl(), "Menu.selectedBorderMargin", insetsUIResource, "Menu.selectedBorderColor", metalTheme.getPrimaryControlDarkShadow(), "Menu.gradientStart", color3, "Menu.gradientEnd", color4, "Menu.borderPainted", Boolean.FALSE, "MenuItem.selectionBackground", metalTheme.getPrimaryControl(), "MenuItem.selectedBorderMargin", insetsUIResource, "MenuItem.selectedBorderColor", metalTheme.getPrimaryControlDarkShadow(), "MenuItem.gradientStart", color3, "MenuItem.gradientEnd", color4, "MenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "MenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.selectionBackground", metalTheme.getPrimaryControl(), "CheckBoxMenuItem.selectedBorderMargin", insetsUIResource, "CheckBoxMenuItem.selectedBorderColor", metalTheme.getPrimaryControlDarkShadow(), "CheckBoxMenuItem.gradientStart", color3, "CheckBoxMenuItem.gradientEnd", color4, "CheckBoxMenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", PgsIconFactory.getCheckBoxMenuItemIcon(), "RadioButtonMenuItem.selectionBackground", metalTheme.getPrimaryControl(), "RadioButtonMenuItem.selectedBorderMargin", insetsUIResource, "RadioButtonMenuItem.selectedBorderColor", metalTheme.getPrimaryControlDarkShadow(), "RadioButtonMenuItem.gradientStart", color3, "RadioButtonMenuItem.gradientEnd", color4, "RadioButtonMenuItem.isFlat", PlafOptions.isFlat("MenuItem"), "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", PgsIconFactory.getRadioButtonMenuItemIcon(), "MenuBar.isFlat", PlafOptions.isFlat("MenuBar"), "MenuBar.gradientStart", color, "MenuBar.gradientEnd", color2, "MenuBarMenu.isFlat", PlafOptions.isFlat("MenuBarMenu"), "MenuBarMenu.foreground", metalTheme.getMenuForeground(), "MenuBarMenu.rolloverBorderColor", metalTheme.getControlTextColor(), "MenuBarMenu.selectedBorderColor", metalTheme.getPrimaryControlDarkShadow(), "MenuBarMenu.rolloverBackground", metalTheme.getControlShadow(), "MenuBarMenu.selectedBackground", metalTheme.getPrimaryControl(), "MenuBarMenu.rolloverBackgroundGradientStart", color3, "MenuBarMenu.rolloverBackground.gradientStart", color3, "MenuBarMenu.rolloverBackgroundGradientEnd", color4, "MenuBarMenu.rolloverBackground.gradientEnd", color4, "MenuBarMenu.selectedBackgroundGradientStart", color4, "MenuBarMenu.selectedBackgroundGradientEnd", color3, "MenuBarMenu.selectedBackground.gradientStart", color4, "MenuBarMenu.selectedBackground.gradientEnd", color3, "ProgressBar.border", PgsBorders.getComponentBorder(), "ProgressBar.gradientStart", color, "ProgressBar.gradientEnd", color2, "ProgressBar.innerGradientStart", color3, "ProgressBar.innerGradientEnd", color4, "ProgressBar.innerDisabledGradientStart", color, "ProgressBar.innerDisabledGradientEnd", color2, "ProgressBar.innerBorderColor", metalTheme.getPrimaryControlDarkShadow(), "ProgressBar.innerDisabledBorderColor", metalTheme.getControlDarkShadow(), "ScrollBar.track", metalTheme.getControlShadow(), "ScrollBar.trackHighlight", metalTheme.getControl(), "ScrollPane.border", BorderFactory.createLineBorder(PgsLookAndFeel.getControlDarkShadow(), 1), "TextField.border", PgsBorders.getTextFieldBorder(), "TextField.margin", new InsetsUIResource(2, 2, 2, 2), "FormattedTextField.border", PgsBorders.getTextFieldBorder(), "FormattedTextField.margin", new InsetsUIResource(2, 2, 2, 2), "PasswordField.border", PgsBorders.getTextFieldBorder(), "PasswordField.margin", new InsetsUIResource(2, 2, 2, 2), "TextArea.margin", new InsetsUIResource(2, 2, 2, 2), "EditorPane.border", PgsBorders.getTextFieldBorder(), "EditorPane.margin", new InsetsUIResource(2, 2, 2, 2), "TextPane.border", PgsBorders.getTextFieldBorder(), "TextPane.margin", new InsetsUIResource(2, 2, 2, 2), "Tooltip.gradientStart", color, "Tooltip.gradientEnd", color2, "ToolTip.border", BorderFactory.createLineBorder(metalTheme.getControlDarkShadow(), 1), "Table.scrollPaneBorder", PgsBorders.getComponentBorder(), "TabbedPane.background", PgsLookAndFeel.getControlShadow(), "SplitPane.border", null, "SplitPaneDivider.border", null, "OptionPane.errorIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Error.png"), "OptionPane.informationIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Inform.png"), "OptionPane.warningIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Warn.png"), "OptionPane.questionIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Question.png"), "FileView.computerIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/Computer.png"), "FileView.directoryIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.png"), "FileView.fileIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/File.png"), "FileView.floppyDriveIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.png"), "FileView.hardDriveIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.png"), "FileChooser.homeFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.png"), "FileChooser.newFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.png"), "FileChooser.upFolderIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.png"), "Tree.closedIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.png"), "Tree.openIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.png"), "Tree.leafIcon", PgsLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.png")};
        uIDefaults.putDefaults(objectArray);
        componentPlugins.processAllDefaultsEntries(uIDefaults, metalTheme);
    }

    public Icon getDisabledSelectedIcon(JComponent jComponent, Icon icon) {
        if (icon instanceof ImageIcon) {
            return PgsUtils.getDisabledButtonIcon(((ImageIcon)icon).getImage());
        }
        return null;
    }

    public static Color getGlow() {
        return UIManager.getColor("glow");
    }

    static {
        logger = Logger.getLogger("PgsLookAndFeel");
        PgsLookAndFeel.loadUserSettings();
    }
}

