/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalScrollButton;

public class PgsScrollBarButton
extends MetalScrollButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;

    public PgsScrollBarButton(int n2, int n3, boolean bl) {
        super(n2, n3, bl);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.isFreeStanding = bl;
        this.putClientProperty("rolloverBackground", UIManager.getColor("Button.rolloverBackground"));
        this.putClientProperty("pgs.isFlat", UIManager.get("Button.isFlat"));
        this.putClientProperty("gradientStart", UIManager.get("Button.gradientStart"));
        this.putClientProperty("gradientEnd", UIManager.get("Button.gradientEnd"));
        this.putClientProperty("rollover.gradientStart", UIManager.get("Button.rolloverGradientStart"));
        this.putClientProperty("rollover.gradientEnd", UIManager.get("Button.rolloverGradientEnd"));
        this.setBorder(null);
    }

    public void setFreeStanding(boolean bl) {
        super.setFreeStanding(bl);
        this.isFreeStanding = bl;
    }

    public void paint(Graphics graphics) {
        int n2;
        int n3;
        boolean bl = PgsUtils.isLeftToRight(this);
        boolean bl2 = this.getParent().isEnabled();
        boolean bl3 = this.getModel().isPressed();
        ColorUIResource colorUIResource = bl2 ? PgsLookAndFeel.getPrimaryControlDarkShadow() : PgsLookAndFeel.getControlDisabled();
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        int n6 = n5 + 1 >> 2;
        if (bl3) {
            PgsUtils.drawGradient(graphics, -1, 0, this.getWidth(), this.getHeight(), UIManager.getColor("Button.select"), UIManager.getColor("Button.select").brighter());
        } else {
            PgsUtils.drawGradient(graphics, this);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.3f, 1, 1));
        graphics.setColor(colorUIResource);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getDirection() == 1) {
            n3 = (n5 + 2 - n6) / 2 - 1;
            n2 = (n4 + 1) / 2 - 1;
            graphics2D.drawLine(n2, n3, n2 - 3, n3 + 3);
            graphics2D.drawLine(n2, n3, n2 + 3, n3 + 3);
        } else if (this.getDirection() == 5) {
            n3 = (n5 + 2 - n6) / 2 - 1;
            n2 = (n4 + 1) / 2 - 1;
            graphics2D.drawLine(n2 - 3, n3, n2, n3 + 3);
            graphics2D.drawLine(n2 + 3, n3, n2, n3 + 3);
        } else if (this.getDirection() == 3) {
            n3 = (n4 + 1 - n6) / 2;
            n2 = n5 / 2;
            graphics2D.drawLine(n3, n2 - 3, n3 + 3, n2);
            graphics2D.drawLine(n3, n2 + 3, n3 + 3, n2);
        } else if (this.getDirection() == 7) {
            n3 = (n4 + 1 - n6) / 2 - 1;
            n2 = n5 / 2;
            graphics2D.drawLine(n3, n2, n3 + 3, n2 - 3);
            graphics2D.drawLine(n3, n2, n3 + 3, n2 + 3);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        graphics2D.setStroke(stroke);
        if (this.getModel().isEnabled() && this.getModel().isRollover() && !UIManager.getBoolean("Button.rolloverVistaStyle")) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.4f, 2, 0));
            graphics.setColor(PgsLookAndFeel.getGlow());
            if (this.getDirection() == 1) {
                graphics.drawRect(2, 1, n4 - 3, n5 - 3);
            } else if (this.getDirection() == 5) {
                graphics.drawRect(2, 2, n4 - 3, n5 - 3);
            } else if (this.getDirection() == 3) {
                graphics.drawRect(2, 2, n4 - 4, n5 - 3);
            } else if (this.getDirection() == 7) {
                graphics.drawRect(1, 2, n4 - 3, n5 - 3);
            }
            graphics2D.setStroke(stroke);
        }
        graphics.setColor(bl2 ? shadowColor : PgsLookAndFeel.getControlShadow());
        if (this.getDirection() == 1) {
            JScrollPane jScrollPane;
            if (PgsUtils.isLeftToRight(this.getParent())) {
                graphics.drawLine(0, 0, 0, n5 - 1);
            } else {
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            }
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            Container container = this.getParent().getParent();
            if (container instanceof JScrollPane && (jScrollPane = (JScrollPane)container).getColumnHeader() != null) {
                graphics.drawLine(0, 0, n4 - 1, 0);
            }
        } else if (this.getDirection() == 5) {
            graphics.drawLine(0, 0, n4 - 1, 0);
            if (PgsUtils.isLeftToRight(this.getParent())) {
                graphics.drawLine(0, 0, 0, n5 - 1);
            } else {
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            }
            Container container = this.getParent().getParent();
            if (container instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                if (jScrollPane.getHorizontalScrollBar() != null && jScrollPane.getHorizontalScrollBar().isVisible()) {
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                }
            } else {
                graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            }
        } else if (this.getDirection() == 3) {
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(0, 0, 0, n5 - 1);
            Container container = this.getParent().getParent();
            if (container instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)container;
                if (jScrollPane.getVerticalScrollBar() != null && jScrollPane.getVerticalScrollBar().isVisible()) {
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
                }
            } else {
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            }
        } else if (this.getDirection() == 7) {
            graphics.drawLine(0, 0, n4 - 1, 0);
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
        }
    }

    protected void paintBorder(Graphics graphics) {
    }
}

