/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class PgsTabbedPaneUI
extends BasicTabbedPaneUI {
    private boolean paintFocus;
    private int rolloverTabIndex;
    private TabRolloverHandler tabHandler;
    private MyPropertyChangeHandler propHandler;
    private TabbedPaneMouseWheelScroller tabScrollHandler;
    private TabSelectionMouseHandler tabSelectionHandler;
    private static Logger logger = Logger.getLogger("PgsTabbedPaneUI");
    public static final String IS_SUB_TAB = "pgs.isSubTab";
    public static final String IS_BUTTON_STYLE = "pgs.isButtonStyle";
    public static final String NO_BORDER = "pgs.noBorder";
    private TabReorderHandler tabReorderingHandler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateBackgroundOpacity();
        this.paintFocus = UIManager.getBoolean("TabbedPane.focusPainted");
    }

    protected void installListeners() {
        super.installListeners();
        if (this.tabHandler == null) {
            this.tabHandler = new TabRolloverHandler();
        }
        this.tabPane.addMouseListener(this.tabHandler);
        this.tabPane.addMouseMotionListener(this.tabHandler);
        if (this.propHandler == null) {
            this.propHandler = new MyPropertyChangeHandler();
        }
        this.tabPane.addPropertyChangeListener(this.propHandler);
        if (PlafOptions.isWheelTabbedPaneEnabled()) {
            if (this.tabScrollHandler == null) {
                this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
            }
            this.tabPane.addMouseWheelListener(this.tabScrollHandler);
        }
        if (PlafOptions.isTabbedPaneRightClickSelectionEnabled()) {
            if (this.tabSelectionHandler == null) {
                this.tabSelectionHandler = new TabSelectionMouseHandler();
            }
            this.tabPane.addMouseListener(this.tabSelectionHandler);
        }
        if (PlafOptions.isTabReorderingEnabled()) {
            this.enableReordering();
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseListener(this.tabHandler);
        this.tabPane.removeMouseMotionListener(this.tabHandler);
        this.tabPane.removePropertyChangeListener(this.propHandler);
        if (this.tabScrollHandler != null) {
            this.tabPane.removeMouseWheelListener(this.tabScrollHandler);
        }
        if (this.tabSelectionHandler != null) {
            this.tabPane.removeMouseListener(this.tabSelectionHandler);
        }
        this.disableReordering();
    }

    private void updateBackgroundOpacity() {
        if (this.isSubTab() || this.isButtonStyle()) {
            this.tabPane.setOpaque(true);
            if (this.isSubTab()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.background"));
            } else if (this.isButtonStyle()) {
                this.tabPane.setBackground(UIManager.getColor("TabbedPane.buttonStyle.background"));
            }
        } else {
            this.tabPane.setOpaque(false);
        }
    }

    private boolean checkBooleanClientProperty(Object object) {
        Object object2 = this.tabPane.getClientProperty(object);
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 instanceof Integer) {
            return (Integer)object2 != 0;
        }
        logger.warning("It seems like you've used a wrong type for '" + object + "'. It should be a boolean, but is a " + object2.getClass().getName());
        return true;
    }

    private boolean isSubTab() {
        return this.checkBooleanClientProperty(IS_SUB_TAB);
    }

    private boolean isButtonStyle() {
        return this.checkBooleanClientProperty(IS_BUTTON_STYLE);
    }

    private void mySetRolloverTab(int n2, int n3) {
        this.mySetRolloverTab(this.myTabForCoordinate(this.tabPane, n2, n3));
    }

    private int myTabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        Point point = new Point(n2, n3);
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected void mySetRolloverTab(int n2) {
        if (n2 >= 0) {
            if (this.rolloverTabIndex != -1) {
                this.tabPane.repaint(this.rects[this.rolloverTabIndex]);
            }
            this.tabPane.repaint(this.rects[n2]);
        } else if (this.rolloverTabIndex != -1) {
            this.tabPane.repaint(this.rects[this.rolloverTabIndex]);
        }
        this.rolloverTabIndex = n2;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        Object object;
        Object object2;
        if (this.isButtonStyle()) {
            if (bl) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBackground"));
                graphics.fillRect(n4 + 2, n5 + 2, n6 - 4, n7 - 4);
            }
            if (n3 == this.getRolloverTab() && this.tabPane.isEnabledAt(n3)) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBackground"));
                if (bl) {
                    graphics.fillRect(n4 + 2, n5 + 2, n6 - 4, n7 - 4);
                } else {
                    graphics.fillRect(n4, n5, n6, n7);
                }
            }
            return;
        }
        if (this.isSubTab() && !bl) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setColor(UIManager.getColor("TabbedPane.selected"));
        } else {
            object2 = UIManager.getColor("TabbedPane.tabGradientStart");
            object = UIManager.getColor("TabbedPane.tabGradientEnd");
            graphics2D.setPaint(new GradientPaint(0.0f, n5 + 1, (Color)object2, 0.0f, n5 + 1 + n7, (Color)object));
        }
        switch (n2) {
            case 2: {
                graphics2D.fill(new Rectangle(n4, n5, n6 + 2, n7));
                break;
            }
            case 4: {
                graphics2D.fill(new Rectangle(n4 - 2, n5, n6 + 2, n7));
                break;
            }
            case 3: {
                graphics2D.fill(new Rectangle(n4, n5 - 2, n6, n7 + 2));
                break;
            }
            default: {
                graphics2D.fill(new Rectangle(n4, n5, n6 - 2, n7 + 2));
            }
        }
        if (!bl && n3 == this.getRolloverTab() && this.tabPane.isEnabledAt(n3)) {
            object2 = graphics2D.getRenderingHints();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(PgsLookAndFeel.getGlow());
            object = graphics2D.getStroke();
            graphics2D.setStroke(PgsUtils.rolloverBorderStroke);
            switch (n2) {
                case 2: {
                    graphics2D.drawRoundRect(n4 + 1, n5 + 1, n6 + 1, n7 - 3, 5, 5);
                    break;
                }
                case 4: {
                    graphics2D.drawRoundRect(n4 - 2, n5 + 1, n6 + 1, n7 - 2, 5, 5);
                    break;
                }
                case 3: {
                    graphics2D.drawRoundRect(n4 + 1, n5 - 2, n6 - 3, n7, 5, 5);
                    break;
                }
                default: {
                    graphics2D.drawRoundRect(n4 + 1, n5 + 1, n6 - 4, n7 + 1, 5, 5);
                }
            }
            graphics2D.setStroke((Stroke)object);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ((RenderingHints)object2).get(RenderingHints.KEY_ANTIALIASING));
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (this.isButtonStyle()) {
            if (bl) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.selectedBorder"));
                graphics.drawRect(n4 + 2, n5 + 2, n6 - 4, n7 - 4);
            }
            if (n3 == this.getRolloverTab()) {
                graphics.setColor(UIManager.getColor("TabbedPane.buttonStyle.rolloverBorder"));
                if (bl) {
                    graphics.drawRect(n4 + 2, n5 + 2, n6 - 4, n7 - 4);
                } else {
                    graphics.drawRect(n4, n5, n6, n7);
                }
            }
            return;
        }
        if (this.isSubTab() && !bl) {
            graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(PgsLookAndFeel.getControlDarkShadow());
        if (this.isSubTab()) {
            switch (n2) {
                case 2: {
                    graphics2D.drawRect(n4, n5, n6 + 2, n7);
                    break;
                }
                case 4: {
                    graphics2D.drawRect(n4 - 2, n5, n6 + 2, n7);
                    break;
                }
                case 3: {
                    graphics2D.drawRect(n4, n5 - 2, n6, n7 + 2);
                    break;
                }
                default: {
                    graphics2D.drawRect(n4, n5, n6 - 2, n7 + 2);
                    break;
                }
            }
        } else {
            switch (n2) {
                case 2: {
                    graphics2D.drawRoundRect(n4, n5, n6 + 2, n7, 5, 5);
                    break;
                }
                case 4: {
                    graphics2D.drawRoundRect(n4 - 2, n5, n6 + 2, n7, 5, 5);
                    break;
                }
                case 3: {
                    graphics2D.drawRoundRect(n4, n5 - 2, n6, n7 + 2, 5, 5);
                    break;
                }
                default: {
                    graphics2D.drawRoundRect(n4, n5, n6 - 2, n7 + 2, 5, 5);
                }
            }
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.paintFocus) {
            super.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl);
        }
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n2);
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        boolean bl = true;
        int n10 = 0;
        int n11 = 0;
        switch (n2) {
            case 2: {
                n10 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                n6 += n10;
                if (bl) {
                    n6 -= insets2.right;
                }
                n8 -= n6 - insets.left;
                break;
            }
            case 4: {
                n10 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                n8 -= n10;
                if (!bl) break;
                n8 += insets2.left;
                break;
            }
            case 3: {
                n11 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                n9 -= n11;
                if (!bl) break;
                n9 += insets2.top;
                break;
            }
            default: {
                n11 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                n7 += n11;
                if (bl) {
                    n7 -= insets2.bottom;
                }
                n9 -= n7 - insets.top;
            }
        }
        Color color = UIManager.getColor("TabbedPane.contentAreaColor");
        Color color2 = UIManager.getColor("TabbedPane.selected");
        if (color != null) {
            graphics.setColor(color);
        } else if (color2 == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(color2);
        }
        graphics.fillRect(n6, n7, n8, n9);
        if (this.checkBooleanClientProperty(NO_BORDER)) {
            return;
        }
        graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
        PgsUtils.drawRoundRect(graphics, n6, n7, n8 - 1, n9 - 1);
        if (n3 > -1 && !this.isButtonStyle()) {
            Rectangle rectangle = this.getTabBounds(n3, this.calcRect);
            graphics.setColor(UIManager.getColor("TabbedPane.selected"));
            switch (n2) {
                case 1: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.width - 2, 1);
                    if (n3 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(n6, rectangle.y + rectangle.height - 2, n6, rectangle.y + rectangle.height + 2);
                    break;
                }
                case 3: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, 1);
                    if (n3 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(n6, rectangle.y - 2, n6, rectangle.y + 2);
                    break;
                }
                case 2: {
                    graphics.fillRect(rectangle.x + rectangle.width - 2, rectangle.y + 1, 1, rectangle.height - 1);
                    if (n3 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y, rectangle.x + rectangle.width + 2, rectangle.y);
                    break;
                }
                case 4: {
                    graphics.fillRect(rectangle.x + 1, rectangle.y + 1, 1, rectangle.height - 1);
                    if (n3 != 0) break;
                    graphics.setColor(PgsLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(rectangle.x - 2, rectangle.y, rectangle.x + 2, rectangle.y);
                }
            }
        }
    }

    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl) {
        PgsUtils.installAntialiasing(graphics);
        super.paintText(graphics, n2, font, fontMetrics, n3, string, rectangle, bl);
        PgsUtils.uninstallAntialiasing(graphics);
    }

    protected JButton createScrollButton(int n2) {
        if (n2 != 5 && n2 != 1 && n2 != 3 && n2 != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(n2);
    }

    public void enableReordering() {
        if (this.tabReorderingHandler == null) {
            this.tabReorderingHandler = new TabReorderHandler();
        }
        this.tabPane.addMouseListener(this.tabReorderingHandler);
        this.tabPane.addMouseMotionListener(this.tabReorderingHandler);
    }

    public void disableReordering() {
        this.tabPane.removeMouseListener(this.tabReorderingHandler);
        this.tabPane.removeMouseMotionListener(this.tabReorderingHandler);
    }

    public class TabbedPaneMouseWheelScroller
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseWheelEvent.getSource();
            int n2 = mouseWheelEvent.getWheelRotation();
            int n3 = jTabbedPane.getSelectedIndex();
            int n4 = jTabbedPane.getTabCount() - 1;
            n3 = n3 == 0 && n2 < 0 || n3 == n4 && n2 > 0 ? n4 - n3 : (n3 += n2);
            jTabbedPane.setSelectedIndex(n3);
        }
    }

    public class SelectTabAction
    extends AbstractAction {
        private JTabbedPane tabPane;
        private int index;

        public SelectTabAction(JTabbedPane jTabbedPane, int n2) {
            super(jTabbedPane.getTitleAt(n2), jTabbedPane.getIconAt(n2));
            this.tabPane = jTabbedPane;
            this.index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tabPane.setSelectedIndex(this.index);
        }
    }

    public class TabSelectionMouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
                JPopupMenu jPopupMenu = new JPopupMenu();
                int n2 = jTabbedPane.getTabCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    jPopupMenu.add(new SelectTabAction(jTabbedPane, i2));
                }
                jPopupMenu.show(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public class TabReorderHandler
    extends MouseInputAdapter {
        private int draggedTabIndex = -1;

        protected TabReorderHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.draggedTabIndex = -1;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.draggedTabIndex == -1) {
                return;
            }
            int n2 = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n2 != -1 && n2 != this.draggedTabIndex) {
                boolean bl = n2 > this.draggedTabIndex;
                PgsTabbedPaneUI.this.tabPane.insertTab(PgsTabbedPaneUI.this.tabPane.getTitleAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getIconAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getComponentAt(this.draggedTabIndex), PgsTabbedPaneUI.this.tabPane.getToolTipTextAt(this.draggedTabIndex), bl ? n2 + 1 : n2);
                this.draggedTabIndex = n2;
                PgsTabbedPaneUI.this.tabPane.setSelectedIndex(this.draggedTabIndex);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.draggedTabIndex = PgsTabbedPaneUI.this.tabPane.getUI().tabForCoordinate(PgsTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n2) {
            super(n2, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            int n2 = this.getSize().width;
            int n3 = this.getSize().height;
            Color color = graphics.getColor();
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.isEnabled();
            if (bl2 && this.getModel().isRollover()) {
                graphics.setColor(bl ? PgsLookAndFeel.getPrimaryControlShadow() : UIManager.getColor("ToolBarButton.rolloverBackground"));
                graphics.fillRect(0, 0, n2 - 2, n3 - 2);
                graphics.setColor(UIManager.getColor("ToolBarButton.rolloverBorderColor"));
                graphics.drawRect(0, 0, n2 - 2, n3 - 2);
            }
            if (n3 < 5 || n2 < 5) {
                graphics.setColor(color);
                return;
            }
            if (bl) {
                graphics.translate(1, 1);
            }
            int n4 = Math.min((n3 - 4) / 3, (n2 - 4) / 3);
            n4 = Math.max(n4, 2);
            this.paintTriangle(graphics, (n2 - n4) / 2, (n3 - n4) / 2, n4, this.direction, bl2);
            if (bl) {
                graphics.translate(-1, -1);
            }
            graphics.setColor(color);
        }
    }

    public class MyPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (PgsTabbedPaneUI.IS_SUB_TAB.equals(propertyChangeEvent.getPropertyName()) || PgsTabbedPaneUI.IS_BUTTON_STYLE.equals(propertyChangeEvent.getPropertyName())) {
                PgsTabbedPaneUI.this.updateBackgroundOpacity();
            } else if ("wheelScrolling".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("wheelScrolling")) {
                    if (PgsTabbedPaneUI.this.tabScrollHandler == null) {
                        PgsTabbedPaneUI.this.tabScrollHandler = new TabbedPaneMouseWheelScroller();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                } else if (PgsTabbedPaneUI.this.tabScrollHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseWheelListener(PgsTabbedPaneUI.this.tabScrollHandler);
                }
            } else if ("rightClickSelection".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("rightClickSelection")) {
                    if (PgsTabbedPaneUI.this.tabSelectionHandler == null) {
                        PgsTabbedPaneUI.this.tabSelectionHandler = new TabSelectionMouseHandler();
                    }
                    PgsTabbedPaneUI.this.tabPane.addMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                } else if (PgsTabbedPaneUI.this.tabSelectionHandler != null) {
                    PgsTabbedPaneUI.this.tabPane.removeMouseListener(PgsTabbedPaneUI.this.tabSelectionHandler);
                }
            } else if ("tabReordering".equals(propertyChangeEvent.getPropertyName())) {
                if (PgsTabbedPaneUI.this.checkBooleanClientProperty("tabReordering")) {
                    PgsTabbedPaneUI.this.enableReordering();
                } else {
                    PgsTabbedPaneUI.this.disableReordering();
                }
            }
        }
    }

    protected class TabRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        protected TabRolloverHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(-1);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            PgsTabbedPaneUI.this.mySetRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

