/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.jidesoft.swing.JideSwingUtilities;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.RGBImageFilter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class PgsUtils {
    private static HashMap gpCache;
    public static Stroke borderStroke;
    public static Stroke rolloverBorderStroke;
    private static Map hintsMap;
    private static Map oldHintsMap;

    public static String createHtmlToolTip(String string) {
        Font font = UIManager.getFont("Button.font");
        return "<html><head><style type='text/css'>" + "body {padding: 5px}" + "h1 {font-size: " + font.getSize() + "pt; margin: 0 0 2px 0; padding:0; color: " + ColorUtils.toString(PgsLookAndFeel.getPrimaryControlDarkShadow()) + "}" + "p {margin-left: 15px}" + "</style></head><body>" + string + "</body>";
    }

    public static boolean isFlat(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty("pgs.isFlat"));
    }

    public static boolean isFlat(String string) {
        return Boolean.TRUE.equals(UIManager.get(string + ".isFlat"));
    }

    public static void paintSprite(Graphics graphics, int n2, int n3, int[][] nArray, Color[] colorArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                if (nArray[i2][i3] == 0) continue;
                graphics.setColor(colorArray[nArray[i2][i3] - 1]);
                graphics.drawLine(n2 + i2, n3 + i3, n2 + i2, n3 + i3);
            }
        }
    }

    public static GradientPaint getGradientPaint(int n2, int n3, int n4, int n5, Color color, Color color2) {
        long l2;
        int n6;
        Integer n7;
        GradientPaint gradientPaint;
        if (gpCache == null) {
            gpCache = new HashMap(20);
        }
        if ((gradientPaint = (GradientPaint)gpCache.get(n7 = new Integer(n6 = ((int)(l2 = Double.doubleToLongBits(n2) + Double.doubleToLongBits(n3) * 37L + Double.doubleToLongBits(n4) * 43L + Double.doubleToLongBits(n5) * 47L) ^ (int)(l2 >> 32) ^ color.hashCode() ^ color2.hashCode() * 17) * 31))) == null) {
            gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n5, color2, true);
            if (gpCache.size() > 40) {
                gpCache.clear();
            }
            gpCache.put(n7, gradientPaint);
        }
        return gradientPaint;
    }

    public static void drawGradient(Graphics graphics, int n2, int n3, Color color, Color color2) {
        PgsUtils.drawGradient(graphics, 0, 0, n2, n3, color, color2);
    }

    public static void drawGradient(Graphics graphics, int n2, int n3, int n4, int n5, Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (PlafOptions.isJideFastGradientEnabled()) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics2D, (Shape)new Rectangle(n2, n3, n4, n5), (Color)color, (Color)color2, (boolean)true);
        } else {
            graphics2D.setPaint(PgsUtils.getGradientPaint(n2, n3, n4, n5, color, color2));
            graphics2D.fill(new Rectangle(n2, n3, n4, n5));
        }
    }

    public static void drawGradient(Graphics graphics, JComponent jComponent, String string, int n2, int n3, int n4, int n5) {
        PgsUtils.drawGradient(graphics, n2, n3, n4, n5, (Color)jComponent.getClientProperty(string + ".gradientStart"), (Color)jComponent.getClientProperty(string + ".gradientEnd"));
    }

    public static void drawGradient(Graphics graphics, JComponent jComponent, String string) {
        PgsUtils.drawGradient(graphics, jComponent.getWidth(), jComponent.getHeight(), (Color)jComponent.getClientProperty(string + ".gradientStart"), (Color)jComponent.getClientProperty(string + ".gradientEnd"));
    }

    public static void drawGradient(Graphics graphics, JComponent jComponent, String string, String string2) {
        PgsUtils.drawGradient(graphics, jComponent.getWidth(), jComponent.getHeight(), (Color)jComponent.getClientProperty(string + ".gradientStart"), (Color)jComponent.getClientProperty(string2 + ".gradientEnd"));
    }

    public static void drawGradient(Graphics graphics, JComponent jComponent) {
        PgsUtils.drawGradient(graphics, jComponent.getWidth(), jComponent.getHeight(), (Color)jComponent.getClientProperty("gradientStart"), (Color)jComponent.getClientProperty("gradientEnd"));
    }

    public static void drawVistaBackground(Graphics graphics, Component component, String string) {
        PgsUtils.drawVistaBackground(graphics, 0, 0, component.getWidth(), component.getHeight(), UIManager.getColor(string + ".gradientStart"), UIManager.getColor(string + ".gradientMiddle"), UIManager.getColor(string + ".gradientEnd"));
    }

    public static void drawVistaBackground(Graphics graphics, Component component, Color color, Color color2, Color color3) {
        PgsUtils.drawVistaBackground(graphics, 0, 0, component.getWidth(), component.getHeight(), color, color2, color3);
    }

    public static void drawVistaBackground(Graphics graphics, int n2, int n3, int n4, int n5, Color color, Color color2, Color color3) {
        graphics.setColor(color);
        graphics.fillRect(n2, n3, n4, n5 / 2);
        graphics.setColor(color3);
        graphics.fillRect(n2, n3 + n5 / 2, n4, n5 / 2 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n2, n3 + n5 / 2, n4, n3 + n5 / 2);
    }

    protected static void paintMenuItemBackground(Graphics graphics, AbstractButton abstractButton, Color color, String string) {
        ButtonModel buttonModel = abstractButton.getModel();
        Color color2 = graphics.getColor();
        Dimension dimension = abstractButton.getSize();
        Insets insets = UIManager.getInsets(string + ".selectedBorderMargin");
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.right - insets.left, dimension.height - insets.top - insets.bottom - 2);
        if (abstractButton.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            if (buttonModel.isArmed() || abstractButton instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(color);
                if (PgsUtils.isFlat("MenuItem")) {
                    graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
                } else {
                    PgsUtils.drawGradient(graphics, (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight(), UIManager.getColor(string + ".gradientStart"), UIManager.getColor(string + ".gradientEnd"));
                }
                graphics.setColor(UIManager.getColor(string + ".selectedBorderColor"));
                graphics.drawRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
            }
            graphics.setColor(color2);
        }
    }

    public static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static Icon getToolBarIcon(Image image) {
        if (!PlafOptions.isToolBarIconUsed()) {
            return null;
        }
        return new IconUIResource(new ShadowedIcon(new ImageIcon(image)));
    }

    public static Icon getDisabledButtonIcon(Image image) {
        if (!PlafOptions.isDisabledIconUsed()) {
            return null;
        }
        return new IconUIResource(new ImageIcon(GrayFilter.createDisabledImage(image)));
    }

    public static void drawVerticalBumps(Graphics graphics, int n2, int n3, int n4) {
        int n5 = n4 / 6;
        for (int i2 = 0; i2 < n5; ++i2) {
            graphics.setColor(PgsLookAndFeel.getControlShadow());
            graphics.fillRect(n2, n3 + i2 * 6, 2, 2);
            graphics.fillRect(n2 + 3, 3 + n3 + i2 * 6, 2, 2);
            graphics.setColor(ColorUtils.getTranslucentColor(PgsLookAndFeel.getControl(), 180));
            graphics.fillRect(n2 + 1, 1 + n3 + i2 * 6, 2, 2);
            graphics.fillRect(n2 + 4, 4 + n3 + i2 * 6, 2, 2);
        }
    }

    public static void drawHorizontalBumps(Graphics graphics, int n2, int n3, int n4) {
        int n5 = n4 / 6;
        for (int i2 = 0; i2 < n5; ++i2) {
            graphics.setColor(PgsLookAndFeel.getControlShadow());
            graphics.fillRect(n2 + i2 * 6, n3, 2, 2);
            graphics.fillRect(3 + n2 + i2 * 6, n3 + 3, 2, 2);
            graphics.setColor(ColorUtils.getTranslucentColor(PgsLookAndFeel.getControl(), 180));
            graphics.fillRect(1 + n2 + i2 * 6, n3 + 1, 2, 2);
            graphics.fillRect(4 + n2 + i2 * 6, n3 + 4, 2, 2);
        }
    }

    public static boolean hasFocus(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                if (!PgsUtils.hasFocus(container.getComponent(i2))) continue;
                return true;
            }
        }
        return component != null && component.isFocusOwner();
    }

    public static void regenerateBorderStroke() {
        rolloverBorderStroke = PlafOptions.isClearBorderEnabled() ? new BasicStroke(2.4f, 2, 0) : new BasicStroke(2.4f, 1, 1);
    }

    public static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, Stroke stroke, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke2 = graphics2D.getStroke();
        graphics2D.setStroke(stroke);
        graphics.setColor(color);
        if (PlafOptions.isClearBorderEnabled()) {
            graphics.drawRect(n2 + 1, n3 + 1, n4 - 1, n5 - 1);
            graphics.drawLine(n2, n3, n2, n3 + n5);
        } else {
            PgsUtils.drawRoundRect(graphics, n2, n3, n4, n5);
        }
        graphics2D.setStroke(stroke2);
    }

    public static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, Color color) {
        if (PlafOptions.isClearBorderEnabled()) {
            graphics.setColor(color);
            graphics.drawRect(n2, n3, n4, n5);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(borderStroke);
            graphics.setColor(color);
            PgsUtils.drawRoundRect(graphics, n2, n3, n4, n5);
            graphics2D.setStroke(stroke);
        }
    }

    public static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        if (PlafOptions.isClearBorderEnabled()) {
            graphics.setColor(color);
            graphics.drawRect(n2, n3, n4, n5);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(borderStroke);
            graphics.setColor(color);
            PgsUtils.drawRoundRect(graphics, n2, n3, n4, n5, n6, n7);
            graphics2D.setStroke(stroke);
        }
    }

    public static void drawDefaultButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        PgsUtils.clearButtonBorder(graphics, n2, n3, n4, n5);
        PgsUtils.drawButtonBorder(graphics, n2 + 1, n3 + 1, n4 - 3, n5 - 3, borderStroke, PgsLookAndFeel.getPrimaryControlShadow());
        if (bl) {
            PgsUtils.drawRolloverButtonBorder(graphics, n2 + 1, n3 + 1, n4 - 3, n5 - 3);
        }
        PgsUtils.drawButtonBorder(graphics, n2, n3, n4 - 1, n5 - 1, PgsLookAndFeel.getPrimaryControlDarkShadow());
    }

    public static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        PgsUtils.clearButtonBorder(graphics, n2, n3, n4, n5);
        PgsUtils.drawButtonBorder(graphics, n2, n3, n4 - 1, n5 - 1, PgsLookAndFeel.getControlDarkShadow());
    }

    public static void drawRolloverButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (UIManager.getBoolean("Button.rolloverVistaStyle")) {
            PgsUtils.drawButtonBorder(graphics, n2, n3, n4 - 1, n5 - 1, PgsLookAndFeel.getGlow());
        } else {
            PgsUtils.drawButtonBorder(graphics, n2 + 1, n3 + 1, n4 - 3, n5 - 3, rolloverBorderStroke, PgsLookAndFeel.getGlow());
            PgsUtils.drawButtonBorder(graphics, n2, n3, n4, n5);
        }
    }

    private static void clearButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        if (PlafOptions.isClearBorderEnabled()) {
            return;
        }
        graphics.setColor(UIManager.getColor("Panel.background"));
        graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
    }

    public static void drawDisabledBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        PgsUtils.drawDisabledBorder(graphics, n2, n3, n4, n5, 4, 4);
    }

    public static void drawDisabledBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        PgsUtils.clearButtonBorder(graphics, n2, n3, n4, n5);
        graphics.setColor(PgsLookAndFeel.getControlShadow());
        if (PlafOptions.isClearBorderEnabled()) {
            graphics.drawRect(n2, n3, n4, n5);
        } else {
            PgsUtils.drawRoundRect(graphics, n2, n3, n4, n5, n6, n7);
        }
    }

    public static void drawRoundRect(Graphics graphics, int n2, int n3, int n4, int n5) {
        PgsUtils.drawRoundRect(graphics, n2, n3, n4, n5, 4, 4);
    }

    public static void drawRoundRect(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawRoundRect(n2, n3, n4, n5, n6, n7);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public static void installAntialiasing(Graphics graphics) {
        if (!PlafOptions.isAntialiasingEnabled()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            oldHintsMap = new HashMap();
            oldHintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, graphics2D.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
            oldHintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
            oldHintsMap.put(RenderingHints.KEY_ANTIALIASING, graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        }
        graphics2D.addRenderingHints(hintsMap);
    }

    public static void uninstallAntialiasing(Graphics graphics) {
        if (!PlafOptions.isAntialiasingEnabled()) {
            return;
        }
        ((Graphics2D)graphics).addRenderingHints(oldHintsMap);
    }

    public static void fixHtmlDisplay(JComponent jComponent) {
        Font font = UIManager.getFont("Button.font");
        String string = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}";
        try {
            HTMLDocument hTMLDocument = null;
            if (jComponent instanceof JEditorPane) {
                if (((JEditorPane)jComponent).getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)((JEditorPane)jComponent).getDocument();
                }
            } else {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null && view.getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)view.getDocument();
                }
            }
            if (hTMLDocument != null) {
                hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        borderStroke = new BasicStroke(1.3f, 1, 1);
        rolloverBorderStroke = new BasicStroke(2.4f, 1, 1);
    }

    private static class ToolBarImageFilter
    extends RGBImageFilter {
        public ToolBarImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n2, int n3, int n4) {
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            int n8 = Math.max(Math.max(n5, n6), n7);
            return n4 & 0xFF000000 | n8 << 16 | n8 << 8 | n8 << 0;
        }
    }

    public static class ShadowedIcon
    implements Icon {
        private int shadowWidth = 2;
        private int shadowHeight = 2;
        private Icon icon;
        private Icon shadow;

        public ShadowedIcon(Icon icon) {
            this.icon = icon;
            this.shadow = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        public ShadowedIcon(Icon icon, int n2, int n3) {
            this(icon);
            this.shadowWidth = n2;
            this.shadowHeight = n3;
        }

        public int getIconHeight() {
            return this.icon.getIconWidth() + this.shadowWidth;
        }

        public int getIconWidth() {
            return this.icon.getIconHeight() + this.shadowHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            this.shadow.paintIcon(component, graphics, n2 + this.shadowWidth, n3 + this.shadowHeight);
            this.icon.paintIcon(component, graphics, n2, n3);
        }
    }
}

