/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsTheme;
import com.pagosoft.plaf.themes.ElegantGrayTheme;
import com.pagosoft.plaf.themes.SilverTheme;
import com.pagosoft.plaf.themes.VistaTheme;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class ThemeFactory {
    public static final PgsTheme GRAY = ThemeFactory.createTheme("Gray", new Color(7968721), new Color(0xABABAB), Color.black);
    public static final PgsTheme YELLOW = ThemeFactory.createTheme("Yellow", new Color(13412947), new Color(0xABABAB), Color.black);
    public static final PgsTheme RUBY = ThemeFactory.createTheme("Ruby", new Color(244, 10, 66), new Color(0xABABAB), Color.black);
    public static final PgsTheme GOLD = ThemeFactory.createTheme("Gold", new Color(16767785));
    public static final PgsTheme WIN = new PgsTheme("Win", new Color(6324396), new Color(16764721), new Color(16375945), new Color(0x666554), new Color(0xDCDBCB), new Color(15855843), Color.black, Color.white, ThemeFactory.getWinCustomEntries());
    public static final PgsTheme GREEN = ThemeFactory.createTheme("Green", new Color(9988167), new Color(15723495), Color.BLACK);
    private static final Pattern SPLIT = Pattern.compile("\\s*,?\\s*");

    private static Object[] getWinCustomEntries() {
        Color color = new Color(0xDCDBCB);
        Color color2 = new Color(15855843);
        Color color3 = new Color(16375945);
        Color color4 = new Color(16764721);
        return new Object[]{"Button.rolloverGradientStart", Color.white, "Button.rolloverGradientEnd", color, "Button.selectedGradientStart", color4, "Button.selectedGradientEnd", color3, "ToggleButton.rolloverGradientStart", Color.white, "ToggleButton.rolloverGradientEnd", color, "ToggleButton.selectedGradientStart", color4, "ToggleButton.selectedGradientEnd", color3, "ToolBar.gradientStart", color2, "ToolBar.gradientEnd", color, "ToolBarButton.rolloverGradientStart", color4, "ToolBarButton.rolloverGradientEnd", color3, "ToolBarButton.selectedGradientStart", color3, "ToolBarButton.selectedGradientEnd", color4, "ScrollBar.thumb", color4, "ScrollBar.thumbHighlight", color4.brighter(), "ProgressBar.gradientStart", color4, "ProgressBar.gradientEnd", color4.brighter()};
    }

    public static PgsTheme createTheme(Color color) {
        return ThemeFactory.createTheme("PgsTheme", color);
    }

    public static PgsTheme createTheme(String string, Color color) {
        Color[] colorArray = ColorUtils.mixColors(color);
        return new PgsTheme(string, colorArray[2], colorArray[1], colorArray[0], colorArray[5], colorArray[4], colorArray[3], colorArray[8], colorArray[7]);
    }

    public static PgsTheme createTheme(Color color, Color color2, Color color3) {
        return ThemeFactory.createTheme("Custom PgsTheme", color, color2, color3);
    }

    public static PgsTheme getDefaultTheme() {
        return new SilverTheme();
    }

    public static PgsTheme createTheme(String string, Color color, Color color2, Color color3) {
        return new PgsTheme(string, color.darker(), color, color.brighter(), color2.darker(), color2, color2.brighter(), color3, ColorUtils.oposite(color3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PgsTheme getTheme(String string) {
        if (string == null) {
            throw new IllegalArgumentException("theme must not be null!");
        }
        if (string.startsWith("theme:")) {
            String string2 = string.substring(5).trim();
            return ThemeFactory.getThemeByName(string2);
        }
        if (string.startsWith("colors:")) {
            String string3 = string.substring(6).trim();
            return ThemeFactory.getThemeByColors(string3);
        }
        if (string.startsWith("res:")) {
            String string4 = string.substring(4).trim();
            File file = new File(string4);
            if (file.exists()) {
                Properties properties = new Properties();
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    PgsTheme pgsTheme = ThemeFactory.createTheme(properties);
                    return pgsTheme;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    PgsTheme pgsTheme = ThemeFactory.getDefaultTheme();
                    return pgsTheme;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            return ThemeFactory.getDefaultTheme();
        }
        if (string.length() > 0) {
            return ThemeFactory.getThemeByName(string);
        }
        return ThemeFactory.getDefaultTheme();
    }

    public static PgsTheme getThemeByName(String string) {
        if ("ruby".equals(string = string.toLowerCase())) {
            return RUBY;
        }
        if ("win".equals(string)) {
            return WIN;
        }
        if ("yellow".equals(string)) {
            return YELLOW;
        }
        if ("gold".equals(string)) {
            return GOLD;
        }
        if ("gray".equals(string)) {
            return GRAY;
        }
        if ("green".equals(string)) {
            return GREEN;
        }
        if ("elegantgray".equals(string)) {
            return ElegantGrayTheme.getInstance();
        }
        if ("silver".equals(string)) {
            return new SilverTheme();
        }
        if ("vista".equals(string)) {
            return new VistaTheme();
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (PgsTheme.class.isAssignableFrom(clazz)) {
                return (PgsTheme)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return ThemeFactory.getDefaultTheme();
    }

    public static PgsTheme getThemeByColors(String string) {
        String[] stringArray = string.split(",?\\s*");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Theme has the wrong format: '" + string + "', but should be '[primary], [secondary], [text]'");
        }
        return ThemeFactory.createTheme(Color.decode(stringArray[0]), Color.decode(stringArray[1]), Color.decode(stringArray[2]));
    }

    public static PgsTheme createTheme(Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = map.keySet().iterator();
        String string = "Custom PgsTheme";
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        Color color5 = null;
        Color color6 = null;
        Color color7 = Color.black;
        Color color8 = Color.white;
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            String string3 = map.get(string2).toString();
            if (string2.equals("name")) {
                string = string3;
                continue;
            }
            if (string2.equals("primary1")) {
                color = Color.decode(string3);
                continue;
            }
            if (string2.equals("primary2")) {
                color2 = Color.decode(string3);
                continue;
            }
            if (string2.equals("primary3")) {
                color3 = Color.decode(string3);
                continue;
            }
            if (string2.equals("secondary1")) {
                color4 = Color.decode(string3);
                continue;
            }
            if (string2.equals("secondary2")) {
                color5 = Color.decode(string3);
                continue;
            }
            if (string2.equals("secondary3")) {
                color6 = Color.decode(string3);
                continue;
            }
            if (string2.equals("black")) {
                color7 = Color.decode(string3);
                continue;
            }
            if (string2.equals("white")) {
                color8 = Color.decode(string3);
                continue;
            }
            if (string2.startsWith("pgs.") || string2.startsWith("swing.")) continue;
            arrayList.add(string2);
            if (string3.startsWith("#")) {
                arrayList.add(Color.decode(string3));
                continue;
            }
            if (string3.equals("true")) {
                arrayList.add(Boolean.TRUE);
                continue;
            }
            if (string3.equals("false")) {
                arrayList.add(Boolean.FALSE);
                continue;
            }
            String[] stringArray = SPLIT.split(string3);
            switch (stringArray.length) {
                case 1: {
                    int n2 = Integer.parseInt(stringArray[0]);
                    arrayList.add(new Insets(n2, n2, n2, n2));
                    break;
                }
                case 2: {
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    arrayList.add(new Insets(n3, n4, n3, n4));
                    break;
                }
                case 4: {
                    arrayList.add(new Insets(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3])));
                }
            }
        }
        if (color != null && color2 != null && color3 != null && color4 != null && color5 != null && color6 != null) {
            return new PgsTheme(string, color, color2, color3, color4, color5, color6, color7, color8, arrayList.toArray());
        }
        return ThemeFactory.getDefaultTheme();
    }
}

