/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.swing;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;

public class ColorUtils {
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public static Color toColor(String string) {
        switch (string.charAt(0)) {
            case '(': {
                int n2 = ColorUtils.nextColorInt(string, 1);
                int n3 = string.indexOf(44);
                int n4 = ColorUtils.nextColorInt(string, n3 + 1);
                n3 = string.indexOf(44, n3 + 1);
                int n5 = ColorUtils.nextColorInt(string, n3 + 1);
                return new Color(n2, n4, n5);
            }
            case '#': {
                if (string.length() == 4) {
                    return new Color(ColorUtils.getShorthandValue(string.charAt(1)), ColorUtils.getShorthandValue(string.charAt(2)), ColorUtils.getShorthandValue(string.charAt(3)));
                }
                return new Color(Integer.parseInt(string.substring(1), 16));
            }
        }
        if (Character.isDigit(string.charAt(0))) {
            int n6 = ColorUtils.nextColorInt(string, 0);
            int n7 = string.indexOf(44);
            int n8 = ColorUtils.nextColorInt(string, n7 + 1);
            n7 = string.indexOf(44, n7 + 1);
            int n9 = ColorUtils.nextColorInt(string, n7 + 1);
            return new Color(n6, n8, n9);
        }
        return (Color)colorNamesMap.get(string);
    }

    private static int nextColorInt(String string, int n2) {
        char c2;
        int n3;
        while (n2 < string.length() && (48 > (n3 = (int)string.charAt(n2)) || n3 > 57)) {
            ++n2;
        }
        for (n3 = n2; n3 < n2 + 3 && (c2 = string.charAt(n3)) >= '0' && '9' >= c2; ++n3) {
        }
        return Integer.parseInt(string.substring(n2, n3));
    }

    private static int getShorthandValue(char c2) {
        if ('A' <= (c2 = Character.toUpperCase(c2)) && c2 <= 'F') {
            return colorShorthandTable[c2 - 65 + 10];
        }
        return colorShorthandTable[c2 - 48];
    }

    public static Color oposite(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color subtract(Color color, Color color2) {
        return new Color(Math.max(0, Math.min(255, color.getRed() - color2.getRed())), Math.max(0, Math.min(255, color.getGreen() - color2.getGreen())), Math.max(0, Math.min(255, color.getBlue() - color2.getBlue())));
    }

    public static String toString(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF).toUpperCase();
        return "#000000".substring(0, 7 - string.length()).concat(string);
    }

    public static Color getTranslucentColor(Color color, int n2) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
    }

    public static Color getSimiliarColor(Color color, float f2) {
        return new Color(ColorUtils.between((int)((float)color.getRed() * f2), 0, 255), ColorUtils.between((int)((float)color.getGreen() * f2), 0, 255), ColorUtils.between((int)((float)color.getBlue() * f2), 0, 255), color.getAlpha());
    }

    private static int between(int n2, int n3, int n4) {
        return Math.max(n3, Math.min(n2, n4));
    }

    public static Color getColor(Color color, float f2) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return Color.getHSBColor(fArray[0], fArray[1], fArray[2] * f2);
    }

    public static Color[] mixColors(Color color) {
        Color[] colorArray = new Color[9];
        colorArray[0] = color;
        double[] dArray = ColorUtils.RGBtoHSV(color);
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        dArray4[0] = dArray2[0] = dArray[0];
        dArray4[1] = dArray2[1] = dArray[1];
        if (dArray[2] > 70.0) {
            dArray2[2] = dArray[2] - 30.0;
            dArray4[2] = dArray[2] - 15.0;
        } else {
            dArray2[2] = dArray[2] + 30.0;
            dArray4[2] = dArray[2] + 15.0;
        }
        colorArray[1] = ColorUtils.HSVtoRGB(dArray4);
        colorArray[2] = ColorUtils.HSVtoRGB(dArray2);
        if (dArray[0] >= 0.0 && dArray[0] < 30.0) {
            dArray3[0] = dArray2[0] = dArray[0] + 20.0;
            dArray5[0] = dArray2[0];
            dArray3[1] = dArray2[1] = dArray[1];
            dArray5[1] = dArray2[1];
            dArray2[2] = dArray[2];
            if (dArray[2] > 70.0) {
                dArray3[2] = dArray[2] - 30.0;
                dArray5[2] = dArray[2] - 15.0;
            } else {
                dArray3[2] = dArray[2] + 30.0;
                dArray5[2] = dArray[2] + 15.0;
            }
        }
        if (dArray[0] >= 30.0 && dArray[0] < 60.0) {
            dArray3[0] = dArray2[0] = dArray[0] + 150.0;
            dArray5[0] = dArray2[0];
            dArray2[1] = ColorUtils.minMax(dArray[1] - 30.0, 0.0, 100.0);
            dArray2[2] = ColorUtils.minMax(dArray[2] - 20.0, 0.0, 100.0);
            dArray5[1] = dArray3[1] = ColorUtils.minMax(dArray[1] - 70.0, 0.0, 100.0);
            dArray3[2] = ColorUtils.minMax(dArray[2] + 20.0, 0.0, 100.0);
            dArray5[2] = dArray[2];
        }
        if (dArray[0] >= 60.0 && dArray[0] < 180.0) {
            dArray3[0] = dArray2[0] = dArray[0] - 40.0;
            dArray5[0] = dArray2[0];
            dArray3[1] = dArray2[1] = dArray[1];
            dArray5[1] = dArray2[1];
            dArray2[2] = dArray[2];
            if (dArray[2] > 70.0) {
                dArray3[2] = dArray[2] - 30.0;
                dArray5[2] = dArray[2] - 15.0;
            } else {
                dArray3[2] = dArray[2] + 30.0;
                dArray5[2] = dArray[2] + 15.0;
            }
        }
        if (dArray[0] >= 180.0 && dArray[0] < 220.0) {
            dArray5[0] = dArray3[0] = dArray[0] - 170.0;
            dArray2[0] = dArray[0] - 160.0;
            dArray3[1] = dArray2[1] = dArray[1];
            dArray5[1] = dArray2[1];
            dArray2[2] = dArray[2];
            if (dArray[2] > 70.0) {
                dArray3[2] = dArray[2] - 30.0;
                dArray5[2] = dArray[2] - 15.0;
            } else {
                dArray3[2] = dArray[2] + 30.0;
                dArray5[2] = dArray[2] + 15.0;
            }
        }
        if (dArray[0] >= 220.0 && dArray[0] < 300.0) {
            dArray3[0] = dArray2[0] = dArray[0];
            dArray5[0] = dArray2[0];
            dArray3[1] = dArray2[1] = ColorUtils.minMax(dArray[1] - 60.0, 0.0, 100.0);
            dArray5[1] = dArray2[1];
            dArray2[2] = dArray[2];
            if (dArray[2] > 70.0) {
                dArray3[2] = dArray[2] - 30.0;
                dArray5[2] = dArray[2] - 15.0;
            } else {
                dArray3[2] = dArray[2] + 30.0;
                dArray5[2] = dArray[2] + 15.0;
            }
        }
        if (dArray[0] >= 300.0) {
            if (dArray[1] > 50.0) {
                dArray3[1] = dArray2[1] = dArray[1] - 40.0;
                dArray5[1] = dArray2[1];
            } else {
                dArray3[1] = dArray2[1] = dArray[1] + 40.0;
                dArray5[1] = dArray2[1];
            }
            dArray3[0] = dArray2[0] = (dArray[0] + 20.0) % 360.0;
            dArray5[0] = dArray2[0];
            dArray2[2] = dArray[2];
            if (dArray[2] > 70.0) {
                dArray3[2] = dArray[2] - 30.0;
                dArray5[2] = dArray[2] - 15.0;
            } else {
                dArray3[2] = dArray[2] + 30.0;
                dArray5[2] = dArray[2] + 15.0;
            }
        }
        colorArray[3] = ColorUtils.HSVtoRGB(dArray2);
        colorArray[4] = ColorUtils.HSVtoRGB(dArray5);
        colorArray[5] = ColorUtils.HSVtoRGB(dArray3);
        dArray2[1] = 0.0;
        dArray2[0] = 0.0;
        dArray2[2] = 100.0 - dArray[2];
        colorArray[6] = ColorUtils.HSVtoRGB(dArray2);
        dArray2[2] = dArray[2];
        colorArray[7] = ColorUtils.HSVtoRGB(dArray2);
        dArray5[1] = 0.0;
        dArray5[0] = 0.0;
        dArray5[2] = dArray[2] >= 50.0 ? 0.0 : 100.0;
        colorArray[8] = ColorUtils.HSVtoRGB(dArray5);
        return colorArray;
    }

    private static double minMax(double d2, double d3, double d4) {
        if (d2 > d4) {
            return d4;
        }
        if (d2 < d3) {
            return d3;
        }
        return d2;
    }

    public static Color HSVtoRGB(double[] dArray) {
        if (dArray == null || dArray.length != 3) {
            throw new IllegalArgumentException("data must be an array of 3 items and must not be null!");
        }
        return ColorUtils.HSVtoRGB(dArray[0], dArray[1], dArray[2]);
    }

    public static Color HSVtoRGB(double d2, double d3, double d4) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (d3 == 0.0) {
            n3 = n4 = (int)Math.round(d4 * 2.55);
            n2 = n4;
        } else {
            double d5 = Math.floor(d2 /= 60.0);
            double d6 = d2 - d5;
            int n5 = (int)Math.round(255.0 * ((d4 /= 100.0) * (1.0 - (d3 /= 100.0))));
            int n6 = (int)Math.round(255.0 * (d4 * (1.0 - d3 * d6)));
            int n7 = (int)Math.round(255.0 * (d4 * (1.0 - d3 * (1.0 - d6))));
            int n8 = (int)Math.round(255.0 * d4);
            switch ((int)d5) {
                case 0: {
                    n2 = n8;
                    n3 = n7;
                    n4 = n5;
                    break;
                }
                case 1: {
                    n2 = n6;
                    n3 = n8;
                    n4 = n5;
                    break;
                }
                case 2: {
                    n2 = n5;
                    n3 = n8;
                    n4 = n7;
                    break;
                }
                case 3: {
                    n2 = n5;
                    n3 = n6;
                    n4 = n8;
                    break;
                }
                case 4: {
                    n2 = n7;
                    n3 = n5;
                    n4 = n8;
                    break;
                }
                default: {
                    n2 = n8;
                    n3 = n5;
                    n4 = n6;
                }
            }
        }
        return new Color(n2, n3, n4);
    }

    public static double[] RGBtoHSV(Color color) {
        double d2;
        double[] dArray = new double[3];
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = Math.min(Math.min(n2, n3), n4);
        int n6 = Math.max(Math.max(n2, n3), n4);
        int n7 = n6 - n5;
        double d3 = 0.0;
        double d4 = 100 * n6 / 255;
        if (n7 == 0) {
            d2 = 0.0;
            d3 = 0.0;
        } else {
            d2 = 100 * n7 / n6;
            double d5 = 100 * ((n6 - n2) / 6 + n6 / 2) / n7;
            double d6 = 100 * ((n6 - n3) / 6 + n6 / 2) / n7;
            double d7 = 100 * ((n6 - n4) / 6 + n6 / 2) / n7;
            if (n2 == n6) {
                d3 = 60 * (n3 - n4) / n7;
            } else if (n3 == n6) {
                d3 = 120 + 60 * (n4 - n2) / n7;
            } else if (n4 == n6) {
                d3 = 240 + 60 * (n2 - n3) / n7;
            }
            if (d3 < 0.0) {
                d3 += 360.0;
            }
        }
        dArray[0] = d3;
        dArray[1] = d2;
        dArray[2] = d4;
        return dArray;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }
}

