/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.javasound.JSAuralParameters;
import com.sun.j3d.audioengines.javasound.JSClip;
import com.sun.j3d.audioengines.javasound.JSDirectionalSample;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import com.sun.j3d.audioengines.javasound.JSSample;
import com.sun.j3d.audioengines.javasound.JSStream;
import com.sun.j3d.audioengines.javasound.JSThread;
import java.util.ArrayList;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class JavaSoundMixer
extends AudioEngine3DL2 {
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    JSAuralParameters auralParams = null;
    JSThread thread = new JSThread(Thread.currentThread().getThreadGroup(), this);
    protected float deviceGain = 1.0f;
    protected static final int NOT_PAUSED = 0;
    protected static final int PAUSE_PENDING = 1;
    protected static final int PAUSED = 2;
    protected static final int RESUME_PENDING = 3;
    protected int pause = 0;

    void debugPrint(String string) {
    }

    void debugPrintln(String string) {
    }

    public JavaSoundMixer(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
    }

    public int getTotalChannels() {
        if (this.thread != null) {
            return this.thread.getTotalChannels();
        }
        return 32;
    }

    public boolean initialize() {
        if (this.thread == null) {
            return false;
        }
        this.thread.initialize();
        this.auralParams = new JSAuralParameters();
        return true;
    }

    public boolean close() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareSound(int n2, MediaContainer mediaContainer) {
        int n3 = -1;
        int n4 = 1;
        if (mediaContainer == null) {
            return -1;
        }
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            int n5;
            n3 = n5 = this.samples.size();
            this.samples.ensureCapacity(n3 + 1);
            boolean bl = false;
            if (n2 == 3) {
                JSDirectionalSample jSDirectionalSample = new JSDirectionalSample();
                bl = jSDirectionalSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n4 == 2) {
                    this.samples.set(n3, jSDirectionalSample);
                } else {
                    this.samples.add(n3, jSDirectionalSample);
                }
                jSDirectionalSample.setDirtyFlags(65535);
                jSDirectionalSample.setSoundType(n2);
                jSDirectionalSample.setSoundData(mediaContainer);
            } else if (n2 == 2) {
                JSPositionalSample jSPositionalSample = new JSPositionalSample();
                bl = jSPositionalSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n4 == 2) {
                    this.samples.set(n3, jSPositionalSample);
                } else {
                    this.samples.add(n3, jSPositionalSample);
                }
                jSPositionalSample.setDirtyFlags(65535);
                jSPositionalSample.setSoundType(n2);
                jSPositionalSample.setSoundData(mediaContainer);
            } else {
                JSSample jSSample = null;
                jSSample = new JSSample();
                bl = jSSample.load(mediaContainer);
                if (bl) {
                    return -1;
                }
                if (n4 == 2) {
                    this.samples.set(n3, jSSample);
                } else {
                    this.samples.add(n3, jSSample);
                }
                jSSample.setDirtyFlags(65535);
                jSSample.setSoundType(n2);
                jSSample.setSoundData(mediaContainer);
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSound(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        jSSample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(n2, null);
        }
    }

    public void setVworldXfrm(int n2, Transform3D transform3D) {
        super.setVworldXfrm(n2, transform3D);
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        int n3 = jSSample.getSoundType();
        if (n3 == 3) {
            JSDirectionalSample jSDirectionalSample = null;
            jSDirectionalSample = (JSDirectionalSample)this.getSample(n2);
            if (jSDirectionalSample == null) {
                return;
            }
            jSDirectionalSample.setXformedDirection();
            jSDirectionalSample.setXformedPosition();
            jSDirectionalSample.setVWrldXfrmFlag(true);
        } else if (n3 == 2) {
            JSPositionalSample jSPositionalSample = null;
            jSPositionalSample = (JSPositionalSample)this.getSample(n2);
            if (jSPositionalSample == null) {
                return;
            }
            jSPositionalSample.setXformedPosition();
            jSPositionalSample.setVWrldXfrmFlag(true);
        }
    }

    public void setPosition(int n2, Point3d point3d) {
        super.setPosition(n2, point3d);
        JSPositionalSample jSPositionalSample = null;
        jSPositionalSample = (JSPositionalSample)this.getSample(n2);
        if (jSPositionalSample == null) {
            return;
        }
        int n3 = jSPositionalSample.getSoundType();
        if (n3 == 2 || n3 == 3) {
            jSPositionalSample.setXformedPosition();
        }
    }

    public void setDirection(int n2, Vector3d vector3d) {
        super.setDirection(n2, vector3d);
        JSDirectionalSample jSDirectionalSample = null;
        jSDirectionalSample = (JSDirectionalSample)this.getSample(n2);
        if (jSDirectionalSample == null) {
            return;
        }
        int n3 = jSDirectionalSample.getSoundType();
        if (n3 == 3) {
            jSDirectionalSample.setXformedDirection();
        }
    }

    public void setReflectionCoefficient(float f2) {
        super.setReflectionCoefficient(f2);
        this.auralParams.reverbDirty |= JSAuralParameters.REFLECTION_COEFF_CHANGED;
    }

    public void setReverbDelay(float f2) {
        super.setReverbDelay(f2);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_DELAY_CHANGED;
    }

    public void setReverbOrder(int n2) {
        super.setReverbOrder(n2);
        this.auralParams.reverbDirty |= JSAuralParameters.REVERB_ORDER_CHANGED;
    }

    public int startSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null || this.thread == null) {
            return -1;
        }
        int n3 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            this.thread.muteSample(jSSample);
            if (n3 != 1) {
                this.setFilter(n2, false, -1.0f);
            }
        } else {
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), this.auralParams);
            this.scaleSampleRate(n2, jSSample.rateRatio);
            if (n3 != 1) {
                this.setFilter(n2, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
        }
        boolean bl2 = this.thread.startSample(jSSample);
        jSSample.channel.startSample(jSSample.getLoopCount(), jSSample.getGain(), 0);
        if (!bl2) {
            return -1;
        }
        if (!bl) {
            if (this.auralParams.reverbDirty > 0) {
                float f2 = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(jSSample);
            }
            this.setReverb(jSSample);
        }
        return n2;
    }

    public int stopSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return -1;
        }
        int n3 = jSSample.getDataType();
        int n4 = jSSample.getSoundType();
        boolean bl = true;
        bl = this.thread.stopSample(jSSample);
        jSSample.channel.stopSample();
        if (!bl) {
            return -1;
        }
        jSSample.reset();
        return 0;
    }

    public void pauseSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        this.thread.pauseSample(jSSample);
    }

    public void unpauseSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        this.thread.unpauseSample(jSSample);
    }

    public void updateSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null || this.thread == null) {
            return;
        }
        int n3 = jSSample.getSoundType();
        boolean bl = jSSample.getMuteFlag();
        if (bl) {
            if (n3 != 1) {
                this.setFilter(n2, false, -1.0f);
            }
            this.thread.muteSample(jSSample);
        } else {
            float f2;
            if (this.auralParams.reverbDirty > 0) {
                f2 = this.auralParams.reverbDelay * this.auralParams.rolloff;
                this.calcReverb(jSSample);
            }
            this.setReverb(jSSample);
            f2 = 0.0f;
            if (!bl && this.auralParams.reverbFlag) {
                f2 = jSSample.getGain() * this.auralParams.reflectionCoefficient;
            }
            jSSample.render(jSSample.getDirtyFlags(), this.getView(), this.auralParams);
            if (n3 != 1) {
                this.setFilter(n2, jSSample.getFilterFlag(), jSSample.getFilterFreq());
            }
            this.thread.setSampleGain(jSSample, this.auralParams);
            this.thread.setSampleRate(jSSample, this.auralParams);
            this.thread.setSampleDelay(jSSample, this.auralParams);
        }
    }

    public void muteSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        jSSample.setMuteFlag(true);
        this.thread.muteSample(jSSample);
    }

    public void unmuteSample(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        jSSample.setMuteFlag(false);
        this.auralParams.reverbDirty = 65535;
        jSSample.setDirtyFlags(65535);
        this.thread.unmuteSample(jSSample);
    }

    public long getSampleDuration(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return -1L;
        }
        long l2 = jSSample != null ? jSSample.getDuration() : -1L;
        return l2;
    }

    public int getNumberOfChannelsUsed(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return 0;
        }
        return this.getNumberOfChannelsUsed(n2, jSSample.getMuteFlag());
    }

    public int getNumberOfChannelsUsed(int n2, boolean bl) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return 0;
        }
        int n3 = jSSample.getSoundType();
        int n4 = jSSample.getDataType();
        if (n4 == 3 || n4 == 3) {
            return 1;
        }
        if (n3 == 1) {
            return 1;
        }
        return 3;
    }

    public long getStartTime(int n2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return 0L;
        }
        if (jSSample.channel == null) {
            return 0L;
        }
        return jSSample.channel.startTime;
    }

    void scaleSampleRate(int n2, float f2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null || this.thread == null) {
            return;
        }
        int n3 = jSSample.getDataType();
        int n4 = jSSample.getSoundType();
        if (n3 == 1 || n3 == 2) {
            this.thread.setSampleRate(jSSample, f2);
        } else if (n3 == 3 || n3 == 3) {
            this.thread.setSampleRate(jSSample, f2);
        }
    }

    void calcReverb(JSSample jSSample) {
        int n2 = jSSample.getDataType();
        int n3 = jSSample.getSoundType();
        float f2 = this.auralParams.decayTime;
        float f3 = this.auralParams.reverbDelay * this.auralParams.rolloff;
        float f4 = this.auralParams.reflectionCoefficient;
        int n4 = this.auralParams.reverbOrder;
        if (this.auralParams.reflectionCoefficient == 0.0f || this.auralParams.reverbCoefficient == 0.0f) {
            this.auralParams.reverbFlag = false;
        } else {
            float f5;
            this.auralParams.reverbFlag = true;
            if (n4 > 0 && (f5 = (float)n4 * f3) < f2) {
                f2 = f5;
            }
            this.auralParams.reverbType = f3 < 100.0f ? (f2 <= 1500.0f ? 2 : 4) : (f3 < 500.0f ? (f2 <= 1500.0f ? 3 : 6) : (f2 <= 1500.0f ? 6 : 5));
        }
        this.auralParams.reverbDirty = 0;
    }

    void setReverb(JSSample jSSample) {
        int n2 = jSSample.getSoundType();
        int n3 = jSSample.getDataType();
        if (n2 == 3 || n2 == 2) {
            if (jSSample == null) {
                return;
            }
            JSPositionalSample jSPositionalSample = (JSPositionalSample)jSSample;
            if (jSPositionalSample.channel == null) {
                return;
            }
            if (n3 == 1) {
                JSStream jSStream = (JSStream)jSPositionalSample.channel;
                jSStream.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            } else if (n3 == 2) {
                JSClip jSClip = (JSClip)jSPositionalSample.channel;
                jSClip.setSampleReverb(this.auralParams.reverbType, this.auralParams.reverbFlag);
            }
        }
    }

    public void setLoop(int n2, int n3) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        int n4 = jSSample.getDataType();
        if ((n4 == 1 || n4 == 2) && n3 == -1) {
            n3 = 0x7FFFFFF;
        }
        super.setLoop(n2, n3);
    }

    void setFilter(int n2, boolean bl, float f2) {
        JSPositionalSample jSPositionalSample = null;
        jSPositionalSample = (JSPositionalSample)this.getSample(n2);
        if (jSPositionalSample == null) {
            return;
        }
        if (jSPositionalSample.channel == null) {
            return;
        }
        int n3 = jSPositionalSample.getDataType();
        if (n3 == 3 || n3 == 3) {
            return;
        }
        if (n3 == 2) {
            JSClip jSClip = (JSClip)jSPositionalSample.channel;
            jSClip.setSampleFiltering(bl, f2);
        } else {
            JSStream jSStream = (JSStream)jSPositionalSample.channel;
            jSStream.setSampleFiltering(bl, f2);
        }
    }

    public void setGain(float f2) {
        float f3 = this.deviceGain;
        float f4 = f2 / f3;
        this.deviceGain = f2;
    }

    public void setRateScaleFactor(int n2, float f2) {
        JSSample jSSample = null;
        jSSample = (JSSample)this.getSample(n2);
        if (jSSample == null) {
            return;
        }
        jSSample.setRateScaleFactor(f2);
        this.scaleSampleRate(n2, f2);
    }

    public void pause() {
        this.pause = 1;
    }

    public void resume() {
        this.pause = 3;
    }
}

