/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.lw3d.LwoParser;
import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.LwoTexture;
import com.sun.j3d.loaders.lw3d.ShapeHolder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

class J3dLwoParser
extends LwoParser {
    float[] normalCoordsArray;
    int[] normalIndicesArray;
    Shape3D objectShape;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    float shininess;
    Vector objectShapeList = new Vector();

    J3dLwoParser(String string, int n2) throws FileNotFoundException {
        super(string, n2);
    }

    J3dLwoParser(URL uRL, int n2) throws FileNotFoundException {
        super(uRL, n2);
    }

    void getSurf(int n2) throws FileNotFoundException {
        super.getSurf(n2);
    }

    void createJava3dGeometry() throws IncorrectFormatException {
        Enumeration enumeration = this.shapeList.elements();
        while (enumeration.hasMoreElements()) {
            GeometryArray geometryArray;
            Object object;
            Object object2;
            int n2 = 1;
            ShapeHolder shapeHolder = (ShapeHolder)enumeration.nextElement();
            this.debugOutputLn(8, "about to create Arrays for Shape");
            this.debugOutputLn(2, "shape = " + shapeHolder);
            shapeHolder.createArrays(true);
            int n3 = shapeHolder.coordsArray.length / 3;
            int n4 = 0;
            if (shapeHolder.facetIndices != null) {
                n4 = shapeHolder.facetIndices.length;
            }
            this.debugOutputLn(2, "numSurf = " + shapeHolder.numSurf);
            String string = (String)this.surfNameList.elementAt(shapeHolder.numSurf - 1);
            LwoSurface lwoSurface = null;
            for (int i2 = 0; i2 < this.surfaceList.size(); ++i2) {
                object2 = (LwoSurface)this.surfaceList.elementAt(i2);
                object = ((LwoSurface)object2).surfName;
                if (!string.equals(object)) continue;
                lwoSurface = object2;
                break;
            }
            if (lwoSurface == null) {
                throw new IncorrectFormatException("bad surf for surfnum/name = " + shapeHolder.numSurf + ", " + string);
            }
            this.debugOutputLn(2, "surf = " + lwoSurface);
            LwoTexture lwoTexture = lwoSurface.getTexture();
            Appearance appearance = new Appearance();
            if (shapeHolder.facetSizes[0] == 1) {
                geometryArray = new PointArray(n3, n2);
                geometryArray.setCoordinates(0, shapeHolder.coordsArray);
                object2 = new ColoringAttributes(lwoSurface.getColor(), 0);
                object = new PointAttributes();
                ((PointAttributes)object).setPointSize(1.0f);
                appearance.setColoringAttributes((ColoringAttributes)object2);
                appearance.setPointAttributes((PointAttributes)object);
            } else if (shapeHolder.facetSizes[0] == 2) {
                this.debugOutputLn(8, "Creating IndexedLineArray");
                geometryArray = new LineArray(n3, n2);
                geometryArray.setCoordinates(0, shapeHolder.coordsArray);
                object2 = new ColoringAttributes(lwoSurface.getColor(), 0);
                appearance.setColoringAttributes((ColoringAttributes)object2);
            } else {
                Object object3;
                this.debugOutputLn(8, "Creating IndexedTriFanArray");
                n2 |= 2;
                this.debugOutputLn(8, "about to process vertices/indices, facetIndices = " + shapeHolder.facetIndices);
                if (shapeHolder.facetIndices != null) {
                    object2 = null;
                    object = null;
                    this.debugOutputLn(8, "setting vertexCount, normind = " + shapeHolder.normalIndices);
                    this.debugOutputLn(8, "vtxcount, format, indcount = " + n3 + ", " + n2 + ", " + n4);
                    if (lwoTexture != null) {
                        n2 |= 0x20;
                        object2 = new float[n3 * 2];
                        object = new int[shapeHolder.facetIndices.length];
                        this.calculateTextureCoords(lwoTexture, shapeHolder.coordsArray, shapeHolder.facetIndices, (float[])object2, (int[])object);
                        this.debugOutputLn(8, "textureCoords:");
                        this.debugOutputLn(8, "texture Coords, Indices.length = " + ((Object)object2).length + ", " + ((Object)object).length);
                    }
                    this.debugOutputLn(8, "about to create GeometryInfo");
                    object3 = new GeometryInfo(3);
                    ((GeometryInfo)object3).setCoordinates(shapeHolder.coordsArray);
                    ((GeometryInfo)object3).setCoordinateIndices(shapeHolder.facetIndices);
                    ((GeometryInfo)object3).setStripCounts(shapeHolder.facetSizes);
                    if (lwoTexture != null) {
                        ((GeometryInfo)object3).setTextureCoordinateParams(1, 2);
                        ((GeometryInfo)object3).setTextureCoordinates(0, (float[])object2);
                        ((GeometryInfo)object3).setTextureCoordinateIndices(0, (int[])object);
                    }
                    ((GeometryInfo)object3).recomputeIndices();
                    NormalGenerator normalGenerator = new NormalGenerator(lwoSurface.getCreaseAngle());
                    normalGenerator.generateNormals((GeometryInfo)object3);
                    Stripifier stripifier = new Stripifier();
                    stripifier.stripify((GeometryInfo)object3);
                    geometryArray = ((GeometryInfo)object3).getGeometryArray(true, true, false);
                    this.debugOutputLn(8, "done.");
                } else {
                    this.debugOutputLn(8, "about to create trifanarray with vertexCount, facetSizes.len = " + n3 + ", " + shapeHolder.facetSizes.length);
                    geometryArray = new TriangleFanArray(n3, n2, shapeHolder.facetSizes);
                    geometryArray.setCoordinates(0, shapeHolder.coordsArray);
                    geometryArray.setNormals(0, shapeHolder.normalCoords);
                    this.debugOutputLn(2, "passed in normalCoords, length = " + shapeHolder.normalCoords.length);
                }
                this.debugOutputLn(8, "created fan array");
                object2 = new Material(lwoSurface.getColor(), lwoSurface.getEmissiveColor(), lwoSurface.getDiffuseColor(), lwoSurface.getSpecularColor(), lwoSurface.getShininess());
                ((Material)object2).setLightingEnable(true);
                appearance.setMaterial((Material)object2);
                if (lwoSurface.getTransparency() != 0.0f) {
                    object = new TransparencyAttributes();
                    ((TransparencyAttributes)object).setTransparency(lwoSurface.getTransparency());
                    ((TransparencyAttributes)object).setTransparencyMode(2);
                    appearance.setTransparencyAttributes((TransparencyAttributes)object);
                }
                if (lwoTexture != null) {
                    this.debugOutputLn(8, "texture != null, enable texturing");
                    object = lwoTexture.getTexture();
                    ((Texture)object).setEnable(true);
                    appearance.setTexture((Texture)object);
                    object3 = new TextureAttributes();
                    if (lwoTexture.getType().equals("DTEX")) {
                        ((TextureAttributes)object3).setTextureMode(2);
                    } else if (lwoTexture.getType().equals("CTEX")) {
                        ((TextureAttributes)object3).setTextureMode(3);
                    }
                    appearance.setTextureAttributes((TextureAttributes)object3);
                } else {
                    this.debugOutputLn(8, "texture == null, no texture to use");
                }
            }
            this.debugOutputLn(8, "done creating object");
            shapeHolder.nullify();
            this.objectShape = new Shape3D(geometryArray);
            this.objectShape.setAppearance(appearance);
            this.objectShapeList.addElement(this.objectShape);
        }
    }

    void calculateTextureCoords(LwoTexture lwoTexture, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateTextureCoords()");
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = lwoTexture.getTextureAxis();
        Vector3f vector3f = lwoTexture.getTextureSize();
        Vector3f vector3f2 = lwoTexture.getTextureCenter();
        String string = lwoTexture.getMappingType();
        if (string.startsWith("Cylindrical")) {
            this.calculateCylindricalTextureCoords(n2, vector3f, vector3f2, fArray2, nArray2, fArray, nArray);
        } else if (string.startsWith("Spherical")) {
            this.calculateSphericalTextureCoords(n2, vector3f2, fArray2, nArray2, fArray, nArray);
        } else if (string.startsWith("Planar")) {
            this.calculatePlanarTextureCoords(n2, vector3f, vector3f2, fArray2, nArray2, fArray, nArray);
        }
    }

    double xyztoh(float f2, float f3, float f4) {
        if ((double)f2 == 0.0 && (double)f4 == 0.0) {
            return 0.0;
        }
        if ((double)f4 == 0.0) {
            return (double)f2 < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if ((double)f4 < 0.0) {
            return -Math.atan(f2 / f4) + Math.PI;
        }
        return -Math.atan(f2 / f4);
    }

    double xyztop(float f2, float f3, float f4) {
        double d2 = (double)f2 == 0.0 && (double)f4 == 0.0 ? ((double)f3 != 0.0 ? ((double)f3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : 0.0) : ((double)(f2 = (float)Math.sqrt(f2 * f2 + f4 * f4)) == 0.0 ? ((double)f3 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.atan(f3 / f2));
        return d2;
    }

    void calculateSphericalTextureCoords(int n2, Vector3f vector3f, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateSphericalTextureCoords");
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            double d2;
            double d3;
            float f2 = fArray2[3 * nArray2[i2]] - vector3f.x;
            float f3 = fArray2[3 * nArray2[i2] + 1] - vector3f.y;
            float f4 = -(fArray2[3 * nArray2[i2] + 2] + vector3f.z);
            if (n2 == 1) {
                d3 = this.xyztoh(f4, f2, -f3);
                d2 = this.xyztop(f4, f2, -f3);
            } else if (n2 == 2) {
                d3 = this.xyztoh(-f2, f3, f4);
                d2 = this.xyztop(-f2, f3, f4);
            } else {
                d3 = this.xyztoh(-f2, f4, -f3);
                d2 = this.xyztop(-f2, f4, -f3);
            }
            d3 = 1.0 - d3 / (Math.PI * 2);
            d2 = -(0.5 - d2 / Math.PI);
            fArray[nArray2[i2] * 2] = (float)d3;
            fArray[nArray2[i2] * 2 + 1] = (float)d2;
            nArray[i2] = nArray2[i2];
        }
    }

    void calculateCylindricalTextureCoords(int n2, Vector3f vector3f, Vector3f vector3f2, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculateCylindricalTextureCoords");
        this.debugOutputLn(2, "axis, size, center, tc, ti, v, i = " + n2 + ", " + vector3f + ", " + vector3f2 + ", " + fArray + ", " + nArray + ", " + fArray2 + ", " + nArray2);
        this.debugOutputLn(2, "Cyl Texture Coords:");
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            double d2;
            double d3;
            float f2 = fArray2[3 * nArray2[i2]] - vector3f2.x;
            float f3 = fArray2[3 * nArray2[i2] + 1] - vector3f2.y;
            float f4 = -(fArray2[3 * nArray2[i2] + 2] + vector3f2.z);
            if (n2 == 1) {
                d3 = this.xyztoh(f4, f2, -f3);
                d2 = (double)(f2 / vector3f.x) + 0.5;
            } else if (n2 == 2) {
                d3 = this.xyztoh(-f2, f3, f4);
                d2 = (double)(f3 / vector3f.y) + 0.5;
            } else {
                d3 = this.xyztoh(-f2, f4, -f3);
                d2 = (double)(f4 / vector3f.z) + 0.5;
            }
            d3 = 1.0 - d3 / (Math.PI * 2);
            fArray[nArray2[i2] * 2] = (float)d3;
            fArray[nArray2[i2] * 2 + 1] = (float)d2;
            nArray[i2] = nArray2[i2];
            this.debugOutputLn(2, "x, y, z = " + f2 + ", " + f3 + ", " + f4 + "    " + "s, t = " + d3 + ", " + d2);
        }
    }

    void calculatePlanarTextureCoords(int n2, Vector3f vector3f, Vector3f vector3f2, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2) {
        this.debugOutputLn(1, "calculatePlanarTextureCoords");
        this.debugOutputLn(2, "size, center, axis = " + vector3f + vector3f2 + ", " + n2);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (n2 == 1) {
            f3 = -1.0f / vector3f.z;
            f4 = 1.0f / vector3f.y;
        } else if (n2 == 2) {
            f2 = 1.0f / vector3f.x;
            f5 = -1.0f / vector3f.z;
        } else {
            f2 = 1.0f / vector3f.x;
            f4 = 1.0f / vector3f.y;
        }
        this.debugOutputLn(2, "Planar Texture Coords:");
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            float f6 = fArray2[3 * nArray2[i2]] - vector3f2.x;
            float f7 = fArray2[3 * nArray2[i2] + 1] - vector3f2.y;
            float f8 = fArray2[3 * nArray2[i2] + 2] + vector3f2.z;
            double d2 = (double)(f6 * f2 + f8 * f3) + 0.5;
            double d3 = (double)(f7 * f4 + f8 * f5) + 0.5;
            fArray[nArray2[i2] * 2] = (float)d2;
            fArray[nArray2[i2] * 2 + 1] = (float)d3;
            nArray[i2] = nArray2[i2];
            this.debugOutputLn(2, "x, y, z = " + f6 + ", " + f7 + ", " + f8 + "    " + "s, t = " + d2 + ", " + d3);
        }
    }

    Shape3D getJava3dShape() {
        return this.objectShape;
    }

    Vector getJava3dShapeList() {
        return this.objectShapeList;
    }
}

