/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import com.sun.j3d.utils.behaviors.interpolators.KBRotPosScaleSplinePathInterpolator;
import java.io.StreamTokenizer;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;

class LwsMotion
extends TextfileParser {
    String motionName;
    LwsFrame[] frames;
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int firstFrame;
    int totalFrames;
    Behavior behaviors;

    LwsMotion(StreamTokenizer streamTokenizer, int n2, float f2) {
        this(streamTokenizer, 0, n2, f2, 16);
    }

    LwsMotion(StreamTokenizer streamTokenizer, int n2, int n3, float f2, int n4) throws ParsingErrorException, IncorrectFormatException {
        this.debugPrinter.setValidOutput(n4);
        this.numFrames = 0;
        this.totalTime = f2;
        this.firstFrame = n2;
        this.totalFrames = n3;
        this.debugOutputLn(8, "about to get motion name");
        this.motionName = this.getName(streamTokenizer);
        this.debugOutputLn(8, "about to get motion");
        this.getMotion(streamTokenizer);
    }

    void getMotion(StreamTokenizer streamTokenizer) throws ParsingErrorException, IncorrectFormatException {
        int n2;
        this.debugOutputLn(1, "getMotion()");
        this.numChannels = (int)this.getNumber(streamTokenizer);
        if (this.numChannels != 9) {
            throw new IncorrectFormatException(J3dUtilsI18N.getString("LwsMotion0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(streamTokenizer);
        this.frames = new LwsFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        for (n2 = 0; n2 < this.numFrames; ++n2) {
            this.frames[n2] = new LwsFrame(streamTokenizer);
        }
        this.debugOutput(8, "got all frames");
        this.getAndCheckString(streamTokenizer, "EndBehavior");
        n2 = (int)this.getNumber(streamTokenizer);
        this.loop = n2 != 1;
    }

    void fixFrames() {
        Object object;
        boolean bl = false;
        Vector<LwsFrame> vector = new Vector<LwsFrame>();
        double d2 = 1.5707963705062866;
        LwsFrame lwsFrame = null;
        for (int i2 = 1; i2 < this.numFrames; ++i2) {
            double d3;
            LwsFrame lwsFrame2;
            double d4;
            double d5;
            LwsFrame lwsFrame3;
            LwsFrame lwsFrame4 = this.frames[i2 - 1];
            lwsFrame = lwsFrame3 = this.frames[i2];
            vector.add(lwsFrame4);
            double d6 = 0.0;
            double d7 = lwsFrame3.getHeading();
            double d8 = lwsFrame4.getHeading();
            double d9 = Math.abs(d7 - d8);
            if (d9 > d6) {
                d6 = d9;
            }
            if ((d9 = Math.abs((d7 = lwsFrame3.getPitch()) - (d8 = lwsFrame4.getPitch()))) > d6) {
                d6 = d9;
            }
            if ((d9 = Math.abs((d7 = lwsFrame3.getBank()) - (d8 = lwsFrame4.getBank()))) > d6) {
                d6 = d9;
            }
            if (!(d6 > d2)) continue;
            bl = true;
            int n2 = (int)(d6 / d2);
            double d10 = d5 = 1.0 / (double)(n2 + 1);
            double d11 = this.frames[this.numFrames - 1].getFrameNum();
            double d12 = (lwsFrame3.getFrameNum() - lwsFrame4.getFrameNum()) / d11;
            if (i2 - 1 < 1) {
                object = this.frames[i2 - 1];
                d4 = 0.0;
            } else {
                object = this.frames[i2 - 2];
                d4 = d12 / ((lwsFrame3.getFrameNum() - ((LwsFrame)object).getFrameNum()) / d11);
            }
            if (i2 + 1 < this.numFrames) {
                lwsFrame2 = this.frames[i2 + 1];
                d3 = d12 / ((lwsFrame2.getFrameNum() - lwsFrame4.getFrameNum()) / d11);
            } else {
                lwsFrame2 = this.frames[i2];
                d3 = 1.0;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                LwsFrame lwsFrame5 = lwsFrame3.linearValue == 1 ? new LwsFrame(lwsFrame4, lwsFrame3, d10) : new LwsFrame((LwsFrame)object, lwsFrame4, lwsFrame3, lwsFrame2, d10, d4, d3);
                d10 += d5;
                vector.add(lwsFrame5);
            }
        }
        if (lwsFrame != null) {
            vector.add(lwsFrame);
        }
        if (bl) {
            LwsFrame[] lwsFrameArray = new LwsFrame[vector.size()];
            object = vector.elements();
            int n3 = 0;
            while (object.hasMoreElements()) {
                lwsFrameArray[n3++] = (LwsFrame)object.nextElement();
            }
            this.frames = lwsFrameArray;
            this.numFrames = this.frames.length;
            for (int i4 = 0; i4 < this.numFrames; ++i4) {
                this.debugOutputLn(2, "frame " + i4 + " = " + this.frames[i4]);
                this.frames[i4].printVals();
            }
        }
    }

    int intMod(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n5 < 0) {
            n5 = -n5;
        }
        while (n4 > n5) {
            n4 -= n5;
        }
        return n4;
    }

    void playWithFrameTimes(Vector vector) {
        this.debugOutputLn(1, "playWithFrameTimes: firstFrame = " + this.firstFrame);
        if (this.firstFrame == 1) {
            return;
        }
        if (this.frames[this.numFrames - 1].getFrameNum() < (double)this.totalFrames) {
            int n2;
            int n3 = (int)(this.frames[this.numFrames - 1].getFrameNum() + 0.4999999);
            int n4 = this.intMod(this.firstFrame, n3);
            int n5 = this.intMod(this.totalFrames, n3);
            for (n2 = 0; n2 < this.numFrames && !(this.frames[n2].getFrameNum() >= (double)n4); ++n2) {
            }
            int n6 = n2;
            if (this.frames[n6].getFrameNum() > (double)this.firstFrame && n6 > 0) {
                --n6;
            }
            if (n4 < n5) {
                for (n2 = n6; n2 < this.numFrames && this.frames[n2].getFrameNum() <= (double)n5; ++n2) {
                    FrameHolder frameHolder = new FrameHolder(this.frames[n2], this.frames[n2].getFrameNum() - (double)n4);
                    vector.addElement(frameHolder);
                }
            } else {
                Object object;
                double d2 = -1.0;
                while (n2 < this.numFrames) {
                    d2 = this.frames[n2].getFrameNum() - (double)n4;
                    object = new FrameHolder(this.frames[n2], d2);
                    vector.addElement(object);
                    ++n2;
                }
                for (n2 = 0; n2 <= n6 && this.frames[n2].getFrameNum() <= (double)n5; ++n2) {
                    if (n2 == 0) {
                        object = new LwsFrame(this.frames[n2], this.frames[n2 + 1], 1.0 / (this.frames[n2 + 1].getFrameNum() - this.frames[n2].getFrameNum()));
                        FrameHolder frameHolder = new FrameHolder((LwsFrame)object, ((LwsFrame)object).getFrameNum() + d2);
                        vector.addElement(frameHolder);
                        continue;
                    }
                    object = new FrameHolder(this.frames[n2], this.frames[n2].getFrameNum() + d2);
                    vector.addElement(object);
                }
            }
        } else {
            FrameHolder frameHolder;
            LwsFrame lwsFrame;
            int n7;
            for (n7 = 0; n7 < this.numFrames && !(this.frames[n7].getFrameNum() >= (double)this.firstFrame); ++n7) {
            }
            int n8 = n7;
            if (this.frames[n8].getFrameNum() > (double)this.firstFrame && n8 > 0) {
                double d3 = (double)this.firstFrame / (this.frames[n8].getFrameNum() - this.frames[n8 - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n8 - 1], this.frames[n8], d3);
                frameHolder = new FrameHolder(lwsFrame, lwsFrame.getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder);
            }
            for (n7 = n8; n7 < this.numFrames && this.frames[n7].getFrameNum() <= (double)this.totalFrames; ++n7) {
                FrameHolder frameHolder2 = new FrameHolder(this.frames[n7], this.frames[n7].getFrameNum() - (double)this.firstFrame);
                vector.addElement(frameHolder2);
            }
            if (this.frames[n7 - 1].getFrameNum() < (double)this.totalFrames) {
                double d4 = ((double)this.totalFrames - this.frames[n7 - 1].getFrameNum()) / (this.frames[n7].getFrameNum() - this.frames[n7 - 1].getFrameNum());
                lwsFrame = new LwsFrame(this.frames[n7 - 1], this.frames[n7], d4);
                frameHolder = new FrameHolder(lwsFrame, this.totalFrames - this.firstFrame);
                vector.addElement(frameHolder);
            }
        }
    }

    void createJava3dBehaviorsForFramesSubset(TransformGroup transformGroup) {
        Object object;
        this.debugOutputLn(1, "createJava3dBehaviorsForFramesSubset");
        Vector vector = new Vector();
        this.playWithFrameTimes(vector);
        long l2 = 0L;
        int n2 = this.loop ? -1 : 1;
        n2 = -1;
        int n3 = vector.size();
        this.debugOutputLn(2, "totalTime = " + this.totalTime);
        this.debugOutputLn(2, "loopCount = " + n2);
        FrameHolder frameHolder = (FrameHolder)vector.elementAt(vector.size() - 1);
        LwsFrame lwsFrame = frameHolder.frame;
        float f2 = 1000.0f * this.totalTime * (float)(frameHolder.frameNumber / (double)(this.totalFrames - this.firstFrame));
        this.debugOutputLn(2, " anim time: " + f2);
        this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
        if (!this.loop) {
            l2 = (long)(1000.0 * (double)this.totalTime - (double)f2);
        }
        Alpha alpha = new Alpha(n2, 1, 0L, 0L, (long)f2, 0L, l2, 0L, 0L, 0L);
        float[] fArray = new float[n3];
        Point3f[] point3fArray = new Point3f[n3];
        Quat4f[] quat4fArray = new Quat4f[n3];
        Point3f[] point3fArray2 = new Point3f[n3];
        Transform3D transform3D = new Transform3D();
        Matrix4d matrix4d = new Matrix4d();
        KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            object = (FrameHolder)vector.elementAt(i2);
            LwsFrame lwsFrame2 = ((FrameHolder)object).frame;
            point3fArray[i2] = lwsFrame2.getPosition();
            point3fArray2[i2] = lwsFrame2.getScale();
            lwsFrame2.setRotationMatrix(matrix4d);
            this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
            quat4fArray[i2] = new Quat4f();
            quat4fArray[i2].set(matrix4d);
            this.debugOutputLn(2, " and quat = " + quat4fArray[i2]);
            fArray[i2] = i2 == 0 ? 0.0f : (float)((FrameHolder)object).frameNumber / (float)frameHolder.frameNumber;
            kBKeyFrameArray[i2] = new KBKeyFrame(fArray[i2], lwsFrame2.linearValue, point3fArray[i2], (float)lwsFrame2.heading, (float)lwsFrame2.pitch, (float)lwsFrame2.bank, point3fArray2[i2], (float)lwsFrame2.tension, (float)lwsFrame2.continuity, (float)lwsFrame2.bias);
            this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[i2] + fArray[i2] + quat4fArray[i2]);
        }
        KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
        if (kBRotPosScaleSplinePathInterpolator != null) {
            this.behaviors = kBRotPosScaleSplinePathInterpolator;
            object = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
            kBRotPosScaleSplinePathInterpolator.setSchedulingBounds((Bounds)object);
            transformGroup.setCapability(18);
            transformGroup.addChild(this.behaviors);
        }
    }

    void createJava3dBehaviors(TransformGroup transformGroup) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            if (this.firstFrame > 1) {
                this.createJava3dBehaviorsForFramesSubset(transformGroup);
                return;
            }
            long l2 = 0L;
            int n2 = this.loop ? -1 : 1;
            n2 = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + n2);
            float f2 = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + f2);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                l2 = (long)(1000.0 * (double)this.totalTime - (double)f2);
            }
            Alpha alpha = new Alpha(n2, 1, 0L, 0L, (long)f2, 0L, l2, 0L, 0L, 0L);
            float[] fArray = new float[this.numFrames];
            Point3f[] point3fArray = new Point3f[this.numFrames];
            Quat4f[] quat4fArray = new Quat4f[this.numFrames];
            Point3f[] point3fArray2 = new Point3f[this.numFrames];
            Transform3D transform3D = new Transform3D();
            Matrix4d matrix4d = new Matrix4d();
            KBKeyFrame[] kBKeyFrameArray = new KBKeyFrame[this.numFrames];
            for (int i2 = 0; i2 < this.numFrames; ++i2) {
                point3fArray[i2] = this.frames[i2].getPosition();
                point3fArray2[i2] = this.frames[i2].getScale();
                this.frames[i2].setRotationMatrix(matrix4d);
                this.debugOutputLn(2, "LwsMotion::createj3dbeh, mat = " + matrix4d);
                quat4fArray[i2] = new Quat4f();
                quat4fArray[i2].set(matrix4d);
                this.debugOutputLn(2, " and quat = " + quat4fArray[i2]);
                fArray[i2] = i2 == 0 ? 0.0f : (float)this.frames[i2].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                kBKeyFrameArray[i2] = new KBKeyFrame(fArray[i2], this.frames[i2].linearValue, point3fArray[i2], (float)this.frames[i2].heading, (float)this.frames[i2].pitch, (float)this.frames[i2].bank, point3fArray2[i2], (float)this.frames[i2].tension, (float)this.frames[i2].continuity, (float)this.frames[i2].bias);
                this.debugOutputLn(2, "pos, knots, quat = " + point3fArray[i2] + fArray[i2] + quat4fArray[i2]);
            }
            KBRotPosScaleSplinePathInterpolator kBRotPosScaleSplinePathInterpolator = new KBRotPosScaleSplinePathInterpolator(alpha, transformGroup, transform3D, kBKeyFrameArray);
            if (kBRotPosScaleSplinePathInterpolator != null) {
                this.behaviors = kBRotPosScaleSplinePathInterpolator;
                BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                kBRotPosScaleSplinePathInterpolator.setSchedulingBounds(boundingSphere);
                transformGroup.setCapability(18);
                transformGroup.addChild(this.behaviors);
            }
        }
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    LwsFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   motionName = " + this.motionName);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        for (int i2 = 0; i2 < this.numFrames; ++i2) {
            this.debugOutputLn(2, "       FRAME " + i2);
            this.frames[i2].printVals();
        }
    }

    class FrameHolder {
        double frameNumber;
        LwsFrame frame;

        FrameHolder(LwsFrame lwsFrame, double d2) {
            this.frame = lwsFrame;
            this.frameNumber = d2;
        }
    }
}

