/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.J3dLwoParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Switch;
import javax.media.j3d.SwitchValueInterpolator;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

class SequenceLine {
    int startFrame;
    int endFrame;
    String fileName;
    Group geometryGroup = null;
    Behavior behaviors;
    int numFrames;
    float totalTime;
    int totalFrames;
    static Hashtable storedRefList = new Hashtable();

    SequenceLine(StreamTokenizer streamTokenizer, float f2, int n2) throws ParsingErrorException {
        try {
            this.totalTime = f2;
            this.totalFrames = n2;
            this.startFrame = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.endFrame = (int)streamTokenizer.nval;
            streamTokenizer.nextToken();
            this.fileName = streamTokenizer.sval;
            this.numFrames = this.endFrame - this.startFrame + 1;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    private void createSwitchBehavior(Switch switch_) {
        int n2 = -1;
        float f2 = 1000.0f * this.totalTime * (float)switch_.numChildren() / (float)this.totalFrames;
        float f3 = 1000.0f * this.totalTime * (float)this.startFrame / (float)this.totalFrames;
        Alpha alpha = new Alpha(-1, (long)f3, 0L, (long)f2, 0L, 0L);
        SwitchValueInterpolator switchValueInterpolator = new SwitchValueInterpolator(alpha, switch_);
        this.behaviors = switchValueInterpolator;
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        switchValueInterpolator.setSchedulingBounds(boundingSphere);
        switch_.setCapability(18);
        switch_.addChild(this.behaviors);
    }

    void createJava3dObjects(int n2, int n3) throws IncorrectFormatException, FileNotFoundException {
        if (this.fileName.indexOf("000") != -1) {
            int n4 = this.fileName.indexOf("000");
            String string = this.fileName.substring(0, n4);
            Switch switch_ = new Switch();
            switch_.setCapability(17);
            switch_.setCapability(18);
            String string2 = this.fileName;
            int n5 = 0;
            while (new File(string2).exists()) {
                Node node;
                Object object;
                if (storedRefList.get(string2) != null) {
                    object = (SharedGroup)storedRefList.get(string2);
                    node = new Link((SharedGroup)object);
                    switch_.addChild(node);
                } else {
                    object = new J3dLwoParser(string2, n2);
                    ((J3dLwoParser)object).createJava3dGeometry();
                    node = new TransformGroup();
                    SharedGroup sharedGroup = new SharedGroup();
                    storedRefList.put(string2, sharedGroup);
                    sharedGroup.addChild(node);
                    Link link = new Link(sharedGroup);
                    switch_.addChild(link);
                    if (((J3dLwoParser)object).getJava3dShapeList() != null) {
                        Enumeration enumeration = ((J3dLwoParser)object).getJava3dShapeList().elements();
                        while (enumeration.hasMoreElements()) {
                            ((Group)node).addChild((Shape3D)enumeration.nextElement());
                        }
                    }
                }
                object = String.valueOf(++n5);
                if (n5 < 10) {
                    object = "00" + (String)object;
                } else if (n5 < 100) {
                    object = "0" + (String)object;
                }
                string2 = string + (String)object + ".lwo";
            }
            this.behaviors = null;
            if (n3 != 0) {
                this.createSwitchBehavior(switch_);
            }
            this.geometryGroup = switch_;
        } else {
            this.geometryGroup = new Group();
            if (storedRefList.get(this.fileName) != null) {
                SharedGroup sharedGroup = (SharedGroup)storedRefList.get(this.fileName);
                Link link = new Link(sharedGroup);
                this.geometryGroup.addChild(link);
            } else {
                Object object;
                J3dLwoParser j3dLwoParser = new J3dLwoParser(this.fileName, n2);
                j3dLwoParser.createJava3dGeometry();
                TransformGroup transformGroup = new TransformGroup();
                if (j3dLwoParser.getJava3dShapeList() != null) {
                    object = j3dLwoParser.getJava3dShapeList().elements();
                    while (object.hasMoreElements()) {
                        transformGroup.addChild((Shape3D)object.nextElement());
                    }
                }
                object = new SharedGroup();
                ((Group)object).addChild(transformGroup);
                Link link = new Link((SharedGroup)object);
                this.geometryGroup.addChild(link);
                storedRefList.put(this.fileName, object);
            }
        }
    }

    Group getGeometry() {
        return this.geometryGroup;
    }

    Behavior getBehavior() {
        return this.behaviors;
    }
}

