/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.KBKeyFrame;
import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;

public abstract class KBSplinePathInterpolator
extends TransformInterpolator {
    private int keysLength;
    protected KBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    KBSplinePathInterpolator() {
    }

    public KBSplinePathInterpolator(Alpha alpha, KBKeyFrame[] kBKeyFrameArray) {
        this(alpha, null, kBKeyFrameArray);
    }

    public KBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, KBKeyFrame[] kBKeyFrameArray) {
        super(alpha, transformGroup);
        this.processKeyFrames(kBKeyFrameArray);
    }

    public KBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, KBKeyFrame[] kBKeyFrameArray) {
        super(alpha, transformGroup, transform3D);
        this.processKeyFrames(kBKeyFrameArray);
    }

    private void processKeyFrames(KBKeyFrame[] kBKeyFrameArray) {
        int n2;
        this.keysLength = kBKeyFrameArray.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator0"));
        }
        if ((double)kBKeyFrameArray[0].knot < -1.0E-4 || (double)kBKeyFrameArray[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator1"));
        }
        if ((double)kBKeyFrameArray[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)kBKeyFrameArray[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator2"));
        }
        for (n2 = 0; n2 < this.keysLength; ++n2) {
            if (n2 <= 0 || !(kBKeyFrameArray[n2].knot < kBKeyFrameArray[n2 - 1].knot)) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator3"));
        }
        this.keyFrames = new KBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new KBKeyFrame();
        this.keyFrames[0] = kBKeyFrameArray[0];
        for (n2 = 1; n2 < this.keysLength + 1; ++n2) {
            this.keyFrames[n2] = kBKeyFrameArray[n2 - 1];
        }
        this.keyFrames[this.keysLength + 1] = new KBKeyFrame();
        this.keyFrames[this.keysLength + 1] = kBKeyFrameArray[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength - 2;
    }

    public KBKeyFrame getKeyFrame(int n2) {
        return this.keyFrames[n2 + 1];
    }

    public void setKeyFrame(int n2, KBKeyFrame kBKeyFrame) {
        this.keyFrames[n2 + 1] = kBKeyFrame;
    }

    public void setKeyFrames(KBKeyFrame[] kBKeyFrameArray) {
        this.processKeyFrames(kBKeyFrameArray);
    }

    protected void computePathInterpolation() {
        this.computePathInterpolation(this.getAlpha().value());
    }

    protected void computePathInterpolation(float f2) {
        int n2;
        int n3 = this.keysLength - 2;
        for (n2 = 1; f2 > this.keyFrames[n2].knot && n2 < n3; ++n2) {
        }
        if (n2 == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (f2 - this.keyFrames[n2 - 1].knot) / (this.keyFrames[n2].knot - this.keyFrames[n2 - 1].knot);
            this.lowerKnot = n2 - 1;
            this.upperKnot = n2;
        }
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        KBSplinePathInterpolator kBSplinePathInterpolator = (KBSplinePathInterpolator)node;
        this.setAlpha(kBSplinePathInterpolator.getAlpha());
        this.keysLength = kBSplinePathInterpolator.keysLength;
        this.keyFrames = new KBKeyFrame[this.keysLength];
        System.arraycopy(kBSplinePathInterpolator.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

