/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import javax.media.j3d.Alpha;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;

public abstract class TCBSplinePathInterpolator
extends TransformInterpolator {
    private int keysLength;
    protected TCBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    TCBSplinePathInterpolator() {
    }

    public TCBSplinePathInterpolator(Alpha alpha, TCBKeyFrame[] tCBKeyFrameArray) {
        this(alpha, null, tCBKeyFrameArray);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, TCBKeyFrame[] tCBKeyFrameArray) {
        super(alpha, transformGroup);
        this.processKeyFrames(tCBKeyFrameArray);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, TCBKeyFrame[] tCBKeyFrameArray) {
        super(alpha, transformGroup, transform3D);
        this.processKeyFrames(tCBKeyFrameArray);
    }

    private void processKeyFrames(TCBKeyFrame[] tCBKeyFrameArray) {
        int n2;
        this.keysLength = tCBKeyFrameArray.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator0"));
        }
        if ((double)tCBKeyFrameArray[0].knot < -1.0E-4 || (double)tCBKeyFrameArray[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator1"));
        }
        if ((double)tCBKeyFrameArray[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)tCBKeyFrameArray[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator2"));
        }
        for (n2 = 0; n2 < this.keysLength; ++n2) {
            if (n2 <= 0 || !(tCBKeyFrameArray[n2].knot < tCBKeyFrameArray[n2 - 1].knot)) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator3"));
        }
        this.keyFrames = new TCBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new TCBKeyFrame();
        this.keyFrames[0] = tCBKeyFrameArray[0];
        for (n2 = 1; n2 < this.keysLength + 1; ++n2) {
            this.keyFrames[n2] = tCBKeyFrameArray[n2 - 1];
        }
        this.keyFrames[this.keysLength + 1] = new TCBKeyFrame();
        this.keyFrames[this.keysLength + 1] = tCBKeyFrameArray[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength - 2;
    }

    public TCBKeyFrame getKeyFrame(int n2) {
        return this.keyFrames[n2 + 1];
    }

    protected void computePathInterpolation(float f2) {
        int n2;
        int n3 = this.keysLength - 2;
        for (n2 = 1; f2 > this.keyFrames[n2].knot && n2 < n3; ++n2) {
        }
        if (n2 == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (f2 - this.keyFrames[n2 - 1].knot) / (this.keyFrames[n2].knot - this.keyFrames[n2 - 1].knot);
            this.lowerKnot = n2 - 1;
            this.upperKnot = n2;
        }
    }

    protected void computePathInterpolation() {
        float f2 = this.getAlpha().value();
        this.computePathInterpolation(f2);
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        TCBSplinePathInterpolator tCBSplinePathInterpolator = (TCBSplinePathInterpolator)node;
        this.setAlpha(tCBSplinePathInterpolator.getAlpha());
        this.keysLength = tCBSplinePathInterpolator.keysLength;
        this.keyFrames = new TCBKeyFrame[this.keysLength];
        System.arraycopy(tCBSplinePathInterpolator.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

