/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.keyboard;

import java.awt.event.KeyEvent;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;

public class KeyNavigator {
    private Vector3d navVec;
    private long time;
    private Vector3d fwdAcc;
    private Vector3d bwdAcc;
    private Vector3d leftAcc;
    private Vector3d rightAcc;
    private Vector3d upAcc;
    private Vector3d downAcc;
    private Vector3d fwdDrag;
    private Vector3d bwdDrag;
    private Vector3d leftDrag;
    private Vector3d rightDrag;
    private Vector3d upDrag;
    private Vector3d downDrag;
    private double fwdVMax;
    private double bwdVMax;
    private double leftVMax;
    private double rightVMax;
    private double upVMax;
    private double downVMax;
    private float leftRotAngle;
    private float rightRotAngle;
    private float upRotAngle;
    private float downRotAngle;
    private double mmx;
    private Vector3d a = new Vector3d();
    private Vector3d dv = new Vector3d();
    private Point3d dp = new Point3d();
    private Quat4d udQuat = new Quat4d();
    private Quat4d lrQuat = new Quat4d();
    private Vector3d vpPos = new Vector3d();
    private double vpScale;
    private Quat4d vpQuat = new Quat4d();
    private Matrix4d vpMatrix = new Matrix4d();
    private Transform3D vpTrans = new Transform3D();
    private Matrix4d mat = new Matrix4d();
    private Vector3d nda = new Vector3d();
    private Vector3d temp = new Vector3d();
    private Transform3D nominal = new Transform3D();
    private TransformGroup targetTG;
    private static final int UP_ARROW = 1;
    private static final int DOWN_ARROW = 2;
    private static final int LEFT_ARROW = 4;
    private static final int RIGHT_ARROW = 8;
    private static final int PLUS_SIGN = 16;
    private static final int MINUS_SIGN = 32;
    private static final int PAGE_UP = 64;
    private static final int PAGE_DOWN = 128;
    private static final int HOME_DIR = 256;
    private static final int HOME_NOMINAL = 512;
    private static final int SHIFT = 1024;
    private static final int ALT = 2048;
    private static final int META = 4096;
    private static final int KEY_UP = 8192;
    private static final int KEY_DOWN = 16384;
    private int key_state = 0;
    private int modifier_key_state = 0;

    public KeyNavigator(TransformGroup transformGroup) {
        this.targetTG = transformGroup;
        transformGroup.getTransform(this.nominal);
        this.mmx = 128.0;
        this.navVec = new Vector3d(0.0, 0.0, 0.0);
        this.fwdAcc = new Vector3d(0.0, 0.0, -this.mmx);
        this.bwdAcc = new Vector3d(0.0, 0.0, this.mmx);
        this.leftAcc = new Vector3d(-this.mmx, 0.0, 0.0);
        this.rightAcc = new Vector3d(this.mmx, 0.0, 0.0);
        this.upAcc = new Vector3d(0.0, this.mmx, 0.0);
        this.downAcc = new Vector3d(0.0, -this.mmx, 0.0);
        this.fwdDrag = new Vector3d(0.0, 0.0, this.mmx);
        this.bwdDrag = new Vector3d(0.0, 0.0, -this.mmx);
        this.leftDrag = new Vector3d(this.mmx, 0.0, 0.0);
        this.rightDrag = new Vector3d(-this.mmx, 0.0, 0.0);
        this.upDrag = new Vector3d(0.0, -this.mmx, 0.0);
        this.downDrag = new Vector3d(0.0, this.mmx, 0.0);
        this.fwdVMax = -this.mmx;
        this.bwdVMax = this.mmx;
        this.leftVMax = -this.mmx;
        this.rightVMax = this.mmx;
        this.upVMax = this.mmx;
        this.downVMax = -this.mmx;
        this.leftRotAngle = -2.0943952f;
        this.rightRotAngle = 2.0943952f;
        this.upRotAngle = 2.0943952f;
        this.downRotAngle = -2.0943952f;
        this.time = System.currentTimeMillis();
    }

    private long getDeltaTime() {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.time;
        this.time = l2;
        if (l3 > 2000L) {
            return 0L;
        }
        return l3;
    }

    private void genRotQuat(double d2, int n2, Quat4d quat4d) {
        quat4d.z = 0.0;
        quat4d.y = 0.0;
        quat4d.x = 0.0;
        quat4d.w = Math.cos(d2 / 2.0);
        double d3 = 1.0 - quat4d.w * quat4d.w;
        if (!(d3 > 0.0)) {
            return;
        }
        d3 = Math.sqrt(d3);
        if (d2 < 0.0) {
            d3 = -d3;
        }
        if (n2 == 0) {
            quat4d.x = d3;
        } else if (n2 == 1) {
            quat4d.y = d3;
        } else {
            quat4d.z = d3;
        }
    }

    private void accKeyAdd(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, double d2) {
        this.nda.scale(d2, vector3d2);
        this.nda.sub(vector3d3);
        vector3d.add(this.nda);
    }

    public void integrateTransformChanges() {
        double d2;
        double d3;
        double d4;
        this.targetTG.getTransform(this.vpTrans);
        this.vpScale = this.vpTrans.get(this.vpQuat, this.vpPos);
        double d5 = this.getDeltaTime();
        d5 *= 0.001;
        if ((this.modifier_key_state & 0x400) != 0 && (this.modifier_key_state & 0x1000) == 0) {
            d4 = 3.0;
            d3 = 2.0;
            d2 = 4.0;
        } else if ((this.modifier_key_state & 0x400) == 0 && (this.modifier_key_state & 0x1000) != 0) {
            d4 = 0.1;
            d3 = 0.1;
            d2 = 0.1;
        } else if ((this.modifier_key_state & 0x400) != 0 && (this.modifier_key_state & 0x1000) != 0) {
            d4 = 0.3;
            d3 = 0.5;
            d2 = 0.1;
        } else {
            d4 = 1.0;
            d3 = 1.0;
            d2 = 4.0;
        }
        this.a.z = 0.0;
        this.a.y = 0.0;
        this.a.x = 0.0;
        if ((this.key_state & 1) != 0 && (this.key_state & 2) == 0) {
            this.accKeyAdd(this.a, this.fwdAcc, this.fwdDrag, d4);
        } else if ((this.key_state & 1) == 0 && (this.key_state & 2) != 0) {
            this.accKeyAdd(this.a, this.bwdAcc, this.bwdDrag, d4);
        }
        if ((this.modifier_key_state & 0x800) != 0 && (this.key_state & 4) != 0 && (this.key_state & 8) == 0) {
            this.accKeyAdd(this.a, this.leftAcc, this.leftDrag, d4);
        } else if ((this.modifier_key_state & 0x800) != 0 && (this.key_state & 4) == 0 && (this.key_state & 8) != 0) {
            this.accKeyAdd(this.a, this.rightAcc, this.rightDrag, d4);
        }
        if ((this.modifier_key_state & 0x800) != 0 && (this.key_state & 0x40) != 0 && (this.key_state & 0x80) == 0) {
            this.accKeyAdd(this.a, this.upAcc, this.upDrag, d4);
        } else if ((this.modifier_key_state & 0x800) != 0 && (this.key_state & 0x40) == 0 && (this.key_state & 0x80) != 0) {
            this.accKeyAdd(this.a, this.downAcc, this.downDrag, d4);
        }
        double d6 = this.navVec.z + this.a.z * d5;
        if (d6 < 0.0) {
            if (d6 + this.fwdDrag.z * d5 < 0.0) {
                this.a.add(this.fwdDrag);
            } else {
                this.a.z -= d6 / d5;
            }
        } else if (d6 > 0.0) {
            if (d6 + this.bwdDrag.z * d5 > 0.0) {
                this.a.add(this.bwdDrag);
            } else {
                this.a.z -= d6 / d5;
            }
        }
        d6 = this.navVec.x + this.a.x * d5;
        if (d6 < 0.0) {
            if (d6 + this.leftDrag.x * d5 < 0.0) {
                this.a.add(this.leftDrag);
            } else {
                this.a.x -= d6 / d5;
            }
        } else if (d6 > 0.0) {
            if (d6 + this.rightDrag.x * d5 > 0.0) {
                this.a.add(this.rightDrag);
            } else {
                this.a.x -= d6 / d5;
            }
        }
        d6 = this.navVec.y + this.a.y * d5;
        if (d6 < 0.0) {
            if (d6 + this.downDrag.y * d5 < 0.0) {
                this.a.add(this.downDrag);
            } else {
                this.a.y -= d6 / d5;
            }
        } else if (d6 > 0.0) {
            if (d6 + this.upDrag.y * d5 > 0.0) {
                this.a.add(this.upDrag);
            } else {
                this.a.y -= d6 / d5;
            }
        }
        this.dv.scale(d5, this.a);
        this.navVec.add(this.dv);
        if (this.navVec.z < d4 * this.fwdVMax) {
            this.navVec.z = d4 * this.fwdVMax;
        }
        if (this.navVec.z > d4 * this.bwdVMax) {
            this.navVec.z = d4 * this.bwdVMax;
        }
        if (this.navVec.x < d4 * this.leftVMax) {
            this.navVec.x = d4 * this.leftVMax;
        }
        if (this.navVec.x > d4 * this.rightVMax) {
            this.navVec.x = d4 * this.rightVMax;
        }
        if (this.navVec.y > d4 * this.upVMax) {
            this.navVec.y = d4 * this.upVMax;
        }
        if (this.navVec.y < d4 * this.downVMax) {
            this.navVec.y = d4 * this.downVMax;
        }
        this.dp.scale(d5, this.navVec);
        double d7 = this.vpScale / 1.0;
        this.dp.scale(d7, this.dp);
        double d8 = 0.0;
        double d9 = 0.0;
        if ((this.modifier_key_state & 0x800) == 0 && (this.key_state & 4) != 0 && (this.key_state & 8) == 0) {
            d8 = this.leftRotAngle;
        } else if ((this.modifier_key_state & 0x800) == 0 && (this.key_state & 4) == 0 && (this.key_state & 8) != 0) {
            d8 = this.rightRotAngle;
        }
        if ((this.modifier_key_state & 0x800) == 0 && (this.key_state & 0x40) != 0 && (this.key_state & 0x80) == 0) {
            d9 = this.upRotAngle;
        } else if ((this.modifier_key_state & 0x800) == 0 && (this.key_state & 0x40) == 0 && (this.key_state & 0x80) != 0) {
            d9 = this.downRotAngle;
        }
        d8 *= d3;
        d9 *= d3;
        d9 *= d5;
        this.vpQuat.inverse();
        if ((d8 *= d5) != 0.0) {
            this.genRotQuat(d8, 1, this.lrQuat);
            this.vpQuat.mul(this.lrQuat, this.vpQuat);
        }
        if (d9 != 0.0) {
            this.genRotQuat(d9, 0, this.udQuat);
            this.vpQuat.mul(this.udQuat, this.vpQuat);
        }
        this.vpQuat.inverse();
        this.vpQuat.normalize();
        this.mat.set(this.vpQuat);
        this.mat.transform(this.dp);
        if ((this.key_state & 0x10) != 0) {
            this.vpScale *= 1.0 + d2 * d5;
            if (this.vpScale > 1.0E15) {
                this.vpScale = 1.0;
            }
        } else if ((this.key_state & 0x20) != 0) {
            this.vpScale /= 1.0 + d2 * d5;
            if (this.vpScale < 1.0E-13) {
                this.vpScale = 1.0;
            }
        }
        this.vpPos.add(this.dp);
        if ((this.key_state & 0x200) != 0) {
            this.resetVelocity();
            this.vpScale = this.nominal.get(this.vpQuat, this.vpPos);
        }
        this.vpTrans.set(this.vpQuat, this.vpPos, this.vpScale);
        this.targetTG.setTransform(this.vpTrans);
    }

    private void resetVelocity() {
        this.navVec.z = 0.0;
        this.navVec.y = 0.0;
        this.navVec.x = 0.0;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        char c2 = keyEvent.getKeyChar();
        if (keyEvent.getID() == 402) {
            if (c2 == '+') {
                this.key_state &= 0xFFFFFFEF;
            } else {
                switch (n2) {
                    case 38: {
                        this.key_state &= 0xFFFFFFFE;
                        break;
                    }
                    case 40: {
                        this.key_state &= 0xFFFFFFFD;
                        break;
                    }
                    case 37: {
                        this.key_state &= 0xFFFFFFFB;
                        break;
                    }
                    case 39: {
                        this.key_state &= 0xFFFFFFF7;
                        break;
                    }
                    case 33: {
                        this.key_state &= 0xFFFFFFBF;
                        break;
                    }
                    case 34: {
                        this.key_state &= 0xFFFFFF7F;
                        break;
                    }
                    case 61: {
                        this.key_state &= 0xFFFFFDFF;
                        break;
                    }
                    default: {
                        switch (c2) {
                            case '-': {
                                this.key_state &= 0xFFFFFFDF;
                            }
                        }
                        break;
                    }
                }
            }
        } else if (keyEvent.getID() == 401) {
            if (c2 == '+') {
                this.key_state |= 0x10;
            }
            switch (n2) {
                case 38: {
                    this.key_state |= 1;
                    break;
                }
                case 40: {
                    this.key_state |= 2;
                    break;
                }
                case 37: {
                    this.key_state |= 4;
                    break;
                }
                case 39: {
                    this.key_state |= 8;
                    break;
                }
                case 33: {
                    this.key_state |= 0x40;
                    break;
                }
                case 34: {
                    this.key_state |= 0x80;
                    break;
                }
                case 61: {
                    this.key_state |= 0x200;
                    break;
                }
                default: {
                    switch (c2) {
                        case '-': {
                            this.key_state |= 0x20;
                        }
                    }
                }
            }
        }
        this.modifier_key_state = keyEvent.isShiftDown() ? (this.modifier_key_state |= 0x400) : (this.modifier_key_state &= 0xFFFFFBFF);
        this.modifier_key_state = keyEvent.isMetaDown() ? (this.modifier_key_state |= 0x1000) : (this.modifier_key_state &= 0xFFFFEFFF);
        this.modifier_key_state = keyEvent.isAltDown() ? (this.modifier_key_state |= 0x800) : (this.modifier_key_state &= 0xFFFFF7FF);
    }
}

