/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.internal.J3dUtilsI18N;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOr;

public abstract class MouseBehavior
extends Behavior
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private boolean listener = false;
    protected WakeupCriterion[] mouseEvents;
    protected WakeupOr mouseCriterion;
    protected int x;
    protected int y;
    protected int x_last;
    protected int y_last;
    protected TransformGroup transformGroup;
    protected Transform3D transformX;
    protected Transform3D transformY;
    protected Transform3D currXform;
    protected boolean buttonPress = false;
    protected boolean reset = false;
    protected boolean invert = false;
    protected boolean wakeUp = false;
    protected int flags = 0;
    protected LinkedList mouseq;
    protected boolean enable = true;
    public static final int MANUAL_WAKEUP = 1;
    public static final int INVERT_INPUT = 2;

    public MouseBehavior(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(int n2) {
        this.flags = n2;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(Component component, TransformGroup transformGroup) {
        this(transformGroup);
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public MouseBehavior(Component component, int n2) {
        this(n2);
        if (component != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    public void initialize() {
        this.mouseEvents = new WakeupCriterion[4];
        if (!this.listener) {
            this.mouseEvents[0] = new WakeupOnAWTEvent(506);
            this.mouseEvents[1] = new WakeupOnAWTEvent(501);
            this.mouseEvents[2] = new WakeupOnAWTEvent(502);
            this.mouseEvents[3] = new WakeupOnAWTEvent(507);
        } else {
            this.mouseEvents[0] = new WakeupOnBehaviorPost(this, 506);
            this.mouseEvents[1] = new WakeupOnBehaviorPost(this, 501);
            this.mouseEvents[2] = new WakeupOnBehaviorPost(this, 502);
            this.mouseEvents[3] = new WakeupOnBehaviorPost(this, 507);
            this.mouseq = new LinkedList();
        }
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn(this.mouseCriterion);
        this.x = 0;
        this.y = 0;
        this.x_last = 0;
        this.y_last = 0;
    }

    public void wakeup() {
        this.wakeUp = true;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.buttonPress = true;
            return;
        }
        if (mouseEvent.getID() == 502) {
            this.buttonPress = false;
            this.wakeUp = false;
        }
    }

    public abstract void processStimulus(Enumeration var1);

    public void addListener(Component component) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Behavior0"));
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(mouseEvent);
                if (this.mouseq.size() == 1) {
                    this.postId(501);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(mouseEvent);
                if (this.mouseq.size() == 1) {
                    this.postId(502);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(mouseEvent);
                if (this.mouseq.size() == 1) {
                    this.postId(506);
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setEnable(boolean bl) {
        super.setEnable(bl);
        this.enable = bl;
        if (!this.enable && this.mouseq != null) {
            this.mouseq.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        System.out.println("MouseBehavior : mouseWheel enable = " + this.enable);
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(mouseWheelEvent);
                if (this.mouseq.size() == 1) {
                    this.postId(507);
                }
            }
        }
    }
}

