/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.utils.geometry.Primitive;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Morph;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickObject {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    public static final int USE_GEOMETRY = 256;
    public static final int USE_BOUNDS = 512;
    BranchGroup pickRoot;
    Canvas3D canvas;
    Point3d origin = new Point3d();
    Vector3d direction = new Vector3d();
    PickRay pickRay = new PickRay();
    SceneGraphPath sceneGraphPath = null;
    SceneGraphPath[] sceneGraphPathArr = null;
    int pickBy;
    static final boolean debug = false;
    private double[] distance;
    private int[] position;

    public PickObject(Canvas3D canvas3D, BranchGroup branchGroup) {
        this.pickRoot = branchGroup;
        this.canvas = canvas3D;
    }

    public PickShape generatePickRay(int n2, int n3) {
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        this.canvas.getCenterEyeInImagePlate(point3d);
        this.canvas.getPixelLocationInImagePlate(n2, n3, point3d2);
        if (this.canvas.getView().getProjectionPolicy() == 0) {
            point3d.x = point3d2.x;
            point3d.y = point3d2.y;
        }
        this.canvas.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        vector3d.sub(point3d2, point3d);
        vector3d.normalize();
        this.pickRay.set(point3d, vector3d);
        return this.pickRay;
    }

    public SceneGraphPath[] pickAll(int n2, int n3) {
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath[] pickAllSorted(int n2, int n3) {
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPathArr = this.pickRoot.pickAllSorted(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath pickAny(int n2, int n3) {
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPath = this.pickRoot.pickAny(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath pickClosest(int n2, int n3) {
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPath = this.pickRoot.pickClosest(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath[] pickAll(int n2, int n3, int n4) {
        if (n4 == 512) {
            return this.pickAll(n2, n3);
        }
        if (n4 == 256) {
            return this.pickGeomAll(n2, n3);
        }
        return null;
    }

    public SceneGraphPath[] pickAllSorted(int n2, int n3, int n4) {
        if (n4 == 512) {
            return this.pickAllSorted(n2, n3);
        }
        if (n4 == 256) {
            return this.pickGeomAllSorted(n2, n3);
        }
        return null;
    }

    public SceneGraphPath pickAny(int n2, int n3, int n4) {
        if (n4 == 512) {
            return this.pickAny(n2, n3);
        }
        if (n4 == 256) {
            return this.pickGeomAny(n2, n3);
        }
        return null;
    }

    public SceneGraphPath pickClosest(int n2, int n3, int n4) {
        if (n4 == 512) {
            return this.pickClosest(n2, n3);
        }
        if (n4 == 256) {
            return this.pickGeomClosest(n2, n3);
        }
        return null;
    }

    private SceneGraphPath[] pickGeomAll(int n2, int n3) {
        int n4;
        int n5 = 0;
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] blArray = new boolean[this.sceneGraphPathArr.length];
        for (n4 = 0; n4 < this.sceneGraphPathArr.length; ++n4) {
            Node node = this.sceneGraphPathArr[n4].getObject();
            if (node instanceof Shape3D) {
                blArray[n4] = ((Shape3D)node).intersect(this.sceneGraphPathArr[n4], this.pickRay);
            } else if (node instanceof Morph) {
                blArray[n4] = ((Morph)node).intersect(this.sceneGraphPathArr[n4], this.pickRay);
            }
            if (!blArray[n4]) continue;
            ++n5;
        }
        if (n5 == 0) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[n5];
        n5 = 0;
        for (n4 = 0; n4 < this.sceneGraphPathArr.length; ++n4) {
            if (!blArray[n4]) continue;
            sceneGraphPathArray[n5++] = this.sceneGraphPathArr[n4];
        }
        return sceneGraphPathArray;
    }

    private SceneGraphPath[] pickGeomAllSorted(int n2, int n3) {
        int n4;
        int n5 = 0;
        double[] dArray = new double[1];
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] blArray = new boolean[this.sceneGraphPathArr.length];
        double[] dArray2 = new double[this.sceneGraphPathArr.length];
        for (n4 = 0; n4 < this.sceneGraphPathArr.length; ++n4) {
            Node node = this.sceneGraphPathArr[n4].getObject();
            if (node instanceof Shape3D) {
                blArray[n4] = ((Shape3D)node).intersect(this.sceneGraphPathArr[n4], this.pickRay, dArray);
                dArray2[n4] = dArray[0];
            } else if (node instanceof Morph) {
                blArray[n4] = ((Morph)node).intersect(this.sceneGraphPathArr[n4], this.pickRay, dArray);
                dArray2[n4] = dArray[0];
            }
            if (!blArray[n4]) continue;
            ++n5;
        }
        if (n5 == 0) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[n5];
        this.distance = new double[n5];
        n5 = 0;
        for (n4 = 0; n4 < this.sceneGraphPathArr.length; ++n4) {
            if (!blArray[n4]) continue;
            sceneGraphPathArray[n5] = this.sceneGraphPathArr[n4];
            this.distance[n5++] = dArray2[n4];
        }
        return this.sort(sceneGraphPathArray);
    }

    private SceneGraphPath pickGeomClosest(int n2, int n3) {
        SceneGraphPath[] sceneGraphPathArray = this.pickGeomAllSorted(n2, n3);
        if (sceneGraphPathArray == null) {
            return null;
        }
        return sceneGraphPathArray[0];
    }

    private SceneGraphPath pickGeomAny(int n2, int n3) {
        this.pickRay = (PickRay)this.generatePickRay(n2, n3);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        for (int i2 = 0; i2 < this.sceneGraphPathArr.length; ++i2) {
            Node node = this.sceneGraphPathArr[i2].getObject();
            if (!(node instanceof Shape3D ? ((Shape3D)node).intersect(this.sceneGraphPathArr[i2], this.pickRay) : node instanceof Morph && ((Morph)node).intersect(this.sceneGraphPathArr[i2], this.pickRay))) continue;
            return this.sceneGraphPathArr[i2];
        }
        return null;
    }

    private SceneGraphPath[] sort(SceneGraphPath[] sceneGraphPathArray) {
        int n2;
        if (sceneGraphPathArray == null) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray2 = new SceneGraphPath[sceneGraphPathArray.length];
        this.position = new int[sceneGraphPathArray.length];
        for (n2 = 0; n2 < sceneGraphPathArray.length; ++n2) {
            this.position[n2] = n2;
        }
        this.quicksort(0, this.distance.length - 1);
        for (n2 = 0; n2 < this.distance.length; ++n2) {
            sceneGraphPathArray2[n2] = sceneGraphPathArray[this.position[n2]];
        }
        return sceneGraphPathArray2;
    }

    private final void quicksort(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        double d2 = this.distance[(n2 + n3) / 2];
        while (true) {
            if (this.distance[n4] < d2) {
                ++n4;
                continue;
            }
            while (d2 < this.distance[n5]) {
                --n5;
            }
            if (n4 <= n5) {
                double d3 = this.distance[n4];
                this.distance[n4] = this.distance[n5];
                this.distance[n5] = d3;
                int n6 = this.position[n4];
                this.position[n4] = this.position[n5];
                this.position[n5] = n6;
                ++n4;
                --n5;
            }
            if (n4 > n5) break;
        }
        if (n2 < n5) {
            this.quicksort(n2, n5);
        }
        if (n2 < n3) {
            this.quicksort(n4, n3);
        }
    }

    public Node pickNode(SceneGraphPath sceneGraphPath, int n2) {
        if (sceneGraphPath != null) {
            Node node = sceneGraphPath.getObject();
            if (node instanceof Shape3D && (n2 & 1) != 0) {
                return node;
            }
            if (node instanceof Morph && (n2 & 2) != 0) {
                return node;
            }
            for (int i2 = sceneGraphPath.nodeCount() - 1; i2 >= 0; --i2) {
                node = sceneGraphPath.getNode(i2);
                if (node instanceof Primitive && (n2 & 4) != 0) {
                    return node;
                }
                if (node instanceof Link && (n2 & 8) != 0) {
                    return node;
                }
                if (node instanceof Switch && (n2 & 0x80) != 0) {
                    return node;
                }
                if (node instanceof TransformGroup && (n2 & 0x20) != 0) {
                    return node;
                }
                if (node instanceof BranchGroup && (n2 & 0x40) != 0) {
                    return node;
                }
                if (!(node instanceof Group) || (n2 & 0x10) == 0) continue;
                return node;
            }
            if (node == null) {
                // empty if block
            }
        }
        return null;
    }

    public Node pickNode(SceneGraphPath sceneGraphPath, int n2, int n3) {
        int n4 = 0;
        if (sceneGraphPath != null) {
            Node node = sceneGraphPath.getObject();
            if (node instanceof Shape3D && (n2 & 1) != 0) {
                return node;
            }
            if (node instanceof Morph && (n2 & 2) != 0) {
                return node;
            }
            for (int i2 = 0; i2 < sceneGraphPath.nodeCount(); ++i2) {
                node = sceneGraphPath.getNode(i2);
                if (!(node instanceof Group && (n2 & 0x10) != 0 ? ++n4 == n3 : (node instanceof BranchGroup && (n2 & 0x40) != 0 ? ++n4 == n3 : (node instanceof TransformGroup && (n2 & 0x20) != 0 ? ++n4 == n3 : (node instanceof Primitive && (n2 & 4) != 0 ? ++n4 == n3 : node instanceof Link && (n2 & 8) != 0 && ++n4 == n3))))) continue;
                return node;
            }
            if (node == null) {
                // empty if block
            }
        }
        return null;
    }
}

