/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.CompressionStreamElement;
import com.sun.j3d.utils.compression.HuffmanNode;
import com.sun.j3d.utils.compression.HuffmanTable;
import javax.vecmath.Vector3f;

class CompressionStreamNormal
extends CompressionStreamElement {
    private int u;
    private int v;
    private int specialOctant;
    private int specialSextant;
    private float normalX;
    private float normalY;
    private float normalZ;
    int octant;
    int sextant;
    boolean specialNormal;
    int uAbsolute;
    int vAbsolute;
    private static final int MAX_UV_BITS = 6;
    private static final int MAX_UV_ENTRIES = 64;
    private static final double[][][][] cgNormals = new double[7][65][65][3];
    private static final double MAX_Y_ANG = 0.615479709;
    private static final double UNITY_14 = 16384.0;
    private static final short[][] inverseSine = new short[7][];
    private static final short MAX_SIN_14BIT = 9459;

    CompressionStreamNormal(CompressionStream compressionStream, Vector3f vector3f) {
        this.normalX = vector3f.x;
        this.normalY = vector3f.y;
        this.normalZ = vector3f.z;
        compressionStream.byteCount += 12;
    }

    private static void computeNormals() {
        for (int i2 = 0; i2 <= 6; ++i2) {
            int n2 = 1 << i2;
            for (int i3 = 0; i3 <= n2; ++i3) {
                for (int i4 = 0; i4 <= n2; ++i4) {
                    if (i4 + i3 > n2) continue;
                    double d2 = 0.615479709 * ((double)i3 / (double)n2);
                    double d3 = Math.asin(Math.tan(0.615479709 * ((double)(n2 - i4) / (double)n2)));
                    double d4 = Math.cos(d3) * Math.cos(d2);
                    double d5 = Math.sin(d2);
                    double d6 = Math.sin(d3) * Math.cos(d2);
                    int n3 = (int)(d4 *= 16384.0);
                    d4 = n3;
                    int n4 = (int)(d5 *= 16384.0);
                    d5 = n4;
                    int n5 = (int)(d6 *= 16384.0);
                    d6 = n5;
                    CompressionStreamNormal.cgNormals[i2][i3][i4][0] = d4 /= 16384.0;
                    CompressionStreamNormal.cgNormals[i2][i3][i4][1] = d5 /= 16384.0;
                    CompressionStreamNormal.cgNormals[i2][i3][i4][2] = d6 /= 16384.0;
                }
            }
        }
    }

    private static void computeInverseSineTables() {
        int n2;
        short[] sArray = new short[65];
        for (n2 = 0; n2 <= 64; ++n2) {
            sArray[n2] = (short)(16384.0 * Math.sin((double)n2 * 0.615479709 / 64.0));
        }
        for (n2 = 0; n2 <= 6; ++n2) {
            int n3;
            switch (n2) {
                default: {
                    n3 = 64;
                    break;
                }
                case 5: {
                    n3 = 128;
                    break;
                }
                case 4: {
                    n3 = 256;
                    break;
                }
                case 3: {
                    n3 = 512;
                    break;
                }
                case 2: {
                    n3 = 1024;
                    break;
                }
                case 1: {
                    n3 = 2048;
                    break;
                }
                case 0: {
                    n3 = 4096;
                }
            }
            CompressionStreamNormal.inverseSine[n2] = new short[9459 / n3 + 1];
            int n4 = 0;
            for (int i2 = 0; i2 < inverseSine[n2].length; ++i2) {
                double d2 = (double)n4 / 16384.0;
                double d3 = Math.asin(d2);
                int n5 = (int)(d3 / 0.615479709 * (double)(1 << n2));
                if (n5 > 0 && Math.abs(sArray[n5 << 6 - n2] - n4) > Math.abs(sArray[n5 - 1 << 6 - n2] - n4)) {
                    --n5;
                }
                if (n5 < 1 << n2 && Math.abs(sArray[n5 << 6 - n2] - n4) > Math.abs(sArray[n5 + 1 << 6 - n2] - n4)) {
                    ++n5;
                }
                CompressionStreamNormal.inverseSine[n2][i2] = (short)n5;
                n4 += n3;
            }
        }
    }

    void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
        int n2;
        int n3;
        double d2;
        int n4 = compressionStream.normalQuant < 0 ? 0 : (compressionStream.normalQuant > 6 ? 6 : compressionStream.normalQuant);
        double d3 = this.normalX;
        double d4 = this.normalY;
        double d5 = this.normalZ;
        this.octant = 0;
        this.sextant = 0;
        this.u = 0;
        this.v = 0;
        if (d3 < 0.0) {
            this.octant |= 4;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            this.octant |= 2;
            d4 = -d4;
        }
        if (d5 < 0.0) {
            this.octant |= 1;
            d5 = -d5;
        }
        if (d3 < d4) {
            this.sextant |= 1;
            d2 = d3;
            d3 = d4;
            d4 = d2;
        }
        if (d5 < d4) {
            this.sextant |= 2;
            d2 = d4;
            d4 = d5;
            d5 = d2;
        }
        if (d3 < d5) {
            this.sextant |= 4;
            d2 = d3;
            d3 = d5;
            d5 = d2;
        }
        int n5 = (int)(d4 * 16384.0);
        short s = inverseSine[n4][n5 >> 12 - n4];
        int n6 = 0;
        int n7 = 0;
        int n8 = 1 << n4;
        double d6 = -1.0;
        for (n3 = s - 1; n3 < s + 1 && n3 <= n8; ++n3) {
            if (n3 < 0) continue;
            for (n2 = 0; n2 <= n8; ++n2) {
                double d7;
                if (n2 + n3 > n8 || !((d7 = d3 * cgNormals[n4][n3][n2][0] + d4 * cgNormals[n4][n3][n2][1] + d5 * cgNormals[n4][n3][n2][2]) > d6)) continue;
                d6 = d7;
                n6 = n2;
                n7 = n3;
            }
        }
        this.u = n6 << 6 - n4;
        this.v = n7 << 6 - n4;
        this.specialNormal = false;
        if (this.u == 64 && this.v == 0) {
            if (this.sextant == 0 || this.sextant == 2) {
                this.specialSextant = 6;
                this.specialOctant = (this.octant & 4) != 0 ? 2 : 0;
            } else if (this.sextant == 3 || this.sextant == 1) {
                this.specialSextant = 6;
                this.specialOctant = 4 | ((this.octant & 2) != 0 ? 2 : 0);
            } else if (this.sextant == 5 || this.sextant == 4) {
                this.specialSextant = 7;
                this.specialOctant = (this.octant & 1) != 0 ? 2 : 0;
            }
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        } else if (this.u == 0 && this.v == 64) {
            this.specialSextant = 6 | this.octant >> 2;
            this.specialOctant = (this.octant & 3) << 1 | 1;
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        }
        n3 = 0;
        n2 = 0;
        int n9 = 64 >> 6 - n4;
        this.absolute = false;
        if (compressionStream.firstNormal || compressionStream.normalQuantChanged || compressionStream.lastSpecialNormal || this.specialNormal) {
            this.absolute = true;
            compressionStream.firstNormal = false;
            compressionStream.normalQuantChanged = false;
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant == this.sextant) {
            n3 = n6 - compressionStream.lastU;
            n2 = n7 - compressionStream.lastV;
        } else if (compressionStream.lastOctant != this.octant && compressionStream.lastSextant == this.sextant && ((this.sextant == 1 || this.sextant == 5) && (compressionStream.lastOctant & 3) == (this.octant & 3) || (this.sextant == 0 || this.sextant == 4) && (compressionStream.lastOctant & 5) == (this.octant & 5) || (this.sextant == 2 || this.sextant == 3) && (compressionStream.lastOctant & 6) == (this.octant & 6))) {
            n3 = n6 - compressionStream.lastU;
            n2 = -n7 - compressionStream.lastV;
            if (n2 < -n9) {
                this.absolute = true;
            }
            if (n7 == 0) {
                this.absolute = true;
            }
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant != this.sextant && (this.sextant == 0 && compressionStream.lastSextant == 4 || this.sextant == 4 && compressionStream.lastSextant == 0 || this.sextant == 1 && compressionStream.lastSextant == 5 || this.sextant == 5 && compressionStream.lastSextant == 1 || this.sextant == 2 && compressionStream.lastSextant == 3 || this.sextant == 3 && compressionStream.lastSextant == 2)) {
            n3 = -n6 - compressionStream.lastU;
            n2 = n7 - compressionStream.lastV;
            if (n3 < -n9) {
                this.absolute = true;
            }
            if (n6 == 0) {
                this.absolute = true;
            }
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant != this.sextant && (this.sextant == 0 && compressionStream.lastSextant == 2 || this.sextant == 2 && compressionStream.lastSextant == 0 || this.sextant == 1 && compressionStream.lastSextant == 3 || this.sextant == 3 && compressionStream.lastSextant == 1 || this.sextant == 4 && compressionStream.lastSextant == 5 || this.sextant == 5 && compressionStream.lastSextant == 4)) {
            if (n6 + n7 != n9 && n6 != 0 && n7 != 0) {
                n3 = n9 - n6 - compressionStream.lastU;
                n2 = n9 - n7 - compressionStream.lastV;
                if (n3 >= n9 || n2 >= n9) {
                    this.absolute = true;
                }
            } else {
                this.absolute = true;
            }
        } else {
            this.absolute = true;
        }
        if (!this.absolute) {
            this.u = n3 << 6 - n4;
            this.v = n2 << 6 - n4;
        }
        this.computeLengthShift(this.u, this.v);
        if (this.absolute && this.length > 6) {
            this.length = 6;
        }
        huffmanTable.addNormalEntry(this.length, this.shift, this.absolute);
        compressionStream.lastSextant = this.sextant;
        compressionStream.lastOctant = this.octant;
        compressionStream.lastU = n6;
        compressionStream.lastV = n7;
        compressionStream.lastSpecialNormal = this.specialNormal;
        this.uAbsolute = n6;
        this.vAbsolute = n7;
    }

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputNormal(huffmanTable, commandStream, 192, 8);
    }

    void outputSubcommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputNormal(huffmanTable, commandStream, 0, 6);
    }

    private void outputNormal(HuffmanTable huffmanTable, CommandStream commandStream, int n2, int n3) {
        HuffmanNode huffmanNode = huffmanTable.getNormalEntry(this.length, this.shift, this.absolute);
        int n4 = huffmanNode.dataLength - huffmanNode.shift;
        int n5 = 0;
        long l2 = 0L;
        if (this.absolute) {
            n5 = huffmanNode.tagLength + 6;
            l2 = this.specialNormal ? (long)(huffmanNode.tag << 6 | this.specialSextant << 3 | this.specialOctant) : (long)(huffmanNode.tag << 6 | this.sextant << 3 | this.octant);
        } else {
            n5 = huffmanNode.tagLength;
            l2 = huffmanNode.tag;
        }
        this.u = this.u >> huffmanNode.shift & (int)lengthMask[n4];
        this.v = this.v >> huffmanNode.shift & (int)lengthMask[n4];
        l2 = l2 << 2 * n4 | (long)(this.u << 1 * n4) | (long)(this.v << 0 * n4);
        if ((n5 += 2 * n4) < 6) {
            n2 |= (int)(l2 << 6 - n5);
            n5 = 0;
        } else {
            n2 |= (int)(l2 >>> n5 - 6);
            n5 -= 6;
        }
        commandStream.addCommand(n2, n3, l2, n5);
    }

    public String toString() {
        String string = this.specialNormal ? " special normal, sextant " + this.specialSextant + " octant " + this.specialOctant : (this.absolute ? " sextant " + this.sextant + " octant " + this.octant + " u " + this.u + " v " + this.v : " du " + this.u + " dv " + this.v);
        return "normal: " + this.normalX + " " + this.normalY + " " + this.normalZ + "\n" + string + "\n" + " length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative");
    }

    static {
        CompressionStreamNormal.computeNormals();
        CompressionStreamNormal.computeInverseSineTables();
    }
}

